/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class MEOwnerTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String MEUUID = "ME_UUID";
    public static final String INCUUID = "INC_UUID";
    public static final String VERSION = "VERSION";
    public static final String MIGRATION = "MIGRATION_VERSION";
    private static final Map DEFAULT = new IdentityHashMap();
    private static final Map ORACLE = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private MEOwnerTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INTEGER, " + MIGRATION + " INTEGER )"};
        }
        if (string6 == "DB2" || string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INTEGER, " + MIGRATION + " INTEGER )"};
        }
        if (string6 == "Oracle" || string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INTEGER, " + MIGRATION + " INTEGER )"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INT, " + MIGRATION + " INT )"};
        }
        if (string6 == "Informix" || string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INT, " + MIGRATION + " INT ) LOCK MODE ROW"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INT, " + MIGRATION + " INT )"};
        }
        if (string6 == "DB2390") {
            return new String[]{"CREATE TABLESPACE OWNERTS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 3200 SECQTY 320 ERASE NO PCTFREE 0 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE TABLE CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + MEUUID + " VARCHAR(16), " + INCUUID + " VARCHAR(16), " + VERSION + " INTEGER, " + MIGRATION + " INTEGER ) IN " + string + ".OWNERTS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + MEUUID + ") USING STOGROUP " + string2 + " PRIQTY 200 SECQTY 20"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + ".OWNERTS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getLockTableSql(String string, String string2, String string3) {
        if (string3 == "DB2" || string3 == "DB2iSeries" || string3 == "db2j" || string3 == "DB2390" || string3 == "Derby") {
            return "LOCK TABLE " + string + "." + string2 + " IN EXCLUSIVE MODE";
        }
        if (string3 == "Oracle" || string3 == "Oracle8i") {
            return "LOCK TABLE " + string + "." + string2 + " IN EXCLUSIVE MODE";
        }
        if (string3 == "MS SQL Server") {
            return "INSERT INTO " + string + "." + string2 + " WITH (TABLOCKX) (" + MEUUID + "," + INCUUID + "," + VERSION + "," + MIGRATION + ") VALUES ('LOCK','LOCK', 0, 0)";
        }
        if (string3 == "Informix" || string3 == "Informix_73") {
            return "LOCK TABLE " + string + "." + string2 + " IN EXCLUSIVE MODE";
        }
        if (string3 == "Sybase") {
            return "LOCK TABLE " + string + "." + string2 + " IN EXCLUSIVE MODE";
        }
        if (string3 == "Dummy") {
            return "";
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string3}, null));
    }

    public static String getReadOwnerSql(String string, String string2, String string3) {
        if (string3 == "MS SQL Server") {
            return "SELECT ME_UUID,INC_UUID,VERSION,MIGRATION_VERSION FROM " + string + "." + string2 + " WHERE NOT " + MEUUID + "='LOCK'";
        }
        return "SELECT ME_UUID,INC_UUID,VERSION,MIGRATION_VERSION FROM " + string + "." + string2;
    }

    public static String getInsertOwnerSql(String string, String string2) {
        return "INSERT INTO " + string + "." + string2 + " (" + MEUUID + "," + INCUUID + "," + VERSION + "," + MIGRATION + ") VALUES (?, ?, ?, ?)";
    }

    public static String getUpdateOwnerSql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + INCUUID + "=?," + VERSION + "=?," + MIGRATION + "=? WHERE " + MEUUID + "=?";
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT,UPDATE ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        DEFAULT.put(MEUUID, TableHelper.VARCHAR);
        DEFAULT.put(INCUUID, TableHelper.VARCHAR);
        DEFAULT.put(VERSION, TableHelper.INTEGER);
        DEFAULT.put(MIGRATION, TableHelper.INTEGER);
        ORACLE.put(MEUUID, TableHelper.VARCHAR);
        ORACLE.put(INCUUID, TableHelper.VARCHAR);
        ORACLE.put(VERSION, TableHelper.DECIMAL);
        ORACLE.put(MIGRATION, TableHelper.DECIMAL);
        SYSTEMS.put("DB2", DEFAULT);
        SYSTEMS.put("DB2iSeries", DEFAULT);
        SYSTEMS.put("DB2390", DEFAULT);
        SYSTEMS.put("db2j", DEFAULT);
        SYSTEMS.put("Derby", DEFAULT);
        SYSTEMS.put("Oracle", ORACLE);
        SYSTEMS.put("Oracle8i", ORACLE);
        SYSTEMS.put("MS SQL Server", DEFAULT);
        SYSTEMS.put("Informix", DEFAULT);
        SYSTEMS.put("Informix_73", DEFAULT);
        SYSTEMS.put("Sybase", DEFAULT);
    }
}

