/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class DatabaseMetaDataExtensions {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)DatabaseMetaDataExtensions.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String DB2j = "db2j";
    public static final String DERBY = "Derby";
    public static final String DB2 = "DB2";
    public static final String DB2_iSeries = "DB2iSeries";
    public static final String DB2_390 = "DB2390";
    public static final String ORACLE = "Oracle";
    public static final String ORACLE_V8 = "Oracle8i";
    public static final String SYBASE = "Sybase";
    public static final String MSSQL = "MS SQL Server";
    public static final String INFORMIX = "Informix";
    public static final String INFORMIX_73 = "Informix_73";
    public static final String DUMMY = "Dummy";
    private final boolean supportsJdbcBatches;
    private final boolean supportsScrollableResultSet;
    private final boolean storesUpperCaseIdentifiers;
    private DatabaseMetaData metadata;
    private String dbms;

    public DatabaseMetaDataExtensions(DatabaseMetaData databaseMetaData) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{databaseMetaData});
        }
        this.metadata = databaseMetaData;
        this.supportsJdbcBatches = databaseMetaData.supportsBatchUpdates();
        this.supportsScrollableResultSet = databaseMetaData.supportsResultSetType(1004);
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.setDBMS(databaseMetaData);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public boolean storesUpperCaseIdentifiers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storesUpperCaseIdentifiers");
            SibTr.exit((TraceComponent)tc, (String)"storesUpperCaseIdentifiers", (Object)new Boolean(this.storesUpperCaseIdentifiers));
        }
        return this.storesUpperCaseIdentifiers;
    }

    public boolean supportsJdbcBatches() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"supportsJdbcBatches");
        }
        boolean bl = this.supportsJdbcBatches;
        if (this.dbms == ORACLE || this.dbms == ORACLE_V8 || this.dbms == DERBY) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"supportsJdbcBatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean supportsTruncateTableSql() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"supportsTruncateTableSql");
        }
        boolean bl = false;
        if (this.dbms == ORACLE || this.dbms == ORACLE_V8 || this.dbms == MSSQL || this.dbms == SYBASE || this.dbms == DB2_390) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"supportsTruncateTableSql", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean supportsScrollableResultSet() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"supportsScrollableResultSet");
            SibTr.exit((TraceComponent)tc, (String)"supportsScrollableResultSet", (Object)new Boolean(this.supportsScrollableResultSet));
        }
        return this.supportsScrollableResultSet;
    }

    public boolean supportsBinaryDataInStringColumns() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"supportsBinaryDataInStringColumns");
        }
        boolean bl = false;
        if (this.dbms == DB2 || this.dbms == DB2_iSeries || this.dbms == DB2_390) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"supportsBinaryDataInStringColumns", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getDBMS() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDBMS");
            SibTr.exit((TraceComponent)tc, (String)"getDBMS", (Object)this.dbms);
        }
        return this.dbms;
    }

    public boolean creatingTablesWillCreateSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"creatingTablesWillCreateSchema");
        }
        boolean bl = false;
        if (this.dbms == ORACLE || this.dbms == ORACLE_V8 || this.dbms == MSSQL || this.dbms == INFORMIX || this.dbms == SYBASE || this.dbms == DB2_390 || this.dbms == INFORMIX_73) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"creatingTablesWillCreateSchema", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean createSchemaIsAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSchemaIsAllowed");
        }
        boolean bl = false;
        if (this.dbms == DB2j || this.dbms == DB2 || this.dbms == DERBY || this.dbms == DUMMY) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSchemaIsAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getColumns", (Object)new Object[]{string, string2, string3, string4});
        }
        ResultSet resultSet = null;
        if (this.metadata != null) {
            resultSet = this.metadata.getColumns(string, string2, string3, string4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getColumns", resultSet);
        }
        return resultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSchemas");
        }
        ResultSet resultSet = null;
        if (this.metadata != null) {
            resultSet = this.metadata.getSchemas();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSchemas", (Object)resultSet);
        }
        return resultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTables", (Object)new Object[]{string, string2, string3, stringArray});
        }
        ResultSet resultSet = null;
        if (this.metadata != null) {
            resultSet = this.metadata.getTables(string, string2, string3, stringArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTables", resultSet);
        }
        return resultSet;
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        this.metadata = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    private void setDBMS(DatabaseMetaData databaseMetaData) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDBMS", (Object)new Object[]{databaseMetaData});
        }
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = databaseMetaData.getDatabaseProductVersion();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("DBMS Vendor: " + string + ", " + "DBMS Version: " + string2));
        }
        if (string.lastIndexOf(DB2j) != -1 || string.lastIndexOf("Cloudscape") != -1) {
            this.dbms = DB2j;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=CLOUDSCAPE");
            }
        } else if (string.lastIndexOf(DERBY) != -1) {
            this.dbms = DERBY;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=Apache Derby");
            }
        } else if (string.lastIndexOf(DB2) != -1) {
            if (string.equals(DB2)) {
                this.dbms = DB2_390;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=DB2 UDB for z/OS");
                }
            } else if (string.lastIndexOf("AS/400") != -1) {
                this.dbms = DB2_iSeries;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=DB2 UDB for AS/400");
                }
            } else {
                this.dbms = DB2;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=DB2 UDB");
                }
            }
        } else if (string.startsWith("DSN")) {
            this.dbms = DB2_390;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=DB2 UDB for z/OS");
            }
        } else if (string.lastIndexOf(ORACLE) != -1) {
            boolean bl;
            String string3 = databaseMetaData.getURL();
            boolean bl2 = bl = string3 != null && string3.toLowerCase().indexOf("oracle:oci8:") > 1;
            if (string2.lastIndexOf(ORACLE_V8) != -1) {
                int n = string2.lastIndexOf("8.1.");
                if (n != -1) {
                    int n2;
                    block53: {
                        n2 = 0;
                        try {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string2.charAt(n + 4));
                            n2 = Integer.parseInt(stringBuffer.toString());
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Oracle version=8.1." + n2));
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.DatabaseMetaDataExtensions.setDBMS", (String)"147", (Object)this);
                            if (!tc.isEventEnabled()) break block53;
                            SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught attempting to determine Oracle DB version!");
                        }
                    }
                    if (n2 < 7) {
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Oracle version does not meet pre-requisite level.");
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"setDBMS");
                        }
                        throw new MessageStoreRuntimeException();
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Oracle version=8.?");
                    }
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Oracle version does not meet pre-requisite level.");
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"setDBMS");
                    }
                    throw new MessageStoreRuntimeException();
                }
                this.dbms = bl ? ORACLE_V8 : ORACLE_V8;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=ORACLE_V8");
                }
            } else {
                this.dbms = bl ? ORACLE : ORACLE;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=ORACLE");
                }
            }
        } else if (string.lastIndexOf("sqlany") != -1 || string.lastIndexOf(SYBASE) != -1 || string.lastIndexOf("Adaptive Server") != -1) {
            this.dbms = SYBASE;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=SYBASE");
            }
        } else if (string.lastIndexOf("ifx") != -1 || string.lastIndexOf(INFORMIX) != -1 || string.lastIndexOf("INFORMIX") != -1) {
            int n = string2.lastIndexOf("7.3");
            if (n != -1) {
                this.dbms = INFORMIX_73;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=INFORMIX_73");
                }
            } else {
                this.dbms = INFORMIX;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"dbms=INFORMIX");
                }
            }
        } else if (string.lastIndexOf("mssql") != -1 || string.lastIndexOf("Microsoft SQL") != -1) {
            this.dbms = MSSQL;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=SQLSERVER");
            }
        } else if (string.lastIndexOf(DUMMY) != -1) {
            this.dbms = DUMMY;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"dbms=DUMMY");
            }
        } else {
            throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDBMS");
        }
    }
}

