/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class ClassmapTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String CLASSID = "CLASSID";
    public static final String URI = "URI";
    private static final Map DEFAULT = new IdentityHashMap();
    private static final Map OTHER = new IdentityHashMap();
    private static final Map ORACLE = new IdentityHashMap();
    private static final Map INFORMIX = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private ClassmapTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INTEGER NOT NULL, " + URI + " VARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") )"};
        }
        if (string6 == "DB2" || string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INTEGER NOT NULL, " + URI + " VARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") )"};
        }
        if (string6 == "Oracle" || string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INTEGER NOT NULL, " + URI + " VARCHAR2(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") )"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INT NOT NULL, " + URI + " NVARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") )"};
        }
        if (string6 == "Informix") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INT NOT NULL, " + URI + " LVARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INT NOT NULL, " + URI + " VARCHAR(254) NOT NULL, PRIMARY KEY(" + CLASSID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INT NOT NULL, " + URI + " NVARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") )"};
        }
        if (string6 == "DB2390") {
            return new String[]{"CREATE TABLESPACE MAPTS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 3200 SECQTY 320 ERASE NO PCTFREE 10 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE ANY CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + CLASSID + " INTEGER NOT NULL, " + URI + " VARCHAR(2048) NOT NULL, PRIMARY KEY(" + CLASSID + ") ) IN " + string + ".MAPTS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + CLASSID + ") USING STOGROUP " + string2 + " PRIQTY 200 SECQTY 20"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + ".MAPTS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getInsertSql(String string, String string2) {
        return "INSERT INTO " + string + "." + string2 + " (" + CLASSID + "," + URI + ") VALUES (?,?)";
    }

    public static String getReadTableSql(String string, String string2) {
        return "SELECT CLASSID,URI FROM " + string + "." + string2;
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        DEFAULT.put(CLASSID, TableHelper.INTEGER);
        DEFAULT.put(URI, TableHelper.VARCHAR);
        OTHER.put(CLASSID, TableHelper.INTEGER);
        OTHER.put(URI, TableHelper.LONGVARCHAR);
        ORACLE.put(CLASSID, TableHelper.DECIMAL);
        ORACLE.put(URI, TableHelper.VARCHAR);
        INFORMIX.put(CLASSID, TableHelper.INTEGER);
        INFORMIX.put(URI, new Integer[]{TableHelper.VARCHAR, TableHelper.LONGVARCHAR});
        SYSTEMS.put("DB2", DEFAULT);
        SYSTEMS.put("DB2iSeries", DEFAULT);
        SYSTEMS.put("DB2390", OTHER);
        SYSTEMS.put("db2j", DEFAULT);
        SYSTEMS.put("Derby", DEFAULT);
        SYSTEMS.put("Oracle", ORACLE);
        SYSTEMS.put("Oracle8i", ORACLE);
        SYSTEMS.put("MS SQL Server", DEFAULT);
        SYSTEMS.put("Informix", INFORMIX);
        SYSTEMS.put("Informix_73", INFORMIX);
        SYSTEMS.put("Sybase", DEFAULT);
    }
}

