/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.persistence.impl.ClassId;
import com.ibm.ws.sib.msgstore.persistence.impl.ClassmapTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.Table;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ClassmapTable
extends Table {
    private static TraceComponent tc = SibTr.register((Class)ClassmapTable.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int DEFAULT_ROWS = 2;
    public static final String ID_TO_CLASS = "ID_TO_CLASS";
    public static final String CLASS_TO_ID = "CLASS_TO_ID";
    private final String addClassSql;
    private final String readTableSql;

    public ClassmapTable(String string, String string2) {
        super(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{string, string2});
        }
        this.addClassSql = ClassmapTableHelper.getInsertSql(string, string2);
        this.readTableSql = ClassmapTableHelper.getReadTableSql(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void initialize(ConnectionWrapper connectionWrapper, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{"connection=" + connectionWrapper, "createTablesAndIndexes=" + bl, "dropTables=" + bl2, "performColumnChecks=" + bl3});
        }
        super.initialize(connectionWrapper, bl, bl2);
        if (bl3) {
            Map map = ClassmapTableHelper.getReferenceInfo(this.metadata.getDBMS());
            this.performColumnChecks(map);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    protected void createTablesAndIndexes(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTablesAndIndexes", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ClassmapTableHelper.getCreateTableSql("SIBDB", "SIBSG", "BP1", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.createTablesAndIndexes(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTablesAndIndexes");
        }
    }

    protected void dropTable(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dropTable", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ClassmapTableHelper.getDropTableSql("SIBDB", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.dropTable(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dropTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(ConnectionWrapper connectionWrapper, ClassId classId, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addClass", (Object)new Object[]{connectionWrapper, classId, string});
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.addClassSql);
            preparedStatement.setInt(1, classId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addClass");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map readTable(ConnectionWrapper connectionWrapper) throws SQLException {
        HashMap hashMap;
        PreparedStatement preparedStatement;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"readTable", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            hashMap = new HashMap(2);
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readTableSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                resultSet = preparedStatement.executeQuery();
                int n = this.getNumberOfRows(resultSet);
                HashMap<ClassId, String> hashMap2 = new HashMap<ClassId, String>(n);
                HashMap<String, ClassId> hashMap3 = new HashMap<String, ClassId>(n);
                while (resultSet.next()) {
                    ClassId classId = new ClassId(resultSet.getInt(1));
                    String string = resultSet.getString(2);
                    hashMap2.put(classId, string);
                    hashMap3.put(string, classId);
                }
                hashMap.put(ID_TO_CLASS, hashMap2);
                hashMap.put(CLASS_TO_ID, hashMap3);
                Object var11_10 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readTable", hashMap);
        }
        return hashMap;
    }
}

