/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.impl.BatchingContextImpl;
import com.ibm.ws.sib.msgstore.persistence.impl.DatasourceController;
import com.ibm.ws.sib.msgstore.persistence.impl.TableManager;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class BatchingContextFactoryImpl
implements BatchingContextFactory {
    private static TraceComponent tc = SibTr.register((Class)BatchingContextFactoryImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final DatasourceController controller;
    private final TableManager tableManager;
    private final MSInstrumentation instrument;

    public BatchingContextFactoryImpl(MessageStoreImpl messageStoreImpl, TableManager tableManager, DatasourceController datasourceController) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, tableManager, datasourceController});
        }
        this.tableManager = tableManager;
        this.controller = datasourceController;
        this.instrument = messageStoreImpl._getInstrumentation();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public BatchingContext createBatchingContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBatchingContext");
        }
        BatchingContextImpl batchingContextImpl = new BatchingContextImpl(this.instrument, this.tableManager, this.controller);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBatchingContext", (Object)batchingContextImpl);
        }
        return batchingContextImpl;
    }

    public BatchingContext createBatchingContext(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBatchingContext", (Object)new Object[]{"capacity=" + n});
        }
        BatchingContextImpl batchingContextImpl = new BatchingContextImpl(this.instrument, this.tableManager, this.controller);
        batchingContextImpl.setCapacity(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBatchingContext", (Object)batchingContextImpl);
        }
        return batchingContextImpl;
    }

    public BatchingContext createBatchingContext(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBatchingContext", (Object)new Object[]{"capacity=" + n, "useEnlistedConnections=" + bl});
        }
        BatchingContext batchingContext = this.createBatchingContext(n);
        batchingContext.setUseEnlistedConnections(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBatchingContext", (Object)batchingContext);
        }
        return batchingContext;
    }

    public BatchingContext getBatchingContext(PersistentTransaction persistentTransaction, int n, boolean bl) {
        BatchingContext batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext", (Object)new Object[]{"transaction=" + persistentTransaction, "capacity=" + n, "useEnlistedConnections=" + bl});
        }
        if ((batchingContext = persistentTransaction.getBatchingContext()) == null) {
            batchingContext = this.createBatchingContext(n, bl);
            persistentTransaction.setBatchingContext(batchingContext);
        } else {
            batchingContext.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)batchingContext);
        }
        return batchingContext;
    }

    public BatchingContext getBatchingContext(PersistentTransaction persistentTransaction, int n) {
        BatchingContext batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext", (Object)new Object[]{"transaction=" + persistentTransaction, "capacity=" + n});
        }
        if ((batchingContext = persistentTransaction.getBatchingContext()) == null) {
            batchingContext = this.createBatchingContext(n);
            persistentTransaction.setBatchingContext(batchingContext);
        } else {
            batchingContext.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)batchingContext);
        }
        return batchingContext;
    }
}

