/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchNotifier;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatcherBase;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class SpillDispatcher
extends DispatcherBase {
    public static final String $ssccid = "@(#) 1.24 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/dispatcher/SpillDispatcher.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/05/31 04:35:42 [3/13/06 13:38:17]";
    private static TraceComponent tc = SibTr.register((Class)SpillDispatcher.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _minBytesPerBatch;
    private long _maxBytesPerBatch;
    private int _maxTasksPerBatch;
    private long _maxDispatchedBytesPerThread;
    public static final int WRITES_TO_RESET_ERROR_STATE = 16;
    private int _maxThreads;
    private int _numThreads;
    private MessageStoreImpl _msi;
    private Thread[] _threads;
    private SpillDispatcherThread[] _workers;
    private BatchingContextFactory _bcfactory;
    private MSInstrumentation _instrument;
    private boolean _stopRequested = false;
    private boolean _running = false;
    private int _threadWriteErrorsOutstanding = 0;

    public SpillDispatcher(MessageStoreImpl messageStoreImpl, BatchingContextFactory batchingContextFactory) {
        this(messageStoreImpl, batchingContextFactory, SpillDispatcher.obtainIntConfigParameter(messageStoreImpl, "jdbcSpillThreads", "8", 1, 32));
    }

    public SpillDispatcher(MessageStoreImpl messageStoreImpl, BatchingContextFactory batchingContextFactory, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, batchingContextFactory, new Integer(n)});
        }
        this._msi = messageStoreImpl;
        if (this._msi != null) {
            this._instrument = this._msi._getInstrumentation();
        }
        this._bcfactory = batchingContextFactory;
        this._maxThreads = n;
        this._minBytesPerBatch = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMinBytesPerBatch", "500000", 10000L, 100000000L);
        this._maxBytesPerBatch = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMaxBytesPerBatch", "1000000", 100000L, 100000000L);
        this._maxTasksPerBatch = SpillDispatcher.obtainIntConfigParameter(this._msi, "jdbcSpillMaxTasksPerBatch", "64", 1, 10000);
        this._maxDispatchedBytesPerThread = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMaxDispatchedBytesPerThread", "2500000", 100000L, 1000000000L);
        if (this._minBytesPerBatch > this._maxDispatchedBytesPerThread) {
            this._minBytesPerBatch = this._maxDispatchedBytesPerThread;
        }
        if (this._minBytesPerBatch > this._maxBytesPerBatch) {
            this._minBytesPerBatch = this._maxBytesPerBatch;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>");
        }
    }

    public synchronized boolean isFullOfHealth() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isFullOfHealth");
        }
        boolean bl2 = bl = this._running && !this._stopRequested && this._threadWriteErrorsOutstanding == 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isFullOfHealth", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void dispatch(Collection collection, PersistentTransaction persistentTransaction, boolean bl) throws PersistenceException {
        long l;
        int n;
        block10: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatch", (Object)new Object[]{collection, new Boolean(bl)});
            }
            boolean bl2 = false;
            n = 0;
            DispatchNotifier dispatchNotifier = new DispatchNotifier(collection.size(), bl);
            boolean[] blArray = new boolean[this._maxThreads];
            boolean[] blArray2 = new boolean[this._maxThreads];
            l = System.currentTimeMillis();
            if (collection != null) {
                n = collection.size();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Task task = (Task)iterator.next();
                    task.copyDataIfVulnerable();
                    ((Tuple)task.getPersistable()).persistableOperationBegun();
                    int n2 = (int)(task.getPersistable().getUniqueId() % (long)this._maxThreads);
                    blArray2[n2] = this._workers[n2].addTask(task, l, dispatchNotifier);
                    blArray[n2] = true;
                }
                for (int i = 0; i < this._maxThreads; ++i) {
                    if (blArray[i]) {
                        this._workers[i].notifyDispatchArrived();
                    }
                    bl2 |= blArray2[i];
                }
            }
            if (bl2) {
                try {
                    dispatchNotifier.waitForDispatch();
                }
                catch (PersistenceException persistenceException) {
                    FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:322:1.24", (Object)this);
                    if (!tc.isEventEnabled()) break block10;
                    SibTr.event((TraceComponent)tc, (String)"Exception persisting batch", (Object)((Object)persistenceException));
                }
            }
        }
        if (this._instrument != null) {
            this._instrument.add(23, l, n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatch");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        int n = SpillDispatcher.obtainIntConfigParameter(this._msi, "jdbcSpillThreadPriorityDelta", "0", -4, 5);
        this._threads = new Thread[this._maxThreads];
        this._workers = new SpillDispatcherThread[this._maxThreads];
        this._stopRequested = false;
        this._running = true;
        for (int i = 0; i < this._maxThreads; ++i) {
            this._workers[i] = new SpillDispatcherThread(i);
            this._threads[i] = new Thread((Runnable)this._workers[i], "sib.SpillDispatcher-" + i);
            this._threads[i].setDaemon(true);
            this._threads[i].setPriority(5 + n);
            this._threads[i].start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)new Integer(n));
        }
        boolean bl = false;
        SpillDispatcher spillDispatcher = this;
        synchronized (spillDispatcher) {
            if (this._running && !this._stopRequested) {
                bl = true;
                this._stopRequested = true;
            }
        }
        if (bl) {
            for (int i = 0; i < this._maxThreads; ++i) {
                this._workers[i].cleanup();
            }
            long l = System.currentTimeMillis() + 60000L;
            for (int i = 0; i < this._maxThreads; ++i) {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) {
                    l2 = 1L;
                }
                try {
                    if (this._threads[i] == null) continue;
                    this._threads[i].join(l2);
                    if (!this._threads[i].isAlive() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Cannot join dispatcher thread " + this._workers[i]));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void threadWriteErrorOccurred(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"threadWriteErrorOccurred", (Object)new Integer(n));
        }
        ++this._threadWriteErrorsOutstanding;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"threadWriteErrorOccurred");
        }
    }

    public synchronized void threadWriteErrorCleared(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"threadWriteErrorCleared", (Object)new Integer(n));
        }
        if (this._threadWriteErrorsOutstanding > 0) {
            --this._threadWriteErrorsOutstanding;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"threadWriteErrorCleared");
        }
    }

    public String toString() {
        return super.toString() + (this._stopRequested ? " (STOP REQUESTED)" : "") + (!this._running ? " (STOPPED)" : "") + (this._threadWriteErrorsOutstanding > 0 ? " (ERROR)" : "");
    }

    static /* synthetic */ BatchingContextFactory access$1300(SpillDispatcher spillDispatcher) {
        return spillDispatcher._bcfactory;
    }

    static /* synthetic */ MSInstrumentation access$1400(SpillDispatcher spillDispatcher) {
        return spillDispatcher._instrument;
    }

    private static class QueueElement {
        private Task _task;
        private int _dataSize;
        private DispatchNotifier _dn;
        private boolean _notified;
        private boolean _cancelled;

        public QueueElement(Task task, DispatchNotifier dispatchNotifier) {
            this._task = task;
            this._dataSize = this._task.getPersistableSizeApproximation(15);
            this._dn = dispatchNotifier;
        }

        public Task getTask() {
            return this._task;
        }

        public int getDataSize() {
            return this._dataSize;
        }

        public void setCancelled() {
            this._cancelled = true;
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        public void notifyDispatch() {
            if (!this._notified) {
                this._notified = true;
                this._dn.notifyDispatch();
            }
        }
    }

    private class SpillDispatcherThread
    implements Runnable {
        private int _threadNum;
        private String _threadName;
        private LinkedList _waitingQueue;
        private LinkedList _dispatchQueue;
        private Object _dispatchingLock = new Object();
        private long _dispatchedBytes;
        private boolean _writeErrorOccurred = false;
        private int _goodWritesSinceLastError = 0;
        private int _consecutiveWriteErrors = 0;
        private boolean _isContributingToThreadWriteErrors = false;
        private long _writeErrorRetryDelay;
        private boolean _interruptible = false;
        private boolean _threadActive;
        private boolean _notifyOutstanding = false;

        SpillDispatcherThread(int n) {
            this._threadNum = n;
            this._threadName = "sib.SpillDispatcher-" + n;
            SpillDispatcher.this._numThreads++;
            this._waitingQueue = new LinkedList();
            this._dispatchQueue = new LinkedList();
            this._threadActive = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            SpillDispatcher spillDispatcher;
            if (SpillDispatcher.this._msi != null && SpillDispatcher.this._msi._getMessagingEngine() != null) {
                SibTr.push((Object)SpillDispatcher.this._msi._getMessagingEngine());
            }
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            LinkedList linkedList = null;
            boolean bl = false;
            try {
                while (!bl) {
                    Object var14_10;
                    boolean bl2 = false;
                    Object object = this._dispatchingLock;
                    synchronized (object) {
                        if (SpillDispatcher.this._stopRequested) {
                            bl = true;
                        }
                        while (!bl2 && !bl) {
                            this.promoteWaiters();
                            linkedList = this.buildBatch();
                            boolean bl3 = bl2 = !linkedList.isEmpty();
                            if (!bl2) {
                                this._threadActive = false;
                                try {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Spill dispatcher started indefinite wait", (Object)this);
                                    }
                                    this._dispatchingLock.wait(0L);
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Spill dispatcher completed wait", (Object)this);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    this._threadActive = true;
                                    this._notifyOutstanding = false;
                                }
                            }
                            if (!SpillDispatcher.this._stopRequested) continue;
                            bl = true;
                        }
                    }
                    if (!bl && this._writeErrorOccurred && this._consecutiveWriteErrors > 1) {
                        Object object2;
                        Object var10_8;
                        object = this._dispatchingLock;
                        synchronized (object) {
                            this._interruptible = true;
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Dispatcher started retry wait of " + this._writeErrorRetryDelay + " ms"), (Object)this);
                        }
                        try {
                            block54: {
                                Thread.sleep(this._writeErrorRetryDelay);
                                if (!tc.isDebugEnabled()) break block54;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dispatcher completed wait", (Object)this);
                            }
                            var10_8 = null;
                            object2 = this._dispatchingLock;
                        }
                        catch (Throwable throwable) {
                            var10_8 = null;
                            object2 = this._dispatchingLock;
                            synchronized (object2) {
                                this._interruptible = false;
                            }
                            throw throwable;
                        }
                        synchronized (object2) {
                            this._interruptible = false;
                        }
                        {
                            catch (InterruptedException interruptedException) {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dispatcher interrupted during wait", (Object)this);
                                }
                                var10_8 = null;
                                object2 = this._dispatchingLock;
                                synchronized (object2) {
                                    this._interruptible = false;
                                }
                            }
                        }
                    }
                    if (bl || !bl2) continue;
                    boolean bl4 = false;
                    try {
                        if (this.writeBatch(linkedList)) {
                            this.confirmBatchCompleted(linkedList);
                            this.removeWrittenTasks(linkedList.size());
                            bl2 = false;
                            if (this._writeErrorOccurred) {
                                this._consecutiveWriteErrors = 0;
                                ++this._goodWritesSinceLastError;
                                if (this._isContributingToThreadWriteErrors) {
                                    this._isContributingToThreadWriteErrors = false;
                                    SpillDispatcher.this.threadWriteErrorCleared(this._threadNum);
                                }
                                if (this._goodWritesSinceLastError > 16) {
                                    this._writeErrorOccurred = false;
                                }
                            }
                        }
                        bl4 = true;
                        var14_10 = null;
                        if (!bl2) continue;
                        this.confirmBatchCancelled(linkedList);
                        this.removeCancelledTasks(linkedList.size());
                        this.handleWriteError(!bl4);
                    }
                    catch (Throwable throwable) {
                        var14_10 = null;
                        if (bl2) {
                            this.confirmBatchCancelled(linkedList);
                            this.removeCancelledTasks(linkedList.size());
                            this.handleWriteError(!bl4);
                        }
                        throw throwable;
                    }
                }
                Object var16_19 = null;
                spillDispatcher = SpillDispatcher.this;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                SpillDispatcher spillDispatcher2 = SpillDispatcher.this;
                synchronized (spillDispatcher2) {
                    SpillDispatcher.this._numThreads--;
                    if (!SpillDispatcher.this._stopRequested && SpillDispatcher.this._msi != null) {
                        SpillDispatcher.this._msi.reportLocalError();
                    }
                    if (SpillDispatcher.this._numThreads == 0) {
                        SpillDispatcher.this._running = false;
                    }
                }
                throw throwable;
            }
            synchronized (spillDispatcher) {
                SpillDispatcher.this._numThreads--;
                if (!SpillDispatcher.this._stopRequested && SpillDispatcher.this._msi != null) {
                    SpillDispatcher.this._msi.reportLocalError();
                }
                if (SpillDispatcher.this._numThreads == 0) {
                    SpillDispatcher.this._running = false;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
            if (SpillDispatcher.this._msi != null && SpillDispatcher.this._msi._getMessagingEngine() != null) {
                SibTr.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanup");
            }
            Object object = this._dispatchingLock;
            synchronized (object) {
                Iterator iterator = this._waitingQueue.iterator();
                while (iterator.hasNext()) {
                    QueueElement queueElement = (QueueElement)iterator.next();
                    queueElement.notifyDispatch();
                }
                this._waitingQueue.clear();
                if (this.isInterruptible()) {
                    SpillDispatcher.this._threads[this._threadNum].interrupt();
                }
                this._dispatchingLock.notify();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanup");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addTask(Task task, long l, DispatchNotifier dispatchNotifier) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"addTask", (Object)new Object[]{task, new Long(l), dispatchNotifier});
            }
            boolean bl = false;
            QueueElement queueElement = new QueueElement(task, dispatchNotifier);
            int n = queueElement.getDataSize();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("bytesForTask=" + n));
            }
            Object object = this._dispatchingLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    if (this._waitingQueue.isEmpty()) {
                        SibTr.debug((TraceComponent)tc, (String)"waiting queue is empty");
                    }
                    if (this._dispatchQueue.isEmpty()) {
                        SibTr.debug((TraceComponent)tc, (String)"dispatch queue is empty");
                    }
                    SibTr.debug((TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                    SibTr.debug((TraceComponent)tc, (String)("_maxDispatchedBytesPerThread=" + SpillDispatcher.this._maxDispatchedBytesPerThread));
                }
                if (this._waitingQueue.isEmpty() && (this._dispatchQueue.isEmpty() || this._dispatchedBytes + (long)n <= SpillDispatcher.this._maxDispatchedBytesPerThread)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Adding to dispatch queue");
                    }
                    this._dispatchQueue.add(queueElement);
                    this._dispatchedBytes += (long)n;
                    queueElement.notifyDispatch();
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Adding to waiting queue");
                    }
                    this._waitingQueue.add(queueElement);
                    if (this._isContributingToThreadWriteErrors) {
                        queueElement.notifyDispatch();
                    } else {
                        bl = true;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addTask", (Object)new Boolean(bl));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDispatchArrived() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyDispatchArrived");
            }
            Object object = this._dispatchingLock;
            synchronized (object) {
                int n;
                int n2 = n = this._writeErrorOccurred ? 1 : SpillDispatcher.this._maxTasksPerBatch;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("_threadActive=" + this._threadActive));
                    SibTr.debug((TraceComponent)tc, (String)("_dispatchQueue.size()=" + this._dispatchQueue.size()));
                    SibTr.debug((TraceComponent)tc, (String)("maxTasksInBatch=" + n));
                    SibTr.debug((TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                    SibTr.debug((TraceComponent)tc, (String)("_maxBytesPerBatch" + SpillDispatcher.this._maxBytesPerBatch));
                    if (this._waitingQueue.isEmpty()) {
                        SibTr.debug((TraceComponent)tc, (String)"waiting queue is empty");
                    }
                }
                if (!(this._notifyOutstanding || this._threadActive || this._dispatchQueue.size() < n && this._dispatchedBytes < SpillDispatcher.this._maxBytesPerBatch && this._waitingQueue.isEmpty())) {
                    this._notifyOutstanding = false;
                    this._dispatchingLock.notify();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyDispatchArrived");
            }
        }

        private LinkedList buildBatch() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildBatch");
            }
            int n = this._writeErrorOccurred ? 1 : SpillDispatcher.this._maxTasksPerBatch;
            LinkedList<QueueElement> linkedList = new LinkedList<QueueElement>();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("_dispatchQueue.size()=" + this._dispatchQueue.size()));
                SibTr.debug((TraceComponent)tc, (String)("maxTasksInBatch=" + n));
                SibTr.debug((TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                SibTr.debug((TraceComponent)tc, (String)("_minBytesPerBatch=" + SpillDispatcher.this._minBytesPerBatch));
                if (this._waitingQueue.isEmpty()) {
                    SibTr.debug((TraceComponent)tc, (String)"waiting queue is empty");
                }
            }
            if (this._dispatchQueue.size() >= n || this._dispatchedBytes >= SpillDispatcher.this._minBytesPerBatch || !this._waitingQueue.isEmpty()) {
                int n2 = 0;
                long l = 0L;
                long l2 = this._dispatchedBytes;
                Iterator iterator = this._dispatchQueue.iterator();
                while (iterator.hasNext() && n2 < n && l < SpillDispatcher.this._maxBytesPerBatch) {
                    QueueElement queueElement = (QueueElement)iterator.next();
                    Task task = queueElement.getTask();
                    int n3 = queueElement.getDataSize();
                    if ((long)n3 + l >= SpillDispatcher.this._maxBytesPerBatch && n2 != 0) break;
                    if (task.getLink() == null || task.getLink().isInStore() || task.isDeleteOfPersistentRepresentation() && ((Tuple)task.getPersistable()).persistableRepresentationWasCreated()) {
                        if (l2 < SpillDispatcher.this._minBytesPerBatch) break;
                        l += (long)n3;
                        ++n2;
                    } else {
                        queueElement.setCancelled();
                    }
                    l2 -= (long)n3;
                    linkedList.add(queueElement);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No batch built");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildBatch", (Object)new Integer(linkedList.size()));
            }
            return linkedList;
        }

        /*
         * Unable to fully structure code
         */
        private boolean writeBatch(LinkedList var1_1) {
            if (SpillDispatcher.access$500().isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SpillDispatcher.access$500(), (String)"writeBatch", (Object)new Integer(var1_1.size()));
            }
            var2_2 = false;
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = null;
            var6_6 = var1_1.iterator();
            while (var6_6.hasNext()) {
                var7_7 = (QueueElement)var6_6.next();
                var8_11 = var7_7.getTask();
                if (!var7_7.isCancelled()) {
                    if (var8_11.getLink() == null || var8_11.getLink().isInStore() || var8_11.isDeleteOfPersistentRepresentation() && ((Tuple)var8_11.getPersistable()).persistableRepresentationWasCreated()) {
                        try {
                            var8_11.ensureDataAvailable();
                        }
                        catch (PersistentDataEncodingException var9_13) {
                            if (SpillDispatcher.access$500().isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$500(), (String)"ensureDataAvailable encountered item which couldn't encode");
                            }
                            var7_7.setCancelled();
                        }
                        catch (NotInMessageStore var9_14) {
                            if (SpillDispatcher.access$500().isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$500(), (String)"ensureDataAvailable encountered item not in store");
                            }
                            var7_7.setCancelled();
                        }
                        if (!var7_7.isCancelled()) {
                            if (var5_5 == null) {
                                var5_5 = SpillDispatcher.access$1300(SpillDispatcher.this).createBatchingContext();
                            }
                            var8_11.persist(var5_5, 15);
                        }
                    } else {
                        var7_7.setCancelled();
                    }
                }
                if (!var7_7.isCancelled()) continue;
                ++var3_3;
                var4_4 += var7_7.getDataSize();
            }
            if (var5_5 != null) {
                try {
                    var5_5.executeBatch();
                    var2_2 = true;
                }
                catch (SeverePersistenceException var7_8) {
                    FFDCFilter.processException((Throwable)var7_8, (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:1177:1.24", (Object)this);
                    if (SpillDispatcher.access$500().isEventEnabled()) {
                        SibTr.event((TraceComponent)SpillDispatcher.access$500(), (String)"Exception persisting batch", (Object)var7_8);
                    }
                    throw new MessageStoreRuntimeException((Throwable)var7_8);
                }
                catch (PersistenceException var7_9) {
                    FFDCFilter.processException((Throwable)var7_9, (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:1185:1.24", (Object)this);
                    if (!SpillDispatcher.access$500().isEventEnabled()) ** GOTO lbl51
                    SibTr.event((TraceComponent)SpillDispatcher.access$500(), (String)"Exception persisting batch", (Object)var7_9);
                }
            } else {
                var2_2 = true;
            }
lbl51:
            // 4 sources

            if (SpillDispatcher.access$1400(SpillDispatcher.this) != null && (SpillDispatcher.access$1400(SpillDispatcher.this).isEnabled(24) || SpillDispatcher.access$1400(SpillDispatcher.this).isEnabled(25) || SpillDispatcher.access$1400(SpillDispatcher.this).isEnabled(26))) {
                var7_10 = System.currentTimeMillis();
                SpillDispatcher.access$1400(SpillDispatcher.this).add(24, var7_10, var1_1.size());
                SpillDispatcher.access$1400(SpillDispatcher.this).add(25, var7_10, var3_3);
                SpillDispatcher.access$1400(SpillDispatcher.this).add(26, var7_10, var4_4);
            }
            if (SpillDispatcher.access$500().isDebugEnabled() && var3_3 != 0) {
                SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$500(), (String)("writeBatch skipped " + var3_3 + " tasks"));
            }
            if (SpillDispatcher.access$500().isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)SpillDispatcher.access$500(), (String)"writeBatch", (Object)(var2_2 != false ? "true" : "false"));
            }
            return var2_2;
        }

        private void confirmBatchCompleted(LinkedList linkedList) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"confirmBatchCompleted", (Object)new Integer(linkedList.size()));
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                QueueElement queueElement = (QueueElement)iterator.next();
                if (!queueElement.isCancelled()) {
                    ((Tuple)queueElement.getTask().getPersistable()).persistableOperationCompleted();
                    continue;
                }
                ((Tuple)queueElement.getTask().getPersistable()).persistableOperationCancelled();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"confirmBatchCompleted");
            }
        }

        private void confirmBatchCancelled(LinkedList linkedList) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"confirmBatchCancelled", (Object)new Integer(linkedList.size()));
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                QueueElement queueElement = (QueueElement)iterator.next();
                if (!queueElement.isCancelled()) continue;
                ((Tuple)queueElement.getTask().getPersistable()).persistableOperationCancelled();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"confirmBatchCancelled");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWriteError(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleWriteError", (Object)new Boolean(bl));
            }
            boolean bl2 = false;
            if (!this._writeErrorOccurred || this._consecutiveWriteErrors == 0) {
                this._writeErrorOccurred = true;
                this._goodWritesSinceLastError = 0;
                this._consecutiveWriteErrors = 1;
                this._writeErrorRetryDelay = 1L;
            } else {
                bl2 = true;
            }
            if (bl || bl2) {
                if (!this._isContributingToThreadWriteErrors) {
                    this._isContributingToThreadWriteErrors = true;
                    SpillDispatcher.this.threadWriteErrorOccurred(this._threadNum);
                }
                ++this._consecutiveWriteErrors;
                this._writeErrorRetryDelay = 5000 * (this._consecutiveWriteErrors > 5 ? 5 : this._consecutiveWriteErrors);
                Object object = this._dispatchingLock;
                synchronized (object) {
                    Iterator iterator = this._waitingQueue.iterator();
                    while (iterator.hasNext()) {
                        QueueElement queueElement = (QueueElement)iterator.next();
                        queueElement.notifyDispatch();
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleWriteError");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeWrittenTasks(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeWrittenTasks", (Object)new Integer(n));
            }
            if (n > 0) {
                Object object = this._dispatchingLock;
                synchronized (object) {
                    for (int i = 0; i < n; ++i) {
                        QueueElement queueElement = (QueueElement)this._dispatchQueue.remove(0);
                        this._dispatchedBytes -= (long)queueElement.getDataSize();
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeWrittenTasks");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCancelledTasks(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeCancelledTasks", (Object)new Integer(n));
            }
            if (n > 0) {
                Object object = this._dispatchingLock;
                synchronized (object) {
                    Iterator iterator = this._dispatchQueue.iterator();
                    for (int i = 0; i < n; ++i) {
                        QueueElement queueElement = (QueueElement)iterator.next();
                        if (!queueElement.isCancelled()) continue;
                        this._dispatchedBytes -= (long)queueElement.getDataSize();
                        iterator.remove();
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeCancelledTasks");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void promoteWaiters() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
            Object object = this._dispatchingLock;
            synchronized (object) {
                if (!this._waitingQueue.isEmpty() && this._dispatchedBytes < SpillDispatcher.this._maxDispatchedBytesPerThread) {
                    Iterator iterator = this._waitingQueue.iterator();
                    while (iterator.hasNext()) {
                        QueueElement queueElement = (QueueElement)iterator.next();
                        if (this._dispatchedBytes >= SpillDispatcher.this._minBytesPerBatch && this._dispatchedBytes + (long)queueElement.getDataSize() > SpillDispatcher.this._maxDispatchedBytesPerThread) break;
                        queueElement.notifyDispatch();
                        iterator.remove();
                        this._dispatchQueue.add(queueElement);
                        this._dispatchedBytes += (long)queueElement.getDataSize();
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
        }

        public boolean isInterruptible() {
            return this._interruptible;
        }

        public String toString() {
            return this._threadName;
        }
    }
}

