/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.RangeManager;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.persistence.impl.UniqueKeyGeneratorImpl;
import com.ibm.ws.sib.msgstore.transactions.XidManager;

public class PersistenceFactory {
    private PersistenceFactory() {
    }

    public static PersistentMessageStore getPersistentMessageStore(MessageStoreImpl messageStoreImpl, XidManager xidManager, Configuration configuration) {
        String string = messageStoreImpl.getProperty("persistentMessageStoreClass", "com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl");
        PersistentMessageStore persistentMessageStore = null;
        try {
            Class<?> clazz = Class.forName(string);
            persistentMessageStore = (PersistentMessageStore)clazz.newInstance();
            persistentMessageStore.initialize(messageStoreImpl, xidManager, configuration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"001");
            throw new MessageStoreRuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"002");
            throw new MessageStoreRuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistenceFactory.getPersistentMessageStore", (String)"003");
            throw new MessageStoreRuntimeException(illegalAccessException);
        }
        return persistentMessageStore;
    }

    public static UniqueKeyGenerator getUniqueKeyGenerator(PersistentMessageStore persistentMessageStore, String string, int n) throws PersistenceException {
        UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl = new UniqueKeyGeneratorImpl((RangeManager)((Object)persistentMessageStore), string, n);
        uniqueKeyGeneratorImpl.initialize();
        return uniqueKeyGeneratorImpl;
    }
}

