/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.ClassmapTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.ItemTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.ListingTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.MEOwnerTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.TransactionsTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.UniqueKeyGeneratorTableHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDLGenerator {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String CLOUDSCAPE = "cloudscape";
    private static final String DERBY = "derby";
    private static final String DB2 = "db2";
    private static final String ORACLE = "oracle";
    private static final String INFORMIX = "informix";
    private static final String SYBASE = "sybase";
    private static final String MSSQL = "sqlserver";
    private static final String CLOUDSCAPE_51 = "5.1";
    private static final String DERBY_100 = "10.0";
    private static final String ISERIES_52 = "5.2";
    private static final String ISERIES_53 = "5.3";
    private static final String DB2_71 = "7.1";
    private static final String DB2_81 = "8.1";
    private static final String ORACLE_8I = "8i";
    private static final String ORACLE_9I = "9i";
    private static final String ORACLE_10G = "10g";
    private static final String INFORMIX_73 = "7.3";
    private static final String INFORMIX_93 = "9.3";
    private static final String INFORMIX_94 = "9.4";
    private static final String SYBASE_120 = "12.0";
    private static final String SYBASE_125 = "12.5";
    private static final String MSSQL_2000 = "2000";
    private static final String UNKNOWN = "";
    private static final String WINDOWS = "windows";
    private static final String UNIX = "unix";
    private static final String ISERIES = "iseries";
    private static final String ZOS = "zos";
    private static final String SYSTEM_NAME_SWITCH = "-system";
    private static final String SYSTEM_VER_SWITCH = "-version";
    private static final String SYSTEM_PLAT_SWITCH = "-platform";
    private static final String USER_SWITCH = "-user";
    private static final String SCHEMA_SWITCH = "-schema";
    private static final String DROP_SWITCH = "-drop";
    private static final String CREATE_SWITCH = "-create";
    private static final String DB_NAME_SWITCH = "-database";
    private static final String STOGROUP_SWITCH = "-storagegroup";
    private static final String BUFPOOL_SWITCH = "-bufferpool";
    private static final String FIRSTLINE_SWITCH = "-firstline";
    private static final String LASTLINE_SWITCH = "-lastline";
    private static final String STATEMENTEND_SWITCH = "-statementend";
    private static final String NOLINEBREAKS_SWITCH = "-nolinebreaks";
    private static final String NOBLANKLINES_SWITCH = "-noblanklines";
    private static final String PERMANENT_SWITCH = "-permanent";
    private static final String TEMPORARY_SWITCH = "-temporary";
    private static final String CLASS_TABLE = "SIBCLASSMAP";
    private static final String LIST_TABLE = "SIBLISTING";
    private static final String XACTS_TABLE = "SIBXACTS";
    private static final String KEYS_TABLE = "SIBKEYS";
    private static final String ME_TABLE = "SIBOWNER";
    private static final Pattern CREATE_TABLE = Pattern.compile("^CREATE TABLE ");
    private static final Pattern OPEN_BRACKET = Pattern.compile("\\(");
    private static final Pattern CLOSE_BRACKET = Pattern.compile(" \\)");
    private static final Pattern SEPARATOR = Pattern.compile(", ");
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s");
    private static final int EXIT_NORMAL = 0;
    private static final int EXIT_ERROR = 1;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_LINE_LENGTH = 72;
    private static String systemName = "cloudscape";
    private static String systemPlatform = "windows";
    private static String userName = "IBMUSER";
    private static String schemaName = "IBMWSSIB";
    private static String stogroup = "SIBSG";
    private static String database = "SIBDB";
    private static String bufferpool = "BP1";
    private static int numberOfPermanentTables = Integer.parseInt("1");
    private static int numberOfTemporaryTables = Integer.parseInt("1");
    private static boolean generateCreateDDL = true;
    private static String firstLine = null;
    private static String lastLine = null;
    private static String statementEnd = "";
    private static boolean useLineBreaks = true;
    private static boolean useBlankLines = true;
    private static String systemVersion = null;
    private static Map systemMapping = new HashMap();

    public static void main(String[] stringArray) {
        String string;
        String string2;
        int n;
        int n2 = stringArray.length;
        try {
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].equals(SYSTEM_NAME_SWITCH)) {
                    systemName = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(SYSTEM_VER_SWITCH)) {
                    systemVersion = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(SYSTEM_PLAT_SWITCH)) {
                    systemPlatform = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(USER_SWITCH)) {
                    userName = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(SCHEMA_SWITCH)) {
                    schemaName = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(DROP_SWITCH)) {
                    generateCreateDDL = false;
                    continue;
                }
                if (stringArray[n].equals(CREATE_SWITCH)) {
                    generateCreateDDL = true;
                    continue;
                }
                if (stringArray[n].equals(DB_NAME_SWITCH)) {
                    database = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(STOGROUP_SWITCH)) {
                    stogroup = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(BUFPOOL_SWITCH)) {
                    bufferpool = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(FIRSTLINE_SWITCH)) {
                    firstLine = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(LASTLINE_SWITCH)) {
                    lastLine = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(STATEMENTEND_SWITCH)) {
                    statementEnd = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals(NOLINEBREAKS_SWITCH)) {
                    useLineBreaks = false;
                    continue;
                }
                if (stringArray[n].equals(NOBLANKLINES_SWITCH)) {
                    useBlankLines = false;
                    continue;
                }
                if (stringArray[n].equals(PERMANENT_SWITCH)) {
                    numberOfPermanentTables = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals(TEMPORARY_SWITCH)) {
                    numberOfTemporaryTables = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                throw new Exception();
            }
        }
        catch (NumberFormatException numberFormatException) {
            DDLGenerator.displayError(stringArray[n]);
            System.exit(1);
        }
        catch (Exception exception) {
            DDLGenerator.displayUsage();
            System.exit(1);
        }
        if (systemVersion == null) {
            systemVersion = systemName.equals(CLOUDSCAPE) ? CLOUDSCAPE_51 : (systemName.equals(DERBY) ? DERBY_100 : (systemName.equals(ORACLE) ? ORACLE_8I : (systemName.equals(DB2) ? (systemPlatform.equals(ZOS) ? DB2_71 : (systemPlatform.equals(ISERIES) ? ISERIES_52 : DB2_81)) : (systemName.equals(MSSQL) ? MSSQL_2000 : (systemName.equals(INFORMIX) ? INFORMIX_93 : (systemName.equals(SYBASE) ? SYBASE_120 : UNKNOWN))))));
        }
        if ((string2 = (String)systemMapping.get(string = systemName + "-" + systemVersion + "-" + systemPlatform)) == null) {
            System.out.println(nls.getFormattedMessage("DATABASE_NOT_SUPPORTED_SIMS1503", new Object[]{systemName, systemVersion, systemPlatform}, null));
            System.exit(1);
        }
        if (numberOfPermanentTables < 0) {
            System.out.println(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{new Integer(numberOfPermanentTables)}, null));
            System.exit(1);
        }
        if (numberOfTemporaryTables < 0) {
            System.out.println(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{new Integer(numberOfTemporaryTables)}, null));
            System.exit(1);
        }
        int n3 = 1 + numberOfPermanentTables + numberOfTemporaryTables;
        if (firstLine != null) {
            System.out.println(firstLine);
            if (useBlankLines) {
                System.out.println();
            }
        }
        if (generateCreateDDL) {
            String string3;
            if (string2 == "DB2390") {
                DDLGenerator.formatAndDisplay(TableHelper.getCreateStogroupSQL(stogroup));
                DDLGenerator.formatAndDisplay(TableHelper.getCreateDatabaseSQL(database, stogroup, bufferpool));
            }
            if (string2 == "db2j" || string2 == "DB2" || string2 == "Derby") {
                DDLGenerator.formatAndDisplay(TableHelper.getCreateSchemaSQL(schemaName));
            }
            DDLGenerator.formatAndDisplay(MEOwnerTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, ME_TABLE, string2));
            DDLGenerator.formatAndDisplay(ClassmapTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, CLASS_TABLE, string2));
            DDLGenerator.formatAndDisplay(ListingTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, LIST_TABLE, string2));
            for (n = 0; n < n3; ++n) {
                string3 = "SIB" + DDLGenerator.intToString(n);
                DDLGenerator.formatAndDisplay(ItemTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, string3, string2));
            }
            DDLGenerator.formatAndDisplay(TransactionsTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, XACTS_TABLE, string2));
            DDLGenerator.formatAndDisplay(UniqueKeyGeneratorTableHelper.getCreateTableSql(database, stogroup, bufferpool, schemaName, KEYS_TABLE, string2));
            if (string2 != "db2j" && string2 != "Derby") {
                DDLGenerator.formatAndDisplay(ClassmapTableHelper.getGrantSql(schemaName, ME_TABLE, userName));
                DDLGenerator.formatAndDisplay(ClassmapTableHelper.getGrantSql(schemaName, CLASS_TABLE, userName));
                DDLGenerator.formatAndDisplay(ListingTableHelper.getGrantSql(schemaName, LIST_TABLE, userName));
                for (n = 0; n < n3; ++n) {
                    string3 = "SIB" + DDLGenerator.intToString(n);
                    DDLGenerator.formatAndDisplay(ItemTableHelper.getGrantSql(schemaName, string3, userName));
                }
                DDLGenerator.formatAndDisplay(TransactionsTableHelper.getGrantSql(schemaName, XACTS_TABLE, userName));
                DDLGenerator.formatAndDisplay(UniqueKeyGeneratorTableHelper.getGrantSql(schemaName, KEYS_TABLE, userName));
            }
        } else {
            DDLGenerator.formatAndDisplay(MEOwnerTableHelper.getDropTableSql(database, schemaName, ME_TABLE, string2));
            DDLGenerator.formatAndDisplay(ClassmapTableHelper.getDropTableSql(database, schemaName, CLASS_TABLE, string2));
            DDLGenerator.formatAndDisplay(ListingTableHelper.getDropTableSql(database, schemaName, LIST_TABLE, string2));
            for (n = 0; n < n3; ++n) {
                String string4 = "SIB" + DDLGenerator.intToString(n);
                DDLGenerator.formatAndDisplay(ItemTableHelper.getDropTableSql(database, schemaName, string4, string2));
            }
            DDLGenerator.formatAndDisplay(TransactionsTableHelper.getDropTableSql(database, schemaName, XACTS_TABLE, string2));
            DDLGenerator.formatAndDisplay(UniqueKeyGeneratorTableHelper.getDropTableSql(database, schemaName, KEYS_TABLE, string2));
            if (string2 == "db2j" || string2 == "DB2" || string2 == "Derby") {
                DDLGenerator.formatAndDisplay(TableHelper.getDropSchemaSQL(schemaName, string2));
            }
            if (string2 == "DB2390") {
                DDLGenerator.formatAndDisplay(TableHelper.getDropDatabaseSQL(database));
                DDLGenerator.formatAndDisplay(TableHelper.getDropStogroupSQL(stogroup));
            }
        }
        if (lastLine != null) {
            System.out.println(lastLine);
        }
        System.exit(0);
    }

    private static void formatAndDisplay(String[] stringArray) {
        String[] stringArray2 = null;
        Matcher matcher = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (useLineBreaks) {
                matcher = CREATE_TABLE.matcher(stringArray[i]);
                if (matcher.lookingAt()) {
                    stringArray2 = OPEN_BRACKET.split(stringArray[i], 2);
                    stringArray2[0] = stringArray2[0].trim();
                    System.out.println(stringArray2[0] + " (");
                    stringArray2 = SEPARATOR.split(stringArray2[1]);
                    int n = stringArray2.length - 1;
                    for (int j = 0; j < n; ++j) {
                        stringArray2[j] = stringArray2[j].trim();
                        System.out.println("  " + stringArray2[j] + ",");
                    }
                    stringArray2 = CLOSE_BRACKET.split(stringArray2[n], 2);
                    System.out.println("  " + stringArray2[0]);
                    System.out.println(DDLGenerator.fold(")" + stringArray2[1] + statementEnd));
                } else {
                    System.out.println(DDLGenerator.fold(stringArray[i] + statementEnd));
                }
            } else {
                System.out.println(stringArray[i] + statementEnd);
            }
            if (!useBlankLines) continue;
            System.out.println();
        }
    }

    private static void formatAndDisplay(String string) {
        if (useLineBreaks) {
            System.out.println(DDLGenerator.fold(string + statementEnd));
        } else {
            System.out.println(string + statementEnd);
        }
        if (useBlankLines) {
            System.out.println();
        }
    }

    private static String fold(String string) {
        int n = string.length();
        if (n <= 72) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        String[] stringArray = WHITE_SPACE.split(string);
        int n2 = stringArray.length;
        String string2 = stringArray[0];
        n = string2.length();
        stringBuffer.append(string2);
        for (int i = 1; i < n2; ++i) {
            string2 = stringArray[i];
            if ((n += 1 + string2.length()) >= 72) {
                stringBuffer.append(LINE_SEPARATOR);
                n = string2.length();
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String intToString(int n) {
        String string = "000";
        int n2 = string.length();
        String string2 = Integer.toString(n);
        int n3 = string2.length();
        if (n3 < n2) {
            string2 = string.substring(0, n2 - n3) + string2;
        } else if (n3 > n2) {
            throw new NumberFormatException();
        }
        return string2;
    }

    private static void displayError(String string) {
        System.out.println(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{string}, null));
    }

    private static void displayUsage() {
        System.out.println(nls.getFormattedMessage("DDLGENERATOR_USAGE_INFO_SIMS1539", new Object[]{SYSTEM_NAME_SWITCH, SYSTEM_VER_SWITCH, SYSTEM_PLAT_SWITCH, SCHEMA_SWITCH, USER_SWITCH, CREATE_SWITCH, DROP_SWITCH, DB_NAME_SWITCH, STOGROUP_SWITCH, BUFPOOL_SWITCH, STATEMENTEND_SWITCH, NOBLANKLINES_SWITCH, NOLINEBREAKS_SWITCH, FIRSTLINE_SWITCH, LASTLINE_SWITCH, PERMANENT_SWITCH, TEMPORARY_SWITCH}, null));
    }

    static {
        systemMapping.put("cloudscape-5.1-windows", "db2j");
        systemMapping.put("cloudscape-5.1-unix", "db2j");
        systemMapping.put("cloudscape-5.1-zos", "db2j");
        systemMapping.put("derby-10.0-windows", "Derby");
        systemMapping.put("derby-10.0-unix", "Derby");
        systemMapping.put("derby-10.0-zos", "Derby");
        systemMapping.put("db2-8.1-windows", "DB2");
        systemMapping.put("db2-8.1-unix", "DB2");
        systemMapping.put("db2-5.2-iseries", "DB2iSeries");
        systemMapping.put("db2-5.3-iseries", "DB2iSeries");
        systemMapping.put("db2-7.1-zos", "DB2390");
        systemMapping.put("db2-8.1-zos", "DB2390");
        systemMapping.put("oracle-8i-windows", "Oracle8i");
        systemMapping.put("oracle-8i-unix", "Oracle8i");
        systemMapping.put("oracle-9i-windows", "Oracle");
        systemMapping.put("oracle-9i-unix", "Oracle");
        systemMapping.put("oracle-10g-windows", "Oracle");
        systemMapping.put("oracle-10g-unix", "Oracle");
        systemMapping.put("sqlserver-2000-windows", "MS SQL Server");
        systemMapping.put("informix-7.3-windows", "Informix_73");
        systemMapping.put("informix-7.3-unix", "Informix_73");
        systemMapping.put("informix-9.3-windows", "Informix");
        systemMapping.put("informix-9.3-unix", "Informix");
        systemMapping.put("informix-9.4-windows", "Informix");
        systemMapping.put("informix-9.4-unix", "Informix");
        systemMapping.put("sybase-12.0-windows", "Sybase");
        systemMapping.put("sybase-12.0-unix", "Sybase");
        systemMapping.put("sybase-12.5-windows", "Sybase");
        systemMapping.put("sybase-12.5-unix", "Sybase");
    }
}

