/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RawDataDumper
implements XmlConstants {
    private final PersistentMessageStore _persistentMessageStore;
    private final HashMap _tupleMap = new HashMap();
    private final FormattedWriter _writer;
    private final boolean _callbackToItem;

    public RawDataDumper(PersistentMessageStore persistentMessageStore, FormattedWriter formattedWriter) {
        this(persistentMessageStore, formattedWriter, false);
    }

    public RawDataDumper(PersistentMessageStore persistentMessageStore, FormattedWriter formattedWriter, boolean bl) {
        this._persistentMessageStore = persistentMessageStore;
        this._writer = formattedWriter;
        this._callbackToItem = bl;
    }

    private final void _buildTupleMap(PersistentMessageStore persistentMessageStore) throws PersistenceException {
        List list = persistentMessageStore.readAllStreams();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Persistable persistable = (Persistable)iterator.next();
            long l = persistable.getContainingStreamId();
            Long l2 = new Long(l);
            ArrayList<Persistable> arrayList = (ArrayList<Persistable>)this._tupleMap.get(l2);
            if (null == arrayList) {
                arrayList = new ArrayList<Persistable>();
                this._tupleMap.put(l2, arrayList);
            }
            arrayList.add(persistable);
        }
    }

    private final void _startTag(String string, Persistable persistable) throws IOException {
        this._writer.write(60);
        this._writer.write(string);
        this._writer.write(32);
        this._writer.write("id");
        this._writer.write("=\"");
        this._writer.write(Long.toString(persistable.getUniqueId()));
        this._writer.write("\" >");
    }

    private final void _writeCallback(Persistable persistable) throws IOException {
        if (this._callbackToItem) {
            try {
                String string = persistable.getItemClassName();
                AbstractItem abstractItem = (AbstractItem)Class.forName(string).newInstance();
                byte[] byArray = this._persistentMessageStore.readDataOnly(persistable);
                if (byArray != null) {
                    abstractItem.restore(byArray);
                    abstractItem.xmlWriteOn(this._writer);
                }
            }
            catch (IOException iOException) {
                this._writer.write((Throwable)iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                this._writer.write(throwable);
            }
        }
    }

    private final void _writeItem(Persistable persistable) throws IOException {
        this._startTag("Item", persistable);
        this._writer.indent();
        this._writer.newLine();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("Item");
    }

    private final void _writeItemReference(Persistable persistable) throws IOException {
        this._startTag("Reference", persistable);
        this._writer.indent();
        this._writer.newLine();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("Reference");
    }

    private final void _writeItemStream(Persistable persistable) throws IOException {
        Object object;
        Object object2;
        this._startTag("ItemStream", persistable);
        this._writer.indent();
        this._writer.newLine();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.newLine();
        ArrayList arrayList = (ArrayList)this._tupleMap.remove(new Long(persistable.getUniqueId()));
        this._writer.startTag("itemStreams");
        this._writer.indent();
        if (null != arrayList) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (Persistable)object2.next();
                if (object.getTupleType() != TupleTypeEnum.ITEM_STREAM) continue;
                this._writer.newLine();
                this._writeItemStream((Persistable)object);
                this._writer.flush();
            }
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("itemStreams");
        this._writer.newLine();
        this._writer.startTag("referenceStreams");
        this._writer.indent();
        if (null != arrayList) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (Persistable)object2.next();
                if (object.getTupleType() != TupleTypeEnum.REFERENCE_STREAM) continue;
                this._writer.newLine();
                this._writeReferenceStream((Persistable)object);
                this._writer.flush();
            }
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("referenceStreams");
        this._writer.newLine();
        this._writer.startTag("items");
        this._writer.indent();
        try {
            object2 = this._persistentMessageStore.readNonStreamItems(persistable);
            object = object2.iterator();
            while (object.hasNext()) {
                Persistable persistable2 = (Persistable)object.next();
                this._writer.newLine();
                this._writeItem(persistable2);
                this._writer.flush();
            }
        }
        catch (PersistenceException persistenceException) {
            this._writer.write("Exception reading items");
            this._writer.write((Throwable)((Object)persistenceException));
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("items");
        this._writer.outdent();
        this._writer.newLine();
        this._writer.write("</");
        this._writer.write("ItemStream");
        this._writer.write(62);
    }

    private final void _writeReferenceStream(Persistable persistable) throws IOException {
        this._startTag("ReferenceStream", persistable);
        this._writer.indent();
        this._writer.newLine();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.newLine();
        this._writer.startTag("references");
        this._writer.indent();
        try {
            List list = this._persistentMessageStore.readNonStreamItems(persistable);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Persistable persistable2 = (Persistable)iterator.next();
                this._writer.newLine();
                this._writeItemReference(persistable2);
                this._writer.flush();
            }
        }
        catch (PersistenceException persistenceException) {
            this._writer.write("Exception reading items");
            this._writer.write((Throwable)((Object)persistenceException));
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("references");
        this._writer.outdent();
        this._writer.newLine();
        this._writer.write("</");
        this._writer.write("ReferenceStream");
        this._writer.write(62);
    }

    public final void dump() throws IOException {
        this._writer.startTag("MessageStore");
        this._writer.indent();
        try {
            this._writer.newLine();
            this._writer.startTag("itemStreams");
            this._writer.indent();
            try {
                Persistable persistable = this._persistentMessageStore.readRootPersistable();
                this._buildTupleMap(this._persistentMessageStore);
                ArrayList arrayList = (ArrayList)this._tupleMap.remove(new Long(persistable.getUniqueId()));
                for (int i = 0; null != arrayList && i < arrayList.size(); ++i) {
                    Persistable persistable2 = (Persistable)arrayList.get(i);
                    this._writer.newLine();
                    this._writeItemStream(persistable2);
                    this._writer.flush();
                }
            }
            catch (PersistenceException persistenceException) {
                this._writer.write("Exception reading itemStreams");
                this._writer.write((Throwable)((Object)persistenceException));
            }
            this._writer.outdent();
            this._writer.newLine();
            this._writer.endTag("itemStreams");
        }
        catch (IOException iOException) {
            this._writer.write("exception reading root item stream");
            this._writer.write((Throwable)iOException);
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("MessageStore");
        this._writer.newLine();
        this._writer.flush();
    }
}

