/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.WASConfiguration;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.RootMembership;
import com.ibm.ws.sib.msgstore.cache.ref.ItemStorageManager;
import com.ibm.ws.sib.msgstore.expiry.CacheLoader;
import com.ibm.ws.sib.msgstore.expiry.Expirer;
import com.ibm.ws.sib.msgstore.impl.ItemLinkMap;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.msgstore.impl.MultiHashMap;
import com.ibm.ws.sib.msgstore.impl.RawDataDumper;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistenceFactory;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.MSTransactionFactory;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionFactory;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.Runtime;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

public final class MessageStoreImpl
extends MessageStore
implements MessageStoreConstants,
XmlConstants {
    private static final String LOGS_DIR = "logs";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String SERVER_ROOT = "server.root";
    private static final String STATE_UNINITIALIZED = "Uninitialized";
    private static final String STATE_STARTED = "Started";
    private static final String STATE_STOPPED = "Stopped";
    private static final String STATE_STARTING = "Starting";
    private static final TraceComponent tc = SibTr.register((Class)MessageStoreImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String XML_CANNOT_BE_WRITTEN = "XML cannot be written as the message store has not started";
    private CacheLoader _cacheLoader = null;
    private long _cacheLoaderInterval = -1L;
    private Configuration _configuration = null;
    private final Hashtable _customProperties = new Hashtable();
    private Expirer _expirer = null;
    private long _expiryInterval = -1L;
    private int _spillUpperLimit;
    private int _spillLowerLimit;
    private JsHealthMonitor _healthMonitor;
    private JsHealthState _healthState;
    private MSInstrumentation _instrumentation = null;
    private ItemStorageManager _itemStorageManager;
    private XidManager _manager;
    private String _state = "Uninitialized";
    private static final Object _startLock = new Object();
    private Map _membershipMap = null;
    private JsMessagingEngine _messagingEngine = null;
    private PersistentMessageStore _persistentMessageStore = null;
    private RootMembership _rootMembership;
    private UniqueKeyGenerator _tickCountGenerator;
    private TransactionFactory _transactionFactory;
    private UniqueKeyGenerator _uniqueIdentifierGenerator;
    private UniqueKeyGenerator _uniqueLockIDGenerator;

    public MessageStoreImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this._manager = new XidManager(this);
        this._expirer = new Expirer(this);
        this._cacheLoader = new CacheLoader(this);
        this._healthState = JsHealthState.getOK();
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public final AbstractItem _findById(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_findById", (Object)new Long(l));
        }
        AbstractItem abstractItem = null;
        AbstractItemLink abstractItemLink = this.getLink(l);
        if (null != abstractItemLink) {
            abstractItem = abstractItemLink.getItem();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_findById", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final Expirer _getExpirer() {
        return this._expirer;
    }

    public final MSInstrumentation _getInstrumentation() {
        return this._instrumentation;
    }

    public final JsMessagingEngine _getMessagingEngine() {
        return this._messagingEngine;
    }

    public final void _setMembership(Membership membership, AbstractItem abstractItem) {
        super._setMembership(membership, abstractItem);
    }

    private final void _xmlWriteRawOn(FormattedWriter formattedWriter) throws IOException {
        new RawDataDumper(this._persistentMessageStore, formattedWriter).dump();
    }

    public void add(ItemStream itemStream, long l, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{itemStream, transaction});
        }
        this._rootMembership.addItemStream(itemStream, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void commitPreparedTransaction(String string) throws TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitPreparedTransaction", (Object)string);
        }
        if (this._manager != null) {
            PersistentTranId persistentTranId = new PersistentTranId(string);
            this._manager.commit(persistentTranId, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPreparedTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"destroy");
        }
        Object object = _startLock;
        synchronized (object) {
            if (!this._state.equals(STATE_STOPPED)) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            this._configuration = null;
            this._instrumentation.terminate();
            this._instrumentation = null;
            this._state = STATE_UNINITIALIZED;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public void dump() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump");
        }
        String string = this.generateDumpFileName();
        System.out.println("MessageStore dumping to: " + string);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FormattedWriter formattedWriter = new FormattedWriter((Writer)fileWriter);
        try {
            this.xmlRequestWriteOnFile(formattedWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    public void dump(FormattedWriter formattedWriter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump");
        }
        try {
            this.xmlRequestWriteOnFile(formattedWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    public void dump(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump", (Object)new String(string));
        }
        if (string != null && string.equalsIgnoreCase("raw")) {
            this.dumpRaw();
        } else {
            this.dump();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    public void dump(FormattedWriter formattedWriter, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump", (Object)new String(string));
        }
        if (string != null && string.equalsIgnoreCase("raw")) {
            this.dumpRaw(formattedWriter);
        } else {
            this.dump(formattedWriter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    public void dumpRaw() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpRaw");
        }
        String string = this.generateDumpFileName();
        System.out.println("MessageStore dumping to: " + string);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FormattedWriter formattedWriter = new FormattedWriter((Writer)fileWriter);
        try {
            this.xmlRequestWriteRawDataOnFile(formattedWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpRaw");
        }
    }

    public void dumpRaw(FormattedWriter formattedWriter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpRaw");
        }
        try {
            this.xmlRequestWriteRawDataOnFile(formattedWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpRaw");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public final void expirerStart() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirerStart");
        }
        this._expirer.start(this._expiryInterval, this._messagingEngine);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirerStart");
        }
    }

    public final void expirerStop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirerStop");
        }
        this._expirer.stop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirerStop");
        }
    }

    public AbstractItem findById(long l) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object)new Long(l));
        }
        AbstractItem abstractItem = this._findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)abstractItem);
        }
        return abstractItem;
    }

    public ItemStream findByStreamId(long l) {
        ItemStream itemStream = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findByIdInRoot", (Object)new Long(l));
        }
        itemStream = (ItemStream)this._findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findByIdInRoot", (Object)itemStream);
        }
        return itemStream;
    }

    public ItemStream findFirstMatching(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        ItemStream itemStream = this._rootMembership.findFirstMatchingItemStream(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)itemStream);
        }
        return itemStream;
    }

    private String generateDumpFileName() {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"generateDumpFileName");
        }
        if ((string = System.getProperty(SERVER_ROOT)) == null) {
            string = "";
        }
        if (string != "") {
            Server server;
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string = string + LOGS_DIR;
            string = string + File.separator;
            object = JsAdminService.getInstance();
            if (object != null && (server = (Server)object.getService(Server.class)) != null) {
                string = string + server.getName();
                string = string + File.separator;
            }
        }
        if (this._messagingEngine != null) {
            string = string + this._messagingEngine.getName();
            string = string + "-";
            string = string + this._messagingEngine.getUuid().toString();
            string = string + "-";
            object = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            string = string + ((DateFormat)object).format(new Date());
            string = string + ".xml";
        }
        if (string.equals("")) {
            string = "default.xml";
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"generateDumpFileName", (Object)string);
        }
        return string;
    }

    public final CacheStatistics getCacheStatistics() {
        return this._itemStorageManager;
    }

    public Configuration getConfig() {
        return this._configuration;
    }

    public final int getExpiryIndexSize() {
        return this._expirer.size();
    }

    public final JsHealthState getHealthState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)("return=" + this._healthState));
        }
        return this._healthState;
    }

    public final AbstractItemLink getLink(long l) {
        return this._membershipMap.get(l);
    }

    public final ItemStorageManager getManagedCache() {
        return this._itemStorageManager;
    }

    public Membership getMembership(long l) {
        return this._membershipMap.get(l);
    }

    public CacheStatistics getNonStoredCacheStatistics() {
        return this._itemStorageManager.getNonStoredCacheStatistics();
    }

    public final PersistentMessageStore getPersistentMessageStore() {
        return this._persistentMessageStore;
    }

    public Collection getPreparedTransactions() {
        Xid[] xidArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPreparedTransactions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._manager != null && (xidArray = this._manager.listRemoteInDoubts()) != null) {
            for (int i = 0; i < xidArray.length; ++i) {
                String string = ((PersistentTranId)xidArray[i]).toString();
                arrayList.add(string);
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("xid " + string + " in-doubt"));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPreparedTransactions");
        }
        return arrayList;
    }

    public final String getProperty(String string, String string2) {
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProperty", (Object)new Object[]{string, string2});
        }
        if (null == (string4 = (String)this._customProperties.get(string3 = "sib.msgstore." + string))) {
            string4 = RuntimeInfo.getProperty((String)string3);
        }
        if (null == string4) {
            string4 = System.getProperty(string3);
        }
        if (null == string4) {
            string4 = string2;
        } else if (!string4.equals(string2)) {
            Runtime.changedPropertyValue((String)string3, (String)string4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProperty", (Object)string4);
        }
        return string4;
    }

    public int getSpillLowerLimit() {
        return this._spillLowerLimit;
    }

    public int getSpillUpperLimit() {
        return this._spillUpperLimit;
    }

    public CacheStatistics getStoredCacheStatistics() {
        return this._itemStorageManager.getStoredCacheStatistics();
    }

    public TransactionFactory getTransactionFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionFactory");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionFactory", (Object)("return=" + this._transactionFactory));
        }
        return this._transactionFactory;
    }

    public final long getUniqueLockID(int n) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueLockID");
        }
        long l = -1L;
        l = 1 == n ? this._uniqueIdentifierGenerator.getPerInstanceUniqueValue() : this._uniqueLockIDGenerator.getUniqueValue();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueLockID", (Object)new Long(l));
        }
        return l;
    }

    public final long getUniqueTickCount() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueTickCount");
        }
        long l = -1L;
        l = this._tickCountGenerator.getUniqueValue();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueTickCount", (Object)new Long(l));
        }
        return l;
    }

    public final long getUniqueValue(int n) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueValue", (Object)new Integer(n));
        }
        long l = -1L;
        l = 1 == n ? this._uniqueIdentifierGenerator.getPerInstanceUniqueValue() : this._uniqueIdentifierGenerator.getUniqueValue();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueValue", (Object)new Long(l));
        }
        return l;
    }

    public XidManager getXidManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getXidManager");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getXidManager", (Object)("return=" + this._manager));
        }
        return this._manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(Configuration configuration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)configuration);
        }
        Object object = _startLock;
        synchronized (object) {
            if (!this._state.equals(STATE_UNINITIALIZED)) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            this._configuration = configuration;
            if (this._instrumentation == null) {
                this._instrumentation = new MSInstrumentation();
            }
            this._state = STATE_STOPPED;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        Object object;
        block6: {
            this._messagingEngine = jsMessagingEngine;
            try {
                object = Class.forName("com.ibm.ws.pmi.preprocess.sib_msgstore_impl_StatsTemplateLookup");
                StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((StatsTemplateLookup)((Class)object).newInstance()));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MessageStore StatsTemplateLookup class not found.");
            }
        }
        this._instrumentation = new MSInstrumentation(this._messagingEngine);
        object = WASConfiguration.getDefaultWasConfiguration();
        if (jsMessagingEngine.datastoreExists()) {
            JsEObject jsEObject = jsMessagingEngine.getDatastore();
            ((WASConfiguration)object).setDatasourceJndiName(jsEObject.getAttribute("dataSourceName"));
            ((WASConfiguration)object).setAuthenticationAlias(jsEObject.getAttribute("authAlias"));
            ((Configuration)object).setDatabaseSchemaName(jsEObject.getAttribute("schemaName"));
            ((Configuration)object).setCleanPersistenceOnStart(false);
            if (jsEObject.getAttribute("createTables").equalsIgnoreCase("true")) {
                ((Configuration)object).setCreateTablesAutomatically(true);
            } else {
                ((Configuration)object).setCreateTablesAutomatically(false);
            }
        } else {
            throw new IllegalStateException(nls.getString("MSGSTORE_CONFIGURATION_ERROR_SIMS0503"));
        }
        this.initialize((Configuration)object);
    }

    public final boolean itemsCanExpire() {
        boolean bl = false;
        if (this._expirer != null) {
            bl = this._expirer.isRunning();
        }
        return bl;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) throws MessageStoreException {
        return this._rootMembership.newNonLockingItemStreamCursor(filter);
    }

    public final void register(AbstractItemLink abstractItemLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"register", (Object)abstractItemLink);
        }
        long l = abstractItemLink.getID();
        this._membershipMap.put(l, abstractItemLink);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"register");
        }
    }

    public final void registerLink(AbstractItemLink abstractItemLink, AbstractItem abstractItem) {
        this.register(abstractItemLink);
        this._setMembership(abstractItemLink, abstractItem);
    }

    public ItemStream removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        ItemStream itemStream = this._rootMembership.removeFirstMatchingItemStream(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)itemStream);
        }
        return itemStream;
    }

    public final void reportGlobalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportGlobalError");
        }
        if (this._healthState.couldBeWorse()) {
            this._healthState = JsHealthState.getGlobalError();
        }
        if (this._healthMonitor == null) {
            if (this._messagingEngine != null && this._messagingEngine instanceof JsHealthMonitor) {
                this._healthMonitor = (JsHealthMonitor)this._messagingEngine;
                this._healthMonitor.reportGlobalError();
            }
        } else {
            this._healthMonitor.reportGlobalError();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportGlobalError");
        }
    }

    public final void reportLocalError() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportLocalError");
        }
        if (this._healthState.isOK()) {
            this._healthState = JsHealthState.getLocalError();
        }
        if (this._healthMonitor == null) {
            if (this._messagingEngine != null && this._messagingEngine instanceof JsHealthMonitor) {
                this._healthMonitor = (JsHealthMonitor)this._messagingEngine;
                this._healthMonitor.reportLocalError();
            }
        } else {
            this._healthMonitor.reportLocalError();
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportLocalError");
        }
    }

    public void rollbackPreparedTransaction(String string) throws TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackPreparedTransaction", (Object)string);
        }
        if (this._manager != null) {
            PersistentTranId persistentTranId = new PersistentTranId(string);
            this._manager.rollback(persistentTranId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackPreparedTransaction");
        }
    }

    public void setAttribute(String string, String string2) {
    }

    public void setCacheLoaderInterval(long l) {
        this._cacheLoaderInterval = l;
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCustomProperty", (Object)new Object[]{string, string2});
        }
        this._customProperties.put(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        Object object2 = _startLock;
        synchronized (object2) {
            if (!this._state.equals(STATE_STOPPED)) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            this._state = STATE_STARTING;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        object2 = this.getProperty("itemMapType", "fastMap");
        String string = this.getProperty("itemMapSize", "18");
        int n2 = -1;
        if (null != string) {
            n2 = Integer.parseInt(string);
        }
        if ("fastMap".equals(object2)) {
            object = this.getProperty("itemMapParallelism", "7");
            int n3 = -1;
            if (null != object) {
                n3 = Integer.parseInt((String)object);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("using itemLinkMap(" + n2 + "/" + n3 + ")"));
            }
            this._membershipMap = new ItemLinkMap(n2, n3);
        } else {
            if (n2 > 50 || n2 < 5) {
                n2 = 20;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("using multiMap(" + n2 + ")"));
            }
            this._membershipMap = new MultiHashMap(n2);
        }
        this._itemStorageManager = new ItemStorageManager();
        this._itemStorageManager.initialize(this);
        try {
            this._persistentMessageStore = PersistenceFactory.getPersistentMessageStore(this, this._manager, this._configuration);
            this._persistentMessageStore.start();
            try {
                object = this.getProperty("spillUpperLimit", "20");
                this._spillUpperLimit = Integer.parseInt((String)object);
                object = this.getProperty("spillLowerLimit", "2");
                this._spillLowerLimit = Integer.parseInt((String)object);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Using spillUpperLimit=" + this._spillUpperLimit + "; spillLowerLimit=" + this._spillLowerLimit));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Exception " + numberFormatException + " while parsing spill limits"));
                }
                throw numberFormatException;
            }
            object = _startLock;
            synchronized (object) {
                Object object3;
                if (!this._state.equals(STATE_STARTING)) {
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
                }
                this._manager.restart(this._persistentMessageStore);
                String string2 = this.getProperty("dumpDataStoreOnStartup", null);
                if (null != string2) {
                    object3 = new FileWriter(string2);
                    FormattedWriter formattedWriter = new FormattedWriter((Writer)object3);
                    this._xmlWriteRawOn(formattedWriter);
                    formattedWriter.flush();
                    formattedWriter.close();
                }
                object3 = this.getProperty("transactionSendLimit", "100");
                int n4 = Integer.parseInt((String)object3);
                this._transactionFactory = new MSTransactionFactory(this, (PersistenceManager)((Object)this._persistentMessageStore));
                this._transactionFactory.setMaximumTransactionSize(n4);
                Persistable persistable = this._persistentMessageStore.readRootPersistable();
                if (null == persistable) {
                    throw new MessageStoreRuntimeException("ROOT_PERSISTABLE_EXCEPTION_SIMS0504");
                }
                this._uniqueIdentifierGenerator = PersistenceFactory.getUniqueKeyGenerator(this._persistentMessageStore, "UniqueIdentifier", 1000000);
                this._uniqueLockIDGenerator = PersistenceFactory.getUniqueKeyGenerator(this._persistentMessageStore, "UniqueLockValue", 500000);
                this._tickCountGenerator = PersistenceFactory.getUniqueKeyGenerator(this._persistentMessageStore, "UniqueTickCount", 500000);
                this._rootMembership = new RootMembership(this, persistable);
                this._rootMembership.initialize();
                this._cacheLoader.start(this._cacheLoaderInterval, this._messagingEngine);
                this._state = STATE_STARTED;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.impl.MessageStoreImpl.start", (String)"755", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{exception});
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception: ", (Object)exception);
            }
            this.stop(0);
            this.reportLocalError();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)new Integer(n));
        }
        Object object = _startLock;
        synchronized (object) {
            if (this._state.equals(STATE_UNINITIALIZED)) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            if (null != this._expirer) {
                this._expirer.stop();
            }
            if (null != this._cacheLoader) {
                this._cacheLoader.stop();
            }
            if (null != this._membershipMap) {
                this._membershipMap.clear();
            }
            if (null != this._persistentMessageStore) {
                this._persistentMessageStore.stop(n);
            }
            this._state = STATE_STOPPED;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public final String toString() {
        return super.toString();
    }

    public final void unregister(AbstractItemLink abstractItemLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unregister", (Object)abstractItemLink);
        }
        this._membershipMap.remove(abstractItemLink.getID());
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.startTag("MessageStore");
        formattedWriter.indent();
        Object object = _startLock;
        synchronized (object) {
            if (this._state.equals(STATE_STARTED)) {
                this._rootMembership.xmlWriteItemStreamsOn(formattedWriter);
            } else {
                formattedWriter.newLine();
                formattedWriter.write(XML_CANNOT_BE_WRITTEN);
            }
        }
        formattedWriter.newLine();
        formattedWriter.startTag("ManagedCache");
        if (null != this._itemStorageManager) {
            formattedWriter.indent();
            this._itemStorageManager.xmlWriteOn(formattedWriter);
            formattedWriter.outdent();
        }
        formattedWriter.newLine();
        formattedWriter.endTag("ManagedCache");
        formattedWriter.newLine();
        formattedWriter.startTag("ItemMap");
        if (null != this._membershipMap) {
            formattedWriter.indent();
            this._membershipMap.xmlWriteOn(formattedWriter);
            formattedWriter.outdent();
        }
        formattedWriter.newLine();
        formattedWriter.endTag("ItemMap");
        if (this._expirer != null) {
            formattedWriter.indent();
            this._expirer.xmlWriteOn(formattedWriter);
            formattedWriter.outdent();
        }
        if (this._cacheLoader != null) {
            formattedWriter.indent();
            this._cacheLoader.xmlWriteOn(formattedWriter);
            formattedWriter.outdent();
        }
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.endTag("MessageStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xmlWriteRawOn(FormattedWriter formattedWriter) throws IOException {
        Object object = _startLock;
        synchronized (object) {
            if (this._state.equals(STATE_STARTED)) {
                this._xmlWriteRawOn(formattedWriter);
            } else {
                formattedWriter.startTag("MessageStore");
                formattedWriter.indent();
                formattedWriter.newLine();
                formattedWriter.write(XML_CANNOT_BE_WRITTEN);
                formattedWriter.outdent();
                formattedWriter.newLine();
                formattedWriter.endTag("MessageStore");
            }
        }
    }
}

