/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;

public final class ItemLinkMap
implements Map {
    private final int _capacityMask;
    private final int _lockMask;
    private final AbstractItemLink[] _entry;
    private final Lock[] _lock;
    private int _size;

    ItemLinkMap(int n) {
        this(n, 8);
    }

    ItemLinkMap(int n, int n2) {
        if (n > 30) {
            n = 30;
        } else if (n < 8) {
            n = 8;
        }
        if (n2 > 15) {
            n2 = 15;
        } else if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 2 << n;
        this._entry = new AbstractItemLink[n3];
        this._capacityMask = n3 - 1;
        n3 = 2 << n2;
        this._lock = new Lock[n3];
        this._lockMask = n3 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Lock _getLock(long l) {
        int n = (int)((long)this._lockMask & l);
        Lock lock = this._lock[n];
        if (null != lock) return lock;
        Lock[] lockArray = this._lock;
        synchronized (this._lock) {
            lock = this._lock[n];
            if (null != lock) return lock;
            this._lock[n] = lock = new Lock();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return lock;
        }
    }

    private final int _indexOfKey(long l) {
        int n = (int)(l & (long)this._capacityMask);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItemLink get(long l) {
        AbstractItemLink abstractItemLink = null;
        Lock lock = this._getLock(l);
        synchronized (lock) {
            int n = this._indexOfKey(l);
            AbstractItemLink abstractItemLink2 = this._entry[n];
            while (null == abstractItemLink && null != abstractItemLink2) {
                if (l == abstractItemLink2.getID()) {
                    abstractItemLink = abstractItemLink2;
                    continue;
                }
                abstractItemLink2 = abstractItemLink2.getNextMappedLink();
            }
        }
        return abstractItemLink;
    }

    public final int getSize() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(long l, AbstractItemLink abstractItemLink) {
        Lock lock = this._getLock(l);
        synchronized (lock) {
            int n = this._indexOfKey(l);
            AbstractItemLink abstractItemLink2 = this._entry[n];
            this._entry[n] = abstractItemLink;
            abstractItemLink.setNextMappedLink(abstractItemLink2);
            ++this._size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItemLink remove(long l) {
        AbstractItemLink abstractItemLink = null;
        Lock lock = this._getLock(l);
        synchronized (lock) {
            AbstractItemLink abstractItemLink2;
            int n = this._indexOfKey(l);
            AbstractItemLink abstractItemLink3 = abstractItemLink2 = this._entry[n];
            while (null != abstractItemLink3 && null == abstractItemLink) {
                AbstractItemLink abstractItemLink4 = abstractItemLink3.getNextMappedLink();
                if (l == abstractItemLink3.getID()) {
                    abstractItemLink = abstractItemLink3;
                    --this._size;
                    if (abstractItemLink2 == abstractItemLink3) {
                        this._entry[n] = abstractItemLink4;
                    } else {
                        abstractItemLink2.setNextMappedLink(abstractItemLink4);
                    }
                }
                abstractItemLink2 = abstractItemLink3;
                abstractItemLink3 = abstractItemLink4;
            }
        }
        return abstractItemLink;
    }

    public final void clear() {
        for (int i = 0; i < this._entry.length; ++i) {
            this._entry[i] = null;
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        for (int i = 0; i < this._entry.length; ++i) {
            for (AbstractItemLink abstractItemLink = this._entry[i]; null != abstractItemLink; abstractItemLink = abstractItemLink.getNextMappedLink()) {
                formattedWriter.newLine();
                abstractItemLink.xmlShortWriteOn(formattedWriter);
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

