/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;

public abstract class NodeStack {
    static final int VISIT_LEFT = 1;
    static final int PROCESS_CURRENT = 2;
    static final int VISIT_RIGHT = 3;
    static final int DONE_VISITS = 4;
    private GBSTree _tree;
    private GBSNode _endp;
    private int _endIndex;
    private int _topIndex;
    private static final int nmax = 182;
    protected GBSNode[] _node;
    protected int[] _state;
    protected int _idx;
    private int _cidx;
    private int _bpidx;
    private State _localState;
    private int _maxIdx;
    private String _starter;
    private String _lastStacker;

    public NodeStack(GBSTree gBSTree) {
        this._tree = gBSTree;
        this._node = new GBSNode[182];
        this._state = new int[182];
        this._localState = new State();
        this.nodeStackReset();
    }

    public void reset() {
        this.nodeStackReset();
    }

    private void nodeStackReset() {
        this._idx = -1;
        this._cidx = -1;
        this._bpidx = -1;
        this._topIndex = -222;
        this._endp = null;
        this._endIndex = -111;
        this._maxIdx = -1;
    }

    private void stackStart(GBSNode gBSNode) {
        this._idx = 0;
        this._cidx = 0;
        this._state[this._cidx] = 0;
        this._node[this._cidx] = gBSNode;
        this._bpidx = this._cidx + 1;
        this._maxIdx = this._cidx;
    }

    protected void stackStart(GBSNode gBSNode, String string) {
        this._starter = string;
        this._lastStacker = null;
        this.stackStart(gBSNode);
    }

    void setStacker(String string) {
        this._lastStacker = string;
    }

    public void push(int n, GBSNode gBSNode, String string) {
        this._lastStacker = string;
        this.push(n, gBSNode);
    }

    public void push(int n, GBSNode gBSNode) {
        ++this._cidx;
        this._idx = this._cidx;
        if (this._cidx > 47) {
            throw new OptimisticDepthException("maxDepth (47) exceeded.  Depth is " + this._cidx + ".");
        }
        this._state[this._cidx] = n;
        this._node[this._cidx] = gBSNode;
        if (this.index() > this._maxIdx) {
            this._maxIdx = this.index();
        }
    }

    void push(GBSNode gBSNode) {
        this.push(0, gBSNode);
    }

    void printSummary() {
        System.out.println("balancePointIndex = " + this.balancePointIndex());
        for (int i = 0; i <= this._cidx; ++i) {
            System.out.println(i + ": " + this.node(i));
        }
    }

    void reset(int n) {
        if (n < 0) {
            throw new RuntimeException("idx < 0, idx = " + n + ".");
        }
        this._idx = n;
        this._cidx = n;
    }

    void balancedPush(int n, GBSNode gBSNode) {
        this.push(n, gBSNode);
        if (gBSNode.balance() != 0) {
            this._bpidx = this._cidx;
        }
    }

    private void pop(State state) {
        state.set(this._state[this._cidx], this._node[this._cidx]);
        this.pop();
    }

    void pop() {
        --this._cidx;
        this._idx = this._cidx;
    }

    public int index() {
        return this._cidx;
    }

    void resetBalancePointIndex() {
        this._bpidx = -2;
    }

    int balancePointIndex() {
        return this._bpidx;
    }

    GBSNode node(int n) {
        return this._node[n];
    }

    GBSNode node() {
        return this._node[this._cidx];
    }

    public GBSNode parent() {
        GBSNode gBSNode = null;
        if (this._cidx > 0) {
            gBSNode = this._node[this._cidx - 1];
        }
        return gBSNode;
    }

    int state() {
        return this._state[this._cidx];
    }

    void setNode(int n, GBSNode gBSNode) {
        this._node[n] = gBSNode;
    }

    void processSubFringe(GBSNode gBSNode) {
        int n = this._tree.tZeroDepth();
        int n2 = 0;
        int n3 = 0;
        if (gBSNode.hasChild()) {
            n3 = 1;
        }
        if (this.index() > n) {
            n2 = this.index() - (n - n3);
        }
        this.innerProcessSubTree(gBSNode, 3, n2);
    }

    public void processSubTree(GBSNode gBSNode) {
        this.stackStart(gBSNode, "NodeStack.processSubTree");
        this.innerProcessSubTree(gBSNode, 1, 0);
    }

    private void innerProcessSubTree(GBSNode gBSNode, int n, int n2) {
        boolean bl = false;
        this._topIndex = n2;
        this._endp = gBSNode;
        this._endIndex = this._idx;
        int n3 = n;
        State state = this._localState;
        state.reset();
        block6: while (!bl) {
            switch (n3) {
                case 1: {
                    n3 = 2;
                    GBSNode gBSNode2 = gBSNode.leftChild();
                    while (gBSNode2 != null) {
                        this.push(n3, gBSNode);
                        gBSNode = gBSNode2;
                        gBSNode2 = gBSNode.leftChild();
                    }
                    continue block6;
                }
                case 2: {
                    n3 = 3;
                    bl = this.processNode(gBSNode);
                    this._endp = gBSNode;
                    this._endIndex = this._idx;
                    continue block6;
                }
                case 3: {
                    n3 = 4;
                    GBSNode gBSNode2 = gBSNode.rightChild();
                    if (gBSNode2 == null) continue block6;
                    this.push(n3, gBSNode);
                    n3 = 1;
                    gBSNode = gBSNode.rightChild();
                    continue block6;
                }
                case 4: {
                    if (this._idx == n2) {
                        bl = true;
                        continue block6;
                    }
                    n3 = this._state[this._cidx];
                    gBSNode = this._node[this._cidx];
                    this.pop();
                    continue block6;
                }
            }
            throw new RuntimeException("Help!, s = " + n3 + ".");
        }
    }

    public abstract boolean processNode(GBSNode var1);

    GBSNode lastNode() {
        return this._endp;
    }

    int lastIndex() {
        return this._endIndex;
    }

    int topIndex() {
        return this._topIndex;
    }

    protected GBSTree tree() {
        return this._tree;
    }

    public String stateName(int n) {
        String string = "Unknown state = " + n;
        switch (n) {
            case 1: {
                string = "VISIT_LEFT";
                break;
            }
            case 2: {
                string = "PROCESS_CURRENT";
                break;
            }
            case 3: {
                string = "VISIT_RIGHT";
                break;
            }
            case 4: {
                string = "DONE_VISITS";
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NodeStack, _idx = " + this._idx + ", _cidx = " + this._cidx + ", maxDepth() = " + this.maxDepth() + ", lastIndex() = " + this.lastIndex() + "\n" + ", starter = " + this._starter + ", lastStacker = " + this._lastStacker + "\n");
        if (this.maxDepth() >= 0) {
            for (int i = 0; i <= this.maxDepth(); ++i) {
                GBSNode gBSNode = this.node(i);
                if (gBSNode == null) {
                    stringBuffer.append(i + ": " + "???" + "\n");
                    continue;
                }
                stringBuffer.append(i + ": " + gBSNode.lmkString() + ", s = " + this.stateName(this._state[i]) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public int maxDepth() {
        return this._maxIdx;
    }

    private class State {
        private int _state;
        private GBSNode _node;

        private State() {
        }

        private void set(int n, GBSNode gBSNode) {
            this._state = n;
            this._node = gBSNode;
        }

        private void reset() {
            this.set(0, null);
        }

        private int state() {
            return this._state;
        }

        private GBSNode node() {
            return this._node;
        }
    }
}

