/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteNode;
import com.ibm.ws.sib.msgstore.gbs.DeleteStack;
import com.ibm.ws.sib.msgstore.gbs.GBSDeleteFringe;
import com.ibm.ws.sib.msgstore.gbs.GBSInsertFringe;
import com.ibm.ws.sib.msgstore.gbs.GBSIterator;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTreeException;
import com.ibm.ws.sib.msgstore.gbs.InsertNodes;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.NodeInsertPoint;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import com.ibm.ws.sib.msgstore.gbs.SearchNode;
import java.util.Comparator;

public class GBSTree {
    public static final int GBS_TREE = 12;
    public static final int T_TREE = 15;
    private Comparator _insertComparator;
    private Comparator _deleteComparator;
    private SearchComparator _localComparator;
    private GBSNode _dummyTopNode;
    private GBSNode _nodePool;
    private int _population;
    private volatile int _vno;
    private volatile int _xno;
    private volatile int _optimisticFinds;
    private int _pessimisticFinds;
    private volatile int _optimisticInserts;
    private volatile int _optimisticInsertSurprises;
    private int _pessimisticInserts;
    private volatile int _optimisticDeletes;
    private volatile int _optimisticDeleteSurprises;
    private int _pessimisticDeletes;
    private volatile int _nullPointerExceptions;
    private volatile int _optimisticDepthExceptions;
    private final int _nodeWidth;
    private final int _nodeMidPoint;
    private final int _kFactor;
    private final int _tZeroDepth;
    private static final boolean pessimisticNeeded = false;
    private static final boolean optimisticWorked = true;
    static final int maxDepth = 47;
    private static final int[] _t0_d = new int[]{-1, -1, 0, -1, 1, -1, 2, -1, 2, -1, -1, -1, 3, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, 4};
    private static ThreadLocal _searchNode = new ThreadLocal();
    private static ThreadLocal _insertStack = new ThreadLocal();
    private static ThreadLocal _deleteStack = new ThreadLocal();

    public GBSTree(int n, int n2, Comparator comparator, Comparator comparator2) {
        this._tZeroDepth = this.calcTZeroDepth(n);
        this._kFactor = n;
        this._nodeWidth = n2;
        this._nodeMidPoint = (n2 - 1) / 2;
        this._insertComparator = comparator;
        this._deleteComparator = comparator;
        if (comparator == null) {
            throw new IllegalArgumentException("insertComparator is null.");
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException("keyComparator is null.");
        }
        this._localComparator = new SearchComparator(comparator2);
        this._dummyTopNode = new GBSNode(this, 0);
        if (n2 < 3 || n2 > 2000) {
            String string = "Invalid node width (" + n2 + ").\n" + "Minimum required is 3.\n" + "Maximum (arbitrary) limit is 2000.";
            throw new IllegalArgumentException(string);
        }
    }

    public int treeType() {
        return 12;
    }

    public int nodeWidth() {
        return this._nodeWidth;
    }

    public int size() {
        return this._population;
    }

    public int optimisticFinds() {
        return this._optimisticFinds;
    }

    public int optimisticInserts() {
        return this._optimisticInserts;
    }

    public int optimisticInsertSurprises() {
        return this._optimisticInsertSurprises;
    }

    public int optimisticDeletes() {
        return this._optimisticDeletes;
    }

    public int optimisticDeleteSurprises() {
        return this._optimisticDeleteSurprises;
    }

    public int pessimisticFinds() {
        return this._pessimisticFinds;
    }

    public int pessimisticInserts() {
        return this._pessimisticInserts;
    }

    public int pessimisticDeletes() {
        return this._pessimisticDeletes;
    }

    public int nullPointerExceptions() {
        return this._nullPointerExceptions;
    }

    public int optimisticDepthExceptions() {
        return this._optimisticDepthExceptions;
    }

    int nodeMidPoint() {
        return this._nodeMidPoint;
    }

    public int kFactor() {
        return this._kFactor;
    }

    public GBSNode root() {
        return this.dummyTopNode().rightChild();
    }

    GBSNode dummyTopNode() {
        return this._dummyTopNode;
    }

    private void setRoot(GBSNode gBSNode) {
        this.dummyTopNode().setRightChild(gBSNode);
    }

    public void testSetRoot(GBSNode gBSNode) {
        this.setRoot(gBSNode);
    }

    private void addFirstNode(Object object) {
        GBSNode gBSNode = this.getNode(object);
        this.setRoot(gBSNode);
    }

    public Comparator insertComparator() {
        return this._insertComparator;
    }

    public Comparator deleteComparator() {
        return this._deleteComparator;
    }

    private SearchComparator searchComparator(int n) {
        return this._localComparator.getSingleton(n);
    }

    void releaseNode(GBSNode gBSNode) {
        gBSNode.setRightChild(this._nodePool);
        this._nodePool = gBSNode;
    }

    GBSNode getNode(Object object) {
        GBSNode gBSNode;
        if (this._nodePool == null) {
            gBSNode = new GBSNode(this, object);
        } else {
            gBSNode = this._nodePool;
            this._nodePool = gBSNode.rightChild();
            gBSNode.reset(object);
        }
        return gBSNode;
    }

    public void prePopulate(int n) {
        SearchNode searchNode = this.getSearchNode();
        for (int i = 0; i < n; ++i) {
            GBSNode gBSNode = new GBSNode(this);
            this.releaseNode(gBSNode);
        }
    }

    public int vno() {
        return this._vno;
    }

    public int xno() {
        return this._xno;
    }

    int tZeroDepth() {
        return this._tZeroDepth;
    }

    public int maximumFringeImbalance() {
        int n;
        GBSNode gBSNode = this.root();
        if (gBSNode.leftChild() == null) {
            n = this.kFactor() - 1;
            if (n < 3) {
                n = 3;
            }
        } else {
            n = this.kFactor() % 3 == 0 ? this.kFactor() + 2 : this.kFactor() + 1;
        }
        return n;
    }

    private int calcTZeroDepth(int n) {
        boolean bl = false;
        int n2 = -1;
        if (n >= 0 && n < _t0_d.length) {
            n2 = _t0_d[n];
        }
        if (n2 < 0) {
            String string = "K Factor (" + n + ") is invalid.\n" + "Valid K factors are: " + this.kFactorString() + ".";
            throw new IllegalArgumentException(string);
        }
        return n2;
    }

    private String kFactorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        for (int i = 0; i < _t0_d.length; ++i) {
            if (_t0_d[i] < 0) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(i + "");
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static boolean checkForPossibleIndexChange(int n, int n2, Throwable throwable, String string) {
        if (n != n2) {
            return false;
        }
        GBSTreeException gBSTreeException = new GBSTreeException(string + ", v1 = " + n, throwable);
        throw gBSTreeException;
    }

    public Iterator iterator() {
        GBSIterator gBSIterator;
        GBSIterator gBSIterator2 = gBSIterator = new GBSIterator(this);
        return gBSIterator2;
    }

    public Object searchEqual(Object object) {
        SearchComparator searchComparator = this.searchComparator(1);
        Object object2 = this.find(searchComparator, object);
        return object2;
    }

    public Object searchGreater(Object object) {
        SearchComparator searchComparator = this.searchComparator(2);
        Object object2 = this.find(searchComparator, object);
        return object2;
    }

    public Object searchGreaterOrEqual(Object object) {
        SearchComparator searchComparator = this.searchComparator(3);
        Object object2 = this.find(searchComparator, object);
        return object2;
    }

    private SearchNode getSearchNode() {
        Object object = _searchNode.get();
        SearchNode searchNode = null;
        if (object != null) {
            searchNode = (SearchNode)object;
            searchNode.reset();
        } else {
            searchNode = new SearchNode();
            object = searchNode;
            _searchNode.set(object);
        }
        return searchNode;
    }

    private Object find(SearchComparator searchComparator, Object object) {
        SearchNode searchNode = this.getSearchNode();
        Object object2 = null;
        boolean bl = this.optimisticFind(searchComparator, object, searchNode);
        if (!bl) {
            this.pessimisticFind(searchComparator, object, searchNode);
        }
        if (searchNode.wasFound()) {
            object2 = searchNode.foundNode().key(searchNode.foundIndex());
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticFind(SearchComparator searchComparator, Object object, SearchNode searchNode) {
        searchNode.reset();
        int n = this._vno;
        if (this.root() != null) {
            if ((n & 1) != 0) {
                return false;
            }
            SearchNode searchNode2 = searchNode;
            // MONITORENTER : searchNode2
            // MONITOREXIT : searchNode2
            try {
                this.internalFind(searchComparator, object, searchNode);
            }
            catch (NullPointerException nullPointerException) {
                ++this._nullPointerExceptions;
                return GBSTree.checkForPossibleIndexChange(n, this._vno, nullPointerException, "optimisticInsert");
            }
            catch (OptimisticDepthException optimisticDepthException) {
                ++this._optimisticDepthExceptions;
                return GBSTree.checkForPossibleIndexChange(n, this._vno, optimisticDepthException, "optimisticInsert");
            }
            if (n != this._vno) {
                return false;
            }
        }
        ++this._optimisticFinds;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticFind(SearchComparator searchComparator, Object object, SearchNode searchNode) {
        searchNode.reset();
        GBSTree gBSTree = this;
        synchronized (gBSTree) {
            this.internalFind(searchComparator, object, searchNode);
            ++this._pessimisticFinds;
        }
    }

    private void internalFind(SearchComparator searchComparator, Object object, SearchNode searchNode) {
        GBSNode gBSNode = this.root();
        GBSNode gBSNode2 = null;
        GBSNode gBSNode3 = null;
        Object var7_7 = null;
        while (gBSNode != null) {
            int n = searchComparator.compare(object, gBSNode.middleKey());
            if (n == 0) {
                searchNode.setFound(gBSNode, gBSNode.middleIndex());
                gBSNode = null;
                continue;
            }
            if (n < 0) {
                if (gBSNode.leftChild() != null) {
                    gBSNode2 = gBSNode;
                    gBSNode = gBSNode.leftChild();
                    continue;
                }
                this.leftSearch(searchComparator, gBSNode, gBSNode3, object, searchNode);
                gBSNode = null;
                continue;
            }
            if (gBSNode.rightChild() != null) {
                gBSNode3 = gBSNode;
                gBSNode = gBSNode.rightChild();
                continue;
            }
            this.rightSearch(searchComparator, gBSNode, gBSNode2, object, searchNode);
            gBSNode = null;
        }
    }

    synchronized Object iteratorFind(DeleteStack deleteStack, SearchComparator searchComparator, Object object, SearchNode searchNode) {
        searchNode.reset();
        GBSNode gBSNode = this.root();
        GBSNode gBSNode2 = null;
        GBSNode gBSNode3 = null;
        int n = 0;
        int n2 = 0;
        Object object2 = null;
        deleteStack.start(this.dummyTopNode(), "GBSTree.iteratorFind");
        while (gBSNode != null) {
            int n3 = searchComparator.compare(object, gBSNode.middleKey());
            if (n3 == 0) {
                searchNode.setFound(gBSNode, gBSNode.middleIndex());
                gBSNode = null;
                continue;
            }
            if (n3 < 0) {
                if (gBSNode.leftChild() != null) {
                    deleteStack.push(2, gBSNode, "GBSTree.iteratorFind(1)");
                    gBSNode2 = gBSNode;
                    n = deleteStack.index();
                    gBSNode = gBSNode.leftChild();
                    continue;
                }
                this.leftSearch(searchComparator, gBSNode, gBSNode3, object, searchNode);
                if (searchNode.wasFound() && searchNode.foundNode() == gBSNode3) {
                    deleteStack.reset(n2 - 1);
                }
                gBSNode = null;
                continue;
            }
            if (gBSNode.rightChild() != null) {
                deleteStack.push(4, gBSNode, "GBSTree.iteratorFind(2)");
                gBSNode3 = gBSNode;
                n2 = deleteStack.index();
                gBSNode = gBSNode.rightChild();
                continue;
            }
            this.rightSearch(searchComparator, gBSNode, gBSNode2, object, searchNode);
            if (searchNode.wasFound() && searchNode.foundNode() == gBSNode2) {
                deleteStack.reset(n - 1);
            }
            gBSNode = null;
        }
        if (searchNode.wasFound()) {
            object2 = searchNode.foundNode().key(searchNode.foundIndex());
            searchNode.setLocation(object2);
        }
        return object2;
    }

    private void leftSearch(SearchComparator searchComparator, GBSNode gBSNode, GBSNode gBSNode2, Object object, SearchNode searchNode) {
        if (gBSNode2 == null) {
            int n = gBSNode.searchLeft(searchComparator, object);
            if (n >= 0) {
                searchNode.setFound(gBSNode, n);
            }
        } else {
            int n = searchComparator.compare(object, gBSNode2.rightMostKey());
            if (n == 0) {
                searchNode.setFound(gBSNode2, gBSNode2.rightMostIndex());
            } else if (n > 0) {
                int n2 = gBSNode.searchLeft(searchComparator, object);
                if (n2 >= 0) {
                    searchNode.setFound(gBSNode, n2);
                }
            } else {
                int n3 = gBSNode2.searchRight(searchComparator, object);
                if (n3 >= 0) {
                    searchNode.setFound(gBSNode2, n3);
                }
            }
        }
    }

    private void rightSearch(SearchComparator searchComparator, GBSNode gBSNode, GBSNode gBSNode2, Object object, SearchNode searchNode) {
        int n;
        int n2 = searchComparator.compare(object, gBSNode.rightMostKey());
        if (n2 == 0) {
            searchNode.setFound(gBSNode, 0);
        } else if (n2 < 0) {
            int n3 = gBSNode.searchRight(searchComparator, object);
            if (n3 >= 0) {
                searchNode.setFound(gBSNode, n3);
            }
        } else if (gBSNode2 != null && (n = gBSNode2.searchLeft(searchComparator, object)) >= 0) {
            searchNode.setFound(gBSNode2, n);
        }
    }

    private InsertStack getInsertStack() {
        Object object = _insertStack.get();
        InsertStack insertStack = null;
        if (object != null) {
            insertStack = (InsertStack)object;
            insertStack.reset();
        } else {
            insertStack = new InsertStack(this);
            object = insertStack;
            _insertStack.set(object);
        }
        return insertStack;
    }

    public boolean insert(Object object) {
        InsertStack insertStack = this.getInsertStack();
        if (this.root() == null) {
            this.pessimisticInsert(insertStack, object);
        } else {
            boolean bl = this.optimisticInsert(insertStack, object);
            if (!bl) {
                this.pessimisticInsert(insertStack, object);
            }
        }
        boolean bl = !insertStack.isDuplicate();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticInsert(InsertStack insertStack, Object object) {
        InsertNodes insertNodes = insertStack.insertNodes();
        int n = this._vno;
        if (this.root() == null) {
            return false;
        }
        if ((n & 1) != 0) {
            return false;
        }
        Object object2 = insertStack;
        // MONITORENTER : object2
        // MONITOREXIT : object2
        try {
            this.findInsert(insertNodes, insertStack, object);
        }
        catch (NullPointerException nullPointerException) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._vno, nullPointerException, "optimisticInsert");
        }
        catch (OptimisticDepthException optimisticDepthException) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._vno, optimisticDepthException, "optimisticInsert");
        }
        object2 = this;
        // MONITORENTER : object2
        if (n != this._vno) {
            ++this._optimisticInsertSurprises;
            // MONITOREXIT : object2
            return false;
        }
        ++this._optimisticInserts;
        if (insertNodes.isDuplicate()) {
            insertStack.markDuplicate();
            return true;
        }
        ++this._vno;
        if ((this._vno & 1) == 1) {
            this.finishInsert(insertNodes, insertStack, object);
            ++this._population;
        }
        InsertStack insertStack2 = insertStack;
        // MONITORENTER : insertStack2
        // MONITOREXIT : insertStack2
        ++this._vno;
        // MONITOREXIT : object2
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized boolean pessimisticInsert(InsertStack insertStack, Object object) {
        Object object2;
        ++this._vno;
        if ((this._vno & 1) == 1) {
            if (this.root() == null) {
                this.addFirstNode(object);
                ++this._population;
            } else {
                object2 = insertStack.insertNodes();
                this.findInsert((InsertNodes)object2, insertStack, object);
                if (((InsertNodes)object2).isDuplicate()) {
                    insertStack.markDuplicate();
                } else {
                    this.finishInsert((InsertNodes)object2, insertStack, object);
                    ++this._population;
                }
            }
        }
        object2 = insertStack;
        // MONITORENTER : object2
        // MONITOREXIT : object2
        ++this._vno;
        ++this._pessimisticInserts;
        return true;
    }

    private void findInsert(InsertNodes insertNodes, InsertStack insertStack, Object object) {
        block3: {
            Comparator comparator = this.insertComparator();
            NodeInsertPoint nodeInsertPoint = insertStack.nodeInsertPoint();
            GBSNode gBSNode = null;
            GBSNode gBSNode2 = null;
            GBSNode gBSNode3 = this.root();
            insertStack.start(this.dummyTopNode(), "GBSTree.findInsert");
            while (true) {
                GBSNode gBSNode4;
                int n;
                if ((n = comparator.compare(object, gBSNode3.middleKey())) <= 0) {
                    gBSNode4 = gBSNode3.leftChild();
                    if (gBSNode4 != null) {
                        gBSNode = gBSNode3;
                        insertStack.balancedPush(2, gBSNode3);
                        gBSNode3 = gBSNode4;
                        continue;
                    }
                    this.leftAdd(gBSNode3, gBSNode2, object, nodeInsertPoint, insertNodes);
                    break block3;
                }
                gBSNode4 = gBSNode3.rightChild();
                if (gBSNode4 == null) break;
                gBSNode2 = gBSNode3;
                insertStack.balancedPush(4, gBSNode3);
                gBSNode3 = gBSNode4;
            }
            this.rightAdd(gBSNode3, gBSNode, object, nodeInsertPoint, insertNodes);
        }
    }

    private void leftAdd(GBSNode gBSNode, GBSNode gBSNode2, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        if (gBSNode2 == null) {
            this.leftAddNoPredecessor(gBSNode, object, nodeInsertPoint, insertNodes);
        } else {
            this.leftAddWithPredecessor(gBSNode, gBSNode2, object, nodeInsertPoint, insertNodes);
        }
    }

    private void leftAddNoPredecessor(GBSNode gBSNode, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        gBSNode.findInsertPointInLeft(object, nodeInsertPoint);
        insertNodes.setInsert(gBSNode, nodeInsertPoint);
    }

    private void leftAddWithPredecessor(GBSNode gBSNode, GBSNode gBSNode2, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        Comparator comparator = gBSNode2.insertComparator();
        int n = comparator.compare(object, gBSNode2.rightMostKey());
        if (n > 0) {
            gBSNode.findInsertPointInLeft(object, nodeInsertPoint);
            insertNodes.setInsert(gBSNode, nodeInsertPoint);
        } else {
            gBSNode2.findInsertPointInRight(object, nodeInsertPoint);
            if (nodeInsertPoint.isDuplicate()) {
                insertNodes.setInsert(gBSNode2, nodeInsertPoint);
            } else {
                insertNodes.setInsertAndPosition(gBSNode, -1, gBSNode2, nodeInsertPoint.insertPoint());
                insertNodes.setRight();
            }
        }
    }

    private void rightAdd(GBSNode gBSNode, GBSNode gBSNode2, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        if (gBSNode2 == null) {
            this.rightAddNoSuccessor(gBSNode, object, nodeInsertPoint, insertNodes);
        } else {
            this.rightAddWithSuccessor(gBSNode, gBSNode2, object, nodeInsertPoint, insertNodes);
        }
    }

    private void rightAddNoSuccessor(GBSNode gBSNode, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        if (gBSNode.lessThanHalfFull()) {
            insertNodes.setInsert(gBSNode, gBSNode.rightMostIndex());
        } else {
            gBSNode.findInsertPointInRight(object, nodeInsertPoint);
            insertNodes.setInsert(gBSNode, nodeInsertPoint);
        }
    }

    private void rightAddWithSuccessor(GBSNode gBSNode, GBSNode gBSNode2, Object object, NodeInsertPoint nodeInsertPoint, InsertNodes insertNodes) {
        Comparator comparator = gBSNode2.insertComparator();
        int n = comparator.compare(object, gBSNode2.leftMostKey());
        if (n < 0) {
            if (gBSNode.lessThanHalfFull()) {
                insertNodes.setInsert(gBSNode, gBSNode.rightMostIndex());
            } else {
                gBSNode.findInsertPointInRight(object, nodeInsertPoint);
                insertNodes.setInsert(gBSNode, nodeInsertPoint);
            }
        } else {
            gBSNode2.findInsertPointInLeft(object, nodeInsertPoint);
            if (nodeInsertPoint.isDuplicate()) {
                insertNodes.setInsert(gBSNode2, nodeInsertPoint);
            } else {
                insertNodes.setInsertAndPosition(gBSNode, gBSNode.rightMostIndex(), gBSNode2, nodeInsertPoint.insertPoint());
                insertNodes.setLeft();
            }
        }
    }

    private void finishInsert(InsertNodes insertNodes, InsertStack insertStack, Object object) {
        Object object2;
        Object object3 = object;
        if (insertNodes.positionNode() != null) {
            object2 = insertNodes.positionNode();
            int n = insertNodes.positionIndex();
            object3 = insertNodes.rightSide() ? ((GBSNode)object2).insertByRightShift(n, object3) : ((GBSNode)object2).insertByLeftShift(n, object3);
        }
        object2 = null;
        object2 = insertNodes.insertIndex() == insertNodes.insertNode().topMostIndex() ? object3 : insertNodes.insertNode().insertByRightShift(insertNodes.insertIndex(), object3);
        this.insertFringeMigrate(insertStack, insertNodes.insertNode(), object2);
    }

    private void insertFringeMigrate(InsertStack insertStack, GBSNode gBSNode, Object object) {
        GBSNode gBSNode2 = gBSNode;
        int n = insertStack.index();
        int n2 = this.maximumFringeImbalance();
        insertStack.setMigratingKey(object);
        if (object != null) {
            insertStack.processSubFringe(gBSNode);
            gBSNode2 = insertStack.lastNode();
            n = insertStack.lastIndex();
        }
        if (insertStack.migrating()) {
            ++this._xno;
            gBSNode2.addRightLeaf(insertStack.migratingKey());
        }
        this.insertCheckFringeBalance(insertStack, gBSNode2, n, n2);
    }

    private void insertCheckFringeBalance(InsertStack insertStack, GBSNode gBSNode, int n, int n2) {
        GBSNode gBSNode2 = null;
        int n3 = 0;
        int n4 = 0;
        if (gBSNode.isFull() && gBSNode.leftChild() == null) {
            GBSNode gBSNode3;
            n3 = 1;
            int n5 = n;
            while (n5 > 0 && (gBSNode3 = insertStack.node(n5)).leftChild() == null) {
                ++n3;
                gBSNode2 = gBSNode3;
                n4 = n5--;
            }
            if (n3 >= n2) {
                ++this._xno;
                GBSInsertFringe.singleInstance().balance(this.kFactor(), insertStack, gBSNode2, n4, n2);
            }
        }
    }

    public boolean delete(Object object) {
        return this.internalDelete(object);
    }

    private DeleteStack getDeleteStack() {
        Object object = _deleteStack.get();
        DeleteStack deleteStack = null;
        if (object != null) {
            deleteStack = (DeleteStack)object;
            deleteStack.reset();
        } else {
            deleteStack = new DeleteStack(this);
            object = deleteStack;
            _deleteStack.set(object);
        }
        return deleteStack;
    }

    private boolean internalDelete(Object object) {
        boolean bl = false;
        if (this.root() != null) {
            DeleteNode deleteNode;
            DeleteStack deleteStack = this.getDeleteStack();
            boolean bl2 = this.optimisticDelete(deleteStack, object);
            if (!bl2) {
                this.pessimisticDelete(deleteStack, object);
            }
            if ((deleteNode = deleteStack.deleteNode()).wasFound()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticDelete(DeleteStack deleteStack, Object object) {
        DeleteNode deleteNode = deleteStack.deleteNode();
        boolean bl = true;
        int n = this._vno;
        if ((n & 1) != 0) {
            return false;
        }
        Object object2 = deleteStack;
        // MONITORENTER : object2
        // MONITOREXIT : object2
        try {
            this.findDelete(deleteNode, deleteStack, object);
        }
        catch (NullPointerException nullPointerException) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._vno, nullPointerException, "optimisticDelete");
        }
        catch (OptimisticDepthException optimisticDepthException) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._vno, optimisticDepthException, "optimisticDelete");
        }
        object2 = this;
        // MONITORENTER : object2
        if (n != this._vno) {
            ++this._optimisticDeleteSurprises;
            // MONITOREXIT : object2
            return false;
        }
        ++this._optimisticDeletes;
        if (!deleteNode.wasFound()) {
            return true;
        }
        ++this._vno;
        if ((this._vno & 1) == 1) {
            this.finishDelete(deleteNode, deleteStack, object);
            if (this._population <= 0) {
                throw new GBSTreeException("_population = " + this._population);
            }
            --this._population;
        }
        DeleteStack deleteStack2 = deleteStack;
        // MONITORENTER : deleteStack2
        // MONITOREXIT : deleteStack2
        ++this._vno;
        // MONITOREXIT : object2
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized boolean pessimisticDelete(DeleteStack deleteStack, Object object) {
        ++this._pessimisticDeletes;
        if (this.root() == null) return true;
        deleteStack.reset();
        DeleteNode deleteNode = deleteStack.deleteNode();
        ++this._vno;
        if ((this._vno & 1) != 1) return true;
        this.findDelete(deleteNode, deleteStack, object);
        if (deleteNode.wasFound()) {
            this.finishDelete(deleteNode, deleteStack, object);
            if (this._population <= 0) {
                throw new GBSTreeException("_population = " + this._population);
            }
            --this._population;
        }
        DeleteStack deleteStack2 = deleteStack;
        // MONITORENTER : deleteStack2
        // MONITOREXIT : deleteStack2
        ++this._vno;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void iteratorSpecialDelete(Iterator iterator, GBSNode gBSNode, int n) {
        ++this._vno;
        if ((this._vno & 1) == 1) {
            gBSNode.deleteByLeftShift(n);
            gBSNode.adjustMedian();
            --this._population;
        }
        Iterator iterator2 = iterator;
        // MONITORENTER : iterator2
        // MONITOREXIT : iterator2
        ++this._vno;
    }

    private void finishDelete(DeleteNode deleteNode, DeleteStack deleteStack, Object object) {
        this.adjustTarget(deleteNode);
        deleteNode.deleteNode().deleteByLeftShift(deleteNode.deleteIndex());
        this.deleteFringeMigrate(deleteStack, deleteNode.deleteNode());
    }

    private void adjustTarget(DeleteNode deleteNode) {
        int n = deleteNode.targetType();
        GBSNode gBSNode = deleteNode.targetNode();
        GBSNode gBSNode2 = deleteNode.deleteNode();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n2 = deleteNode.targetIndex();
                gBSNode.addLeftMostKeyByDelete(n2, gBSNode2.rightMostKey());
                break;
            }
            case 2: {
                int n3 = deleteNode.targetIndex();
                gBSNode.addRightMostKeyByDelete(n3, gBSNode2.leftMostKey());
                break;
            }
            case 3: {
                gBSNode.overlayRightMostKey(gBSNode2.leftMostKey());
                break;
            }
            case 4: {
                gBSNode.overlayLeftMostKey(gBSNode2.rightMostKey());
                break;
            }
            default: {
                throw new RuntimeException("s = " + n);
            }
        }
    }

    private void findDelete(DeleteNode deleteNode, DeleteStack deleteStack, Object object) {
        Comparator comparator = this.deleteComparator();
        GBSNode gBSNode = null;
        GBSNode gBSNode2 = null;
        GBSNode gBSNode3 = this.root();
        deleteStack.start(this.dummyTopNode(), "GBSTree.findDelete");
        while (gBSNode3 != null) {
            int n = comparator.compare(object, gBSNode3.middleKey());
            if (n == 0) {
                this.midDelete(deleteStack, gBSNode3, deleteNode);
                gBSNode3 = null;
                continue;
            }
            if (n < 0) {
                if (gBSNode3.leftChild() != null) {
                    gBSNode = gBSNode3;
                    deleteStack.push(2, gBSNode3, "GBSTree.findDelete(1)");
                    gBSNode3 = gBSNode3.leftChild();
                    continue;
                }
                this.leftDelete(gBSNode3, gBSNode2, object, deleteNode);
                gBSNode3 = null;
                continue;
            }
            if (gBSNode3.rightChild() != null) {
                gBSNode2 = gBSNode3;
                deleteStack.push(4, gBSNode3, "GBSTree.findDelete(2)");
                gBSNode3 = gBSNode3.rightChild();
                continue;
            }
            this.rightDelete(gBSNode3, gBSNode, object, deleteNode);
            gBSNode3 = null;
        }
    }

    private void midDelete(DeleteStack deleteStack, GBSNode gBSNode, DeleteNode deleteNode) {
        deleteNode.setDelete(gBSNode, gBSNode.middleIndex());
        GBSNode gBSNode2 = gBSNode.lowerPredecessor(deleteStack);
        if (gBSNode2 != null) {
            deleteNode.setDelete(gBSNode2, gBSNode2.rightMostIndex());
            deleteNode.setTarget(gBSNode, gBSNode.middleIndex(), 1);
        } else {
            gBSNode2 = gBSNode.lowerSuccessor(deleteStack);
            if (gBSNode2 != null) {
                deleteNode.setDelete(gBSNode2, 0);
                deleteNode.setTarget(gBSNode, gBSNode.middleIndex(), 2);
            }
        }
    }

    private void leftDelete(GBSNode gBSNode, GBSNode gBSNode2, Object object, DeleteNode deleteNode) {
        if (gBSNode2 == null) {
            this.leftDeleteNoPredecessor(gBSNode, object, deleteNode);
        } else {
            this.leftDeleteWithPredecessor(gBSNode, gBSNode2, object, deleteNode);
        }
    }

    private void leftDeleteNoPredecessor(GBSNode gBSNode, Object object, DeleteNode deleteNode) {
        int n = gBSNode.findDeleteInLeft(object);
        if (n >= 0) {
            deleteNode.setDelete(gBSNode, n);
        }
    }

    private void leftDeleteWithPredecessor(GBSNode gBSNode, GBSNode gBSNode2, Object object, DeleteNode deleteNode) {
        Comparator comparator = gBSNode.deleteComparator();
        int n = comparator.compare(object, gBSNode2.rightMostKey());
        if (n == 0) {
            deleteNode.setDelete(gBSNode, 0);
            deleteNode.setTarget(gBSNode2, gBSNode2.rightMostIndex(), 3);
        } else if (n > 0) {
            int n2 = gBSNode.findDeleteInLeft(object);
            if (n2 >= 0) {
                deleteNode.setDelete(gBSNode, n2);
            }
        } else {
            int n3 = gBSNode2.findDeleteInRight(object);
            if (n3 >= 0) {
                deleteNode.setTarget(gBSNode2, n3, 2);
                deleteNode.setDelete(gBSNode, 0);
            }
        }
    }

    private void rightDelete(GBSNode gBSNode, GBSNode gBSNode2, Object object, DeleteNode deleteNode) {
        if (gBSNode2 == null) {
            this.rightDeleteNoSuccessor(gBSNode, object, deleteNode);
        } else {
            this.rightDeleteWithSuccessor(gBSNode, gBSNode2, object, deleteNode);
        }
    }

    private void rightDeleteNoSuccessor(GBSNode gBSNode, Object object, DeleteNode deleteNode) {
        int n = gBSNode.findDeleteInRight(object);
        if (n >= 0) {
            deleteNode.setDelete(gBSNode, n);
        }
    }

    private void rightDeleteWithSuccessor(GBSNode gBSNode, GBSNode gBSNode2, Object object, DeleteNode deleteNode) {
        Comparator comparator = gBSNode.deleteComparator();
        int n = comparator.compare(object, gBSNode2.leftMostKey());
        if (n == 0) {
            deleteNode.setDelete(gBSNode, gBSNode.rightMostIndex());
            deleteNode.setTarget(gBSNode2, 0, 4);
        } else if (n < 0) {
            int n2 = gBSNode.findDeleteInRight(object);
            if (n2 >= 0) {
                deleteNode.setDelete(gBSNode, n2);
            }
        } else {
            int n3 = gBSNode2.findDeleteInLeft(object);
            if (n3 >= 0) {
                deleteNode.setDelete(gBSNode, gBSNode.rightMostIndex());
                deleteNode.setTarget(gBSNode2, n3, 1);
            }
        }
    }

    private void deleteFringeMigrate(DeleteStack deleteStack, GBSNode gBSNode) {
        GBSNode gBSNode2 = gBSNode;
        GBSNode gBSNode3 = gBSNode;
        int n = deleteStack.index();
        deleteStack.add(0, gBSNode);
        int n2 = this.maximumFringeImbalance();
        deleteStack.processSubFringe(gBSNode);
        gBSNode2 = deleteStack.lastNode();
        n = deleteStack.lastIndex();
        this.deleteCheckFringeBalance(deleteStack, gBSNode2, n, n2);
    }

    private void deleteCheckFringeBalance(DeleteStack deleteStack, GBSNode gBSNode, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        n5 = 0;
        if (gBSNode.leftChild() == null) {
            GBSNode gBSNode2;
            n5 = 1;
            for (n4 = n; n4 > 0 && (gBSNode2 = deleteStack.node(n4)).leftChild() == null; --n4) {
                ++n5;
            }
        }
        if ((n3 = (n4 = this.tZeroDepth())) < 1) {
            n3 = 1;
        }
        if (deleteStack.maxDepth() >= n3 && gBSNode.population() == gBSNode.width() - 1) {
            int n6 = 1;
            if (this.kFactor() % 3 == 0) {
                n6 = 2;
            }
            if (n5 == n6) {
                ++this._xno;
                GBSDeleteFringe.singleInstance().balance(this.tZeroDepth(), deleteStack);
            }
        } else if (gBSNode.population() != 0) {
            gBSNode.adjustMedian();
        } else {
            ++this._xno;
            GBSNode gBSNode3 = deleteStack.node(n);
            if (gBSNode3.leftChild() == gBSNode) {
                gBSNode3.setLeftChild(null);
            } else {
                gBSNode3.setRightChild(null);
            }
        }
    }

    public static interface Iterator {
        public Object next();

        public boolean remove();

        public void reset();
    }
}

