/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteStack;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import com.ibm.ws.sib.msgstore.gbs.SearchNode;
import java.util.NoSuchElementException;

public class GBSIterator
implements GBSTree.Iterator {
    private boolean _eof;
    private int _s;
    private GBSNode _p;
    private int _specialCount;
    private int _deleteCount;
    private GBSTree _index;
    private DeleteStack _dstack;
    private Locator _current1;
    private Locator _last1;
    private static final boolean pessimisticNeeded = false;
    private static final boolean optimisticWorked = true;
    private SearchComparator _localComparator;
    private SearchNode _localSearchNode;
    private volatile int _optimisticFindFirsts;
    private volatile int _optimisticGetNext1s;
    private volatile int _optimisticGetNext2s;
    private volatile int _optimisticSearchNexts;
    private volatile int _nullPointerExceptions;
    private volatile int _optimisticDepthExceptions;
    private int _pessimisticFindFirsts;
    private int _pessimisticSearchNexts;
    private int _pessimisticGetNexts;

    private GBSIterator() {
    }

    GBSIterator(GBSTree gBSTree) {
        this._index = gBSTree;
        this._dstack = new DeleteStack(gBSTree);
        this._current1 = new Locator();
        this._last1 = new Locator();
    }

    public void reset() {
        this._dstack.reset();
        this._current1.reset();
        this._last1.reset();
        this._eof = false;
        this._s = 0;
        this._p = null;
    }

    private void findFirst(DeleteStack deleteStack) {
        boolean bl = this.optimisticFindFirst(deleteStack);
        if (!bl) {
            this.pessimisticFindFirst(deleteStack);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticFindFirst(DeleteStack deleteStack) {
        Object object = null;
        int n = this._index.vno();
        int n2 = this._index.xno();
        if ((n & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        // MONITORENTER : gBSIterator
        // MONITOREXIT : gBSIterator
        try {
            object = this.getFirst(deleteStack);
        }
        catch (NullPointerException nullPointerException) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), nullPointerException, "optimisticFindFirst");
        }
        catch (OptimisticDepthException optimisticDepthException) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), optimisticDepthException, "optimisticFindFirst");
        }
        if (n != this._index.vno()) {
            return false;
        }
        this._current1.setLocation(object, n, n2);
        ++this._optimisticFindFirsts;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticFindFirst(DeleteStack deleteStack) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            object = this.getFirst(deleteStack);
            n = this._index.vno();
            n2 = this._index.xno();
            ++this._pessimisticFindFirsts;
        }
        this._current1.setLocation(object, n, n2);
    }

    private Object getFirst(DeleteStack deleteStack) {
        Object object = null;
        GBSNode gBSNode = this.leftMostChild(deleteStack);
        if (gBSNode != null) {
            object = gBSNode.leftMostKey();
            this._current1.setLocation(gBSNode, 0);
        }
        return object;
    }

    private GBSNode leftMostChild(DeleteStack deleteStack) {
        GBSNode gBSNode = this._index.root();
        GBSNode gBSNode2 = null;
        if (gBSNode != null) {
            deleteStack.start(this._index.dummyTopNode(), "GBSIterator.leftMostChild");
            gBSNode2 = this.leftMostChild(deleteStack, gBSNode);
        }
        return gBSNode2;
    }

    private GBSNode leftMostChild(DeleteStack deleteStack, GBSNode gBSNode) {
        GBSNode gBSNode2 = gBSNode.leftChild();
        while (gBSNode2 != null) {
            if (deleteStack.index() > 47) {
                throw new OptimisticDepthException("maxDepth (47) exceeded in GBSIterator.leftMostChild().");
            }
            deleteStack.push(2, gBSNode, "GBSIterator.leftMostChild");
            gBSNode = gBSNode2;
            gBSNode2 = gBSNode.leftChild();
        }
        this._p = gBSNode;
        this._s = 3;
        return this._p;
    }

    private void findNext(DeleteStack deleteStack) {
        if (this._last1.key() == null) {
            throw new RuntimeException("Help!  In findNext(), _last1.key() == null");
        }
        if (!this._eof) {
            this.findNextBeforeEof(deleteStack);
        } else {
            this.findNextAfterEof(deleteStack);
        }
    }

    private void findNextBeforeEof(DeleteStack deleteStack) {
        boolean bl = false;
        if (this._last1._vno == this._index.vno()) {
            bl = this.optimisticGetNext1(deleteStack);
        }
        if (!bl) {
            this.pessimisticGetNext(deleteStack);
        }
    }

    private void findNextAfterEof(DeleteStack deleteStack) {
        if (!this._eof) {
            throw new RuntimeException("findNextAfterEof called when _eof false.");
        }
        if (this._current1._vno != this._index.vno()) {
            boolean bl = false;
            bl = this.optimisticSearchNext(deleteStack);
            if (!bl) {
                this.pessimisticSearchNext(deleteStack);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticSearchNext(DeleteStack deleteStack) {
        int n = this._index.vno();
        int n2 = this._index.xno();
        if ((n & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        // MONITORENTER : gBSIterator
        // MONITOREXIT : gBSIterator
        try {
            this.internalSearchNext(deleteStack, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), nullPointerException, "optimisticSearchNext");
        }
        catch (OptimisticDepthException optimisticDepthException) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), optimisticDepthException, "optimisticSearchNext");
        }
        if (n != this._index.vno()) {
            this._current1.setVersion(1);
            return false;
        }
        ++this._optimisticSearchNexts;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticSearchNext(DeleteStack deleteStack) {
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            this.internalSearchNext(deleteStack, this._index.vno(), this._index.xno());
            ++this._pessimisticSearchNexts;
        }
    }

    private void internalSearchNext(DeleteStack deleteStack, int n, int n2) {
        SearchComparator searchComparator = this.searchComparator(2);
        this._s = 0;
        this._p = null;
        this._eof = true;
        this._current1.setVersion(n);
        SearchNode searchNode = this.searchNode();
        Object object = this._index.iteratorFind(this._dstack, searchComparator, this._last1.key(), searchNode);
        if (object != null) {
            this._current1.setLocation(searchNode.foundNode(), searchNode.foundIndex());
            this._current1.setLocation(searchNode.key(), n, n2);
            this._s = 3;
            this._p = searchNode.foundNode();
            this._eof = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticGetNext1(DeleteStack deleteStack) {
        Object object = null;
        int n = this._index.vno();
        int n2 = this._index.xno();
        if ((n & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        // MONITORENTER : gBSIterator
        // MONITOREXIT : gBSIterator
        int n3 = this._last1.index() + 1;
        GBSNode gBSNode = this._last1.node();
        if (n3 >= gBSNode.population()) return false;
        this._current1.setLocation(gBSNode, n3);
        object = gBSNode.key(n3);
        if (n != this._index.vno()) {
            return false;
        }
        this._current1.setLocation(object, n, n2);
        ++this._optimisticGetNext1s;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean optimisticGetNext2(DeleteStack deleteStack) {
        Object var2_2 = null;
        int n = this._index.vno();
        int n2 = this._index.xno();
        if ((n & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        // MONITORENTER : gBSIterator
        // MONITOREXIT : gBSIterator
        try {
            this.internalGetNext(deleteStack, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), nullPointerException, "optimisticGetNext2");
        }
        catch (OptimisticDepthException optimisticDepthException) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(n, this._index.vno(), optimisticDepthException, "optimisticGetNext2");
        }
        if (n != this._index.vno()) {
            return false;
        }
        ++this._optimisticGetNext2s;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticGetNext(DeleteStack deleteStack) {
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            this.internalGetNext(deleteStack, this._index.vno(), this._index.xno());
            ++this._pessimisticGetNexts;
        }
    }

    private void internalGetNext(DeleteStack deleteStack, int n, int n2) {
        if (this._last1._xno == n2) {
            SearchComparator searchComparator = this.searchComparator(1);
            GBSNode gBSNode = this._last1.node();
            int n3 = gBSNode.searchAll(searchComparator, this._last1.key());
            if (n3 >= 0) {
                if (n3 + 1 < gBSNode.population()) {
                    this._current1.setLocation(gBSNode, n3 + 1);
                    this._current1.setLocation(gBSNode.key(n3 + 1), n, n2);
                } else {
                    gBSNode = this.nextNode(deleteStack);
                    this._current1.setLocation(gBSNode, 0);
                    if (gBSNode != null) {
                        Object object = gBSNode.leftMostKey();
                        this._current1.setLocation(object, n, n2);
                    }
                }
            }
        }
        if (this._current1.key() == null) {
            this.internalSearchNext(deleteStack, n, n2);
        }
    }

    private GBSNode nextNode(DeleteStack deleteStack) {
        if (this._eof) {
            throw new RuntimeException("_eof is set on entry to nextNode()");
        }
        boolean bl = false;
        GBSNode gBSNode = null;
        GBSNode gBSNode2 = null;
        block6: while (!bl) {
            if (deleteStack.index() > 47) {
                throw new OptimisticDepthException("maxDepth (47) exceeded in GBSIterator.nextNode().");
            }
            switch (this._s) {
                case 1: {
                    this._s = 2;
                    gBSNode = this._p.leftChild();
                    while (gBSNode != null) {
                        deleteStack.push(this._s, this._p, "GBSIterator.nextNode:VISIT_LEFT");
                        this._p = gBSNode;
                        gBSNode = this._p.leftChild();
                    }
                    continue block6;
                }
                case 2: {
                    this._s = 3;
                    bl = true;
                    gBSNode2 = this._p;
                    continue block6;
                }
                case 3: {
                    this._s = 4;
                    gBSNode = this._p.rightChild();
                    if (gBSNode == null) continue block6;
                    deleteStack.push(this._s, this._p, "GBSIterator.nextNode:VISIT_RIGHT");
                    this._s = 1;
                    this._p = this._p.rightChild();
                    continue block6;
                }
                case 4: {
                    if (deleteStack.index() <= 0) {
                        bl = true;
                        continue block6;
                    }
                    this._s = deleteStack.state();
                    this._p = deleteStack.node();
                    deleteStack.pop();
                    continue block6;
                }
            }
            throw new RuntimeException("Help!, _s = " + this._s + ", _p = " + this._p + ".");
        }
        return gBSNode2;
    }

    public Object next() {
        this._current1.reset();
        if (this._last1.key() == null) {
            this.findFirst(this._dstack);
        } else {
            this.findNext(this._dstack);
            if (this._current1.key() == null) {
                this._eof = true;
            }
        }
        if (this._current1.key() != null) {
            this._last1.setLocation(this._current1);
        }
        return this._current1.key();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalRemove() {
        boolean bl = false;
        boolean bl2 = true;
        GBSNode gBSNode = this._last1.node();
        int n = this._last1.index();
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            SearchComparator searchComparator;
            bl2 = this._last1._xno != this._index.xno() ? true : (!(gBSNode = this._last1.node()).isLeafNode() ? true : (gBSNode.population() < 2 || gBSNode.isFull() ? true : (this._last1._vno == this._index.vno() ? false : (n = gBSNode.searchAll(searchComparator = this.searchComparator(1), this._last1.key())) < 0)));
            if (!bl2) {
                this._index.iteratorSpecialDelete(this, gBSNode, n);
            }
        }
        ++this._deleteCount;
        if (bl2) {
            bl = this._index.delete(this._last1.key());
        } else {
            ++this._specialCount;
            bl = true;
        }
        return bl;
    }

    public boolean remove() {
        if (this._last1.key() == null) {
            throw new NoSuchElementException("remove() without calling next()");
        }
        boolean bl = this.internalRemove();
        return bl;
    }

    public String toString() {
        String string = "Delete Count = " + this._deleteCount + ", " + "Special Count = " + this._specialCount;
        return string;
    }

    private SearchComparator searchComparator(int n) {
        return this.localComparator().getSingleton(n);
    }

    private SearchComparator localComparator() {
        if (this._localComparator == null) {
            this._localComparator = new SearchComparator(this._index.insertComparator());
        }
        return this._localComparator;
    }

    private SearchNode searchNode() {
        if (this._localSearchNode == null) {
            this._localSearchNode = new SearchNode();
        } else {
            this._localSearchNode.reset();
        }
        return this._localSearchNode;
    }

    private class Locator {
        private GBSNode _node;
        private int _index;
        private Object _obj;
        private int _vno;
        private int _xno;

        private Locator() {
        }

        private void reset() {
            this._node = null;
            this._index = -6;
            this._obj = null;
            this._vno = 0;
            this._xno = 0;
        }

        private void setLocation(Object object, int n, int n2) {
            this._obj = object;
            this._vno = n;
            this._xno = n2;
        }

        private void setLocation(GBSNode gBSNode, int n) {
            this._node = gBSNode;
            this._index = n;
        }

        private void setLocation(Locator locator) {
            this._node = locator._node;
            this._index = locator._index;
            this._obj = locator._obj;
            this._vno = locator._vno;
            this._xno = locator._xno;
        }

        private void setVersion(int n) {
            this._vno = n;
        }

        private Object key() {
            return this._obj;
        }

        private GBSNode node() {
            return this._node;
        }

        private int index() {
            return this._index;
        }

        public String toString() {
            String string = "node = " + this._node + "\n" + "  " + "index = " + this._index + ", " + "vno = " + this._vno + ", " + "xno = " + this._xno;
            return string;
        }
    }
}

