/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Comparator;

public class ExpiryIndex {
    private static TraceComponent tc = SibTr.register((Class)ExpiryIndex.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private GBSTree tree = null;
    private GBSTree.Iterator iterator = null;
    private int size = 0;

    public ExpiryIndex() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.tree = new GBSTree(2, 10, new ExpiryComparator(), new ExpiryComparator());
        this.iterator = this.tree.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean put(ExpirableReference expirableReference) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)("ObjId=" + expirableReference.getID() + " ET=" + expirableReference.getExpiryTime()));
        }
        if (bl = this.tree.insert(expirableReference)) {
            ++this.size;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)("reply=" + bl));
        }
        return bl;
    }

    public boolean remove() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        boolean bl = this.iterator.remove();
        if (bl) {
            --this.size;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)("reply=" + bl));
        }
        return bl;
    }

    public boolean remove(ExpirableReference expirableReference) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)(expirableReference == null ? "null" : "ObjId=" + expirableReference.getID() + " ET=" + expirableReference.getExpiryTime()));
        }
        if (bl = this.tree.delete(expirableReference)) {
            --this.size;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)("reply=" + bl));
        }
        return bl;
    }

    public void resetIterator() {
        this.iterator.reset();
    }

    public int size() {
        return this.size;
    }

    public ExpirableReference next() {
        return (ExpirableReference)this.iterator.next();
    }

    class ExpiryComparator
    implements Comparator {
        ExpiryComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            ExpirableReference expirableReference = (ExpirableReference)object;
            ExpirableReference expirableReference2 = (ExpirableReference)object2;
            long l2 = expirableReference.getExpiryTime();
            if (l2 == (l = expirableReference2.getExpiryTime())) {
                long l3;
                long l4 = expirableReference.getID();
                if (l4 == (l3 = expirableReference2.getID())) {
                    return 0;
                }
                if (l4 < l3) {
                    return -1;
                }
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
    }
}

