/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

final class UnstoredItemManager
extends IndirectionCache {
    public static final String $ssccid = "@(#) 1.12 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/ref/UnstoredItemManager.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/05/03 09:53:22 [3/13/06 13:38:26]";
    private static TraceComponent tc = SibTr.register((Class)UnstoredItemManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final IndirectionList _list = new IndirectionList();
    private long _maximumSize = 10000L;
    private long _maximumItemSize = 100000L;
    private long _totalCount = 0L;
    private long _totalDiscardCount = 0L;
    private long _totalDiscardSize = 0L;
    private long _totalRefusalCount = 0L;

    UnstoredItemManager(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        this._maximumSize = l;
        this._maximumItemSize = l2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private void _postAppendSlimming(Indirection indirection) {
        if (this._list.getCurrentSize() > this._maximumSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("begin discarding indirections as size (" + this._list.getCurrentSize() + ") > max (" + this._maximumSize + ")"));
            }
            while (this._list.getCurrentSize() > this._maximumSize) {
                Indirection indirection2 = this._list.removeFirst();
                if (null == indirection2) {
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"list empty");
                    break;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinking " + indirection2.getID()));
                }
                indirection2.releaseIfDiscardable();
                ++this._totalDiscardCount;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("end discarding indirections new size = " + this._list.getCurrentSize()));
            }
        }
    }

    public IndirectionCache register(Indirection indirection) throws OutOfCacheSpace {
        return this;
    }

    public final long getCurrentCount() {
        return this._list.getCurrentCount();
    }

    public final long getCurrentSize() {
        return this._list.getCurrentSize();
    }

    public final long getDiscardableSize() {
        return this._list.getCurrentSize();
    }

    public final long getMaximumSize() {
        return this._maximumSize;
    }

    final CacheStatistics getStatistics() {
        return this;
    }

    public final long getTotalCount() {
        return this._totalCount;
    }

    public final long getTotalDiscardCount() {
        return this._totalDiscardCount;
    }

    public final long getTotalDiscardSize() {
        return this._totalDiscardSize;
    }

    public final long getTotalRefusalCount() {
        return this._totalRefusalCount;
    }

    public final long getTotalSize() {
        return this._totalDiscardSize;
    }

    public final void unregister(Indirection indirection) {
        boolean bl = this._list.unlink(indirection);
        if (bl && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinked: " + indirection.getID() + " (size=" + this._list.getCurrentCount() + ")"));
        }
    }

    public final void unmanage(Indirection indirection) {
        boolean bl = this._list.unlink(indirection);
        if (bl && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinked: " + indirection.getID() + " (size=" + this._list.getCurrentCount() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void manage(Indirection indirection, AbstractItem abstractItem) {
        if ((long)indirection.getSize() > this._maximumSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item too large to cache, so just hold with weak reference");
            }
            UnstoredItemManager unstoredItemManager = this;
            synchronized (unstoredItemManager) {
                ++this._totalRefusalCount;
            }
        } else {
            boolean bl = this._list.append(indirection, abstractItem);
            if (bl) {
                this._postAppendSlimming(indirection);
            }
        }
    }

    public final synchronized void resetTotals() {
        this._totalDiscardCount = 0L;
        this._totalDiscardSize = 0L;
        this._totalCount = 0L;
        this._totalRefusalCount = 0L;
    }

    public final String toString() {
        return "UnstoredItemManager(" + this.hashCode() + ") size=" + this.getCurrentSize() + " max=" + this.getMaximumSize();
    }

    void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.startTag("UnstoredItemManager");
        formattedWriter.indent();
        this._list.xmlWriteOn(formattedWriter);
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.endTag("UnstoredItemManager");
    }
}

