/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.ref.StoredItemManager;
import com.ibm.ws.sib.msgstore.cache.ref.UnstoredItemManager;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentor;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public final class ItemStorageManager
implements MessageStoreConstants,
CacheStatistics,
MSInstrumentor {
    public static final String $ssccid = "@(#) 1.26 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/ref/ItemStorageManager.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/04/28 09:01:46 [3/13/06 13:38:26]";
    private static TraceComponent tc = SibTr.register((Class)ItemStorageManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    MSInstrumentation _instr = null;
    private StoredItemManager _storedItemManager = null;
    private UnstoredItemManager _unstoredItemManager = null;

    public final IndirectionCache register(Indirection indirection, int n) throws OutOfCacheSpace {
        IndirectionCache indirectionCache = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"register", (Object)indirection);
        }
        if (1 == n) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"using unstoredItemManager");
            }
            indirectionCache = this._unstoredItemManager.register(indirection);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"using storedItemManager");
            }
            indirectionCache = this._storedItemManager.register(indirection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"register", (Object)indirectionCache);
        }
        return indirectionCache;
    }

    public final long getCurrentCount() {
        long l = 0L;
        l += this._storedItemManager.getCurrentCount();
        return l += this._unstoredItemManager.getCurrentCount();
    }

    public final long getCurrentSize() {
        long l = 0L;
        l += this._storedItemManager.getCurrentSize();
        return l += this._unstoredItemManager.getCurrentSize();
    }

    public final long getDiscardableSize() {
        long l = 0L;
        l += this._storedItemManager.getStatistics().getDiscardableSize();
        return l += this._unstoredItemManager.getStatistics().getDiscardableSize();
    }

    public final long getMaximumSize() {
        long l = 0L;
        l += this._storedItemManager.getMaximumSize();
        return l += this._unstoredItemManager.getMaximumSize();
    }

    public final CacheStatistics getNonStoredCacheStatistics() {
        return this._unstoredItemManager.getStatistics();
    }

    public final CacheStatistics getStoredCacheStatistics() {
        return this._storedItemManager.getStatistics();
    }

    public final long getTotalCount() {
        long l = 0L;
        l += this._storedItemManager.getStatistics().getTotalCount();
        return l += this._unstoredItemManager.getStatistics().getTotalCount();
    }

    public final long getTotalDiscardCount() {
        long l = 0L;
        l += this._storedItemManager.getTotalDiscardCount();
        return l += this._unstoredItemManager.getTotalDiscardCount();
    }

    public final long getTotalDiscardSize() {
        long l = 0L;
        l += this._storedItemManager.getTotalDiscardSize();
        return l += this._unstoredItemManager.getTotalDiscardSize();
    }

    public final long getTotalRefusalCount() {
        long l = 0L;
        l += this._storedItemManager.getStatistics().getTotalRefusalCount();
        return l += this._unstoredItemManager.getStatistics().getTotalRefusalCount();
    }

    public final long getTotalSize() {
        long l = 0L;
        l += this._storedItemManager.getStatistics().getTotalSize();
        return l += this._unstoredItemManager.getStatistics().getTotalSize();
    }

    public final void initialize(MessageStoreImpl messageStoreImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_initializeIndirection");
        }
        String string = messageStoreImpl.getProperty("cachedDataBufferSize", "320000");
        long l = Long.parseLong(string);
        string = messageStoreImpl.getProperty("cachedDataItemMaximumSize", "100000");
        long l2 = Long.parseLong(string);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("StoredItemManager size = " + l));
            SibTr.debug((TraceComponent)tc, (String)("StoredItemManager max size = " + l2));
        }
        if (l <= 0L) {
            throw new MessageStoreRuntimeException("invalid setting: cachedDataBufferSize=" + string);
        }
        this._storedItemManager = new StoredItemManager(l, l2);
        string = messageStoreImpl.getProperty("discardableDataBufferSize", "320000");
        l = Long.parseLong(string);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("unstoredItemManager size = " + l));
            SibTr.debug((TraceComponent)tc, (String)("unstoredItemManager max size = " + l2));
        }
        if (l <= 0L) {
            throw new MessageStoreRuntimeException("invalid setting: discardableDataBufferSize=" + string);
        }
        this._unstoredItemManager = new UnstoredItemManager(l, l2);
        this._instr = messageStoreImpl._getInstrumentation();
        this._instr.registerInstrumentor(this, 8);
        this._instr.registerInstrumentor(this, 9);
        this._instr.registerInstrumentor(this, 10);
        this._instr.registerInstrumentor(this, 11);
        this._instr.registerInstrumentor(this, 12);
        this._instr.registerInstrumentor(this, 13);
        this._instr.registerInstrumentor(this, 14);
        this._instr.registerInstrumentor(this, 15);
        this._instr.registerInstrumentor(this, 16);
        this._instr.registerInstrumentor(this, 17);
        this._instr.registerInstrumentor(this, 18);
        this._instr.registerInstrumentor(this, 19);
        this._instr.registerInstrumentor(this, 20);
        this._instr.registerInstrumentor(this, 21);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_initializeIndirection");
        }
    }

    public final void requestStatUpdate(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestStatUpdate", (Object)new Integer(n));
        }
        long l = -1L;
        if (null == this._instr) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"no instrumentor");
            }
        } else {
            switch (n) {
                case 8: {
                    l = this._storedItemManager.getCurrentCount();
                    break;
                }
                case 9: {
                    l = this._unstoredItemManager.getCurrentCount();
                    break;
                }
                case 10: {
                    l = this._storedItemManager.getCurrentSize();
                    break;
                }
                case 11: {
                    l = this._unstoredItemManager.getCurrentSize();
                    break;
                }
                case 12: {
                    l = this._storedItemManager.getStatistics().getTotalCount();
                    break;
                }
                case 13: {
                    l = this._unstoredItemManager.getStatistics().getTotalCount();
                    break;
                }
                case 14: {
                    l = this._storedItemManager.getStatistics().getTotalSize();
                    break;
                }
                case 15: {
                    l = this._unstoredItemManager.getStatistics().getTotalSize();
                    break;
                }
                case 16: {
                    l = this._storedItemManager.getTotalDiscardCount();
                    break;
                }
                case 17: {
                    l = this._unstoredItemManager.getTotalDiscardCount();
                    break;
                }
                case 18: {
                    l = this._storedItemManager.getTotalDiscardSize();
                    break;
                }
                case 19: {
                    l = this._storedItemManager.getTotalDiscardSize();
                    break;
                }
                case 20: {
                    l = this._unstoredItemManager.getStatistics().getTotalRefusalCount();
                    break;
                }
                case 21: {
                    l = this._storedItemManager.getStatistics().getTotalRefusalCount();
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("unrecognized id: " + n));
                }
            }
            this._instr.setCount(n, l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestStatUpdate", (Object)new Long(l));
        }
    }

    public final void resetTotals() {
        this._storedItemManager.getStatistics().resetTotals();
        this._unstoredItemManager.getStatistics().resetTotals();
    }

    public final void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.newLine();
        this._storedItemManager.xmlWriteOn(formattedWriter);
        formattedWriter.newLine();
        this._unstoredItemManager.xmlWriteOn(formattedWriter);
    }
}

