/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.CursorImpl;
import com.ibm.ws.sib.msgstore.cache.links.Priorities;
import com.ibm.ws.sib.msgstore.cache.xalist.TransactionalList;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.collections.linkedlist.Link;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

final class PrioritisedList
implements Priorities {
    private static TraceComponent tc = SibTr.register((Class)PrioritisedList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private CursorImpl _firstCursor = null;
    private final TransactionalList[] _prioritySublists = new TransactionalList[10];

    PrioritisedList() {
    }

    final synchronized void _removeCursor(CursorImpl cursorImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_removeCursor", (Object)cursorImpl);
        }
        if (null == this._firstCursor) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"no cursors in list");
            }
        } else if (this._firstCursor == cursorImpl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"removing first cursor");
            }
            this._firstCursor = this._firstCursor.getNextCursor();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"scanning list");
            }
            CursorImpl cursorImpl2 = this._firstCursor;
            CursorImpl cursorImpl3 = this._firstCursor.getNextCursor();
            while (null != cursorImpl3) {
                if (cursorImpl == cursorImpl3) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"removing cursor");
                    }
                    cursorImpl2.setNextCursor(cursorImpl3.getNextCursor());
                    cursorImpl3.setNextCursor(null);
                    cursorImpl3 = null;
                    continue;
                }
                cursorImpl2 = cursorImpl3;
                cursorImpl3 = cursorImpl3.getNextCursor();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_removeCursor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void append(AbstractItemLink abstractItemLink) {
        int n = abstractItemLink.getPriority();
        TransactionalList transactionalList = this._prioritySublists[n];
        if (null == transactionalList) {
            TransactionalList[] transactionalListArray = this._prioritySublists;
            // MONITORENTER : this._prioritySublists
            transactionalList = this._prioritySublists[n];
            if (null == transactionalList) {
                this._prioritySublists[n] = transactionalList = new TransactionalList();
            }
            // MONITOREXIT : transactionalListArray
        }
        transactionalList.append(abstractItemLink);
    }

    final AbstractItem findFirstMatching(Filter filter) throws MessageStoreException {
        AbstractItem abstractItem = null;
        for (int i = 9; null == abstractItem && i >= 0; --i) {
            TransactionalList transactionalList = this._prioritySublists[i];
            if (null == transactionalList) continue;
            abstractItem = transactionalList.findFirstMatching(filter);
        }
        return abstractItem;
    }

    final AbstractItem findOldestItem() throws MessageStoreException {
        AbstractItem abstractItem = null;
        AbstractItemLink abstractItemLink = null;
        long l = Long.MAX_VALUE;
        for (int i = 0; i <= 9; ++i) {
            long l2;
            AbstractItemLink abstractItemLink2;
            TransactionalList transactionalList = this._prioritySublists[i];
            if (null == transactionalList || null == (abstractItemLink2 = (AbstractItemLink)transactionalList.getHead()) || (l2 = abstractItemLink2.getSequence()) >= l) continue;
            l = l2;
            abstractItemLink = abstractItemLink2;
        }
        if (null != abstractItemLink) {
            abstractItem = abstractItemLink.getItem();
        }
        return abstractItem;
    }

    final TransactionalList getPrioritySublist(int n) {
        return this._prioritySublists[n];
    }

    final synchronized void linkAvailable(AbstractItemLink abstractItemLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linkReavailable", (Object)abstractItemLink);
        }
        for (CursorImpl cursorImpl = this._firstCursor; null != cursorImpl; cursorImpl = cursorImpl.getNextCursor()) {
            cursorImpl.linkAvailable(abstractItemLink);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"linkReavailable");
        }
    }

    final synchronized CursorImpl newCursor(Filter filter, long l) {
        CursorImpl cursorImpl = new CursorImpl(this, filter, l);
        cursorImpl.setNextCursor(this._firstCursor);
        this._firstCursor = cursorImpl;
        return cursorImpl;
    }

    final AbstractItem removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        AbstractItem abstractItem = null;
        for (int i = 9; null == abstractItem && i >= 0; --i) {
            TransactionalList transactionalList = this._prioritySublists[i];
            if (null == transactionalList || null == (abstractItem = transactionalList.removeFirstMatching(filter, transaction)) || !tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("found item: " + abstractItem));
        }
        return abstractItem;
    }

    final boolean xmlHasChildren() {
        for (int i = 0; i <= 9; ++i) {
            if (null == this._prioritySublists[i]) continue;
            return true;
        }
        return false;
    }

    final void xmlWriteChildrenOn(FormattedWriter formattedWriter, String string) throws IOException {
        formattedWriter.newLine();
        formattedWriter.write("<");
        formattedWriter.write(string);
        formattedWriter.write(">");
        formattedWriter.indent();
        if (null != this._firstCursor) {
            formattedWriter.newLine();
            formattedWriter.write("<cursors>");
            formattedWriter.indent();
            for (CursorImpl cursorImpl = this._firstCursor; null != cursorImpl; cursorImpl = cursorImpl.getNextCursor()) {
                formattedWriter.newLine();
                cursorImpl.xmlWriteOn(formattedWriter);
            }
            formattedWriter.outdent();
            formattedWriter.newLine();
            formattedWriter.write("</cursors>");
        }
        formattedWriter.newLine();
        formattedWriter.write("<children>");
        formattedWriter.indent();
        for (int i = 9; i >= 0; --i) {
            if (null == this._prioritySublists[i]) continue;
            for (Link link = this._prioritySublists[i].getDummyHead(); null != link; link = link.getNextPhysicalLink()) {
                formattedWriter.newLine();
                link.xmlWriteOn(formattedWriter);
            }
        }
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.write("</children>");
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.write("</");
        formattedWriter.write(string);
        formattedWriter.write(">");
    }
}

