/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemCollection;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.CursorImpl;
import com.ibm.ws.sib.msgstore.cache.links.ItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.NoLockNoPriorityCursor;
import com.ibm.ws.sib.msgstore.cache.links.PrioritisedList;
import com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.cache.xalist.Cursor;
import com.ibm.ws.sib.msgstore.cache.xalist.TransactionalList;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ItemStreamLink
extends LinkOwner
implements ItemCollection {
    private static TraceComponent tc = Tr.register((Class)ItemStreamLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private PrioritisedList _items = null;
    private TransactionalList _itemStreams;
    private long _nextSequenceToIssue = 0L;
    private TransactionalList _referenceStreams;
    private final ListStatistics _statistics;

    public ItemStreamLink(ItemStream itemStream, LinkOwner linkOwner, Persistable persistable) throws OutOfCacheSpace {
        super(itemStream, linkOwner, persistable);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ItemStreamLink", (Object)new Object[]{linkOwner, itemStream, persistable});
        }
        this._items = new PrioritisedList();
        this._itemStreams = new TransactionalList();
        this._referenceStreams = new TransactionalList();
        this._statistics = new ListStatistics(this);
        this._setWatermarks(itemStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ItemStreamLink", (Object)this);
        }
    }

    public ItemStreamLink(LinkOwner linkOwner, Persistable persistable) {
        super(linkOwner, persistable);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ItemStreamLink", (Object)new Object[]{linkOwner, persistable});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ItemStreamLink", (Object)this);
        }
        this._statistics = new ListStatistics(this);
    }

    private final void _ensureReferencesAreLoaded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_ensureReferencesAreLoaded");
        }
        for (ReferenceStreamLink referenceStreamLink = (ReferenceStreamLink)this._referenceStreams.getHead(); null != referenceStreamLink; referenceStreamLink = (ReferenceStreamLink)referenceStreamLink.getNextLink()) {
            referenceStreamLink.ensureReferencesLoaded();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_ensureReferencesAreLoaded");
        }
    }

    final void _initializeChildren(HashMap hashMap) {
        this._itemStreams = new TransactionalList();
        this._referenceStreams = new TransactionalList();
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        ArrayList arrayList = (ArrayList)hashMap.remove(new Long(this.getID()));
        for (int i = 0; null != arrayList && i < arrayList.size(); ++i) {
            long l;
            Persistable persistable = (Persistable)arrayList.get(i);
            LinkOwner linkOwner = null;
            persistable.setContainingStream(this.getTuple());
            if (persistable.getTupleType().equals(TupleTypeEnum.ITEM_STREAM)) {
                linkOwner = new ItemStreamLink(this, persistable);
                linkOwner.restoreState(persistable);
                if (linkOwner.isInStore()) {
                    messageStoreImpl.register(linkOwner);
                }
                if (linkOwner.isItemStreamLink()) {
                    ((ItemStreamLink)linkOwner)._initializeChildren(hashMap);
                }
            } else if (persistable.getTupleType().equals(TupleTypeEnum.REFERENCE_STREAM)) {
                linkOwner = new ReferenceStreamLink(this, persistable);
                linkOwner.restoreState(persistable);
                if (linkOwner.isInStore()) {
                    messageStoreImpl.register(linkOwner);
                }
            } else {
                throw new MessageStoreRuntimeException("Wrong tuple type in ItemStream:" + persistable.getTupleType());
            }
            if ((l = persistable.getSequence()) < this._nextSequenceToIssue) continue;
            this._nextSequenceToIssue = l + 1L;
        }
    }

    private final void _initializeItems() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_initializeItems");
        }
        this._items = new PrioritisedList();
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        PersistentMessageStore persistentMessageStore = messageStoreImpl.getPersistentMessageStore();
        try {
            List list = persistentMessageStore.readNonStreamItems(this.getTuple());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Persistable persistable = (Persistable)iterator.next();
                ItemLink itemLink = null;
                if (persistable.getTupleType().equals(TupleTypeEnum.ITEM)) {
                    itemLink = new ItemLink(this, persistable);
                    itemLink.restoreState(persistable);
                    if (itemLink.isInStore()) {
                        messageStoreImpl.register(itemLink);
                    }
                } else {
                    throw new MessageStoreRuntimeException("Wrong tuple type in ItemStream:" + persistable.getTupleType());
                }
                long l = persistable.getSequence();
                if (l < this._nextSequenceToIssue) continue;
                this._nextSequenceToIssue = l + 1L;
            }
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink._initializeItems", (String)"217", (Object)this);
            throw new MessageStoreRuntimeException((Throwable)((Object)persistenceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeItems");
        }
    }

    private final PrioritisedList _items() {
        if (null == this._items) {
            this._initializeItems();
            this._ensureReferencesAreLoaded();
        }
        return this._items;
    }

    private final void _setWatermarks(ItemStream itemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)itemStream);
        }
        long l = itemStream.getCountLowWaterMark();
        long l2 = itemStream.getCountHighWaterMark();
        long l3 = itemStream.getByteLowWaterMark();
        long l4 = itemStream.getByteHighWaterMark();
        this._statistics.setWatermarks(l, l2, l3, l4);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)this._statistics);
        }
    }

    public final void addItem(Item item, long l, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItem", (Object)new Object[]{item, transaction});
        }
        this._items();
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        int n = item.getStorageStrategy();
        long l2 = messageStoreImpl.getUniqueValue(n);
        TupleTypeEnum tupleTypeEnum = TupleTypeEnum.ITEM;
        Persistable persistable = this.getTuple().createPersistable(l2, tupleTypeEnum);
        ItemLink itemLink = new ItemLink(item, this, persistable);
        itemLink.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStoreImpl.registerLink(itemLink, item);
        itemLink.cmdAdd(this, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
        }
    }

    public final void addItemStream(ItemStream itemStream, long l, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItemStream", (Object)new Object[]{itemStream, transaction});
        }
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        int n = itemStream.getStorageStrategy();
        long l2 = messageStoreImpl.getUniqueValue(n);
        TupleTypeEnum tupleTypeEnum = TupleTypeEnum.ITEM_STREAM;
        Persistable persistable = this.getTuple().createPersistable(l2, tupleTypeEnum);
        ItemStreamLink itemStreamLink = new ItemStreamLink(itemStream, (LinkOwner)this, persistable);
        itemStreamLink.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStoreImpl.registerLink(itemStreamLink, itemStream);
        itemStreamLink.cmdAdd(this, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
        }
    }

    public final void addReferenceStream(ReferenceStream referenceStream, long l, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReferenceStream", (Object)new Object[]{referenceStream, transaction});
        }
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        int n = referenceStream.getStorageStrategy();
        long l2 = messageStoreImpl.getUniqueValue(n);
        TupleTypeEnum tupleTypeEnum = TupleTypeEnum.REFERENCE_STREAM;
        Persistable persistable = this.getTuple().createPersistable(l2, tupleTypeEnum);
        ReferenceStreamLink referenceStreamLink = new ReferenceStreamLink(referenceStream, (LinkOwner)this, persistable);
        referenceStreamLink.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStoreImpl.registerLink(referenceStreamLink, referenceStream);
        referenceStreamLink.cmdAdd(this, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
        }
    }

    public final void append(AbstractItemLink abstractItemLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"append", (Object)abstractItemLink);
        }
        if (abstractItemLink.isItemStreamLink()) {
            this._itemStreams.append(abstractItemLink);
        } else if (abstractItemLink.isReferenceStreamLink()) {
            this._referenceStreams.append(abstractItemLink);
        } else {
            this._items().append(abstractItemLink);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"append");
        }
    }

    void appendReferenceStream(AbstractItemLink abstractItemLink) {
        this._referenceStreams.append(abstractItemLink);
    }

    public final RuntimeException assertCanDelete(Transaction transaction) {
        Object object = super.assertCanDelete(transaction);
        if (null != object) {
            return object;
        }
        int n = 0;
        TaskList taskList = (TaskList)transaction.getWorkList();
        if (null != taskList) {
            n = taskList.countRemovingItems(this);
            boolean bl = this.getListStatistics().canDelete(n);
            if (!bl) {
                object = new MessageStoreRuntimeException("STREAM_NOT_EMPTY_SIMS0501");
            }
        }
        return object;
    }

    final void assertReadyForReferenceInitialisation() {
        this._items();
    }

    public final void calculateMovingAverage() {
        this._statistics.calculateMovingAverage();
    }

    protected final boolean canSoftenReference() {
        return false;
    }

    public final void ensureItemsLoaded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureItemsLoaded");
        }
        this._items();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureItemsLoaded");
        }
    }

    public final void eventWatermarkBreached() {
        ItemStream itemStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        if (null != (itemStream = (ItemStream)this.getItem())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notifying eventWatermarkBreached: " + itemStream));
            }
            itemStream.eventWatermarkBreached();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notified eventWatermarkBreached: " + itemStream));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no itemStream to notify");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    public final boolean expirableExpire(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        boolean bl = true;
        if (this._statistics.countTotalItems() > 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"cannot expire a non-empty stream");
            }
            bl = false;
        } else {
            bl = super.expirableExpire(transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final AbstractItem findById(long l) {
        this.getStatistics();
        return this.getMessageStoreImpl()._findById(l);
    }

    public AbstractItem findFirstMatchingItem(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        PrioritisedList prioritisedList = this._items();
        AbstractItem abstractItem = prioritisedList.findFirstMatching(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        ItemStream itemStream = (ItemStream)this._itemStreams.findFirstMatching(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public final ReferenceStream findFirstMatchingReferenceStream(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)filter);
        }
        ReferenceStream referenceStream = (ReferenceStream)this._referenceStreams.findFirstMatching(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }

    public AbstractItem findOldestItem() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        this._items();
        AbstractItem abstractItem = this._items().findOldestItem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)abstractItem);
        }
        return abstractItem;
    }

    final ItemStream getItemStream() {
        return (ItemStream)this.getItem();
    }

    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final ItemStream getOwningItemStream() {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    final ReferenceStream getReferenceStream() {
        return null;
    }

    public final Statistics getStatistics() {
        this._items();
        return this.getListStatistics();
    }

    public final boolean isItemStreamLink() {
        return true;
    }

    public final boolean isSpilling() {
        boolean bl = false;
        if (1 != this.getTuple().getStorageStrategy()) {
            bl = this.getListStatistics().isSpilling();
        }
        return bl;
    }

    protected final void itemHasBeenRestored(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored", (Object)abstractItem);
        }
        super.itemHasBeenRestored(abstractItem);
        this._setWatermarks((ItemStream)abstractItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored");
        }
    }

    public final void linkAvailable(AbstractItemLink abstractItemLink) {
        this._items().linkAvailable(abstractItemLink);
    }

    public final boolean loadOwnedLinks() {
        boolean bl = false;
        if (null == this._items) {
            this._items();
            bl = true;
        }
        return bl;
    }

    public LockingCursor newLockingItemCursor(Filter filter) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)filter);
        }
        AbstractItem abstractItem = this.getItem();
        int n = abstractItem.getStorageStrategy();
        long l = this.getMessageStoreImpl().getUniqueLockID(n);
        CursorImpl cursorImpl = this._items().newCursor(filter, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)cursorImpl);
        }
        return cursorImpl;
    }

    public NonLockingCursor newNonLockingItemCursor(Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)filter);
        }
        CursorImpl cursorImpl = this._items().newCursor(filter, -2L);
        cursorImpl.disableJumpback();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)cursorImpl);
        }
        return cursorImpl;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)filter);
        }
        Cursor cursor = new Cursor(this._itemStreams, filter);
        NoLockNoPriorityCursor noLockNoPriorityCursor = new NoLockNoPriorityCursor(cursor);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)noLockNoPriorityCursor);
        }
        return noLockNoPriorityCursor;
    }

    public final NonLockingCursor newNonLockingReferenceStreamCursor(Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)filter);
        }
        Cursor cursor = new Cursor(this._referenceStreams, filter);
        NoLockNoPriorityCursor noLockNoPriorityCursor = new NoLockNoPriorityCursor(cursor);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)noLockNoPriorityCursor);
        }
        return noLockNoPriorityCursor;
    }

    public final synchronized long nextSequence() {
        return this._nextSequenceToIssue++;
    }

    public AbstractItem removeFirstMatchingItem(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        PrioritisedList prioritisedList = this._items();
        AbstractItem abstractItem = prioritisedList.removeFirstMatching(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream");
        }
        ItemStream itemStream = (ItemStream)this._itemStreams.removeFirstMatching(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public final ReferenceStream removeFirstMatchingReferenceStream(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream");
        }
        ReferenceStream referenceStream = (ReferenceStream)this._referenceStreams.removeFirstMatching(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }

    public void setMaximumSize(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaximumSize", (Object)new Integer(n));
        }
        if (!this.isAdding()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring as not adding");
            }
        } else if (n < 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring invalid value");
            }
        } else {
            this.getListStatistics().setMaximumSize(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMaximumSize");
        }
    }

    public final void setWatermarks(long l, long l2, long l3, long l4) {
        this._statistics.setWatermarks(l, l2, l3, l4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ItemStreamLink(");
        stringBuffer.append(this.getID());
        stringBuffer.append(")");
        stringBuffer.append(super.toString());
        stringBuffer.append(" state=");
        stringBuffer.append(this.getState());
        return stringBuffer.toString();
    }

    protected boolean xmlHasChildren() {
        if (null != this._items) {
            return this._items.xmlHasChildren();
        }
        return false;
    }

    protected final String xmlTagName() {
        return "ItemStream";
    }

    protected void xmlWriteChildrenOn(FormattedWriter formattedWriter) throws IOException {
        super.xmlWriteChildrenOn(formattedWriter);
        if (null != this._items) {
            this._items.xmlWriteChildrenOn(formattedWriter, "items");
        }
        if (null != this._itemStreams) {
            this._itemStreams.xmlWriteOn(formattedWriter, "itemStreams");
        }
        if (null != this._referenceStreams) {
            this._referenceStreams.xmlWriteOn(formattedWriter, "referenceStreams");
        }
    }
}

