/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class Configuration {
    private static TraceComponent tc = SibTr.register((Class)Configuration.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String PROPERTY_FILE = "MessageStore.properties";
    protected String datasourceClassname = null;
    protected String datasourceUsername = null;
    protected String datasourcePassword = null;
    protected Properties datasourceProperties = new Properties();
    protected String schemaName = "IBMWSSIB";
    protected int numberOfPooledConnections = 3;
    protected boolean createTablesAutomatically = true;
    protected boolean cleanPersistenceOnStart = false;
    protected boolean verbose = false;

    protected Configuration() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>()");
            SibTr.exit((TraceComponent)tc, (String)"<ctor>()", (Object)this);
        }
    }

    public static Configuration createBasicConfiguration() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBasicConfiguration()");
        }
        Configuration configuration = new Configuration();
        try {
            configuration.loadFromPropertyFile();
        }
        catch (IOException iOException) {
            configuration.datasourceClassname = "com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource";
            configuration.datasourceProperties.setProperty("databaseName", "msdb");
            configuration.datasourceProperties.setProperty("createDatabase", "create");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBasicConfiguration()", (Object)configuration);
        }
        return configuration;
    }

    public void loadFromPropertyFile() throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadFromPropertyFile()");
        }
        String string = null;
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream(PROPERTY_FILE);
        if (inputStream == null) {
            throw new IOException("Resource MessageStore.properties not found in current classloader");
        }
        properties.load(inputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equals("datasourceClassname")) {
                this.datasourceClassname = properties.getProperty(string);
                continue;
            }
            if (string.equals("username")) {
                this.datasourceUsername = properties.getProperty(string);
                continue;
            }
            if (string.equals("password")) {
                this.datasourcePassword = properties.getProperty(string);
                continue;
            }
            if (string.equals("schemaname")) {
                this.schemaName = properties.getProperty(string);
                continue;
            }
            if (string.equals("poolSize")) {
                this.numberOfPooledConnections = Integer.parseInt(properties.getProperty(string));
                continue;
            }
            if (string.equals("verbose")) {
                this.verbose = Boolean.valueOf(properties.getProperty(string));
                continue;
            }
            this.datasourceProperties.setProperty(string, properties.getProperty(string));
        }
        if (this.datasourceClassname == null) {
            throw new IllegalStateException("The properties file must specify datasourceClassname");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadFromPropertyFile()");
        }
    }

    public String getDatasourceClassname() {
        return this.datasourceClassname;
    }

    public String getDatasourcePassword() {
        return this.datasourcePassword;
    }

    public String getDatasourceUsername() {
        return this.datasourceUsername;
    }

    public void setDatasourceClassname(String string) {
        this.datasourceClassname = string;
    }

    public void setDatasourcePassword(String string) {
        this.datasourcePassword = string;
    }

    public void setDatasourceUsername(String string) {
        this.datasourceUsername = string;
    }

    public Properties getDatasourceProperties() {
        return this.datasourceProperties;
    }

    public boolean isCreateTablesAutomatically() {
        return this.createTablesAutomatically;
    }

    public void setCreateTablesAutomatically(boolean bl) {
        this.createTablesAutomatically = bl;
    }

    public void setDatabaseSchemaName(String string) {
        this.schemaName = string;
    }

    public String getDatabaseSchemaName() {
        return this.schemaName;
    }

    public boolean isCleanPersistenceOnStart() {
        return this.cleanPersistenceOnStart;
    }

    public void setCleanPersistenceOnStart(boolean bl) {
        this.cleanPersistenceOnStart = bl;
    }

    public int getNumberOfPooledConnections() {
        return this.numberOfPooledConnections;
    }

    public void setNumberOfPooledConnections(int n) {
        this.numberOfPooledConnections = n;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public String toString() {
        return "Class name: " + this.datasourceClassname + ", User name: " + this.datasourceUsername + ", Password: " + "**********" + ", Schema name: " + this.schemaName + ", Pool size: " + this.numberOfPooledConnections + ", Create tables: " + this.createTablesAutomatically + ", Clean start: " + this.cleanPersistenceOnStart + ", Properties: " + this.datasourceProperties;
    }
}

