/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.migration;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.sib.migration.SIBMigrationHelper;
import com.ibm.ws.sib.migration.SIBMigrationHelperException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class SIBQueueManagerName {
    private static final String CLASS_NAME = "com.ibm.ws.sib.migration.SIBJMSQueueManagerName";
    private static final String SIB_MIGRATION_GROUP_NAME = "SIBMigration";
    private static final String SIB_MIGRATION_RESOURCE_BUNDLE_NAME = "com.ibm.ws.sib.migration.CWSIOMessages";
    private static final TraceComponent tc = SibTr.register((Class)SIBMigrationHelper.class, (String)"SIBMigration", (String)"com.ibm.ws.sib.migration.CWSIOMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.migration.CWSIOMessages");
    private static final int MAX_LENGTH = 48;
    private static final String PREFIX = "WAS_";
    private static final String SEPARATOR = "_";
    private static final String REPLACEMENT = "_";
    private static final String SHORT_NAME = "was.shortName";
    private static final HashSet validChars = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_", "%"));
    private static PlatformHelper platformHelper = null;

    private static boolean isZOS() throws SIBMigrationHelperException {
        String string = "isZOS";
        SibTr.entry((TraceComponent)tc, (String)string, null);
        if (platformHelper == null) {
            platformHelper = PlatformHelperFactory.getPlatformHelper();
        }
        if (platformHelper == null) {
            SibTr.event((TraceComponent)tc, (String)"platformHelper == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_PLATFORM_HELPER_CWSIO0011", null, null));
        }
        boolean bl = platformHelper.isZOS();
        SibTr.exit((TraceComponent)tc, (String)string, (Object)new Object[]{new Boolean(bl)});
        return bl;
    }

    public static String generateQueueManagerName(JMSServer jMSServer, String string, String string2) throws SIBMigrationHelperException {
        String string3 = "generateQueueManagerName";
        SibTr.entry((TraceComponent)tc, (String)string3, (Object)new Object[]{jMSServer, string, string2});
        String string4 = null;
        if (SIBQueueManagerName.isZOS()) {
            EList eList = jMSServer.getProperties();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                String string5 = property.getName();
                String string6 = property.getValue();
                if (!SHORT_NAME.equals(string5)) continue;
                string4 = string6;
                break;
            }
            if (string4 == null) {
                SibTr.event((TraceComponent)tc, (String)"queueManagerName == null");
                throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_JMS_SERVER_SHORT_NAME_CWSIO0012", new Object[]{jMSServer.getName()}, null));
            }
        } else {
            String string7 = PREFIX + string + "_" + string2;
            StringBuffer stringBuffer = new StringBuffer(string7);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (validChars.contains(stringBuffer.substring(i, i + 1))) continue;
                stringBuffer.replace(i, i + 1, "_");
            }
            if (stringBuffer.length() > 48) {
                SibTr.event((TraceComponent)tc, (String)"sb.length() > MAX_LENGTH (48)");
                stringBuffer.setLength(48);
            }
            string4 = stringBuffer.toString();
        }
        SibTr.exit((TraceComponent)tc, (String)string3, (Object)new Object[]{string4});
        return string4;
    }
}

