/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.migration;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.migration.SIBMigrationHelperException;
import com.ibm.ws.sib.migration.SIBQueueManagerName;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class SIBMigrationHelper {
    private static final String CLASS_NAME = "com.ibm.ws.sib.migration.SIBMigrationHelper";
    private static final String SIB_MIGRATION_GROUP_NAME = "SIBMigration";
    private static final String SIB_MIGRATION_RESOURCE_BUNDLE_NAME = "com.ibm.ws.sib.migration.CWSIOMessages";
    private static final String ALIAS_NAME_PREFIX = "WQ_";
    private static final TraceComponent tc = SibTr.register((Class)SIBMigrationHelper.class, (String)"SIBMigration", (String)"com.ibm.ws.sib.migration.CWSIOMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.migration.CWSIOMessages");
    private static CommandMgr commandMgr = CommandMgr.getCommandMgr();

    public void createBusFromJmsServer(ConfigService configService, Session session, JMSServer jMSServer, String string, String string2) throws SIBMigrationHelperException {
        String string3 = "createBusFromJmsServer";
        SibTr.entry((TraceComponent)tc, (String)string3, (Object)new Object[]{configService, session, jMSServer, string, string2});
        String string4 = string;
        ObjectName objectName = null;
        try {
            objectName = this.createBus(configService, session, string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)("com.ibm.ws.sib.migration.SIBMigrationHelper." + string3), (String)"118", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("CREATE_BUS_FAILED_CWSIO0001", new Object[]{string4}, null), exception);
        }
        try {
            this.addServerToBus(configService, session, string4, string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)("com.ibm.ws.sib.migration.SIBMigrationHelper." + string3), (String)"129", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("ADD_SERVER_TO_BUS_FAILED_CWSIO0002", new Object[]{string4, string, string2}, null), exception);
        }
        try {
            ObjectName objectName2 = this.createMqClientLink(configService, session, jMSServer, string4, string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)("com.ibm.ws.sib.migration.SIBMigrationHelper." + string3), (String)"141", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("CREATE_MQ_CLIENT_LINK_FAILED_CWSIO0003", new Object[]{string4, string, string2}, null), exception);
        }
        try {
            this.createQueues(configService, session, jMSServer, string4, string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)("com.ibm.ws.sib.migration.SIBMigrationHelper." + string3), (String)"156", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("CREATE_QUEUES_FAILED_CWSIO0004", new Object[]{string4, string, string2}, null), exception);
        }
        try {
            this.migrateJMSServerEndpoint(configService, session, string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)("com.ibm.ws.sib.migration.SIBMigrationHelper." + string3), (String)"168", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("MIGRATE_JMSSERVER_ENDPOINT_FAILED_CWSIO0009", new Object[0], null), exception);
        }
        SibTr.exit((TraceComponent)tc, (String)string3);
    }

    private ObjectName createBus(ConfigService configService, Session session, String string) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string2 = "createBus";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{configService, session, string});
        ObjectName objectName = this.getBus(configService, session, string);
        if (objectName == null) {
            AdminCommand adminCommand = commandMgr.createCommand("createSIBus");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("bus", (Object)string);
            adminCommand.setParameter("description", (Object)"");
            adminCommand.setParameter("secure", (Object)Boolean.FALSE);
            adminCommand.setParameter("mediationsAuthAlias", (Object)"");
            adminCommand.setParameter("protocol", (Object)"");
            adminCommand.setParameter("discardOnDelete", (Object)Boolean.FALSE);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult == null) {
                SibTr.debug((TraceComponent)tc, (String)"result == null");
                throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"createSIBus"}, null));
            }
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"createSIBus"}, null), throwable);
            }
            objectName = (ObjectName)commandResult.getResult();
        } else {
            SibTr.event((TraceComponent)tc, (String)("Attempted to create an SIBus which already exists. SIBus name is \"" + string + "\""));
        }
        SibTr.exit((TraceComponent)tc, (String)string2, (Object)objectName);
        return objectName;
    }

    private ObjectName getBus(ConfigService configService, Session session, String string) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string2 = "getBus";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{configService, session, string});
        List list = this.getBusList(session);
        Iterator iterator = list.iterator();
        ObjectName objectName = null;
        while (iterator.hasNext() && objectName == null) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string3 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string3.equals(string)) continue;
            objectName = objectName2;
        }
        SibTr.exit((TraceComponent)tc, (String)string2, objectName);
        return objectName;
    }

    private List getBusList(Session session) throws CommandException, CommandNotFoundException, ConnectorException, SIBMigrationHelperException {
        String string = "getBusList";
        SibTr.entry((TraceComponent)tc, (String)string, (Object)session);
        AdminCommand adminCommand = commandMgr.createCommand("listSIBuses");
        adminCommand.setConfigSession(session);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            SibTr.debug((TraceComponent)tc, (String)"result == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"listSIBuses"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"listSIBuses"}, null), throwable);
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        List<ObjectName> list = Arrays.asList(objectNameArray);
        SibTr.exit((TraceComponent)tc, (String)string, list);
        return list;
    }

    private void addServerToBus(ConfigService configService, Session session, String string, String string2, String string3) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string4 = "addServerToBus";
        SibTr.entry((TraceComponent)tc, (String)string4, (Object)new Object[]{configService, session, string, string2, string3});
        ObjectName objectName = this.getBusMember(configService, session, string, string2, string3);
        if (objectName == null) {
            AdminCommand adminCommand = commandMgr.createCommand("addSIBusMember");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("bus", (Object)string);
            adminCommand.setParameter("node", (Object)string2);
            adminCommand.setParameter("server", (Object)string3);
            adminCommand.setParameter("createDefaultDatasource", (Object)Boolean.TRUE);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult == null) {
                SibTr.debug((TraceComponent)tc, (String)"result == null");
                throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"addSIBusMember"}, null));
            }
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                SibTr.exception((TraceComponent)tc, (Throwable)throwable);
                throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"addSIBusMember"}, null), throwable);
            }
        } else {
            SibTr.event((TraceComponent)tc, (String)("Attempted to add a server to an SIBus. Server is already a member of the SIBus. SIBus name is \"" + string + "\". Node name is \"" + string2 + "\". Server name is \"" + string3 + "\""));
        }
        SibTr.exit((TraceComponent)tc, (String)string4);
    }

    private ObjectName getBusMember(ConfigService configService, Session session, String string, String string2, String string3) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string4 = "getBusMember";
        SibTr.entry((TraceComponent)tc, (String)string4, (Object)new Object[]{configService, session, string, string2, string3});
        List list = this.getBusMemberList(session, string);
        Iterator iterator = list.iterator();
        ObjectName objectName = null;
        while (iterator.hasNext() && objectName == null) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string5 = (String)configService.getAttribute(session, objectName2, "server");
            String string6 = (String)configService.getAttribute(session, objectName2, "node");
            if (!string5.equals(string3) || !string6.equals(string2)) continue;
            objectName = objectName2;
        }
        SibTr.exit((TraceComponent)tc, (String)string4, objectName);
        return objectName;
    }

    private List getBusMemberList(Session session, String string) throws CommandException, CommandNotFoundException, ConnectorException, SIBMigrationHelperException {
        String string2 = "getBusMemberList";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{session, string});
        AdminCommand adminCommand = commandMgr.createCommand("listSIBusMembers");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            SibTr.debug((TraceComponent)tc, (String)"result == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"listSIBusMembers"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"listSIBusMembers"}, null), throwable);
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        List<ObjectName> list = Arrays.asList(objectNameArray);
        SibTr.exit((TraceComponent)tc, (String)string2, list);
        return list;
    }

    private ObjectName createMqClientLink(ConfigService configService, Session session, JMSServer jMSServer, String string, String string2, String string3) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string4 = "createMqClientLink";
        SibTr.entry((TraceComponent)tc, (String)string4, (Object)new Object[]{configService, session, string, string2, string3});
        ObjectName objectName = this.getEngine(session, string, string2, string3);
        String string5 = "Default.MQClientLink";
        ObjectName objectName2 = this.getMQClientLink(configService, session, objectName, string5);
        if (objectName2 == null) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"channelName", (Object)"WAS.JMS.SVRCONN");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)"Default MQ Client Link");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"migratedDefinition", (Object)Boolean.TRUE);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"Default.MQClientLink");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"qmName", (Object)SIBQueueManagerName.generateQueueManagerName(jMSServer, string2, string3));
            objectName2 = configService.createConfigData(session, objectName, "mqClientLink", "SIBMQClientLink", attributeList);
        } else {
            SibTr.event((TraceComponent)tc, (String)("Attempted to create an MQ client link which already exists. MQ client link name is \"" + string5 + "\""));
        }
        SibTr.exit((TraceComponent)tc, (String)string4, (Object)objectName2);
        return objectName2;
    }

    private ObjectName getEngine(Session session, String string, String string2, String string3) throws CommandException, CommandNotFoundException, ConnectorException, SIBMigrationHelperException {
        String string4 = "getEngine";
        SibTr.entry((TraceComponent)tc, (String)string4, (Object)new Object[]{session, string, string2, string3});
        AdminCommand adminCommand = commandMgr.createCommand("listSIBEngines");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.setParameter("node", (Object)string2);
        adminCommand.setParameter("server", (Object)string3);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            SibTr.debug((TraceComponent)tc, (String)"result == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"listSIBEngines"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"listSIBEngines"}, null), throwable);
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        if (objectNameArray.length < 1) {
            SibTr.debug((TraceComponent)tc, (String)"engineArray.length < 1");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_ENGINES_FOUND_CWSIO0007", new Object[]{string, string2, string3}, null));
        }
        if (objectNameArray.length > 1) {
            SibTr.debug((TraceComponent)tc, (String)"engineArray.length > 1");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("TOO_MANY_ENGINES_FOUND_CWSIO0008", new Object[]{string, string2, string3}, null));
        }
        ObjectName objectName = objectNameArray[0];
        SibTr.exit((TraceComponent)tc, (String)string4, (Object)objectName);
        return objectName;
    }

    private ObjectName getMQClientLink(ConfigService configService, Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        String string2 = "getMQClientLink";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{configService, session, objectName, string});
        List list = this.getMQClientLinkList(configService, session, objectName);
        Iterator iterator = list.iterator();
        ObjectName objectName2 = null;
        while (iterator.hasNext() && objectName2 == null) {
            ObjectName objectName3 = (ObjectName)iterator.next();
            String string3 = (String)configService.getAttribute(session, objectName3, "name");
            if (!string3.equals(string)) continue;
            objectName2 = objectName3;
        }
        SibTr.exit((TraceComponent)tc, (String)string2, objectName2);
        return objectName2;
    }

    private List getMQClientLinkList(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        String string = "getMQClientLinkList";
        SibTr.entry((TraceComponent)tc, (String)string, (Object)new Object[]{configService, session, objectName});
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBMQClientLink");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        List<ObjectName> list = Arrays.asList(objectNameArray);
        SibTr.exit((TraceComponent)tc, (String)string, list);
        return list;
    }

    private void createQueues(ConfigService configService, Session session, JMSServer jMSServer, String string, String string2, String string3) throws CommandNotFoundException, CommandException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string4 = "createQueues";
        SibTr.entry((TraceComponent)tc, (String)string4, (Object)new Object[]{jMSServer, session, string, string2, string3});
        EList eList = this.getQueueNames(session, jMSServer);
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            ObjectName objectName = this.createQueue(configService, session, string, string2, string3, string5);
            ObjectName objectName2 = this.createQueueAlias(configService, session, string, string2, string3, string5);
        }
        SibTr.exit((TraceComponent)tc, (String)string4);
    }

    private EList getQueueNames(Session session, JMSServer jMSServer) {
        String string = "getQueueNames";
        SibTr.entry((TraceComponent)tc, (String)string, (Object)new Object[]{session, jMSServer});
        EList eList = jMSServer.getQueueNames();
        SibTr.exit((TraceComponent)tc, (String)string, (Object)eList);
        return eList;
    }

    private ObjectName createQueue(ConfigService configService, Session session, String string, String string2, String string3, String string4) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        ObjectName objectName = this.getQueue(configService, session, string, string4);
        if (objectName == null) {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("createSIBDestination");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("bus", (Object)string);
            adminCommand.setParameter("name", (Object)string4);
            adminCommand.setParameter("type", (Object)"Queue");
            adminCommand.setParameter("node", (Object)string2);
            adminCommand.setParameter("server", (Object)string3);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult == null) {
                SibTr.debug((TraceComponent)tc, (String)"result == null");
                throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"createSIBDestination"}, null));
            }
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                SibTr.exception((TraceComponent)tc, (Throwable)throwable);
                throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"createSIBDestination"}, null), throwable);
            }
            objectName = (ObjectName)commandResult.getResult();
        } else {
            SibTr.event((TraceComponent)tc, (String)("Attempted to create a queue which has already exists. Queue name is \"" + string4 + "\""));
        }
        return objectName;
    }

    private ObjectName getQueue(ConfigService configService, Session session, String string, String string2) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string3 = "getQueue";
        SibTr.entry((TraceComponent)tc, (String)string3, (Object)new Object[]{configService, session, string, string2, string});
        List list = this.getQueueList(session, string);
        Iterator iterator = list.iterator();
        ObjectName objectName = null;
        while (iterator.hasNext() && objectName == null) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "identifier");
            if (!string2.equals(string4)) continue;
            objectName = objectName2;
        }
        SibTr.exit((TraceComponent)tc, (String)string3, objectName);
        return objectName;
    }

    private List getQueueList(Session session, String string) throws CommandException, CommandNotFoundException, ConnectorException, SIBMigrationHelperException {
        String string2 = "getQueueList";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{session, string});
        AdminCommand adminCommand = commandMgr.createCommand("listSIBDestinations");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.setParameter("type", (Object)"Queue");
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            SibTr.debug((TraceComponent)tc, (String)"result == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"listSIBDestinations"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"listSIBDestinations"}, null), throwable);
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        List<ObjectName> list = Arrays.asList(objectNameArray);
        SibTr.exit((TraceComponent)tc, (String)string2, list);
        return list;
    }

    private ObjectName createQueueAlias(ConfigService configService, Session session, String string, String string2, String string3, String string4) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string5 = ALIAS_NAME_PREFIX + string4;
        ObjectName objectName = this.getAlias(configService, session, string, string5);
        if (objectName == null) {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("createSIBDestination");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("bus", (Object)string);
            adminCommand.setParameter("name", (Object)string5);
            adminCommand.setParameter("type", (Object)"Alias");
            adminCommand.setParameter("node", (Object)string2);
            adminCommand.setParameter("server", (Object)string3);
            adminCommand.setParameter("aliasBus", (Object)string);
            adminCommand.setParameter("targetBus", (Object)string);
            adminCommand.setParameter("targetName", (Object)string4);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult == null) {
                SibTr.debug((TraceComponent)tc, (String)"result == null");
                throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"createSIBDestination"}, null));
            }
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                SibTr.exception((TraceComponent)tc, (Throwable)throwable);
                throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"createSIBDestination"}, null), throwable);
            }
            objectName = (ObjectName)commandResult.getResult();
        } else {
            SibTr.event((TraceComponent)tc, (String)("Attempted to create an alias which has already exists. Alias name is \"" + string5 + "\""));
        }
        return objectName;
    }

    private ObjectName getAlias(ConfigService configService, Session session, String string, String string2) throws CommandException, CommandNotFoundException, ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        String string3 = "getAlias";
        SibTr.entry((TraceComponent)tc, (String)string3, (Object)new Object[]{configService, session, string, string2, string});
        List list = this.getAliasList(session, string);
        Iterator iterator = list.iterator();
        ObjectName objectName = null;
        while (iterator.hasNext() && objectName == null) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "identifier");
            if (!string2.equals(string4)) continue;
            objectName = objectName2;
        }
        SibTr.exit((TraceComponent)tc, (String)string3, objectName);
        return objectName;
    }

    private List getAliasList(Session session, String string) throws CommandException, CommandNotFoundException, ConnectorException, SIBMigrationHelperException {
        String string2 = "getAliasList";
        SibTr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{session, string});
        AdminCommand adminCommand = commandMgr.createCommand("listSIBDestinations");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.setParameter("type", (Object)"Alias");
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            SibTr.debug((TraceComponent)tc, (String)"result == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("NO_RESULT_AVAILABLE_CWSIO0005", new Object[]{"listSIBDestinations"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            throw new SIBMigrationHelperException(nls.getFormattedMessage("COMMAND_FAILED_CWSIO0006", new Object[]{"listSIBDestinations"}, null), throwable);
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        List<ObjectName> list = Arrays.asList(objectNameArray);
        SibTr.exit((TraceComponent)tc, (String)string2, list);
        return list;
    }

    private void migrateJMSServerEndpoint(ConfigService configService, Session session, String string, String string2) throws ConfigServiceException, ConnectorException, SIBMigrationHelperException {
        Comparable<ObjectName> comparable;
        ObjectName[] objectNameArray;
        ObjectName objectName;
        String string3 = "migrateJMSServerEndpoint";
        SibTr.entry((TraceComponent)tc, (String)string3, (Object)new Object[]{configService, session, string, string2});
        ObjectName objectName2 = configService.resolve(session, "Node=" + string)[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"ServerEntry");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName2, objectName3, null);
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray2.length; ++i) {
            objectName = objectNameArray2[i];
            objectNameArray = (ObjectName[])configService.getAttribute(session, objectName, "serverName");
            if (!objectNameArray.equals(string2)) continue;
            objectName4 = objectName;
            break;
        }
        if (objectName4 == null) {
            SibTr.debug((TraceComponent)tc, (String)"serverEntry == null");
            throw new SIBMigrationHelperException(nls.getFormattedMessage("SERVER_ENTRY_NOT_FOUND_CWSIO0010", new Object[]{string, string2}, null));
        }
        ObjectName objectName5 = null;
        objectName = null;
        objectName3 = ConfigServiceHelper.createObjectName(null, (String)"NamedEndPoint");
        objectNameArray = configService.queryConfigObjects(session, objectName4, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            comparable = objectNameArray[i];
            String string4 = (String)configService.getAttribute(session, comparable, "endPointName");
            if (string4.equals("SIB_MQ_ENDPOINT_ADDRESS")) {
                objectName5 = configService.queryConfigObjects(session, comparable, ConfigServiceHelper.createObjectName(null, (String)"EndPoint"), null)[0];
                continue;
            }
            if (!string4.equals("JMSSERVER_QUEUED_ADDRESS")) continue;
            objectName = configService.queryConfigObjects(session, comparable, ConfigServiceHelper.createObjectName(null, (String)"EndPoint"), null)[0];
        }
        if (objectName5 != null && objectName != null) {
            AttributeList attributeList = new AttributeList();
            comparable = (Integer)configService.getAttribute(session, objectName5, "port");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"port", (Object)comparable);
            configService.setAttributes(session, objectName, attributeList);
        }
        SibTr.exit((TraceComponent)tc, (String)string3);
    }
}

