/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.SIMessage;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.mediation.session.SIDestinationConfiguration;
import com.ibm.websphere.sib.mediation.session.SIDestinationNotFoundException;
import com.ibm.websphere.sib.mediation.session.SIMediationRoutingException;
import com.ibm.websphere.sib.mediation.session.SIMediationSessionException;
import com.ibm.websphere.sib.mediation.session.SINotAuthorizedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mediation.common.ConnectionPropertiesProvider;
import com.ibm.ws.sib.mediation.runtime.TraceMessage;
import com.ibm.ws.sib.mediation.session.SIDestinationConfigurationImpl;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.security.auth.SIBAccessControl;
import com.ibm.ws.sib.security.auth.SIBAccessControlException;
import com.ibm.ws.sib.security.auth.SibLogin;
import com.ibm.ws.sib.security.auth.SibLoginFactory;
import com.ibm.ws.sib.security.context.SecurityContextException;
import com.ibm.ws.sib.security.context.SecurityContextFactory;
import com.ibm.ws.sib.security.context.SecurityContextHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SISystemMessage;
import com.ibm.wsspi.sib.core.SISystemMessageFactory;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.mediation.session.SIMediationSessionInitializer;
import com.ibm.wsspi.sib.ra.SibRaAutoCommitTransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.security.auth.Subject;

public final class SIMediationSessionImpl
implements SIMediationSessionInitializer {
    private static final String _sourceInfo = "Source info: @(#) 1.46.1.2 SIB/ws/code/sib.mediation.session/src/com/ibm/ws/sib/mediation/session/SIMediationSessionImpl.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 05/10/20 07:11:09 [3/13/06 13:40:24]";
    private String _busName;
    private String _messagingEngineName;
    private String _mediationName;
    private String _destinationName;
    private String _discriminator;
    private String _messageSelector;
    private SICoreConnection _connection;
    private ConnectionPropertiesProvider _connectionPropertiesProvider;
    private SIDestinationAddress _address;
    private SICoreConnectionFactory _connectionFactory;
    private SelectionCriteriaFactory _selectionCriteriaFactory;
    private static final TraceComponent _tc = SibTr.register((Class)SIMediationSessionImpl.class, (String)"SIBMediations.Session", (String)"com.ibm.ws.sib.mediation.session.CWSIMMessages");
    private static TraceNLS _nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mediation.session.CWSIMMessages");
    private static final SecurityContextHelper _helper;
    private static final AuthUtils _authUtils;
    private static final Subject _serverSubject;
    private SIBAccessControl _accessControl;
    private static final SibLogin _login;
    private boolean _valid = true;
    private Thread _creationThread = Thread.currentThread();

    public void setBusName(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setBusName", (Object)new Object[]{this, string});
        }
        this._busName = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setBusName");
        }
    }

    public void setMessagingEngineName(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMessagingEngineName", (Object)new Object[]{this, string});
        }
        this._messagingEngineName = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMessagingEngineName");
        }
    }

    public void setMediationName(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMediationName", (Object)new Object[]{this, string});
        }
        this._mediationName = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMediationName");
        }
    }

    public void setDestinationName(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setDestinationName", (Object)new Object[]{this, string});
        }
        this._destinationName = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setDestinationName");
        }
    }

    public void setDiscriminator(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setDiscriminator", (Object)new Object[]{this, string});
        }
        this._discriminator = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setDiscriminator");
        }
    }

    public void setMessageSelector(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMessageSelector", (Object)new Object[]{this, string});
        }
        this._messageSelector = string;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMessageSelector");
        }
    }

    public void setSICoreConnection(SICoreConnection sICoreConnection) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSICoreConnection", (Object)new Object[]{this, sICoreConnection});
        }
        this._connection = sICoreConnection;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSICoreConnection");
        }
    }

    public void setConnectionPropertiesProvider(ConnectionPropertiesProvider connectionPropertiesProvider) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setConnectionPropertiesProvider", (Object)new Object[]{this, connectionPropertiesProvider});
        }
        this._connectionPropertiesProvider = connectionPropertiesProvider;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setConnectionPropertiesProvider");
        }
    }

    public void setSIDestinationAddress(SIDestinationAddress sIDestinationAddress) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSIDestinationAddress", (Object)new Object[]{this, sIDestinationAddress});
        }
        this._address = sIDestinationAddress;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSIDestinationAddress");
        }
    }

    public void setSICoreConnectionFactory(SICoreConnectionFactory sICoreConnectionFactory) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSICoreConnectionFactory", (Object)new Object[]{this, sICoreConnectionFactory});
        }
        this._connectionFactory = sICoreConnectionFactory;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSICoreConnectionFactory");
        }
    }

    public void setSelectionCriteriaFactory(SelectionCriteriaFactory selectionCriteriaFactory) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSelectionCriteriaFactory", (Object)new Object[]{this, selectionCriteriaFactory});
        }
        this._selectionCriteriaFactory = selectionCriteriaFactory;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSelectionCriteriaFactory");
        }
    }

    public String getBusName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getBusName", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getBusName", (Object)this._busName);
        }
        return this._busName;
    }

    public String getMessagingEngineName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMessagingEngineName", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMessagingEngineName", (Object)this._messagingEngineName);
        }
        return this._messagingEngineName;
    }

    public String getMediationName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMediationName", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMediationName", (Object)this._mediationName);
        }
        return this._mediationName;
    }

    public String getDestinationName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationName", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationName", (Object)this._destinationName);
        }
        return this._destinationName;
    }

    public String getDiscriminator() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDiscriminator", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDiscriminator", (Object)this._discriminator);
        }
        return this._discriminator;
    }

    public String getMessageSelector() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMessageSelector", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMessageSelector", (Object)this._messageSelector);
        }
        return this._messageSelector;
    }

    public SIDestinationConfiguration getSIDestinationConfiguration(String string) throws SIDestinationNotFoundException, SINotAuthorizedException, SIMediationSessionException, NullPointerException {
        SIDestinationConfiguration sIDestinationConfiguration;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)new Object[]{this, string});
        }
        try {
            SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, this._busName);
            sIDestinationConfiguration = this.getSIDestinationConfiguration(sIDestinationAddress);
        }
        catch (SIMediationSessionException sIMediationSessionException) {
            this.traceRethrowingException((Exception)((Object)sIMediationSessionException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"494", (Object)this);
            this.traceRethrowingException(nullPointerException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"500", (Object)this);
            this.traceRethrowingException(illegalStateException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"504", (Object)this);
            String string2 = _nls.getFormattedMessage("SIDESTINATION_ADDRESS_FACTORY_ERROR_CWSIM0012E", new Object[]{exception}, null);
            SIMediationSessionException sIMediationSessionException = new SIMediationSessionException(string2, exception);
            this.traceConvertingException(exception, (Exception)((Object)sIMediationSessionException), "Could not obtain the SIDestinationAddressFactory");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)sIDestinationConfiguration);
        }
        return sIDestinationConfiguration;
    }

    public SIDestinationConfiguration getSIDestinationConfiguration(SIDestinationAddress sIDestinationAddress) throws SIDestinationNotFoundException, SINotAuthorizedException, SIMediationSessionException {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)new Object[]{this, sIDestinationAddress});
        }
        try {
            this.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"500", (Object)this);
            this.traceRethrowingException(illegalStateException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        String string = sIDestinationAddress.getDestinationName();
        Subject subject = null;
        subject = this.login(string);
        try {
            bl = this._accessControl.checkDestinationAccess(subject, this._busName, sIDestinationAddress.getDestinationName(), OperationType.INQUIRE);
        }
        catch (SIBAccessControlException sIBAccessControlException) {
            FFDCFilter.processException((Throwable)sIBAccessControlException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"647", (Object)this);
            String string2 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), string, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string2, sIBAccessControlException);
            this.traceConvertingException(sIBAccessControlException, (Exception)((Object)sINotAuthorizedException), "Unable to check that " + subject + " has access to the bus");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        if (!bl) {
            String string3 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), string, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string3);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        SIDestinationConfigurationImpl sIDestinationConfigurationImpl = new SIDestinationConfigurationImpl();
        try {
            DestinationConfiguration destinationConfiguration = this._connection.getDestinationConfiguration(sIDestinationAddress);
            sIDestinationConfigurationImpl.setDestinationConfiguration(destinationConfiguration);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"647", (Object)this);
            String string4 = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, nullPointerException}, null);
            SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string4, nullPointerException);
            this.traceConvertingException(nullPointerException, (Exception)((Object)sIMediationRoutingException), "the connection provided to the SIMediationSession was null");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        catch (com.ibm.wsspi.sib.core.exception.SINotAuthorizedException sINotAuthorizedException) {
            String string5;
            FFDCFilter.processException((Throwable)sINotAuthorizedException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"669", (Object)this);
            try {
                string5 = this._connection.getResolvedUserid();
            }
            catch (SIException sIException) {
                string5 = "<unknown>";
            }
            catch (SIErrorException sIErrorException) {
                string5 = "<unknown>";
            }
            String string6 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{string5, string, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException2 = new SINotAuthorizedException(string6, sINotAuthorizedException);
            this.traceConvertingException((Exception)((Object)sINotAuthorizedException), (Exception)((Object)sINotAuthorizedException2), "not authorized to query " + sIDestinationAddress);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sINotAuthorizedException2));
            }
            throw sINotAuthorizedException2;
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            FFDCFilter.processException((Throwable)sINotPossibleInCurrentConfigurationException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"713", (Object)this);
            String string7 = _nls.getFormattedMessage("NO_SUCH_DESTINATION_CONFIG_CWSIM0010E", new Object[]{this._mediationName, string, this._busName}, null);
            SIDestinationNotFoundException sIDestinationNotFoundException = new SIDestinationNotFoundException(string7, sINotPossibleInCurrentConfigurationException);
            this.traceConvertingException((Exception)((Object)sINotPossibleInCurrentConfigurationException), (Exception)((Object)sIDestinationNotFoundException), "destination " + sIDestinationAddress + "does not exist");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIDestinationNotFoundException));
            }
            throw sIDestinationNotFoundException;
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"736", (Object)this);
            String string8 = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, sIConnectionLostException}, null);
            SIMediationSessionException sIMediationSessionException = new SIMediationSessionException(string8, sIConnectionLostException);
            this.traceConvertingException((Exception)((Object)sIConnectionLostException), (Exception)((Object)sIMediationSessionException), "a comms error occurred");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"756", (Object)this);
            String string9 = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, sIException}, null);
            SIMediationSessionException sIMediationSessionException = new SIMediationSessionException(string9, sIException);
            this.traceConvertingException((Exception)((Object)sIException), (Exception)((Object)sIMediationSessionException), "some unexpected error occurred");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.getSIDestinationConfiguration", (String)"776", (Object)this);
            String string10 = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, sIErrorException}, null);
            SIMediationSessionException sIMediationSessionException = new SIMediationSessionException(string10, sIErrorException);
            this.traceConvertingException((Exception)((Object)sIErrorException), (Exception)((Object)sIMediationSessionException), "some unexpected error occurred");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationConfiguration", (Object)sIDestinationConfigurationImpl);
        }
        return sIDestinationConfigurationImpl;
    }

    /*
     * Loose catch block
     */
    public void send(SIMessage sIMessage, boolean bl) throws SIMediationRoutingException, SIDestinationNotFoundException, SINotAuthorizedException {
        block42: {
            SIDestinationAddress sIDestinationAddress;
            Subject subject;
            SICoreConnection sICoreConnection;
            block40: {
                SIBusMessage sIBusMessage;
                SIMessage sIMessage2;
                if (_tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)_tc, (String)"send", (Object)new Object[]{this, sIMessage, bl ? Boolean.TRUE : Boolean.FALSE});
                }
                try {
                    this.checkValid();
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"845", (Object)this);
                    this.traceRethrowingException(illegalStateException);
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)illegalStateException);
                    }
                    throw illegalStateException;
                }
                SibRaAutoCommitTransaction sibRaAutoCommitTransaction = null;
                sICoreConnection = null;
                subject = null;
                boolean bl2 = _authUtils.isBusSecure(this._busName);
                if (bl) {
                    sibRaAutoCommitTransaction = SibRaAutoCommitTransaction.AUTO_COMMIT_TRANSACTION;
                }
                try {
                    sIMessage2 = (SIMessage)sIMessage.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"938", (Object)this);
                    String string = _nls.getFormattedMessage("UNABLE_TO_CLONE_SIMEOO05E", new Object[]{sIMessage.getSystemMessageId(), this._mediationName}, null);
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string, cloneNotSupportedException);
                    this.traceConvertingException(cloneNotSupportedException, (Exception)((Object)sIMediationRoutingException), "Unable to clone the message prior to sending");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
                if (!(sIMessage2 instanceof SISystemMessage)) {
                    String string = _nls.getFormattedMessage("INVALID_SIMESSAGE_IMPLEMENTATION_CWSIM0009E", new Object[]{sIMessage2.getSystemMessageId(), this._mediationName, this._messagingEngineName, this._busName}, null);
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string);
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
                List list = sIMessage2.getForwardRoutingPath();
                sIDestinationAddress = null;
                if (list.size() != 0) {
                    sIDestinationAddress = (SIDestinationAddress)list.remove(0);
                    sIMessage2.setForwardRoutingPath(list);
                } else {
                    sIDestinationAddress = this._address;
                }
                if (bl2) {
                    try {
                        subject = this.login(sIDestinationAddress.getDestinationName());
                    }
                    catch (SINotAuthorizedException sINotAuthorizedException) {
                        this.traceRethrowingException((Exception)((Object)sINotAuthorizedException));
                        if (_tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sINotAuthorizedException));
                        }
                        throw sINotAuthorizedException;
                    }
                }
                if (!((sIBusMessage = ((SISystemMessage)sIMessage2).toSIBusMessage()) instanceof JsMessage)) {
                    String string = _nls.getFormattedMessage("INVALID_SIMESSAGE_IMPLEMENTATION_CWSIM0009E", new Object[]{sIMessage2.getSystemMessageId(), this._mediationName, this._messagingEngineName, this._busName}, null);
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string);
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
                ((JsMessage)sIBusMessage).setTimestamp(System.currentTimeMillis());
                sICoreConnection = this._connectionFactory.createConnection(_serverSubject, this._connectionPropertiesProvider.getConnectionProperties());
                this.resetIdentity(subject, sIBusMessage);
                SIBPmiRm.getInstance().attachCurrentContextCorrelators(sIBusMessage, true);
                ((JsMessage)sIBusMessage).setSystemMessageSourceUuid(null);
                if (TraceMessage.isEnabled()) {
                    TraceMessage.traceMessageSentByMediation(sIMessage2, this._mediationName, sIDestinationAddress.getDestinationName());
                }
                String string = this._accessControl.getSecurityIDFromMessage((JsMessage)sIBusMessage);
                sICoreConnection.send(sIBusMessage, (SITransaction)sibRaAutoCommitTransaction, sIDestinationAddress, null, null, string);
                Object var15_31 = null;
                if (sICoreConnection == null) break block40;
                try {
                    sICoreConnection.close();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1227", (Object)this);
                    this.traceAbsorbingException((Exception)((Object)sIException), "When closing the connection an error occurred.");
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1236", (Object)this);
                    this.traceAbsorbingException((Exception)((Object)sIErrorException), "When closing the connection an error occurred.");
                }
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send");
            }
            break block42;
            {
                catch (NullPointerException nullPointerException) {
                    FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1123", (Object)this);
                    String string = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, nullPointerException}, null);
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string, nullPointerException);
                    this.traceConvertingException(nullPointerException, (Exception)((Object)sIMediationRoutingException), "the connection provided to the SIMediationSession was null");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
                catch (com.ibm.wsspi.sib.core.exception.SINotAuthorizedException sINotAuthorizedException) {
                    FFDCFilter.processException((Throwable)sINotAuthorizedException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1144", (Object)this);
                    String string = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), sIDestinationAddress.getDestinationName(), this._busName, this._messagingEngineName, this._mediationName}, null);
                    SINotAuthorizedException sINotAuthorizedException2 = new SINotAuthorizedException(string, sINotAuthorizedException);
                    this.traceConvertingException((Exception)((Object)sINotAuthorizedException), (Exception)((Object)sINotAuthorizedException2), "user is not authorised to access the destination");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sINotAuthorizedException2));
                    }
                    throw sINotAuthorizedException2;
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    FFDCFilter.processException((Throwable)sINotPossibleInCurrentConfigurationException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1164", (Object)this);
                    String string = _nls.getFormattedMessage("NO_SUCH_DESTINATION_SEND_CWSIM0003E", new Object[]{this._mediationName, sIDestinationAddress.getDestinationName(), this._busName}, null);
                    SIDestinationNotFoundException sIDestinationNotFoundException = new SIDestinationNotFoundException(string, sINotPossibleInCurrentConfigurationException);
                    this.traceConvertingException((Exception)((Object)sINotPossibleInCurrentConfigurationException), (Exception)((Object)sIDestinationNotFoundException), "The specified destination does not exist");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIDestinationNotFoundException));
                    }
                    throw sIDestinationNotFoundException;
                }
                catch (SIMediationSessionException sIMediationSessionException) {
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(sIMediationSessionException.getMessage(), sIMediationSessionException.getCause());
                    this.traceConvertingException((Exception)((Object)sIMediationSessionException), (Exception)((Object)sIMediationRoutingException), "mapping SIMediationSessionException to SIMediationRoutingException");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1199", (Object)this);
                    String string = _nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, exception}, null);
                    SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string, exception);
                    this.traceConvertingException(exception, (Exception)((Object)sIMediationRoutingException), "error occurred while sending the message");
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send", (Object)((Object)sIMediationRoutingException));
                    }
                    throw sIMediationRoutingException;
                }
            }
            catch (Throwable throwable) {
                Object var15_32 = null;
                if (sICoreConnection != null) {
                    try {
                        sICoreConnection.close();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1227", (Object)this);
                        this.traceAbsorbingException((Exception)((Object)sIException), "When closing the connection an error occurred.");
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.send", (String)"1236", (Object)this);
                        this.traceAbsorbingException((Exception)((Object)sIErrorException), "When closing the connection an error occurred.");
                    }
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"send");
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public SIMessage receive(SIDestinationAddress var1_1, long var2_2, String var4_3, String var5_4, boolean var6_5) throws SIMediationRoutingException, SIDestinationNotFoundException, SINotAuthorizedException {
        block39: {
            if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)new Object[]{this, var1_1, new Long(var2_2), var4_3, var5_4, var6_5 != false ? Boolean.TRUE : Boolean.FALSE});
            }
            try {
                this.checkValid();
            }
            catch (IllegalStateException var7_6) {
                FFDCFilter.processException((Throwable)var7_6, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1202", (Object)this);
                this.traceRethrowingException(var7_6);
                if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var7_6);
                }
                throw var7_6;
            }
            var8_8 = null;
            var9_9 = null;
            var10_10 = null;
            var11_11 = SIMediationSessionImpl._authUtils.isBusSecure(this._busName);
            if (var6_5) {
                var10_10 = SibRaAutoCommitTransaction.AUTO_COMMIT_TRANSACTION;
            }
            if (var11_11) {
                try {
                    var9_9 = this.login(var1_1.getDestinationName());
                }
                catch (SINotAuthorizedException var12_12) {
                    this.traceRethrowingException((Exception)var12_12);
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var12_12);
                    }
                    throw var12_12;
                }
            }
            try {
                block38: {
                    var8_8 = this._connectionFactory.createConnection(SIMediationSessionImpl._serverSubject, this._connectionPropertiesProvider.getConnectionProperties());
                    var12_13 = this._selectionCriteriaFactory.createSelectionCriteria(var4_3, var5_4, SelectorDomain.SIMESSAGE);
                    var13_19 = this.getUserId(var9_9);
                    if (var2_2 == 0L) {
                        var7_7 = var8_8.receiveNoWait((SITransaction)var10_10, null, var1_1, null, var12_13, null, var13_19);
                        break block38;
                    }
                    var7_7 = var8_8.receiveWithWait((SITransaction)var10_10, null, var1_1, null, var12_13, null, var2_2, var13_19);
                }
                var16_27 = null;
                ** if (var8_8 == null) goto lbl-1000
            }
            catch (Throwable var15_40) {
                var16_28 = null;
                if (var8_8 != null) {
                    try {
                        var8_8.close();
                    }
                    catch (SIException var17_31) {
                        FFDCFilter.processException((Throwable)var17_31, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1534", (Object)this);
                        this.traceAbsorbingException((Exception)var17_31, "Error occurred while closing the connection");
                    }
                    catch (SIErrorException var17_32) {
                        FFDCFilter.processException((Throwable)var17_32, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1546", (Object)this);
                        this.traceAbsorbingException((Exception)var17_32, "Error occurred while closing the connection");
                    }
                }
                throw var15_40;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var8_8.close();
                }
                catch (SIException var17_29) {
                    FFDCFilter.processException((Throwable)var17_29, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1534", (Object)this);
                    this.traceAbsorbingException((Exception)var17_29, "Error occurred while closing the connection");
                }
                catch (SIErrorException var17_30) {
                    FFDCFilter.processException((Throwable)var17_30, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1546", (Object)this);
                    this.traceAbsorbingException((Exception)var17_30, "Error occurred while closing the connection");
                }
            }
lbl-1000:
            // 2 sources

            {
                break block39;
                catch (NullPointerException var12_14) {
                    FFDCFilter.processException((Throwable)var12_14, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1422", (Object)this);
                    var13_20 = SIMediationSessionImpl._nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, var12_14}, null);
                    var14_33 = new SIMediationRoutingException(var13_20, var12_14);
                    this.traceConvertingException(var12_14, (Exception)var14_33, "the connection provided to the SIMediationSession was null");
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var14_33);
                    }
                    throw var14_33;
                }
                catch (com.ibm.wsspi.sib.core.exception.SINotAuthorizedException var12_15) {
                    FFDCFilter.processException((Throwable)var12_15, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1443", (Object)this);
                    var13_21 = SIMediationSessionImpl._nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(var9_9), var1_1.getDestinationName(), this._busName, this._messagingEngineName, this._mediationName}, null);
                    var14_34 = new SINotAuthorizedException(var13_21, var12_15);
                    this.traceConvertingException((Exception)var12_15, (Exception)var14_34, "user is not authorised to access the destination");
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var14_34);
                    }
                    throw var14_34;
                }
                catch (SINotPossibleInCurrentConfigurationException var12_16) {
                    FFDCFilter.processException((Throwable)var12_16, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1462", (Object)this);
                    var13_22 = SIMediationSessionImpl._nls.getFormattedMessage("NO_SUCH_DESTINATION_RECEIVE_CWSIM0011E", new Object[]{this._mediationName, var1_1, this._busName}, null);
                    var14_35 = new SIDestinationNotFoundException(var13_22, var12_16);
                    this.traceConvertingException((Exception)var12_16, (Exception)var14_35, "The specified destination does not exist");
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var14_35);
                    }
                    throw var14_35;
                }
                catch (SIException var12_17) {
                    FFDCFilter.processException((Throwable)var12_17, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1483", (Object)this);
                    var13_23 = SIMediationSessionImpl._nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, var12_17}, null);
                    var14_36 = new SIMediationRoutingException(var13_23, var12_17);
                    this.traceConvertingException((Exception)var12_17, (Exception)var14_36, "error occurred while sending the message");
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var14_36);
                    }
                    throw var14_36;
                }
                catch (SIErrorException var12_18) {
                    FFDCFilter.processException((Throwable)var12_18, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1504", (Object)this);
                    var13_24 = SIMediationSessionImpl._nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, var12_18}, null);
                    var14_37 = new SIMediationRoutingException(var13_24, var12_18);
                    this.traceConvertingException((Exception)var12_18, (Exception)var14_37, "error occurred while sending the message");
                    if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var14_37);
                    }
                    throw var14_37;
                }
            }
        }
        if (var7_7 == null) {
            var12_13 = null;
        } else {
            try {
                var12_13 = ((SISystemMessageFactory)SISystemMessageFactory.getInstance()).createSISystemMessage(var7_7);
            }
            catch (SIErrorException var13_25) {
                FFDCFilter.processException((Throwable)var13_25, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1577", (Object)this);
                var14_38 = SIMediationSessionImpl._nls.getFormattedMessage("MESSAGE_FORMAT_EXCEPTION_CWSIM0004E", new Object[]{var7_7.getSystemMessageId(), var1_1, this._mediationName, this._messagingEngineName, this._busName}, null);
                var15_41 = new SIMediationRoutingException(var14_38, var13_25);
                this.traceConvertingException((Exception)var13_25, (Exception)var15_41, "There was an error when converting from SIBusMessage to SIMessage");
                if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var15_41);
                }
                throw var15_41;
            }
            catch (Exception var13_26) {
                FFDCFilter.processException((Throwable)var13_26, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1598", (Object)this);
                var14_39 = SIMediationSessionImpl._nls.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIM0001E", new Object[]{this._mediationName, this._messagingEngineName, this._busName, var13_26}, null);
                var15_42 = new SIMediationRoutingException(var14_39, var13_26);
                this.traceConvertingException(var13_26, (Exception)var15_42, "Unable to locate message factory");
                if (SIMediationSessionImpl._tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var15_42);
                }
                throw var15_42;
            }
        }
        if (SIMediationSessionImpl._tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)SIMediationSessionImpl._tc, (String)"receive", (Object)var12_13);
        }
        return var12_13;
    }

    private Subject login(String string) throws SINotAuthorizedException {
        boolean bl;
        Subject subject;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"login", (Object)new Object[]{this, string});
        }
        try {
            subject = _helper.peekRunAs();
        }
        catch (SecurityContextException securityContextException) {
            FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.login", (String)"1556", (Object)this);
            String string2 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{"<unknown>", string, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string2, securityContextException);
            this.traceConvertingException(securityContextException, (Exception)((Object)sINotAuthorizedException), "Unable to obtain the run as subject");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        subject = _login.login(this._busName, subject);
        if (subject == null) {
            String string3 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), string, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string3);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        try {
            bl = this._accessControl.checkBusAccess(subject);
        }
        catch (SIBAccessControlException sIBAccessControlException) {
            FFDCFilter.processException((Throwable)sIBAccessControlException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.login", (String)"1580", (Object)this);
            String string4 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), this._destinationName, this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string4, sIBAccessControlException);
            this.traceConvertingException(sIBAccessControlException, (Exception)((Object)sINotAuthorizedException), "Unable to check that " + subject + " has access to the destination bus " + this._busName);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        if (!bl) {
            String string5 = _nls.getFormattedMessage("NOT_AUTHORIZED_CWSIM0002E", new Object[]{this.getUserId(subject), this.getDestinationName(), this._busName, this._messagingEngineName, this._mediationName}, null);
            SINotAuthorizedException sINotAuthorizedException = new SINotAuthorizedException(string5);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"user is not authorised to access destination {0}", (Object)new Object[]{this.getDestinationName()});
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"throwing", (Object)((Object)sINotAuthorizedException));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)subject);
        }
        return subject;
    }

    public SIMessage receive(String string) throws SIMediationRoutingException, SIDestinationNotFoundException, SINotAuthorizedException {
        SIMessage sIMessage;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"receive", (Object)new Object[]{this, string});
        }
        try {
            SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, this._busName);
            sIMessage = this.receive(sIDestinationAddress);
        }
        catch (SIMediationRoutingException sIMediationRoutingException) {
            this.traceRethrowingException((Exception)((Object)sIMediationRoutingException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        catch (SIDestinationNotFoundException sIDestinationNotFoundException) {
            this.traceRethrowingException((Exception)((Object)sIDestinationNotFoundException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIDestinationNotFoundException));
            }
            throw sIDestinationNotFoundException;
        }
        catch (SINotAuthorizedException sINotAuthorizedException) {
            this.traceRethrowingException((Exception)((Object)sINotAuthorizedException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1591", (Object)this);
            this.traceRethrowingException(nullPointerException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1601", (Object)this);
            this.traceRethrowingException(illegalStateException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1611", (Object)this);
            String string2 = _nls.getFormattedMessage("SIDESTINATION_ADDRESS_FACTORY_ERROR_CWSIM0012E", new Object[]{exception}, null);
            SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string2, exception);
            this.traceConvertingException(exception, (Exception)((Object)sIMediationRoutingException), "Could not obtain the SIDestinationAddressFactory");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)sIMessage);
        }
        return sIMessage;
    }

    public SIMessage receive(String string, long l, String string2, String string3, boolean bl) throws SIMediationRoutingException, SIDestinationNotFoundException, SINotAuthorizedException {
        SIMessage sIMessage;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"receive", (Object)new Object[]{this, string, new Long(l), string2, string3, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        try {
            SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, this._busName);
            sIMessage = this.receive(sIDestinationAddress, l, string2, string3, bl);
        }
        catch (SIMediationRoutingException sIMediationRoutingException) {
            this.traceRethrowingException((Exception)((Object)sIMediationRoutingException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        catch (SIDestinationNotFoundException sIDestinationNotFoundException) {
            this.traceRethrowingException((Exception)((Object)sIDestinationNotFoundException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIDestinationNotFoundException));
            }
            throw sIDestinationNotFoundException;
        }
        catch (SINotAuthorizedException sINotAuthorizedException) {
            this.traceRethrowingException((Exception)((Object)sINotAuthorizedException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1713", (Object)this);
            this.traceRethrowingException(nullPointerException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1723", (Object)this);
            this.traceRethrowingException(illegalStateException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1733", (Object)this);
            String string4 = _nls.getFormattedMessage("SIDESTINATION_ADDRESS_FACTORY_ERROR_CWSIM0012E", new Object[]{exception}, null);
            SIMediationRoutingException sIMediationRoutingException = new SIMediationRoutingException(string4, exception);
            this.traceConvertingException(exception, (Exception)((Object)sIMediationRoutingException), "Could not obtain the SIDestinationAddressFactory");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)sIMessage);
        }
        return sIMessage;
    }

    public SIMessage receive(SIDestinationAddress sIDestinationAddress) throws SIMediationRoutingException, SIDestinationNotFoundException, SINotAuthorizedException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"receive", (Object)new Object[]{this, sIDestinationAddress});
        }
        try {
            SIMessage sIMessage = this.receive(sIDestinationAddress, 0L, null, null, false);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)sIMessage);
            }
            return sIMessage;
        }
        catch (SIMediationRoutingException sIMediationRoutingException) {
            this.traceRethrowingException((Exception)((Object)sIMediationRoutingException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIMediationRoutingException));
            }
            throw sIMediationRoutingException;
        }
        catch (SIDestinationNotFoundException sIDestinationNotFoundException) {
            this.traceRethrowingException((Exception)((Object)sIDestinationNotFoundException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sIDestinationNotFoundException));
            }
            throw sIDestinationNotFoundException;
        }
        catch (SINotAuthorizedException sINotAuthorizedException) {
            this.traceRethrowingException((Exception)((Object)sINotAuthorizedException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)((Object)sINotAuthorizedException));
            }
            throw sINotAuthorizedException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.receive", (String)"1901", (Object)this);
            this.traceRethrowingException(runtimeException);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"receive", (Object)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void resetIdentity(SIMessage sIMessage) throws SIMediationSessionException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"resetIdentity", (Object)new Object[]{this, sIMessage});
        }
        try {
            Subject subject = _helper.peekRunAs();
            this.resetIdentity(subject, ((SISystemMessage)sIMessage).toSIBusMessage());
        }
        catch (SecurityContextException securityContextException) {
            FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.session.SIMediationSessionImpl.resetIdentity", (String)"1935", (Object)this);
            String string = _nls.getString("UnableToObtainRunAsIdentity");
            SIMediationSessionException sIMediationSessionException = new SIMediationSessionException(string, securityContextException);
            this.traceConvertingException(securityContextException, (Exception)((Object)sIMediationSessionException), "While trying to get the run as subject an exception was received");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"resetIdentity", (Object)((Object)sIMediationSessionException));
            }
            throw sIMediationSessionException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"resetIdentity");
        }
    }

    private String getUserId(Subject subject) {
        String string = _authUtils.getUserName(subject);
        return string;
    }

    private void resetIdentity(Subject subject, SIBusMessage sIBusMessage) throws SIMediationSessionException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"resetIdentity", (Object)new Object[]{this, this.getUserId(subject), sIBusMessage});
        }
        this._accessControl.setSecurityIDInMessage(subject, (JsMessage)sIBusMessage);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"resetIdentity");
        }
    }

    private void traceRethrowingException(Exception exception) {
        if (_tc.isEventEnabled()) {
            SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)exception);
        }
    }

    private void traceConvertingException(Exception exception, Exception exception2, String string) {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)string);
        }
        if (_tc.isEventEnabled()) {
            SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{exception, exception2});
        }
    }

    private void traceAbsorbingException(Exception exception, String string) {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)string);
        }
        if (_tc.isEventEnabled()) {
            SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)exception);
        }
    }

    public void setSIBAccessControl(SIBAccessControl sIBAccessControl) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSIBAccessControl", (Object)new Object[]{this, sIBAccessControl});
        }
        this._accessControl = sIBAccessControl;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSIBAccessControl");
        }
    }

    public void invalidate() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"invalidate", (Object)this);
        }
        this._valid = false;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"invalidate");
        }
    }

    private void checkValid() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"checkValid", (Object)this);
        }
        if (!this._valid || Thread.currentThread() != this._creationThread) {
            IllegalStateException illegalStateException = new IllegalStateException();
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("A potential API violation has occurred. valid: " + this._valid + ", Stack Trace is: " + SIMediationSessionImpl.extractStackTrace(illegalStateException)));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"checkValid", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"checkValid");
        }
    }

    private static String extractStackTrace(Throwable throwable) {
        String string;
        if (throwable == null) {
            string = "null";
        } else {
            try {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.close();
                string = stringWriter.toString();
            }
            catch (IOException iOException) {
                string = throwable.toString();
            }
        }
        return string;
    }

    static {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"<clinit>");
        }
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)_sourceInfo);
        }
        _helper = SecurityContextFactory.getInstance().createNewSecurityContextHelper();
        _authUtils = AuthUtilsFactory.getInstance().createNewAuthUtils();
        _serverSubject = _authUtils.getSIBServerSubject();
        _login = SibLoginFactory.getInstance().createNewSibLogin();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"<clinit>");
        }
    }
}

