/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.util.AuthData;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.security.auth.SibLoginFactory;
import com.ibm.ws.sib.security.context.SecurityContextException;
import com.ibm.ws.sib.security.context.SecurityContextFactory;
import com.ibm.ws.sib.security.context.SecurityContextHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.mediation.runtime.ContextElementHandler;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public class SecurityContextHandler
implements ContextElementHandler {
    private static final TraceComponent _tc = SibTr.register((Class)SecurityContextHandler.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private static final String _sourceInfo = "Source Info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/SecurityContextHandler.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.19";
    private static SecurityContextHelper _helper;
    private static Map _authDataCache;
    private static boolean _enabled;

    public boolean start(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"start", (Object)new Object[]{this, sIBusMessage, destinationDefinition, jsMessagingEngine, map});
        }
        boolean bl = true;
        JsBus jsBus = (JsBus)jsMessagingEngine.getBus();
        AuthUtils authUtils = AuthUtilsFactory.getInstance().createNewAuthUtils();
        _enabled = authUtils.isServerSecure();
        if (_enabled) {
            SecurityContextHelper securityContextHelper = this.getHelper();
            if (securityContextHelper == null) {
                bl = false;
            }
            if (bl) {
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Bus security has been enabled");
                }
                try {
                    String string = jsBus.getAttribute("mediationsAuthAlias");
                    AuthData authData = null;
                    if (string == null || "".equals(string)) {
                        SibTr.error((TraceComponent)_tc, (String)"NO_MEDIATION_AUTH_ALIAS_CWSIZ0020E", (Object)jsBus.getName());
                        bl = false;
                    }
                    if (bl && (authData = this.getAuthData(string)) == null) {
                        SibTr.error((TraceComponent)_tc, (String)"MEDIATION_AUTH_ALIAS_NOT_FOUND_CWSIZ0021E", (Object)new Object[]{string, jsBus.getName()});
                        bl = false;
                    }
                    if (bl) {
                        Subject subject = SibLoginFactory.getInstance().createNewSibLogin().login(authData.uid, authData.psw);
                        if (subject != null) {
                            securityContextHelper.pushRunAs(subject);
                            map.put(this.getClass().getName(), Boolean.TRUE);
                        } else {
                            SibTr.error((TraceComponent)_tc, (String)"MEDIATION_IDENTITY_NOT_VALID_CWSIZ0045E", (Object)new Object[]{string, jsBus.getName()});
                            bl = false;
                        }
                    }
                }
                catch (SecurityContextException securityContextException) {
                    FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.SecurityContextHandler.start", (String)"67", (Object)this);
                    SibTr.error((TraceComponent)_tc, (String)"MEDIATION_SECURITY_ERROR_CWSIZ0022E", (Object)securityContextException);
                    if (_tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
                    }
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"start", (Object)Boolean.FALSE);
                    }
                    return false;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"start", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public void complete(Map map) {
        block6: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"complete", (Object)new Object[]{this, map});
            }
            try {
                Object v = map.get(this.getClass().getName());
                if (v != null) {
                    this.getHelper().popRunAs();
                }
            }
            catch (SecurityContextException securityContextException) {
                FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.SecurityContextHandler.complete", (String)"92", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"The security context handler failed to remove the security context");
                }
                if (!_tc.isEventEnabled()) break block6;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"complete");
        }
    }

    public void fail(Map map) {
        block6: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"fail", (Object)new Object[]{this, map});
            }
            try {
                Object v = map.get(this.getClass().getName());
                if (v != null) {
                    this.getHelper().popRunAs();
                }
            }
            catch (SecurityContextException securityContextException) {
                FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.SecurityContextHandler.fail", (String)"122", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"The security context handler failed to remove the security context");
                }
                if (!_tc.isEventEnabled()) break block6;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"fail");
        }
    }

    public void preDispatch(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"preDispatch has been called");
        }
    }

    private AuthData getAuthData(String string) {
        AuthData authData;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getAuthData", (Object)new Object[]{this, string});
        }
        if (_authDataCache.containsKey(string)) {
            authData = (AuthData)_authDataCache.get(string);
        } else {
            authData = WSDefaultPrincipalMapping.getAuthDataInt((String)string);
            if (authData != null) {
                _authDataCache.put(string, authData);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getAuthData", (Object)authData);
        }
        return authData;
    }

    private SecurityContextHelper getHelper() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getHelper", (Object)this);
        }
        if (_helper == null) {
            _helper = SecurityContextFactory.getInstance().createNewSecurityContextHelper();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHelper", (Object)_helper);
        }
        return _helper;
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)_sourceInfo);
        }
        _authDataCache = new HashMap();
    }
}

