/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.PMIDestinationInfo;
import com.ibm.ws.sib.mediation.runtime.PMIEngineInfo;
import com.ibm.ws.sib.mediation.runtime.PMIGlobalInfo;
import com.ibm.ws.sib.mediation.runtime.PMIMediationInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;

public class MediationPMIInstrumentation {
    private static final TraceComponent _tc = SibTr.register((Class)MediationPMIInstrumentation.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private static PMIGlobalInfo _globalInfo;
    private PMIEngineInfo _engineInfo;
    private PMIMediationInfo _mediationInfo;
    private PMIDestinationInfo _destinationInfo;
    private boolean _open;

    public MediationPMIInstrumentation(JsMessagingEngine jsMessagingEngine, String string, String string2) {
        block5: {
            this._open = false;
            if (_tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)_tc, (String)"MediationPMIInstrumentation", (Object)new Object[]{jsMessagingEngine, string, string2});
            }
            if (StatsFactory.isPMIEnabled()) {
                try {
                    this._engineInfo = _globalInfo.getEngineInfo(jsMessagingEngine);
                    this._mediationInfo = this._engineInfo.getMediationInfo(string);
                    this._destinationInfo = this._mediationInfo.getDestinationInfo(string2);
                    this._destinationInfo.incrementUsageCount();
                    this._open = true;
                }
                catch (StatsFactoryException statsFactoryException) {
                    if (!_tc.isDebugEnabled()) break block5;
                    SibTr.debug((TraceComponent)_tc, (String)("Absorbing " + (Object)((Object)statsFactoryException)));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"MediationPMIInstrumentation", (Object)this);
        }
    }

    public final void close() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"close");
        }
        if (this._open) {
            this._open = false;
            this._destinationInfo.decrementUsageCount();
            this._destinationInfo = null;
            this._mediationInfo = null;
            this._engineInfo = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"close");
        }
    }

    public final void onThreadAllocatedToMediation() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"onThreadAllocatedToMediation");
        }
        if (this._open) {
            this._mediationInfo.allocateThread();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"onThreadAllocatedToMediation");
        }
    }

    public final void onThreadReclaimedFromMediation() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"onThreadReclaimedFromMediation");
        }
        if (this._open) {
            this._mediationInfo.reclaimThread();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"onThreadReclaimedFromMediation");
        }
    }

    public final void onMessageMediated(long l) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"onMessageMediated", (Object)new Long(l));
        }
        if (this._open) {
            this._destinationInfo.messageMediated(l);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"onMessageMediated");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/MediationPMIInstrumentation.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.14");
        }
        _globalInfo = new PMIGlobalInfo();
    }
}

