/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters;
import com.ibm.ws.sib.utils.ffdc.SibDiagnosticModule;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;

public class MediationFrameworkDiagnosticModule
extends SibDiagnosticModule {
    private static final TraceComponent _tc = SibTr.register((Class)MediationFrameworkDiagnosticModule.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private static boolean _registered;
    private static WSThreadLocal _diagnosticData;

    public static synchronized void register() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"register");
        }
        if (!_registered) {
            _registered = true;
            String[] stringArray = new String[]{"com.ibm.ws.sib.mediation", "com.ibm.wsspi.sib.mediation", "com.ibm.websphere.sib.mediation"};
            MediationFrameworkDiagnosticModule mediationFrameworkDiagnosticModule = new MediationFrameworkDiagnosticModule();
            mediationFrameworkDiagnosticModule.register(stringArray);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"register");
        }
    }

    public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        ThreadDeath threadDeath;
        block27: {
            DiagnosticData diagnosticData;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                if (_tc.isEntryEnabled()) {
                                    SibTr.entry((Object)((Object)this), (TraceComponent)_tc, (String)"ffdcDumpDefault", (Object)new Object[]{this, throwable, incidentStream, object, objectArray, string});
                                }
                                super.ffdcDumpDefault(throwable, incidentStream, object, objectArray, string);
                                diagnosticData = (DiagnosticData)_diagnosticData.get();
                                threadDeath = null;
                                try {
                                    if (diagnosticData.isParamsKnown()) {
                                        incidentStream.introspectAndWrite(" Parameters of the mediation", (Object)diagnosticData.getParams());
                                    }
                                }
                                catch (Throwable throwable2) {
                                    incidentStream.write(" Parameters of the mediation are not available", (Object)throwable2);
                                    if (!(throwable2 instanceof ThreadDeath)) break block22;
                                    threadDeath = (ThreadDeath)throwable2;
                                }
                            }
                            try {
                                if (diagnosticData.isDestinationDefinitionKnown()) {
                                    incidentStream.introspectAndWrite("DestinationDefinition", (Object)diagnosticData.getDestinationDefinition());
                                }
                            }
                            catch (Throwable throwable3) {
                                incidentStream.write(" DestinationDefinition is not available", (Object)throwable3);
                                if (!(throwable3 instanceof ThreadDeath)) break block23;
                                threadDeath = (ThreadDeath)throwable3;
                            }
                        }
                        try {
                            if (diagnosticData.isMediationDefinitionKnown()) {
                                incidentStream.introspectAndWrite("MediationDefinition", (Object)diagnosticData.getMediationDefinition());
                            }
                        }
                        catch (Throwable throwable4) {
                            incidentStream.write(" MediationDefinition is not available", (Object)throwable4);
                            if (!(throwable4 instanceof ThreadDeath)) break block24;
                            threadDeath = (ThreadDeath)throwable4;
                        }
                    }
                    try {
                        if (diagnosticData.isMessageHandleKnown()) {
                            incidentStream.write("Message Handle", (Object)diagnosticData.getMessageHandle());
                        }
                    }
                    catch (Throwable throwable5) {
                        incidentStream.write(" Message Handle is unavailable", (Object)throwable5);
                        if (!(throwable5 instanceof ThreadDeath)) break block25;
                        threadDeath = (ThreadDeath)throwable5;
                    }
                }
                try {
                    if (diagnosticData.isSystemMessageIdKnown()) {
                        incidentStream.write(" System Message id", diagnosticData.getSystemMessageId());
                    }
                }
                catch (Throwable throwable6) {
                    incidentStream.write(" System message id is unavailable", (Object)throwable6);
                    if (!(throwable6 instanceof ThreadDeath)) break block26;
                    threadDeath = (ThreadDeath)throwable6;
                }
            }
            try {
                if (diagnosticData.isMessagingEngineKnown()) {
                    incidentStream.introspectAndWrite("Messaging Engine", diagnosticData.getMessagingEngine());
                }
            }
            catch (Throwable throwable7) {
                incidentStream.write(" Messaging Engine is not available", (Object)throwable7);
                if (!(throwable7 instanceof ThreadDeath)) break block27;
                threadDeath = (ThreadDeath)throwable7;
            }
        }
        if (threadDeath != null) {
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)_tc, (String)"ffdcDumpDefault", (Object)threadDeath);
            }
            throw threadDeath;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)_tc, (String)"ffdcDumpDefault");
        }
    }

    public static void addDiagnosticData(JsMessagingEngine jsMessagingEngine) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"addDiagnosticData", (Object)jsMessagingEngine);
        }
        DiagnosticData diagnosticData = (DiagnosticData)_diagnosticData.get();
        diagnosticData.setMessagingEngine(jsMessagingEngine);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"addDiagnosticData");
        }
    }

    public static void addDiagnosticData(DestinationDefinition destinationDefinition) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"addDiagnosticData", (Object)destinationDefinition);
        }
        DiagnosticData diagnosticData = (DiagnosticData)_diagnosticData.get();
        diagnosticData.setDestinationDefinition(destinationDefinition);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"addDiagnosticData");
        }
    }

    public static void addDiagnosticData(SIBusMessage sIBusMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"addDiagnosticData", (Object)sIBusMessage);
        }
        DiagnosticData diagnosticData = (DiagnosticData)_diagnosticData.get();
        diagnosticData.setMessage(sIBusMessage);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"addDiagnosticData");
        }
    }

    public static void addDiagnosticData(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"addDiagnosticData", (Object)destinationMediationParameters);
        }
        DiagnosticData diagnosticData = (DiagnosticData)_diagnosticData.get();
        diagnosticData.setParams(destinationMediationParameters);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"addDiagnosticData");
        }
    }

    public static void clearDiagnosticData() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"clearDiagnosticData");
        }
        DiagnosticData diagnosticData = (DiagnosticData)_diagnosticData.get();
        diagnosticData.clear();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"clearDiagnosticData");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/MediationFrameworkDiagnosticModule.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.12");
        }
        _registered = false;
        _diagnosticData = new WSThreadLocal(){

            public Object initialValue() {
                if (_tc.isEntryEnabled()) {
                    SibTr.entry((Object)((Object)this), (TraceComponent)_tc, (String)"initialValue", (Object)((Object)this));
                }
                DiagnosticData diagnosticData = new DiagnosticData();
                diagnosticData.clear();
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)((Object)this), (TraceComponent)_tc, (String)"initialValue", (Object)diagnosticData);
                }
                return diagnosticData;
            }
        };
    }

    private static class DiagnosticData {
        private DestinationMediationParameters _params;
        private DestinationDefinition _dd;
        private SIBusMessage _message;
        private JsMessagingEngine _engine;

        private DiagnosticData() {
        }

        public DestinationMediationParameters getParams() {
            return this._params;
        }

        public DestinationDefinition getDestinationDefinition() {
            return this._params == null ? this._dd : this._params.getDestinationDefinition();
        }

        public MediationDefinition getMediationDefinition() {
            DestinationDefinition destinationDefinition = this.getDestinationDefinition();
            return destinationDefinition == null ? null : this.getDestinationDefinition().getMediationDefinition();
        }

        public Object getMessagingEngine() {
            return this._params == null ? this._engine : this._params.getMessagingEngine();
        }

        public SIMessageHandle getMessageHandle() {
            SIMessageHandle[] sIMessageHandleArray;
            SIMessageHandle sIMessageHandle = null;
            if (this._message != null) {
                sIMessageHandle = this._message.getMessageHandle();
            } else if (this._params != null && (sIMessageHandleArray = this._params.getMessageIds()) != null && sIMessageHandleArray.length > 0) {
                sIMessageHandle = sIMessageHandleArray[0];
            }
            return sIMessageHandle;
        }

        public String getSystemMessageId() {
            Object object = this._params == null ? (this._message == null ? null : this._message.getSystemMessageId()) : this._params.getTraceMessageId();
            return object;
        }

        public void setParams(DestinationMediationParameters destinationMediationParameters) {
            this._params = destinationMediationParameters;
        }

        public void setDestinationDefinition(DestinationDefinition destinationDefinition) {
            this._dd = destinationDefinition;
        }

        public void setMessagingEngine(JsMessagingEngine jsMessagingEngine) {
            this._engine = jsMessagingEngine;
        }

        public void setMessage(SIBusMessage sIBusMessage) {
            this._message = sIBusMessage;
        }

        public boolean isMessageHandleKnown() {
            return this.getMessageHandle() != null;
        }

        public boolean isSystemMessageIdKnown() {
            return this.getSystemMessageId() != null;
        }

        public boolean isMessagingEngineKnown() {
            return this.getMessagingEngine() != null;
        }

        public boolean isDestinationDefinitionKnown() {
            return this.getDestinationDefinition() != null;
        }

        public boolean isMediationDefinitionKnown() {
            return this.getMediationDefinition() != null;
        }

        public boolean isParamsKnown() {
            return this.getParams() != null;
        }

        public void clear() {
            this._params = null;
            this._dd = null;
            this._message = null;
            this._engine = null;
        }
    }
}

