/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.SIMediationContextSetupException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.handlerfw.HandlerFramework;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.handlerfw.exception.HandlerListNotFoundException;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.mediation.runtime.ContextElementHandler;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ContextHelper {
    private static HandlerFramework _handlerFramework;
    private static ContextElementHandler _contextHandlerProxy;
    private static HandlerList _list;
    private static final TraceComponent _tc;
    private static final String CONTEXT_HANDLER_LIST_NAME = "SIB:MediationFramework:DestinationMediation:ContextSetupList";
    private static final String _sourceInfo = "Source Info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/ContextHelper.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.16";

    public static boolean startContext(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) throws SIMediationContextSetupException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"startContext", (Object)new Object[]{sIBusMessage, destinationDefinition, jsMessagingEngine, map});
        }
        boolean bl = false;
        try {
            bl = ContextHelper.getProxy().start(sIBusMessage, destinationDefinition, jsMessagingEngine, map);
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIMediationContextSetupException));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"startContext");
            }
            throw sIMediationContextSetupException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"startContext", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public static void preDispatchContext(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) throws SIMediationContextSetupException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"startContext", (Object)new Object[]{sIBusMessage, destinationDefinition, jsMessagingEngine, map});
        }
        try {
            ContextHelper.getProxy().preDispatch(sIBusMessage, destinationDefinition, jsMessagingEngine, map);
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIMediationContextSetupException));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"startContext");
            }
            throw sIMediationContextSetupException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"startContext");
        }
    }

    public static void completeContext(Map map) throws SIMediationContextSetupException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"completeContext", (Object)map);
        }
        try {
            ContextHelper.getProxy().complete(map);
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIMediationContextSetupException));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"completeContext");
            }
            throw sIMediationContextSetupException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"completeContext");
        }
    }

    public static void failContext(Map map) throws SIMediationContextSetupException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"failContext", (Object)map);
        }
        try {
            ContextHelper.getProxy().fail(map);
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIMediationContextSetupException));
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"failContext");
            }
            throw sIMediationContextSetupException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"failContext");
        }
    }

    private static ContextElementHandler getProxy() throws SIMediationContextSetupException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getProxy");
        }
        if (_contextHandlerProxy == null) {
            try {
                _list = ContextHelper.getHandlerFramework().getHandlerList(CONTEXT_HANDLER_LIST_NAME);
                _contextHandlerProxy = (ContextElementHandler)_list.getProxy(ContextElementHandler.class);
            }
            catch (HandlerListNotFoundException handlerListNotFoundException) {
                FFDCFilter.processException((Throwable)handlerListNotFoundException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getProxy", (String)"182", (Object)ContextHelper.class);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"System handler list 'SIB:MediationFramework:DestinationMediation:ContextSetupList' has not been defined");
                }
                SIMediationContextSetupException sIMediationContextSetupException = new SIMediationContextSetupException("ContextHandlerListNotFound", handlerListNotFoundException);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{handlerListNotFoundException, sIMediationContextSetupException});
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getProxy");
                }
                throw sIMediationContextSetupException;
            }
            catch (HFConfigException hFConfigException) {
                FFDCFilter.processException((Throwable)hFConfigException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getProxy", (String)"213", (Object)ContextHelper.class);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Error occurred while obtaining system handler list named 'SIB:MediationFramework:DestinationMediation:ContextSetupList'");
                }
                SIMediationContextSetupException sIMediationContextSetupException = new SIMediationContextSetupException("ErrorObtainingHandlerManager", hFConfigException);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{hFConfigException, sIMediationContextSetupException});
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getProxy");
                }
                throw sIMediationContextSetupException;
            }
            catch (HFRuntimeException hFRuntimeException) {
                FFDCFilter.processException((Throwable)hFRuntimeException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getProxy", (String)"239", (Object)ContextHelper.class);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Error occurred while obtaining system handler list named 'SIB:MediationFramework:DestinationMediation:ContextSetupList'");
                }
                SIMediationContextSetupException sIMediationContextSetupException = new SIMediationContextSetupException("ErrorObtainingHandlerManager", hFRuntimeException);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{hFRuntimeException, sIMediationContextSetupException});
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getProxy");
                }
                throw sIMediationContextSetupException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getProxy", (String)"265", (Object)ContextHelper.class);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"System handler list name 'SIB:MediationFramework:DestinationMediation:ContextSetupList' is not valid", (Object)illegalArgumentException);
                }
                SIMediationContextSetupException sIMediationContextSetupException = new SIMediationContextSetupException("ContextHandlerListNameInvalid", illegalArgumentException);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{illegalArgumentException, sIMediationContextSetupException});
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getProxy");
                }
                throw sIMediationContextSetupException;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getProxy", (String)"292", (Object)ContextHelper.class);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Unable to load HandlerManager");
                }
                SIMediationContextSetupException sIMediationContextSetupException = new SIMediationContextSetupException("ErrorObtainingHandlerManager", namingException);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"converting", (Object)new Object[]{namingException, sIMediationContextSetupException});
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getProxy");
                }
                throw sIMediationContextSetupException;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getProxy", (Object)_contextHandlerProxy);
        }
        return _contextHandlerProxy;
    }

    private static HandlerFramework getHandlerFramework() throws NamingException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getHandlerFramework");
        }
        try {
            if (_handlerFramework == null) {
                InitialContext initialContext = new InitialContext();
                _handlerFramework = (HandlerFramework)initialContext.lookup("services:websphere/HandlerFrameworkService");
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sib.mediation.runtime.ContextHelper.getHandlerFramework", (String)"353", (Object)ContextHelper.class);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Error occurred trying to lookup the HandlerManager to setup the context");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)namingException);
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"getHandlerFramework");
            }
            throw namingException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getHandlerFramework", (Object)_handlerFramework);
        }
        return _handlerFramework;
    }

    static {
        _tc = SibTr.register((Class)ContextHelper.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)_sourceInfo);
        }
    }
}

