/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationDispatcherInitializer;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.mediation.runtime.MediationControl;
import com.ibm.wsspi.sib.mediation.runtime.StoppedListener;

public abstract class AbstractDestinationMediationDispatcher
implements DestinationMediationDispatcherInitializer {
    private static final TraceComponent _tc = SibTr.register((Class)AbstractDestinationMediationDispatcher.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private DestinationDefinition _dd;
    private JsMessagingEngine _engine;
    private SIDestinationAddress _address;

    public void setDestinationDefinition(DestinationDefinition destinationDefinition) throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setDestinationDefinition", (Object)new Object[]{this, destinationDefinition});
        }
        if (this._dd != null) {
            IllegalStateException illegalStateException = new IllegalStateException();
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setDestinationDefinition", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        this._dd = destinationDefinition;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setDestinationDefinition");
        }
    }

    public void setMessagingEngine(JsMessagingEngine jsMessagingEngine) throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMessagingEngine", (Object)new Object[]{this, jsMessagingEngine});
        }
        if (this._engine != null) {
            IllegalStateException illegalStateException = new IllegalStateException();
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMessagingEngine", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        this._engine = jsMessagingEngine;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMessagingEngine");
        }
    }

    public void setSIDestinationAddress(SIDestinationAddress sIDestinationAddress) throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setSIDestinationAddress", (Object)new Object[]{this, sIDestinationAddress});
        }
        if (this._address != null) {
            IllegalStateException illegalStateException = new IllegalStateException();
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSIDestinationAddress", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        this._address = sIDestinationAddress;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setSIDestinationAddress");
        }
    }

    protected final void unlockMessage(SIBusMessage sIBusMessage, ConsumerSession consumerSession) {
        block5: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"unlockMessage", (Object)new Object[]{this, sIBusMessage, consumerSession});
            }
            try {
                consumerSession.unlockSet(new SIMessageHandle[]{sIBusMessage.getMessageHandle()});
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.AbstractDestinationMediationDispatcher.unlockMessage", (String)"191", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"While unlocking the message that could not be mediated an exception was thrown");
                }
                if (!_tc.isEventEnabled()) break block5;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"unlockMessage");
        }
    }

    protected SIDestinationAddress getSIDestinationAddress() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIDestinationAddress", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationAddress", (Object)this._address);
        }
        return this._address;
    }

    protected final DestinationDefinition getDestinationDefinition() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationDefinition", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationDefinition", (Object)this._dd);
        }
        return this._dd;
    }

    protected final JsMessagingEngine getMessagingEngine() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMessagingEngine", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMessagingEngine", (Object)this._engine);
        }
        return this._engine;
    }

    protected final DestinationMediationParameters createDestinationMediationParameters(ConsumerSession consumerSession, SIBusMessage sIBusMessage, MediationControl mediationControl) {
        DestinationMediationParameters destinationMediationParameters;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"createDestinationMediationParameters", (Object)new Object[]{this, consumerSession, sIBusMessage, mediationControl});
        }
        try {
            destinationMediationParameters = new DestinationMediationParameters(consumerSession.getConnection(), consumerSession, sIBusMessage, this.getDestinationDefinition(), this.getMessagingEngine(), this.getSIDestinationAddress(), mediationControl);
        }
        catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
            FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.AbstractDestinationMediationDispatcher.createDestinationMediationParameters", (String)"339", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"While doing setup for mediating it was discovered that the consumer was closed, aborting");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionUnavailableException));
            }
            destinationMediationParameters = null;
        }
        catch (SISessionUnavailableException sISessionUnavailableException) {
            FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.AbstractDestinationMediationDispatcher.createDestinationMediationParameters", (String)"356", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"While doing setup for mediating it was discovered that the consumer was closed, aborting");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sISessionUnavailableException));
            }
            destinationMediationParameters = null;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.AbstractDestinationMediationDispatcher.createDestinationMediationParameters", (String)"375", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to get consumer id for the consumer");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            this.unlockMessage(sIBusMessage, consumerSession);
            destinationMediationParameters = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createDestinationMediationParameters", (Object)destinationMediationParameters);
        }
        return destinationMediationParameters;
    }

    public void cancelWaitingWorkAndStop() throws IllegalStateException {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"cancelWaitingWorkAndStop");
        }
    }

    public void resume() {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"resume");
        }
    }

    public void stop(StoppedListener stoppedListener) {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"stop", (Object)stoppedListener);
        }
    }
}

