/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.ConjunctionImpl;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SimpleTestImpl;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.tools.Resolver;
import com.ibm.ws.sib.matchspace.tools.Transformer;
import java.util.ArrayList;
import java.util.List;

public final class TransformerImpl
implements Transformer {
    public Selector resolve(Selector selector, Resolver resolver, PositionAssigner positionAssigner) {
        if (selector instanceof Identifier) {
            Identifier identifier = (Identifier)selector;
            return resolver.resolve(identifier, positionAssigner);
        }
        if (selector.getNumIds() > 0) {
            Operator operator = (Operator)selector;
            for (int i = 0; i < operator.getOperands().length; ++i) {
                operator.setOperand(i, this.resolve(operator.getOperands()[i], resolver, positionAssigner));
            }
            operator.assignType();
        }
        return selector;
    }

    public Selector DNF(Selector selector) {
        selector = TransformerImpl.simplifyTree(selector);
        return TransformerImpl.DNF0(selector);
    }

    private static Selector DNF0(Selector selector) {
        if (!(selector instanceof Operator)) {
            return selector;
        }
        Operator operator = (Operator)selector;
        switch (operator.getOp()) {
            case 46: {
                return TransformerImpl.processAND(operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 47: {
                return TransformerImpl.makeOR(TransformerImpl.DNF0(operator.getOperands()[0]), TransformerImpl.DNF0(operator.getOperands()[1]));
            }
        }
        return selector;
    }

    private static Selector processAND(Selector selector, Selector selector2) {
        Operator operator;
        selector = TransformerImpl.DNF0(selector);
        selector2 = TransformerImpl.DNF0(selector2);
        if (selector instanceof Operator && (operator = (Operator)selector).getOp() == 47) {
            return TransformerImpl.makeOR(TransformerImpl.processAND(operator.getOperands()[0], selector2), TransformerImpl.processAND(operator.getOperands()[1], selector2));
        }
        return TransformerImpl.processANDRight(selector, selector2);
    }

    private static Selector processANDRight(Selector selector, Selector selector2) {
        Operator operator;
        if (selector2 instanceof Operator && (operator = (Operator)selector2).getOp() == 47) {
            return TransformerImpl.makeOR(TransformerImpl.processANDRight(selector, operator.getOperands()[0]), TransformerImpl.processANDRight(selector, operator.getOperands()[1]));
        }
        return TransformerImpl.makeAND(selector, selector2);
    }

    private static Selector makeOR(Selector selector, Selector selector2) {
        if (selector.getNumIds() == 0) {
            Boolean bl = (Boolean)Matching.getEvaluator().eval(selector);
            if (bl != null && bl.booleanValue()) {
                return new LiteralImpl(Boolean.TRUE);
            }
            return TransformerImpl.evalOf(selector2);
        }
        if (selector2.getNumIds() == 0) {
            Boolean bl = (Boolean)Matching.getEvaluator().eval(selector2);
            if (bl != null && bl.booleanValue()) {
                return new LiteralImpl(Boolean.TRUE);
            }
            return TransformerImpl.evalOf(selector);
        }
        return new OperatorImpl(47, selector, selector2);
    }

    private static Selector makeAND(Selector selector, Selector selector2) {
        if (selector.getNumIds() == 0) {
            Boolean bl = (Boolean)Matching.getEvaluator().eval(selector);
            if (bl == null || !bl.booleanValue()) {
                return new LiteralImpl(Boolean.FALSE);
            }
            return TransformerImpl.evalOf(selector2);
        }
        if (selector2.getNumIds() == 0) {
            Boolean bl = (Boolean)Matching.getEvaluator().eval(selector2);
            if (bl == null || !bl.booleanValue()) {
                return new LiteralImpl(Boolean.FALSE);
            }
            return TransformerImpl.evalOf(selector);
        }
        return new OperatorImpl(46, selector, selector2);
    }

    private static Selector evalOf(Selector selector) {
        if (selector.getNumIds() > 0) {
            return selector;
        }
        return new LiteralImpl(Matching.getEvaluator().eval(selector));
    }

    private static Selector simplifyTree(Selector selector) {
        if (!(selector instanceof Operator)) {
            return selector;
        }
        Operator operator = (Operator)selector;
        switch (operator.getOp()) {
            case 1: {
                return TransformerImpl.simplifyNOT(operator.getOperands()[0]);
            }
            case 45: {
                return TransformerImpl.simplifyEQ(operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 40: {
                return TransformerImpl.simplifyNE(operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 2: 
            case 3: {
                return new OperatorImpl(operator.getOp(), TransformerImpl.simplifyTree(operator.getOperands()[0]));
            }
            case 4: 
            case 5: {
                LikeOperatorImpl likeOperatorImpl = (LikeOperatorImpl)operator;
                return new LikeOperatorImpl(likeOperatorImpl.getOp(), TransformerImpl.simplifyTree(likeOperatorImpl.getOperands()[0]), likeOperatorImpl.getInternalPattern(), likeOperatorImpl.getPattern(), likeOperatorImpl.isEscaped(), likeOperatorImpl.getEscape());
            }
        }
        return new OperatorImpl(operator.getOp(), TransformerImpl.simplifyTree(operator.getOperands()[0]), TransformerImpl.simplifyTree(operator.getOperands()[1]));
    }

    private static Selector simplifyNOT(Selector selector) {
        if (selector instanceof Literal) {
            return new LiteralImpl(EvaluatorImpl.not((Boolean)((Literal)selector).getValue()));
        }
        if (!(selector instanceof Operator)) {
            return new OperatorImpl(1, selector);
        }
        Operator operator = (Operator)selector;
        switch (operator.getOp()) {
            case 1: {
                return TransformerImpl.simplifyTree(operator.getOperands()[0]);
            }
            case 46: {
                return TransformerImpl.makeOR(TransformerImpl.simplifyNOT(operator.getOperands()[0]), TransformerImpl.simplifyNOT(operator.getOperands()[1]));
            }
            case 47: {
                return TransformerImpl.makeAND(TransformerImpl.simplifyNOT(operator.getOperands()[0]), TransformerImpl.simplifyNOT(operator.getOperands()[1]));
            }
            case 45: {
                return TransformerImpl.simplifyNE(operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 40: {
                return TransformerImpl.simplifyEQ(operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 41: {
                return new OperatorImpl(44, operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 42: {
                return new OperatorImpl(43, operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 43: {
                return new OperatorImpl(42, operator.getOperands()[0], operator.getOperands()[1]);
            }
            case 44: {
                return new OperatorImpl(41, operator.getOperands()[0], operator.getOperands()[1]);
            }
        }
        return new OperatorImpl(1, selector);
    }

    private static Selector simplifyEQ(Selector selector, Selector selector2) {
        if (selector.getType() != -6) {
            return new OperatorImpl(45, selector, selector2);
        }
        return TransformerImpl.makeOR(TransformerImpl.makeAND(TransformerImpl.simplifyTree(selector), TransformerImpl.simplifyTree(selector2)), TransformerImpl.makeAND(TransformerImpl.simplifyNOT(selector), TransformerImpl.simplifyNOT(selector2)));
    }

    private static Selector simplifyNE(Selector selector, Selector selector2) {
        if (selector.getType() == -6) {
            return TransformerImpl.makeOR(TransformerImpl.makeAND(TransformerImpl.simplifyTree(selector), TransformerImpl.simplifyNOT(selector2)), TransformerImpl.makeAND(TransformerImpl.simplifyNOT(selector), TransformerImpl.simplifyTree(selector2)));
        }
        if (selector.getType() == -5 || selector.getType() == 0) {
            return new OperatorImpl(40, selector, selector2);
        }
        return TransformerImpl.makeOR(new OperatorImpl(42, selector, selector2), new OperatorImpl(41, selector, selector2));
    }

    public Conjunction[] organizeTests(Selector selector) {
        ArrayList arrayList = new ArrayList();
        if (TransformerImpl.organizeTests(arrayList, selector)) {
            return null;
        }
        return arrayList.toArray(new ConjunctionImpl[0]);
    }

    private static boolean organizeTests(List list, Selector selector) {
        ConjunctionImpl conjunctionImpl;
        if (selector instanceof Operator) {
            Operator operator = (Operator)selector;
            if (operator.getOp() == 47) {
                return TransformerImpl.organizeTests(list, operator.getOperands()[0]) || TransformerImpl.organizeTests(list, operator.getOperands()[1]);
            }
            conjunctionImpl = operator.getOp() == 46 ? TransformerImpl.organizeConjunction(operator) : TransformerImpl.simpleConjunct(selector);
        } else {
            conjunctionImpl = TransformerImpl.simpleConjunct(selector);
        }
        if (conjunctionImpl == null) {
            return false;
        }
        if (conjunctionImpl.alwaysTrue) {
            return true;
        }
        if (conjunctionImpl.organize()) {
            list.add(conjunctionImpl);
        }
        return false;
    }

    private static ConjunctionImpl simpleConjunct(Selector selector) {
        if (selector.getNumIds() == 0) {
            Boolean bl = (Boolean)Matching.getEvaluator().eval(selector);
            if (bl != null && bl.booleanValue()) {
                return new ConjunctionImpl();
            }
            return null;
        }
        if (Matching.isSimple((Selector)selector)) {
            return new ConjunctionImpl(new SimpleTestImpl(selector));
        }
        return new ConjunctionImpl(selector);
    }

    private static ConjunctionImpl organizeConjunction(Operator operator) {
        Operator operator2;
        Selector selector = operator.getOperands()[0];
        ConjunctionImpl conjunctionImpl = selector instanceof Operator ? ((operator2 = (Operator)selector).getOp() == 46 ? TransformerImpl.organizeConjunction(operator2) : TransformerImpl.simpleConjunct(selector)) : TransformerImpl.simpleConjunct(selector);
        if (conjunctionImpl == null) {
            return null;
        }
        return TransformerImpl.augmentConjunction(conjunctionImpl, operator.getOperands()[1]) ? conjunctionImpl : null;
    }

    private static boolean augmentConjunction(ConjunctionImpl conjunctionImpl, Selector selector) {
        Object object;
        if (selector instanceof Operator && (object = (Operator)selector).getOp() == 46) {
            return TransformerImpl.augmentConjunction(conjunctionImpl, object.getOperands()[0]) && TransformerImpl.augmentConjunction(conjunctionImpl, object.getOperands()[1]);
        }
        if (selector.getNumIds() == 0) {
            object = (Boolean)Matching.getEvaluator().eval(selector);
            if (object == null) {
                return false;
            }
            return (Boolean)object;
        }
        if (Matching.isSimple((Selector)selector)) {
            return conjunctionImpl.and(new SimpleTestImpl(selector));
        }
        conjunctionImpl.and(selector);
        return true;
    }
}

