/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.EvalCacheImpl;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import java.util.List;

public final class SimpleTestImpl
implements SimpleTest {
    public Identifier identifier;
    public int kind;
    public Object value;
    public Number lower;
    public boolean lowIncl;
    public Number upper;
    public boolean upIncl;
    public Selector[] tests;

    public SimpleTestImpl(Selector selector) {
        if (selector instanceof Identifier) {
            this.identifier = (Identifier)selector;
            this.kind = 0;
            return;
        }
        if (!(selector instanceof Operator)) {
            throw new IllegalArgumentException();
        }
        Operator operator = (Operator)selector;
        switch (operator.getOp()) {
            case 4: 
            case 5: {
                this.identifier = (Identifier)operator.getOperands()[0];
                this.kind = 3;
                this.tests = new Selector[]{selector};
                return;
            }
            case 1: {
                if (operator.getOperands()[0] instanceof Identifier) {
                    this.identifier = (Identifier)operator.getOperands()[0];
                    this.kind = 1;
                    return;
                }
                Operator operator2 = (Operator)operator.getOperands()[0];
                this.identifier = (Identifier)operator2.getOperands()[0];
                if (operator2.getOp() == 4 || operator2.getOp() == 5) {
                    this.kind = 3;
                    this.tests = new Selector[]{selector};
                    return;
                }
                if (operator2.getOp() == 3) {
                    this.kind = 5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                this.identifier = (Identifier)operator.getOperands()[0];
                this.kind = 4;
                return;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                operator = SimpleTestImpl.simpleComparison(operator);
                this.identifier = (Identifier)operator.getOperands()[0];
                Object object = Matching.getEvaluator().eval(operator.getOperands()[1]);
                if (operator.getOp() == 45) {
                    this.kind = 2;
                    this.value = object;
                } else if (object instanceof String) {
                    this.kind = 3;
                    this.tests = new Selector[]{operator};
                } else {
                    this.recordNumericComparison(operator.getOp(), (Number)object);
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void recordNumericComparison(int n, Number number) {
        this.kind = 6;
        switch (n) {
            case 42: {
                this.upper = number;
                return;
            }
            case 41: {
                this.lower = number;
                return;
            }
            case 44: {
                this.upper = number;
                this.upIncl = true;
                return;
            }
            case 43: {
                this.lower = number;
                this.lowIncl = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Operator simpleComparison(Operator operator) {
        Selector selector;
        int n = operator.getOp();
        Selector selector2 = operator.getOperands()[0];
        Selector selector3 = operator.getOperands()[1];
        if (selector2.getNumIds() == 0) {
            selector = selector3;
            selector3 = selector2;
            selector2 = selector;
            n = SimpleTestImpl.invertComparison(n);
        }
        while (!(selector2 instanceof Identifier)) {
            int n2;
            Selector selector4;
            selector = (Operator)selector2;
            if (selector.getOp() == 2) {
                n = SimpleTestImpl.invertComparison(n);
                selector2 = selector.getOperands()[0];
                selector3 = new OperatorImpl(2, selector3);
                continue;
            }
            if (selector.getOperands()[0].getNumIds() == 0) {
                switch (selector.getOp()) {
                    case 48: 
                    case 50: {
                        break;
                    }
                    case 49: {
                        n = SimpleTestImpl.invertComparison(n);
                        selector3 = new OperatorImpl(2, selector3);
                        break;
                    }
                    case 51: {
                        n = SimpleTestImpl.invertComparison(n);
                        selector3 = new OperatorImpl(51, new LiteralImpl(new Integer(1)), selector3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                selector4 = selector.getOperands()[0];
                selector2 = selector.getOperands()[1];
            } else {
                selector4 = selector.getOperands()[1];
                selector2 = selector.getOperands()[0];
            }
            switch (selector.getOp()) {
                case 48: {
                    n2 = 49;
                    break;
                }
                case 50: {
                    n2 = 51;
                    break;
                }
                case 49: {
                    n2 = 48;
                    break;
                }
                case 51: {
                    n2 = 50;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            selector3 = new OperatorImpl(n2, selector3, selector4);
        }
        return new OperatorImpl(n, selector2, selector3);
    }

    private static int invertComparison(int n) {
        switch (n) {
            case 40: 
            case 45: {
                return n;
            }
            case 42: {
                return 41;
            }
            case 41: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 43: {
                return 44;
            }
        }
        throw new IllegalArgumentException();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean combine(SimpleTest simpleTest) {
        switch (this.kind) {
            case 0: 
            case 1: 
            case 4: {
                return this.kind == simpleTest.getKind();
            }
            case 5: {
                this.absorb(simpleTest);
                return true;
            }
            case 2: {
                if (simpleTest.getKind() == 2) {
                    return this.value.equals(simpleTest.getValue());
                }
                if (simpleTest.getKind() == 3) {
                    return this.selects((String)this.value, simpleTest.getTests());
                }
                return simpleTest.getKind() == 5;
            }
            case 3: {
                if (simpleTest.getKind() == 3) {
                    this.tests = this.append(this.tests, simpleTest.getTests());
                    return true;
                }
                if (simpleTest.getKind() == 2) {
                    if (this.selects((String)simpleTest.getValue(), this.tests)) {
                        this.absorb(simpleTest);
                        return true;
                    }
                    return false;
                }
                return simpleTest.getKind() == 5;
            }
            case 6: {
                if (simpleTest.getKind() == 6) {
                    return this.combineNumeric(simpleTest);
                }
                return simpleTest.getKind() == 5;
            }
        }
        throw new IllegalArgumentException();
    }

    private void absorb(SimpleTest simpleTest) {
        this.identifier = simpleTest.getIdentifier();
        this.kind = simpleTest.getKind();
        this.value = simpleTest.getValue();
        this.tests = simpleTest.getTests();
        this.upper = simpleTest.getUpper();
        this.lower = simpleTest.getLower();
        this.upIncl = simpleTest.isUpIncl();
        this.lowIncl = simpleTest.isLowIncl();
    }

    private Selector[] append(Selector[] selectorArray, Selector[] selectorArray2) {
        Selector[] selectorArray3 = new Selector[selectorArray.length + selectorArray2.length];
        System.arraycopy(selectorArray, 0, selectorArray3, 0, selectorArray.length);
        System.arraycopy(selectorArray2, 0, selectorArray3, selectorArray.length, selectorArray2.length);
        return selectorArray3;
    }

    private boolean selects(String string, Selector[] selectorArray) {
        OneIdentifierContext oneIdentifierContext = new OneIdentifierContext(string);
        EvalCacheImpl evalCacheImpl = new EvalCacheImpl();
        try {
            for (int i = 0; i < selectorArray.length; ++i) {
                Boolean bl = (Boolean)Matching.getEvaluator().eval(selectorArray[i], (MatchSpaceKey)oneIdentifierContext, (EvalCache)evalCacheImpl, false);
                if (bl != null && bl.booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.matchspace.selector.impl.SimpleTest.selects", (String)"497", (Object)this);
            throw new IllegalStateException();
        }
    }

    private boolean combineNumeric(SimpleTest simpleTest) {
        boolean bl;
        Number number;
        int n;
        boolean bl2;
        Number number2;
        if (this.upper == null) {
            number2 = simpleTest.getUpper();
            bl2 = simpleTest.isUpIncl();
        } else if (simpleTest.getUpper() == null) {
            number2 = this.upper;
            bl2 = this.upIncl;
        } else {
            n = EvaluatorImpl.compare(this.upper, simpleTest.getUpper());
            if (n < 0) {
                number2 = this.upper;
                bl2 = this.upIncl;
            } else if (n == 0) {
                number2 = this.upper;
                bl2 = this.upIncl & simpleTest.isUpIncl();
            } else {
                number2 = simpleTest.getUpper();
                bl2 = simpleTest.isUpIncl();
            }
        }
        if (this.lower == null) {
            number = simpleTest.getLower();
            bl = simpleTest.isLowIncl();
        } else if (simpleTest.getLower() == null) {
            number = this.lower;
            bl = this.lowIncl;
        } else {
            n = EvaluatorImpl.compare(this.lower, simpleTest.getLower());
            if (n > 0) {
                number = this.lower;
                bl = this.lowIncl;
            } else if (n == 0) {
                number = this.lower;
                bl = this.lowIncl & simpleTest.isLowIncl();
            } else {
                number = simpleTest.getLower();
                bl = simpleTest.isLowIncl();
            }
        }
        if (number != null && number2 != null) {
            n = EvaluatorImpl.compare(number, number2);
            if (n > 0) {
                return false;
            }
            if (n == 0) {
                if (!bl || !bl2) {
                    return false;
                }
                this.kind = 2;
                this.value = number2;
                this.lower = null;
                this.upper = null;
                this.lowIncl = false;
                this.upIncl = false;
                return true;
            }
        }
        this.upper = number2;
        this.lower = number;
        this.upIncl = bl2;
        this.lowIncl = bl;
        return true;
    }

    public String toString() {
        return this.toSelector().toString();
    }

    public Selector toSelector() {
        switch (this.kind) {
            case 0: {
                return this.identifier;
            }
            case 1: {
                return new OperatorImpl(1, (Selector)this.identifier);
            }
            case 4: {
                return new OperatorImpl(3, (Selector)this.identifier);
            }
            case 5: {
                return new OperatorImpl(1, new OperatorImpl(3, (Selector)this.identifier));
            }
            case 2: {
                return new OperatorImpl(45, (Selector)this.identifier, new LiteralImpl(this.value));
            }
            case 3: {
                Object object = null;
                for (int i = 0; i < this.tests.length; ++i) {
                    object = object == null ? this.tests[i] : new OperatorImpl(46, (Selector)object, this.tests[i]);
                }
                return object;
            }
            case 6: {
                if (this.upper == null) {
                    if (this.lowIncl) {
                        return new OperatorImpl(43, (Selector)this.identifier, new LiteralImpl(this.lower));
                    }
                    return new OperatorImpl(41, (Selector)this.identifier, new LiteralImpl(this.lower));
                }
                if (this.lower == null) {
                    if (this.upIncl) {
                        return new OperatorImpl(44, (Selector)this.identifier, new LiteralImpl(this.upper));
                    }
                    return new OperatorImpl(42, (Selector)this.identifier, new LiteralImpl(this.upper));
                }
                return new OperatorImpl(46, new OperatorImpl(this.lowIncl ? 43 : 41, (Selector)this.identifier, new LiteralImpl(this.lower)), new OperatorImpl(this.upIncl ? 44 : 42, (Selector)this.identifier, new LiteralImpl(this.upper)));
            }
        }
        throw new IllegalArgumentException();
    }

    boolean shedSubtests(List list) {
        if (this.kind != 3) {
            return true;
        }
        Operator operator = null;
        for (int i = 0; i < this.tests.length; ++i) {
            Operator operator2 = (Operator)this.tests[i];
            if (operator == null && operator2 instanceof LikeOperatorImpl && !((LikeOperatorImpl)operator2).getInternalPattern().hasMidClauses()) {
                operator = operator2;
                continue;
            }
            list.add(operator2);
        }
        if (operator == null) {
            return false;
        }
        this.tests = new Selector[]{operator};
        return true;
    }

    public int getKind() {
        return this.kind;
    }

    public Number getLower() {
        return this.lower;
    }

    public boolean isLowIncl() {
        return this.lowIncl;
    }

    public Selector[] getTests() {
        return this.tests;
    }

    public boolean isUpIncl() {
        return this.upIncl;
    }

    public Number getUpper() {
        return this.upper;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    private static final class OneIdentifierContext
    implements MatchSpaceKey {
        String value;

        OneIdentifierContext(String string) {
            this.value = string;
        }

        public Object getIdentifierValue(Identifier identifier, boolean bl) {
            return this.value;
        }
    }
}

