/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.IdentifierImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SelectorImpl
implements Selector,
Cloneable {
    public int type;
    public int uniqueId;
    private int refCount;
    public int numIds;

    public boolean mayBeBoolean() {
        if (this.type == 0) {
            this.type = -6;
        }
        return this.type == -6;
    }

    public boolean mayBeString() {
        if (this.type == 0) {
            this.type = -5;
        }
        return this.type == -5;
    }

    public boolean mayBeNumeric() {
        if (this.type == 0) {
            this.type = 1;
        }
        return this.type == 1 || this.type >= -4 && this.type <= -1;
    }

    public boolean mayBeObject() {
        if (this.type == 0) {
            this.type = -7;
        }
        return this.type == -7;
    }

    public Selector intern(Selector.InternTable internTable) {
        Selector selector = (Selector)internTable.get((Object)this);
        if (selector != null) {
            selector.incRefCount();
            return selector;
        }
        this.uniqueId = internTable.getNextUniqueId();
        ++this.refCount;
        internTable.put((Object)this, (Object)this);
        return this;
    }

    public void unintern(Selector.InternTable internTable) {
        Object object;
        --this.refCount;
        if (this.refCount < 0) {
            throw new IllegalStateException();
        }
        if (this.refCount == 0 && (object = internTable.remove((Object)this)) == null) {
            throw new IllegalStateException();
        }
    }

    public static Selector decode(ObjectInput objectInput) throws IOException {
        if (objectInput.readByte() != 1) {
            throw new IOException();
        }
        try {
            return SelectorImpl.decodeSubtree(objectInput);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.matchspace.selector.impl.Selector.decode", (String)"309", (Object)objectInput);
            throw new IllegalArgumentException();
        }
    }

    static Selector decodeSubtree(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        byte by = objectInput.readByte();
        if (by < 0) {
            return new LiteralImpl(objectInput);
        }
        if (by == 0) {
            return new IdentifierImpl(objectInput);
        }
        if (by == 4) {
            return new LikeOperatorImpl(objectInput);
        }
        return new OperatorImpl(objectInput);
    }

    public void encode(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        this.encodeSelf(objectOutput);
    }

    public boolean equals(Object object) {
        if (object instanceof Selector) {
            Selector selector = (Selector)object;
            return this.type == selector.getType() && this.numIds == selector.getNumIds();
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.matchspace.selector.impl.Selector.decode", (String)"372", (Object)this);
            throw new IllegalStateException();
        }
    }

    public int getNumIds() {
        return this.numIds;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public int getType() {
        return this.type;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int n) {
        this.uniqueId = n;
    }
}

