/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SelectorImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OperatorImpl
extends SelectorImpl
implements Operator {
    public int op;
    public Selector[] operands;
    private int hashcode;
    private boolean hashCodeCached;

    public OperatorImpl(int n, Selector selector) {
        this.op = n;
        this.operands = new Selector[]{selector};
        this.assignType();
        if (this.type == 2) {
            return;
        }
        this.numIds = selector.getNumIds();
        if (this.numIds == 0 && selector instanceof Operator) {
            this.operands[0] = new LiteralImpl(Matching.getEvaluator().eval(selector));
        }
    }

    public OperatorImpl(int n, Selector selector, Selector selector2) {
        this.op = n;
        this.operands = new Selector[]{selector, selector2};
        this.assignType();
        if (this.type == 2) {
            return;
        }
        if (selector.getNumIds() == 0 && selector instanceof Operator) {
            this.operands[0] = new LiteralImpl(Matching.getEvaluator().eval(selector));
        }
        if (selector2.getNumIds() == 0 && selector2 instanceof Operator) {
            this.operands[1] = new LiteralImpl(Matching.getEvaluator().eval(selector2));
        }
        this.numIds = selector.getNumIds() + selector2.getNumIds();
    }

    public OperatorImpl(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n;
        this.op = objectInput.readByte();
        this.operands = new SelectorImpl[this.op >= 40 ? 2 : 1];
        for (n = 0; n < this.operands.length; ++n) {
            this.operands[n] = SelectorImpl.decodeSubtree(objectInput);
        }
        this.assignType();
        if (this.type == 2) {
            return;
        }
        for (n = 0; n < this.operands.length; ++n) {
            Selector selector = this.operands[n];
            if (selector.getNumIds() == 0 && selector instanceof Operator) {
                this.operands[n] = new LiteralImpl(Matching.getEvaluator().eval(selector));
            }
            this.numIds += selector.getNumIds();
        }
    }

    public void assignType() {
        switch (this.op) {
            case 1: {
                this.type = this.operands[0].mayBeBoolean() ? -6 : 2;
                break;
            }
            case 2: {
                this.type = this.operands[0].mayBeNumeric() ? this.operands[0].getType() : 2;
                break;
            }
            case 3: {
                if (this.operands[0] instanceof Identifier) {
                    this.type = -6;
                    break;
                }
                this.type = 2;
                break;
            }
            case 4: {
                this.type = this.operands[0].mayBeString() ? -6 : 2;
                break;
            }
            case 5: {
                this.type = this.operands[0].getType() == 3 ? -6 : 2;
                break;
            }
            case 40: 
            case 45: {
                int n = this.operands[0].getType();
                int n2 = this.operands[1].getType();
                if (n >= -4 && n <= -1) {
                    n = 1;
                }
                if (n2 >= -4 && n2 <= -1) {
                    n2 = 1;
                }
                if (n == 3) {
                    n = -5;
                }
                if (n2 == 3) {
                    n2 = -5;
                }
                if (n == 0) {
                    n = n2;
                    this.operands[0].setType(n2);
                } else if (n2 == 0) {
                    n2 = n;
                    this.operands[1].setType(n);
                }
                this.type = n == n2 ? -6 : 2;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.type = this.operands[0].mayBeNumeric() && this.operands[1].mayBeNumeric() ? -6 : 2;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                if (!this.operands[0].mayBeNumeric() || !this.operands[1].mayBeNumeric()) {
                    this.type = 2;
                    break;
                }
                this.type = this.operands[0].getType() > this.operands[1].getType() ? this.operands[0].getType() : this.operands[1].getType();
                break;
            }
            case 46: 
            case 47: {
                this.type = this.operands[0].mayBeBoolean() && this.operands[1].mayBeBoolean() ? -6 : 2;
                break;
            }
            default: {
                this.type = 2;
            }
        }
    }

    public void encodeSelf(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte((byte)this.op);
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i].encodeSelf(objectOutput);
        }
    }

    public Selector intern(Selector.InternTable internTable) {
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i] = this.operands[i].intern(internTable);
        }
        return super.intern(internTable);
    }

    public void unintern(Selector.InternTable internTable) {
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i].unintern(internTable);
        }
        super.unintern(internTable);
    }

    public boolean equals(Object object) {
        if (object instanceof Operator && super.equals(object)) {
            Operator operator = (Operator)object;
            if (this.op != operator.getOp()) {
                return false;
            }
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].equals(operator.getOperands()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeCached) {
            return this.hashcode;
        }
        int n = this.op;
        for (int i = 0; i < this.operands.length; ++i) {
            n = (n << 9) + this.operands[i].hashCode();
        }
        this.hashCodeCached = true;
        this.hashcode = n;
        return n;
    }

    public Object clone() {
        Operator operator = (Operator)super.clone();
        for (int i = 0; i < this.operands.length; ++i) {
            operator.setOperand(i, (Selector)this.operands[i].clone());
        }
        return operator;
    }

    public String toString() {
        String string = null;
        int n = this.precedence(this);
        String string2 = this.operands[0].toString();
        if (this.precedence(this.operands[0]) > n) {
            string2 = "(" + string2 + ")";
        }
        String string3 = null;
        if (this.operands.length > 1) {
            string3 = this.operands[1].toString();
            if (this.precedence(this.operands[1]) > n) {
                string3 = "(" + string3 + ")";
            }
        }
        switch (this.op) {
            case 1: {
                return "NOT " + string2;
            }
            case 2: {
                return "-" + string2;
            }
            case 3: {
                return string2 + " IS NULL";
            }
            case 40: {
                string = "<>";
                break;
            }
            case 41: {
                string = ">";
                break;
            }
            case 42: {
                string = "<";
                break;
            }
            case 43: {
                string = ">=";
                break;
            }
            case 44: {
                string = "<=";
                break;
            }
            case 45: {
                string = "=";
                break;
            }
            case 46: {
                string = " AND ";
                break;
            }
            case 47: {
                string = " OR ";
                break;
            }
            case 48: {
                string = "+";
                break;
            }
            case 49: {
                string = "-";
                break;
            }
            case 50: {
                string = "*";
                break;
            }
            case 51: {
                string = "/";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return string2 + string + string3;
    }

    private int precedence(Selector selector) {
        if (!(selector instanceof Operator)) {
            return 0;
        }
        Operator operator = (Operator)selector;
        if (operator.getOp() < 40) {
            return 0;
        }
        switch (operator.getOp()) {
            case 50: 
            case 51: {
                return 1;
            }
            case 48: 
            case 49: {
                return 2;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 3;
            }
            case 46: {
                return 4;
            }
        }
        return 5;
    }

    public int getOp() {
        return this.op;
    }

    public Selector[] getOperands() {
        return this.operands;
    }

    public void setOperand(int n, Selector selector) {
        this.operands[n] = selector;
    }
}

