/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.LikeOperator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.Pattern;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class LikeOperatorImpl
extends OperatorImpl
implements LikeOperator {
    public String strPattern;
    public char escape;
    public boolean escaped = false;
    public Pattern pattern;

    public LikeOperatorImpl(int n, Selector selector, Pattern pattern, String string, boolean bl, char c) {
        super(n, selector);
        this.pattern = pattern;
        this.strPattern = string;
        this.escaped = bl;
        this.escape = c;
    }

    public LikeOperatorImpl(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super(objectInput);
        this.strPattern = objectInput.readUTF();
        this.escaped = objectInput.readBoolean();
        if (this.escaped) {
            this.escape = objectInput.readChar();
        }
        this.pattern = (Pattern)Pattern.parsePattern(this.strPattern, this.escaped, this.escape);
    }

    public void encodeSelf(ObjectOutput objectOutput) throws IOException {
        super.encodeSelf(objectOutput);
        objectOutput.writeBoolean(this.escaped);
        if (this.escaped) {
            objectOutput.writeChar(this.escape);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LikeOperator) {
            LikeOperator likeOperator = (LikeOperator)object;
            return super.equals(object) && this.pattern.equals(likeOperator.getPattern()) && this.escaped == likeOperator.isEscaped() && this.escape == likeOperator.getEscape();
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.pattern.hashCode();
    }

    public String toString() {
        return this.operands[0] + " LIKE '" + this.strPattern + "'" + (this.escaped ? " ESCAPE '" + this.escape + "'" : "");
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public Pattern getInternalPattern() {
        return this.pattern;
    }
}

