/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.InvalidTopicSyntaxException;
import com.ibm.ws.sib.matchspace.MatchSpace;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.BooleanMatcher;
import com.ibm.ws.sib.matchspace.impl.CacheingSearchResults;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.EqualityMatcher;
import com.ibm.ws.sib.matchspace.impl.Factory;
import com.ibm.ws.sib.matchspace.impl.InternTable;
import com.ibm.ws.sib.matchspace.impl.MatchCache;
import com.ibm.ws.sib.matchspace.impl.NumericMatcher;
import com.ibm.ws.sib.matchspace.impl.StringMatcher;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintWriter;

public class MatchSpaceImpl
implements MatchSpace,
MatchCache.RehashFilter {
    private static final TraceComponent tc = SibTr.register((Class)MatchSpaceImpl.class, (String)"SIBMatchSpace", (String)"com.ibm.ws.sib.matchspace.CWSIHMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.matchspace.CWSIHMessages");
    private static final int MATCH_CACHE_INITIAL_CAPACITY = 10000;
    private MatchCache matchCache;
    private volatile long matchTreeGeneration = 0L;
    private ContentMatcher matchTree;
    Identifier rootId;
    InternTable subExpr = new InternTable();
    private int exactPuts;
    private int wildPuts;
    private int resultCacheHitGets;
    private int wildCacheHitGets;
    private int wildCacheMissGets;
    private int exactMatches;
    private int resultsCached;
    private int removals;
    private int cacheCreates;
    private int cacheRemoves;
    private int optimisticGets;
    private int pessimisticGets;
    private int puntsDueToCache;

    public MatchSpaceImpl(Identifier identifier, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MatchSpaceImpl", (Object)new Object[]{identifier, new Boolean(bl)});
        }
        switch (identifier.getType()) {
            case -7: 
            case 0: {
                this.matchTree = new EqualityMatcher(identifier);
                break;
            }
            case -5: 
            case 3: {
                this.matchTree = new StringMatcher(identifier);
                break;
            }
            case -6: {
                this.matchTree = new BooleanMatcher(identifier);
                break;
            }
            default: {
                this.matchTree = new NumericMatcher(identifier);
            }
        }
        if (bl) {
            this.rootId = identifier;
            this.matchCache = new MatchCache(10000);
            this.matchCache.setRehashFilter(this);
            ((EqualityMatcher)this.matchTree).setCacheing(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MatchSpaceImpl", (Object)this);
        }
    }

    public synchronized void addTarget(Conjunction conjunction, MatchTarget matchTarget) throws MatchingException {
        SimpleTest simpleTest;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTarget", (Object)new Object[]{conjunction, matchTarget});
        }
        if (this.rootId != null && (simpleTest = Factory.findTest(0, conjunction)) != null && simpleTest.getKind() == 2) {
            CacheEntry cacheEntry = this.getCacheEntry(simpleTest.getValue(), true);
            ++cacheEntry.exactGeneration;
            ContentMatcher contentMatcher = cacheEntry.exactMatcher;
            cacheEntry.exactMatcher = contentMatcher = Factory.createMatcher(0, conjunction, contentMatcher);
            cacheEntry.cachedResults = null;
            try {
                contentMatcher.put(conjunction, matchTarget, this.subExpr);
                cacheEntry.noResultCache |= contentMatcher.hasTests();
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.addTarget", (String)"206", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)cacheEntry);
                }
                throw new MatchingException((Exception)runtimeException);
            }
            finally {
                ++cacheEntry.exactGeneration;
            }
            ++this.exactPuts;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTarget");
            }
            return;
        }
        ++this.matchTreeGeneration;
        try {
            this.matchTree.put(conjunction, matchTarget, this.subExpr);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.addTarget", (String)"206", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)runtimeException);
            }
            throw new MatchingException((Exception)runtimeException);
        }
        finally {
            ++this.matchTreeGeneration;
        }
        ++this.wildPuts;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTarget");
        }
    }

    public boolean checkTopicSyntax(String string) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(string);
        char[] cArray = string.toCharArray();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '*') {
                if (bl3) {
                    bl6 = true;
                    bl2 = false;
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    bl = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0001", new Object[]{string, new Integer(i + 1)}, null));
            }
            if (c == '.') {
                if (bl2) {
                    bl2 = false;
                    bl5 = false;
                    bl3 = false;
                    bl4 = true;
                    bl = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0002", new Object[]{string, new Integer(i + 1)}, null));
            }
            if (c == '/') {
                if (bl) {
                    if (bl5) {
                        if (i == cArray.length - 1) {
                            throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0003", new Object[]{string, new Integer(i + 1)}, null));
                        }
                        bl = false;
                        bl6 = true;
                        bl2 = true;
                        continue;
                    }
                    bl5 = true;
                    bl4 = true;
                    bl3 = true;
                    bl2 = false;
                    continue;
                }
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0003", new Object[]{string, new Integer(i + 1)}, null));
            }
            if (c == ':') {
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("TEMPORARY_CWSIH9999", new Object[]{" ':' characters are not allowed in topics. A ':' was found at character " + (i + 1)}, null));
            }
            if (!bl4) {
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0004", new Object[]{string, new Integer(i + 1)}, null));
            }
            bl5 = false;
            bl3 = false;
            bl2 = true;
            bl = true;
        }
        return bl6;
    }

    private final void checkTopicNotNull(String string) throws InvalidTopicSyntaxException {
        if (string == null) {
            throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0005", new Object[]{string}, null));
        }
    }

    public void checkEventTopicSyntax(String string) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(string);
        char[] cArray = string.toCharArray();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '*') {
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0006", new Object[]{string}, null));
            }
            if (c == '.') {
                if (bl2) {
                    bl2 = false;
                    bl4 = false;
                    bl3 = true;
                    bl = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0006", new Object[]{string}, null));
            }
            if (c == '/') {
                if (!bl) continue;
                if (bl4) {
                    throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0006", new Object[]{string}, null));
                }
                bl4 = true;
                bl3 = true;
                bl2 = false;
                continue;
            }
            if (c == ':') {
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0006", new Object[]{string}, null));
            }
            if (!bl3) {
                throw new InvalidTopicSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIH0006", new Object[]{string}, null));
            }
            bl4 = false;
            bl2 = true;
            bl = true;
        }
    }

    private CacheEntry getCacheEntry(Object object, boolean bl) throws MatchingException {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCacheEntry", (Object)new Object[]{object, new Boolean(bl), this.matchCache});
        }
        if ((cacheEntry = (CacheEntry)this.matchCache.get(object)) == null && bl) {
            cacheEntry = new CacheEntry();
            this.matchCache.put(object, cacheEntry);
            ++this.cacheCreates;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCacheEntry", (Object)cacheEntry);
        }
        return cacheEntry;
    }

    public boolean shouldRetain(Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"shouldRetain", (Object)new Object[]{object, object2});
        }
        CacheEntry cacheEntry = (CacheEntry)object2;
        if (cacheEntry.exactMatcher != null) {
            return true;
        }
        ++this.cacheRemoves;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void search(Object object, MatchSpaceKey matchSpaceKey, EvalCache evalCache, SearchResults searchResults) throws MatchingException, BadMessageFormatMatchingException {
        Object object2;
        long l;
        long l2;
        CacheEntry cacheEntry;
        block24: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"search", (Object)new Object[]{object, matchSpaceKey, evalCache, searchResults});
            }
            if (object == null && this.rootId != null) {
                object = matchSpaceKey.getIdentifierValue(this.rootId, false);
            }
            cacheEntry = null;
            if (this.rootId != null && (cacheEntry = this.getCacheEntry(object, false)) == null) {
                ++this.puntsDueToCache;
                this.pessimisticGet(object, matchSpaceKey, evalCache, searchResults);
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"search");
                return;
            }
            l2 = this.matchTreeGeneration;
            long l3 = l = cacheEntry == null ? 0L : cacheEntry.exactGeneration;
            if ((l2 & 1L) == 1L || (l & 1L) == 1L) {
                if (cacheEntry == null) {
                    MatchSpaceImpl matchSpaceImpl = this;
                    // MONITORENTER : matchSpaceImpl
                    this.matchTree.get(object, matchSpaceKey, evalCache, searchResults);
                    // MONITOREXIT : matchSpaceImpl
                } else {
                    this.pessimisticGet(object, matchSpaceKey, evalCache, searchResults);
                }
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"search");
                return;
            }
            if (cacheEntry != null && (l2 != cacheEntry.matchTreeGeneration || !cacheEntry.noResultCache && cacheEntry.cachedResults == null)) {
                ++this.puntsDueToCache;
                this.pessimisticGet(object, matchSpaceKey, evalCache, searchResults);
                if (!tc.isEntryEnabled()) return;
                SibTr.exit((TraceComponent)tc, (String)"search");
                return;
            }
            object2 = searchResults;
            // MONITORENTER : object2
            // MONITOREXIT : object2
            object2 = null;
            try {
                if (cacheEntry != null && cacheEntry.cachedResults != null && searchResults.acceptCacheable(cacheEntry.cachedResults)) {
                    ++this.resultCacheHitGets;
                    break block24;
                }
                evalCache.prepareCache(this.subExpr.evalCacheSize());
                if (cacheEntry == null) {
                    this.matchTree.get(object, matchSpaceKey, evalCache, searchResults);
                    break block24;
                }
                if (cacheEntry.otherMatchers != null) {
                    for (int i = 0; i < cacheEntry.otherMatchers.length; ++i) {
                        cacheEntry.otherMatchers[i].get(null, matchSpaceKey, evalCache, searchResults);
                    }
                    ++this.wildCacheHitGets;
                }
                if (cacheEntry.exactMatcher != null) {
                    cacheEntry.exactMatcher.get(null, matchSpaceKey, evalCache, searchResults);
                    ++this.exactMatches;
                }
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.search", (String)"490", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                object2 = runtimeException;
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.search", (String)"501", (Object)this);
                SibTr.exception((TraceComponent)tc, (Throwable)error);
                object2 = error;
            }
        }
        if (l2 != this.matchTreeGeneration || cacheEntry != null && l != cacheEntry.exactGeneration) {
            searchResults.reset();
            if (cacheEntry == null) {
                MatchSpaceImpl matchSpaceImpl = this;
                // MONITORENTER : matchSpaceImpl
                this.matchTree.get(object, matchSpaceKey, evalCache, searchResults);
                // MONITOREXIT : matchSpaceImpl
            } else {
                this.pessimisticGet(object, matchSpaceKey, evalCache, searchResults);
            }
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((TraceComponent)tc, (String)"search");
            return;
        }
        if (object2 != null) {
            if (!tc.isEntryEnabled()) throw new MatchingException(((Throwable)object2).toString());
            SibTr.exit((TraceComponent)tc, (String)"search", (Object)object2);
            throw new MatchingException(((Throwable)object2).toString());
        }
        ++this.optimisticGets;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"search");
    }

    private synchronized void pessimisticGet(Object object, MatchSpaceKey matchSpaceKey, EvalCache evalCache, SearchResults searchResults) throws MatchingException, BadMessageFormatMatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"pessimisticGet", (Object)new Object[]{object, matchSpaceKey, evalCache, searchResults});
        }
        CacheEntry cacheEntry = this.getCacheEntry(object, true);
        if (cacheEntry.matchTreeGeneration != this.matchTreeGeneration) {
            cacheEntry.cachedResults = null;
            cacheEntry.otherMatchers = null;
        }
        if (cacheEntry.cachedResults != null && searchResults.acceptCacheable(cacheEntry.cachedResults)) {
            ++this.resultCacheHitGets;
            ++this.pessimisticGets;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"pessimisticGet");
            }
            return;
        }
        evalCache.prepareCache(this.subExpr.evalCacheSize());
        if (cacheEntry.otherMatchers != null) {
            for (int i = 0; i < cacheEntry.otherMatchers.length; ++i) {
                try {
                    cacheEntry.otherMatchers[i].get(null, matchSpaceKey, evalCache, searchResults);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (String)"587", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                    throw new MatchingException((Exception)runtimeException);
                }
            }
            ++this.wildCacheHitGets;
        } else if (this.matchTree != null) {
            CacheingSearchResults cacheingSearchResults = new CacheingSearchResults(searchResults);
            try {
                this.matchTree.get(object, matchSpaceKey, evalCache, cacheingSearchResults);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (String)"609", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                throw new MatchingException((Exception)runtimeException);
            }
            cacheEntry.otherMatchers = cacheingSearchResults.getMatchers();
            cacheEntry.matchTreeGeneration = this.matchTreeGeneration;
            cacheEntry.noResultCache |= cacheingSearchResults.hasContent;
            ++this.wildCacheMissGets;
        }
        if (cacheEntry.exactMatcher != null) {
            try {
                cacheEntry.exactMatcher.get(null, matchSpaceKey, evalCache, searchResults);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (String)"631", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                throw new MatchingException((Exception)runtimeException);
            }
            ++this.exactMatches;
        }
        if (!cacheEntry.noResultCache) {
            cacheEntry.cachedResults = searchResults.provideCacheable(object);
            if (cacheEntry.cachedResults != null) {
                ++this.resultsCached;
            }
        }
        ++this.pessimisticGets;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"pessimisticGet");
        }
    }

    public synchronized void removeTarget(Conjunction conjunction, MatchTarget matchTarget) throws MatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTarget", (Object)new Object[]{conjunction, matchTarget, this.matchCache});
        }
        SimpleTest simpleTest = Factory.findTest(0, conjunction);
        if (this.rootId == null || simpleTest == null || simpleTest.getKind() != 2) {
            if (this.matchTree == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeTarget", (Object)"matchTree == null");
                }
                throw new MatchingException();
            }
            ++this.matchTreeGeneration;
            try {
                this.matchTree.remove(conjunction, matchTarget, this.subExpr, 0);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.removeTarget", (String)"706", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeTarget", (Object)runtimeException);
                }
                throw new MatchingException((Exception)runtimeException);
            }
            finally {
                ++this.matchTreeGeneration;
            }
        }
        CacheEntry cacheEntry = (CacheEntry)this.matchCache.get(simpleTest.getValue());
        if (cacheEntry == null || cacheEntry.exactMatcher == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeTarget", (Object)"MatchingException");
            }
            throw new MatchingException();
        }
        ++cacheEntry.exactGeneration;
        try {
            cacheEntry.exactMatcher = cacheEntry.exactMatcher.remove(conjunction, matchTarget, this.subExpr, 0);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.removeTarget", (String)"737", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
            ++cacheEntry.exactGeneration;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeTarget", (Object)"MatchingException");
            }
            throw new MatchingException((Exception)runtimeException);
        }
        if (cacheEntry.exactMatcher == null && (cacheEntry.otherMatchers == null || cacheEntry.matchTreeGeneration != this.matchTreeGeneration || cacheEntry.otherMatchers.length == 0)) {
            this.matchCache.remove(simpleTest.getValue());
            ++this.cacheRemoves;
        }
        cacheEntry.cachedResults = null;
        ++cacheEntry.exactGeneration;
        ++this.removals;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTarget");
        }
    }

    public void statistics(PrintWriter printWriter) {
        int n = this.pessimisticGets - this.puntsDueToCache;
        printWriter.println("Exact puts: " + this.exactPuts + ", Wildcard generation: " + this.matchTreeGeneration + ", Wildcard puts: " + this.wildPuts + ", Wildcard-Cache-hit gets: " + this.wildCacheHitGets + ", Wildcard-Cache-miss gets: " + this.wildCacheMissGets + ", Result-Cache-hit gets: " + this.resultCacheHitGets + ", Exact matches: " + this.exactMatches + ", Results cached: " + this.resultsCached + ", Removals:" + this.removals + ", Cache entries created:" + this.cacheCreates + ", Cache entries removed:" + this.cacheRemoves + ", Optimistic gets:" + this.optimisticGets + ", True Pessimistic gets:" + n + ", Mutating gets:" + this.puntsDueToCache);
    }

    public synchronized void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clear");
        }
        this.matchTree = null;
        this.matchTreeGeneration = 0L;
        this.subExpr.clear();
        this.matchCache = new MatchCache(10000);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.matchspace.impl/src/com/ibm/ws/sib/matchspace/impl/MatchSpaceImpl.java, SIB.matchspace, WAS602.SIB, o0610.11 1.29");
        }
    }

    private class CacheEntry {
        ContentMatcher exactMatcher;
        volatile long exactGeneration;
        ContentMatcher[] otherMatchers;
        long matchTreeGeneration;
        Object cachedResults;
        boolean noResultCache;

        private CacheEntry() {
        }
    }
}

