/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.InternTable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public final class DifficultMatcher
extends ContentMatcher {
    private static final TraceComponent tc = SibTr.register((Class)DifficultMatcher.class, (String)"SIBMatchSpace", (String)"com.ibm.ws.sib.matchspace.CWSIHMessages");
    private static final int INIT_MTTL_SIZE = 0;
    List roots;
    List objs;
    MatchTargetTypeList alwaysMatch;
    public static int totalDifficultEntries = 0;

    public DifficultMatcher(int n) {
        super(n);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DifficultMatcher", (Object)("pid: " + new Integer(n)));
        }
        this.roots = new ArrayList(2);
        this.objs = new ArrayList(2);
        this.alwaysMatch = new MatchTargetTypeList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DifficultMatcher");
        }
    }

    public void put(Conjunction conjunction, MatchTarget matchTarget, InternTable internTable) throws MatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{conjunction, matchTarget, internTable});
        }
        if (conjunction == null || this.noEligibleTests(conjunction)) {
            MatchTargetTypeList matchTargetTypeList;
            Selector selector;
            Selector selector2 = selector = conjunction == null ? null : conjunction.getResidual();
            if (selector == null) {
                matchTargetTypeList = this.alwaysMatch;
            } else {
                selector = selector.intern((Selector.InternTable)internTable);
                totalDifficultEntries = internTable.size();
                int n = this.roots.indexOf(selector);
                if (n == -1) {
                    MatchTargetTypeList matchTargetTypeList2;
                    matchTargetTypeList = matchTargetTypeList2 = new MatchTargetTypeList();
                    this.objs.add(matchTargetTypeList2);
                    this.roots.add(selector);
                } else {
                    matchTargetTypeList = (MatchTargetTypeList)this.objs.get(n);
                }
            }
            matchTargetTypeList.addTarget(matchTarget);
        } else {
            super.put(conjunction, matchTarget, internTable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    private boolean noEligibleTests(Conjunction conjunction) {
        for (int i = 0; i < conjunction.getSimpleTests().length; ++i) {
            if (conjunction.getSimpleTests()[i].getIdentifier().getOrdinalPosition() <= this.ordinalPosition) continue;
            return false;
        }
        return true;
    }

    public void get(Object object, MatchSpaceKey matchSpaceKey, EvalCache evalCache, SearchResults searchResults) throws MatchingException, BadMessageFormatMatchingException {
        List[] listArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)("msg: " + matchSpaceKey + ", result: " + searchResults));
        }
        if ((listArray = this.alwaysMatch.lists).length > 0) {
            searchResults.addObjects(listArray);
        }
        if (matchSpaceKey != null) {
            int n = this.roots.size();
            for (int i = 0; i < n; ++i) {
                Boolean bl = (Boolean)Matching.getEvaluator().eval((Selector)this.roots.get(i), matchSpaceKey, evalCache, false);
                if (bl == null || !bl.booleanValue()) continue;
                MatchTargetTypeList matchTargetTypeList = (MatchTargetTypeList)this.objs.get(i);
                listArray = matchTargetTypeList.lists;
                if (listArray.length <= 0) continue;
                searchResults.addObjects(listArray);
            }
        }
        super.get(null, matchSpaceKey, evalCache, searchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get");
        }
    }

    public ContentMatcher remove(Conjunction conjunction, MatchTarget matchTarget, InternTable internTable, int n) throws MatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)("selector: " + conjunction + ", object: " + matchTarget));
        }
        if (this.objs == null) {
            throw new IllegalStateException();
        }
        if (conjunction == null || this.noEligibleTests(conjunction)) {
            int n2 = this.objs.size();
            boolean bl = false;
            for (int i = 0; !bl && i < n2; ++i) {
                MatchTargetTypeList matchTargetTypeList = (MatchTargetTypeList)this.objs.get(i);
                bl = matchTargetTypeList.deleteTarget(matchTarget);
                if (!bl) continue;
                Selector selector = (Selector)this.roots.get(i);
                if (selector == null) {
                    throw new IllegalStateException();
                }
                selector.unintern((Selector.InternTable)internTable);
                if (matchTargetTypeList.size() != 0) continue;
                this.objs.remove(i);
                this.roots.remove(i);
            }
            if (!bl && !(bl = this.alwaysMatch.deleteTarget(matchTarget))) {
                throw new IllegalStateException();
            }
        } else {
            super.remove(conjunction, matchTarget, internTable, this.ordinalPosition);
        }
        ContentMatcher contentMatcher = this;
        if (this.roots.size() == 0 && this.alwaysMatch.size() == 0) {
            contentMatcher = this.vacantChild;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)("result: " + contentMatcher));
        }
        return contentMatcher;
    }

    boolean hasTests() {
        return this.roots.size() > 0 || this.vacantChild != null;
    }

    private class MatchTargetTypeList {
        List[] lists = new List[0];

        MatchTargetTypeList() {
        }

        public void addTarget(MatchTarget matchTarget) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"addTarget", (Object)("target: " + matchTarget));
            }
            int n = matchTarget.type();
            this.resize(n);
            if (this.lists[n] == null) {
                this.lists[n] = new ArrayList(2);
            }
            matchTarget.setIndex(this.lists[n].size());
            this.lists[n].add(matchTarget);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTarget");
            }
        }

        public boolean deleteTarget(MatchTarget matchTarget) {
            int n;
            List list;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"addTarget", (Object)("target: " + matchTarget));
            }
            int n2 = matchTarget.type();
            boolean bl = false;
            if (n2 < this.lists.length && (list = this.lists[n2]) != null && (n = matchTarget.getIndex()) < list.size() && matchTarget == list.get(n)) {
                if (list.size() == 1) {
                    list.clear();
                } else {
                    MatchTarget matchTarget2 = (MatchTarget)list.get(list.size() - 1);
                    matchTarget2.setIndex(n);
                    list.set(n, matchTarget2);
                    list.remove(list.size() - 1);
                }
                if (list.isEmpty()) {
                    this.lists[n2] = null;
                    if (n2 == this.lists.length - 1) {
                        int n3;
                        for (n3 = this.lists.length; n3 > 0 && this.lists[n3 - 1] == null; --n3) {
                        }
                        if (n3 > 0) {
                            List[] listArray = new List[n3];
                            System.arraycopy(this.lists, 0, listArray, 0, n3);
                            this.lists = listArray;
                        } else {
                            this.lists = new List[0];
                        }
                    }
                }
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteTarget", (Object)("result: " + new Boolean(bl)));
            }
            return bl;
        }

        public List getTypeList(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getTypeList", (Object)("type: " + new Integer(n)));
            }
            List list = null;
            if (n < this.lists.length) {
                list = this.lists[n];
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getTypeList", (Object)("result: " + list));
            }
            return list;
        }

        private void resize(int n) {
            int n2;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"resize", (Object)("maxType: " + new Integer(n)));
            }
            if ((n2 = this.lists.length) <= n) {
                List[] listArray = new List[n + 1];
                System.arraycopy(this.lists, 0, listArray, 0, n2);
                this.lists = listArray;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resize");
            }
        }

        public int size() {
            return this.lists.length;
        }
    }
}

