/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import java.util.ArrayList;
import java.util.List;

public class CheapRangeTable {
    public static int numTables = 0;
    public static int numEntries = 0;
    int size = 0;
    RangeEntry[] ranges = new RangeEntry[3];

    public void insert(SimpleTest simpleTest, Object object) {
        if (this.size == this.ranges.length) {
            RangeEntry[] rangeEntryArray = new RangeEntry[2 * this.size];
            System.arraycopy(this.ranges, 0, rangeEntryArray, 0, this.size);
            this.ranges = rangeEntryArray;
        }
        this.ranges[this.size] = new RangeEntry(simpleTest, object);
        ++this.size;
    }

    public Object getExact(SimpleTest simpleTest) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(simpleTest)) continue;
            return this.ranges[i].target;
        }
        return null;
    }

    public void replace(SimpleTest simpleTest, Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(simpleTest)) continue;
            this.ranges[i].target = object;
            return;
        }
        throw new IllegalStateException();
    }

    public List find(Number number) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].contains(number)) continue;
            arrayList.add(this.ranges[i].target);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(SimpleTest simpleTest) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        int n = -1;
        for (int i = 0; n < 0 && i < this.size; ++i) {
            if (!this.ranges[i].correspondsTo(simpleTest)) continue;
            n = i;
        }
        if (n < 0) {
            throw new IllegalStateException();
        }
        System.arraycopy(this.ranges, n + 1, this.ranges, n, this.size - n - 1);
        --this.size;
    }

    class RangeEntry {
        Number lower;
        boolean lowIncl;
        Number upper;
        boolean upIncl;
        Object target;

        RangeEntry(SimpleTest simpleTest, Object object) {
            this.lower = simpleTest.getLower();
            this.lowIncl = simpleTest.isLowIncl();
            this.upper = simpleTest.getUpper();
            this.upIncl = simpleTest.isUpIncl();
            this.target = object;
        }

        boolean correspondsTo(SimpleTest simpleTest) {
            if (this.lowIncl != simpleTest.isLowIncl() || this.upIncl != simpleTest.isUpIncl()) {
                return false;
            }
            if (this.lower == null) {
                if (simpleTest.getLower() != null) {
                    return false;
                }
            } else {
                if (simpleTest.getLower() == null) {
                    return false;
                }
                if (!EvaluatorImpl.equals(this.lower, simpleTest.getLower())) {
                    return false;
                }
            }
            if (this.upper == null) {
                if (simpleTest.getUpper() != null) {
                    return false;
                }
            } else {
                if (simpleTest.getUpper() == null) {
                    return false;
                }
                if (!EvaluatorImpl.equals(this.upper, simpleTest.getUpper())) {
                    return false;
                }
            }
            return true;
        }

        boolean contains(Number number) {
            int n;
            if (this.lower != null && ((n = EvaluatorImpl.compare(this.lower, number)) > 0 || !this.lowIncl && n == 0)) {
                return false;
            }
            return this.upper == null || (n = EvaluatorImpl.compare(this.upper, number)) >= 0 && (this.upIncl || n != 0);
        }
    }
}

