/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class MQUtil
implements MQConstants,
MQFAP {
    private static final TraceComponent tc = SibTr.register((Class)MQUtil.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static String byteBufferToString(WsByteBuffer wsByteBuffer) {
        int n = wsByteBuffer.position();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(wsByteBuffer.toString());
        int n3 = 0;
        while (wsByteBuffer.hasRemaining()) {
            String string;
            int n4;
            if (n3 % 16 == 0) {
                stringBuffer.append("\n");
                String string2 = Integer.toHexString(n2 + n3);
                for (int i = 8; i > string2.length(); --i) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
                stringBuffer.append(": ");
            }
            if ((n4 = wsByteBuffer.get()) < 0) {
                n4 += 256;
            }
            if ((string = Integer.toHexString(n4)).length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
            ++n3;
        }
        stringBuffer.append("\n");
        wsByteBuffer.position(n);
        return stringBuffer.toString();
    }

    public static void reportError(Connection connection, Object object, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportError");
        }
        String string = "MQLink error: ";
        if (connection != null) {
            string = string + "\nConnection:" + connection;
        }
        if (throwable != null) {
            string = string + "\nError:" + throwable;
        }
        if (object != null) {
            string = string + "\nData:\n" + object;
            if (object instanceof WsByteBuffer) {
                string = string + MQUtil.byteBufferToString((WsByteBuffer)object);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Exception being reported on is", (Object)throwable);
        }
        if (tc.isDebugEnabled()) {
            SibTr.error((TraceComponent)tc, (String)"ERR_MQLINK_FAILURE_SICO3237", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportError");
        }
    }

    private static String fixedWidthInt(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        if (string.length() > n2) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String timeToMQDate(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("timeToMQDate " + l));
        }
        String string = "";
        if (l != -1L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(l);
            string = MQUtil.fixedWidthInt(gregorianCalendar.get(1), 4) + "-";
            string = string + MQUtil.fixedWidthInt(gregorianCalendar.get(2), 2) + "-";
            string = string + MQUtil.fixedWidthInt(gregorianCalendar.get(5), 2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"timeToMQDate ", (Object)string);
        }
        return string;
    }

    public static String timeToMQTime(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("timeToMQTime " + l));
        }
        String string = "";
        if (l != -1L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(l);
            string = MQUtil.fixedWidthInt(gregorianCalendar.get(11) - 1, 2) + ".";
            string = string + MQUtil.fixedWidthInt(gregorianCalendar.get(12), 2) + ".";
            string = string + MQUtil.fixedWidthInt(gregorianCalendar.get(13), 2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("timeToMQTime " + string));
        }
        return string;
    }

    public static String getOptions(int n, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = "";
        if (n == 0) {
            string2 = "[";
        } else {
            for (int i = 1; i != 0; i *= 2) {
                int n2 = n & i;
                if (n2 == 0) continue;
                arrayList.add(new Integer(i));
            }
            Class clazz = MQConstants.class;
            Field[] fieldArray = clazz.getFields();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                boolean bl = false;
                for (int i = 0; i < fieldArray.length; ++i) {
                    try {
                        int n4;
                        if (!fieldArray[i].getName().startsWith(string) || fieldArray[i].getName().startsWith(string + "VERSION") || (n4 = fieldArray[i].getInt(null)) != n3) continue;
                        string2 = string2.equals("") ? "[ " + fieldArray[i].getName() : string2 + ", " + fieldArray[i].getName();
                        bl = true;
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (bl) continue;
                if (string2.equals("")) {
                    string2 = "[ Unknown: " + Integer.toBinaryString(n3);
                    continue;
                }
                string2 = ", Unknown: " + Integer.toBinaryString(n3);
            }
        }
        string2 = string2 + " ]";
        return string2;
    }

    public static String getState(int n) {
        String string = "";
        Class clazz = LinkConstants.class;
        Field[] fieldArray = clazz.getFields();
        boolean bl = false;
        String string2 = "STATE_";
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n2;
                if (!fieldArray[i].getName().startsWith(string2) || (n2 = fieldArray[i].getInt(null)) != n) continue;
                string = "==========> [" + fieldArray[i].getName() + " : " + n + "]";
                bl = true;
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!bl) {
            string = "==========> [Unknown state: " + n + "]";
        }
        return string;
    }

    public static String getConstant(int n, String string) {
        Class clazz = MQConstants.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        String string2 = "Unknown - " + n + " [0x" + Integer.toHexString(n) + "]";
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n2;
                if (!fieldArray[i].getName().startsWith(string) || (n2 = fieldArray[i].getInt(null)) != n) continue;
                string2 = fieldArray[i].getName();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String getSegmentTypeConstant(byte by) {
        Class clazz = MQFAP.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        String string = "Unknown - " + by + " [0x" + Integer.toHexString(by) + "]";
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                byte by2;
                if (!fieldArray[i].getName().startsWith("TST_") || (by2 = fieldArray[i].getByte(null)) != by) continue;
                string = fieldArray[i].getName();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string;
    }

    public static int mapSIRCtoMQRC(SIException sIException) {
        int n = 2195;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mapSIRCtoMQRC");
        }
        int n2 = sIException.getExceptionReason();
        switch (n2) {
            case 1: {
                n = 2195;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n = 2043;
                break;
            }
            case 15: {
                n = 2085;
                break;
            }
            case 16: {
                n = 2072;
                break;
            }
            case 17: {
                n = 2051;
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                n = 2035;
                break;
            }
            case 21: {
                n = 2019;
                break;
            }
            case 22: {
                n = 2009;
                break;
            }
            case 23: {
                n = 2195;
                break;
            }
            case 24: {
                n = 2051;
                break;
            }
            case 25: {
                n = 2053;
                break;
            }
            case 26: {
                n = 2102;
                break;
            }
            case 27: {
                n = 2101;
                break;
            }
            case 28: {
                n = 2082;
                break;
            }
            case 29: {
                n = 2001;
                break;
            }
            case 30: {
                n = 2085;
                break;
            }
            case 31: {
                n = 2100;
                break;
            }
            case 32: {
                n = 2052;
                break;
            }
            case 33: {
                n = 2047;
                break;
            }
            case 34: {
                n = 2085;
                break;
            }
            case 35: {
                n = 2362;
                break;
            }
            case 36: {
                n = 2195;
                break;
            }
            case 37: {
                n = 2085;
                break;
            }
            case 101: {
                n = 2195;
                break;
            }
            case 102: {
                n = 2110;
                break;
            }
            case 103: {
                n = 2317;
                break;
            }
            case 104: {
                n = 2030;
                break;
            }
            case 105: {
                n = 2110;
                break;
            }
            case 900: 
            case 901: 
            case 905: {
                n = 2195;
                break;
            }
            default: {
                n = 2195;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mapSIRCtoMQRC", (Object)("reason = " + n));
        }
        return n;
    }

    public static synchronized String padString(String string, int n, char c, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("paddingString " + c));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        if (n > 0 && n > n2) {
            for (int i = 0; i <= n; ++i) {
                if (bl) {
                    if (i >= n - n2) continue;
                    stringBuffer.insert(0, c);
                    continue;
                }
                if (i <= n2) continue;
                stringBuffer.append(c);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"padString ", (Object)stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/util/MQUtil.java, SIB.comms, WAS602.SIB, o0610.11 1.21.1.1");
        }
    }
}

