/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.mq.link.MQSync;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MQSyncItem
extends Item {
    private static final TraceComponent tc = SibTr.register((Class)MQSync.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final int TYPE_SENDER = 1;
    public static final int TYPE_RECEIVER = 2;
    private int syncType;
    private String remoteQmgrName;
    private String channelName;
    private String mqlinkName;
    private boolean inDoubt;
    private int inDoubtSequenceNumber;
    private long inDoubtLuwid;
    private List inDoubtMsgIds = new ArrayList();
    private int committedSequenceNumber;
    private long committedLuwid;
    private Filter filter;
    private boolean recoveryIndoubt;
    private int recoveryCommittedSequenceNumber;
    private long recoveryCommittedLuwid;
    private List recoveryInDoubtMsgIds = new ArrayList();

    public MQSyncItem(int n, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.syncType = n;
        this.remoteQmgrName = string;
        this.channelName = string2;
        this.mqlinkName = string3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public MQSyncItem() throws MessageStoreException {
    }

    public byte[] getPersistentData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentData");
        }
        int n = 0;
        n += 4;
        n += this.remoteQmgrName.length() + 4;
        n += this.channelName.length() + 4;
        n += this.mqlinkName.length() + 4;
        n += 29;
        int n2 = this.inDoubtMsgIds == null ? 0 : this.inDoubtMsgIds.size();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)this.inDoubtMsgIds.get(i);
            n += stringArray[i].getBytes().length + 4;
        }
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(this.syncType);
        byteBuffer.putInt(this.remoteQmgrName.length());
        byteBuffer.put(this.remoteQmgrName.getBytes());
        byteBuffer.putInt(this.channelName.length());
        byteBuffer.put(this.channelName.getBytes());
        byteBuffer.putInt(this.mqlinkName.length());
        byteBuffer.put(this.mqlinkName.getBytes());
        byteBuffer.put((byte)(this.inDoubt ? 1 : 0));
        byteBuffer.putInt(this.inDoubtSequenceNumber);
        byteBuffer.putLong(this.inDoubtLuwid);
        byteBuffer.putInt(this.committedSequenceNumber);
        byteBuffer.putLong(this.committedLuwid);
        byteBuffer.putInt(n2);
        for (int i = 0; i < n2; ++i) {
            byteBuffer.putInt(stringArray[i].getBytes().length);
            byteBuffer.put(stringArray[i].getBytes());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentData");
        }
        return byArray;
    }

    public void restore(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restore");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.syncType = byteBuffer.getInt();
        int n = byteBuffer.getInt();
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.remoteQmgrName = new String(byArray2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("remoteQmgrName = " + this.remoteQmgrName));
        }
        n = byteBuffer.getInt();
        byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.channelName = new String(byArray2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("channelName = " + this.channelName));
        }
        n = byteBuffer.getInt();
        byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.mqlinkName = new String(byArray2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("mqlinkName = " + this.mqlinkName));
        }
        this.inDoubt = byteBuffer.get() != 0;
        this.inDoubtSequenceNumber = byteBuffer.getInt();
        this.inDoubtLuwid = byteBuffer.getLong();
        this.committedSequenceNumber = byteBuffer.getInt();
        this.committedLuwid = byteBuffer.getLong();
        int n2 = byteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("numIds = " + n2));
        }
        this.inDoubtMsgIds = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            n = byteBuffer.getInt();
            byArray2 = new byte[n];
            byteBuffer.get(byArray2);
            this.inDoubtMsgIds.add(new String(byArray2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restore");
        }
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStorageStrategy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStorageStrategy");
        }
        return 4;
    }

    void setInDoubtSequenceNumber(int n) {
        this.inDoubtSequenceNumber = n;
    }

    void setInDoubtLuwid(long l) {
        this.inDoubtLuwid = l;
    }

    void setInDoubtMsgIds(List list) {
        this.inDoubtMsgIds = list;
    }

    void setInDoubt(boolean bl) {
        this.inDoubt = bl;
    }

    void setCommittedLuwid(long l) {
        this.committedLuwid = l;
    }

    void setCommittedSequenceNumber(int n) {
        this.committedSequenceNumber = n;
    }

    int getInDoubtSequenceNumber() {
        return this.inDoubtSequenceNumber;
    }

    long getInDoubtLuwid() {
        return this.inDoubtLuwid;
    }

    List getInDoubtMsgIds() {
        return this.inDoubtMsgIds;
    }

    boolean isInDoubt() {
        return this.inDoubt;
    }

    long getCommittedLuwid() {
        return this.committedLuwid;
    }

    int getCommittedSequenceNumber() {
        return this.committedSequenceNumber;
    }

    String getRemoteQmgrName() {
        return this.remoteQmgrName;
    }

    String getMQLinkName() {
        return this.mqlinkName;
    }

    String getChannelName() {
        return this.channelName;
    }

    int getType() {
        return this.syncType;
    }

    void inDoubtToCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inDoubtToCommit");
        }
        this.setRecoveryFields();
        this.inDoubt = false;
        this.committedLuwid = this.inDoubtLuwid;
        this.committedSequenceNumber = this.inDoubtSequenceNumber;
        this.inDoubtMsgIds.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inDoubtToCommit");
        }
    }

    void clearIndoubt() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearIndoubt");
        }
        this.setRecoveryFields();
        this.inDoubt = false;
        this.inDoubtMsgIds.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearIndoubt");
        }
    }

    Filter getFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return new ItemFilter();
    }

    static Filter getMQLinkFilter(String string) {
        return new ItemFieldFilter(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MQSyncItem for ");
        stringBuffer.append(" MQLinkName     :" + this.mqlinkName);
        switch (this.syncType) {
            case 2: {
                stringBuffer.append(" Type           :Receiver");
                break;
            }
            case 1: {
                stringBuffer.append(" Type           :Sender");
                break;
            }
            default: {
                stringBuffer.append(" Type           :" + this.syncType);
            }
        }
        stringBuffer.append(" ChannelName    :" + this.channelName);
        stringBuffer.append(" RemoteQmgrName :" + this.remoteQmgrName);
        stringBuffer.append(" CommittedSeq   :" + this.committedSequenceNumber);
        stringBuffer.append(" CommittedLuwid :" + this.committedLuwid);
        if (this.syncType == 1) {
            stringBuffer.append(" InDoubt?       :" + this.inDoubt);
            stringBuffer.append(" InDoubtSeq     :" + this.inDoubtSequenceNumber);
            stringBuffer.append(" InDoubtLuwid   :" + this.inDoubtLuwid);
        }
        return stringBuffer.toString();
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        super.eventPostRollbackAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
        this.restoreRecoveryFields();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackUpdate(Transaction transaction) {
        super.eventPostRollbackUpdate(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostRollbackUpdate");
        }
        this.restoreRecoveryFields();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackUpdate");
        }
    }

    public void setRecoveryFields() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRecoveryFields");
        }
        this.recoveryCommittedSequenceNumber = this.committedSequenceNumber;
        this.recoveryCommittedLuwid = this.committedLuwid;
        if (this.syncType == 1) {
            this.recoveryIndoubt = this.inDoubt;
            if (this.recoveryIndoubt) {
                this.recoveryInDoubtMsgIds.clear();
                for (int i = 0; i < this.inDoubtMsgIds.size(); ++i) {
                    this.recoveryInDoubtMsgIds.add(i, this.inDoubtMsgIds.get(i));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRecoveryFields");
        }
    }

    private void restoreRecoveryFields() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreRecoveryFields");
        }
        this.committedLuwid = this.recoveryCommittedLuwid;
        this.committedSequenceNumber = this.recoveryCommittedSequenceNumber;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Last Committed LUWID = " + this.committedLuwid + " Last Committed Sequence Number = " + this.committedSequenceNumber));
        }
        if (this.syncType == 1) {
            this.inDoubt = this.recoveryIndoubt;
            if (this.inDoubt) {
                this.inDoubtMsgIds.clear();
                for (int i = 0; i < this.recoveryInDoubtMsgIds.size(); ++i) {
                    this.inDoubtMsgIds.add(i, this.recoveryInDoubtMsgIds.get(i));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreRecoveryFields");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQSyncItem.java, SIB.comms, WAS602.SIB, o0610.11 1.16");
        }
    }

    private static class ItemFieldFilter
    implements Filter {
        String mqlinkName;

        ItemFieldFilter(String string) {
            this.mqlinkName = string;
        }

        public boolean filterMatches(AbstractItem abstractItem) throws MessageStoreException {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"filterMatches");
            }
            if (!(abstractItem instanceof MQSyncItem)) {
                return false;
            }
            MQSyncItem mQSyncItem = (MQSyncItem)abstractItem;
            return this.mqlinkName != null && this.mqlinkName.equals(mQSyncItem.mqlinkName);
        }
    }

    private class ItemFilter
    implements Filter {
        private ItemFilter() {
        }

        public boolean filterMatches(AbstractItem abstractItem) throws MessageStoreException {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"filterMatches");
            }
            if (!(abstractItem instanceof MQSyncItem)) {
                return false;
            }
            MQSyncItem mQSyncItem = (MQSyncItem)abstractItem;
            if (mQSyncItem.syncType != MQSyncItem.this.syncType) {
                return false;
            }
            if (!mQSyncItem.channelName.equals(MQSyncItem.this.channelName)) {
                return false;
            }
            if (!mQSyncItem.remoteQmgrName.equals(MQSyncItem.this.remoteQmgrName)) {
                return false;
            }
            return mQSyncItem.mqlinkName.equals(MQSyncItem.this.mqlinkName);
        }
    }
}

