/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentStateException;
import com.ibm.ws.sib.comms.mq.link.MQSyncItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;

public class MQSync
extends ItemStream {
    private final String description = "MQLink item stream containing MQSyncItems";
    private static final TraceComponent tc = SibTr.register((Class)MQSync.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static MQSync open(MessageStore messageStore, SICoreConnection sICoreConnection, String string) throws MessageStoreException, SIException {
        MPCoreConnection mPCoreConnection;
        MQSync mQSync;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"open");
        }
        if ((mQSync = (MQSync)(mPCoreConnection = (MPCoreConnection)sICoreConnection).getMQLinkStateItemStream(string)) == null) {
            mQSync = new MQSync();
            try {
                mPCoreConnection.setMQLinkStateItemStream(string, mQSync);
            }
            catch (SINotPossibleInCurrentStateException sINotPossibleInCurrentStateException) {
                mQSync = (MQSync)mPCoreConnection.getMQLinkStateItemStream(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"open");
        }
        return mQSync;
    }

    public MessageStore getMessageStore() {
        MessageStore messageStore = this.getOwningMessageStore();
        return messageStore;
    }

    public MQSyncItem readSync(int n, String string, String string2, String string3) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readSync");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)(" remoteQM = " + string + " , channel = " + string2 + " , mqLink = " + string3));
        }
        MQSyncItem mQSyncItem = new MQSyncItem(n, string, string2, string3);
        Filter filter = mQSyncItem.getFilter();
        MQSyncItem mQSyncItem2 = (MQSyncItem)this.findFirstMatchingItem(filter);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Returning item: " + mQSyncItem2));
            if (mQSyncItem2 != null) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Last committed sequence number: " + Integer.toHexString(mQSyncItem2.getCommittedSequenceNumber())));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Last committed luwid: " + Long.toHexString(mQSyncItem2.getCommittedLuwid())));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readSync");
        }
        return mQSyncItem2;
    }

    public void writeSync(MQSyncItem mQSyncItem, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSync");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Item: " + mQSyncItem));
            if (mQSyncItem != null) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Last committed sequence number: " + Integer.toHexString(mQSyncItem.getCommittedSequenceNumber())));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Last committed luwid: " + Long.toHexString(mQSyncItem.getCommittedLuwid())));
            }
        }
        if (transaction == null) {
            transaction = this.getMessageStore().getTransactionFactory().createAutoCommitTransaction();
        }
        if (!mQSyncItem.isInStore()) {
            this.addItem(mQSyncItem, transaction);
        } else {
            mQSyncItem.requestUpdate(transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeSync");
        }
    }

    public void destroy(String string) {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)("destroy (MQLink = " + string + ")"));
            }
            try {
                Filter filter = MQSyncItem.getMQLinkFilter(string);
                ExternalAutoCommitTransaction externalAutoCommitTransaction = this.getMessageStore().getTransactionFactory().createAutoCommitTransaction();
                NonLockingCursor nonLockingCursor = this.newNonLockingItemCursor(filter);
                MQSyncItem mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                while (mQSyncItem != null) {
                    mQSyncItem.remove(externalAutoCommitTransaction, this.getLockID());
                    mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                }
                nonLockingCursor.finished();
            }
            catch (MessageStoreException messageStoreException) {
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public MQSyncItem anotherInDoubt(MQSyncItem mQSyncItem) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"anotherInDoubt");
        }
        MQSyncItem mQSyncItem2 = null;
        NonLockingCursor nonLockingCursor = this.newNonLockingItemCursor(null);
        MQSyncItem mQSyncItem3 = (MQSyncItem)nonLockingCursor.next();
        while (mQSyncItem3 != null) {
            if (mQSyncItem3.isInDoubt()) {
                if (!mQSyncItem3.getChannelName().equals(mQSyncItem.getChannelName())) {
                    mQSyncItem2 = mQSyncItem3;
                    break;
                }
                if (!mQSyncItem3.getRemoteQmgrName().equals(mQSyncItem.getRemoteQmgrName())) {
                    mQSyncItem2 = mQSyncItem3;
                    break;
                }
            }
            mQSyncItem3 = (MQSyncItem)nonLockingCursor.next();
        }
        nonLockingCursor.finished();
        if (tc.isDebugEnabled() && mQSyncItem2 != null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt sync item: " + mQSyncItem2));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt sequence number: " + Integer.toHexString(mQSyncItem2.getInDoubtSequenceNumber())));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt luwid: " + Long.toHexString(mQSyncItem2.getInDoubtLuwid())));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"anotherInDoubt");
        }
        return mQSyncItem2;
    }

    public boolean isIndoubt(String string) {
        boolean bl;
        block6: {
            bl = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"isInDoubt");
            }
            try {
                Filter filter = MQSyncItem.getMQLinkFilter(string);
                NonLockingCursor nonLockingCursor = this.newNonLockingItemCursor(filter);
                MQSyncItem mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                while (mQSyncItem != null & !bl) {
                    if (mQSyncItem.isInDoubt()) {
                        bl = true;
                        continue;
                    }
                    mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                }
                nonLockingCursor.finished();
            }
            catch (MessageStoreException messageStoreException) {
                if (!tc.isEventEnabled()) break block6;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("isInDoubt : " + bl));
        }
        return bl;
    }

    public int getStorageStrategy() {
        return 4;
    }

    public byte[] getPersistentData() {
        return "MQLink item stream containing MQSyncItems".getBytes();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQSync.java, SIB.comms, WAS602.SIB, o0610.11 1.20");
        }
    }
}

