/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MQLinkStats {
    static final int BATCHES_SENT = 1;
    static final int BATCHES_RECEIVED = 2;
    static final int MESSAGES_SENT = 3;
    static final int MESSAGES_RECEIVED = 4;
    static final int SENDER_BYTES_SENT = 5;
    static final int SENDER_BYTES_RECEIVED = 6;
    static final int RECEIVER_BYTES_SENT = 7;
    static final int RECEIVER_BYTES_RECEIVED = 8;
    static final int SENDER_BUFFERS_SENT = 9;
    static final int SENDER_BUFFERS_RECEIVED = 10;
    static final int RECEIVER_BUFFERS_SENT = 11;
    static final int RECEIVER_BUFFERS_RECEIVED = 12;
    static final int SHORT_RETRIES = 13;
    static final int LONG_RETRIES = 14;
    static final int SENDER_BUSY_INDICATOR = 15;
    private long batchesSent;
    private long batchesReceived;
    private long messagesSent;
    private long messagesReceived;
    private long senderBytesSent;
    private long senderBytesReceived;
    private long receiverBytesSent;
    private long receiverBytesReceived;
    private long senderBuffersSent;
    private long senderBuffersReceived;
    private long receiverBuffersSent;
    private long receiverBuffersReceived;
    private long shortRetries;
    private long longRetries;
    private int senderBusyIndicator;
    static TraceComponent tc = SibTr.register((Class)MQLinkStats.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public MQLinkStats(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQLinkStats");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQLinkStats");
        }
    }

    public void incrementStats(int n, long l) {
        switch (n) {
            case 1: {
                int n2 = 0;
                while ((long)n2 < l) {
                    CommsPMI.getMQLinkStats().onSendBatch();
                    ++n2;
                }
                this.batchesSent += l;
                break;
            }
            case 2: {
                int n3 = 0;
                while ((long)n3 < l) {
                    CommsPMI.getMQLinkStats().onReceiveBatch();
                    ++n3;
                }
                this.batchesReceived += l;
                break;
            }
            case 3: {
                int n4 = 0;
                while ((long)n4 < l) {
                    CommsPMI.getMQLinkStats().onSendMessage();
                    ++n4;
                }
                this.messagesSent += l;
                break;
            }
            case 4: {
                int n5 = 0;
                while ((long)n5 < l) {
                    CommsPMI.getMQLinkStats().onReceiveMessage();
                    ++n5;
                }
                this.messagesReceived += l;
                break;
            }
            case 5: {
                CommsPMI.getMQLinkStats().onSenderSendBytes((int)l);
                this.senderBytesSent += l;
                break;
            }
            case 6: {
                CommsPMI.getMQLinkStats().onSenderReceiveBytes((int)l);
                this.senderBytesReceived += l;
                break;
            }
            case 7: {
                CommsPMI.getMQLinkStats().onReceiverSendBytes((int)l);
                this.receiverBytesSent += l;
                break;
            }
            case 8: {
                CommsPMI.getMQLinkStats().onReceiverReceiveBytes((int)l);
                this.receiverBytesReceived += l;
                break;
            }
            case 9: {
                this.senderBuffersSent += l;
                break;
            }
            case 10: {
                this.senderBuffersReceived += l;
                break;
            }
            case 11: {
                this.receiverBuffersSent += l;
                break;
            }
            case 12: {
                this.receiverBuffersReceived += l;
                break;
            }
            case 13: {
                this.shortRetries += l;
                break;
            }
            case 14: {
                this.longRetries += l;
                break;
            }
            case 15: {
                this.senderBusyIndicator = (int)((long)this.senderBusyIndicator + l);
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)"Invalid id specified!");
            }
        }
    }

    public void onSendMessage(long l) {
        CommsPMI.getMQLinkStats().onSendMessage();
        CommsPMI.getMQLinkStats().onSenderSendBytes((int)l);
        ++this.messagesSent;
        this.senderBytesSent += l;
        ++this.senderBuffersSent;
    }

    public void onReceiveMessage() {
        CommsPMI.getMQLinkStats().onReceiveMessage();
        ++this.messagesReceived;
    }

    public void senderSent(long l) {
        CommsPMI.getMQLinkStats().onSenderSendBytes((int)l);
        this.senderBytesSent += l;
        ++this.senderBuffersSent;
    }

    public void senderReceived(long l) {
        CommsPMI.getMQLinkStats().onSenderReceiveBytes((int)l);
        this.senderBytesReceived += l;
        ++this.senderBuffersReceived;
    }

    public void receiverSent(long l) {
        CommsPMI.getMQLinkStats().onReceiverSendBytes((int)l);
        this.receiverBytesSent += l;
        ++this.receiverBuffersSent;
    }

    public void receiverReceived(long l) {
        CommsPMI.getMQLinkStats().onReceiverReceiveBytes((int)l);
        this.receiverBytesReceived += l;
        ++this.receiverBytesReceived;
    }

    public void onBatchSend() {
        ++this.batchesSent;
    }

    public void onBatchReceive() {
        ++this.batchesReceived;
    }

    public void busyIndicator(int n) {
        this.senderBusyIndicator += n;
    }

    public long getStatValue(int n) {
        switch (n) {
            case 1: {
                return this.batchesSent;
            }
            case 2: {
                return this.batchesReceived;
            }
            case 3: {
                return this.messagesSent;
            }
            case 4: {
                return this.messagesReceived;
            }
            case 5: {
                return this.senderBytesSent;
            }
            case 6: {
                return this.senderBytesReceived;
            }
            case 7: {
                return this.receiverBytesSent;
            }
            case 8: {
                return this.receiverBytesReceived;
            }
            case 9: {
                return this.senderBuffersSent;
            }
            case 10: {
                return this.senderBuffersReceived;
            }
            case 11: {
                return this.receiverBuffersSent;
            }
            case 12: {
                return this.receiverBuffersReceived;
            }
            case 13: {
                return this.shortRetries;
            }
            case 14: {
                return this.longRetries;
            }
        }
        return 0L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of batches sent           = " + this.batchesSent + "\n");
        stringBuffer.append("Number of batches received       = " + this.batchesReceived + "\n");
        stringBuffer.append("Number of messages sent          = " + this.messagesSent + "\n");
        stringBuffer.append("Number of messages received      = " + this.messagesReceived + "\n");
        stringBuffer.append("Bytes sent by MQLinkSender       = " + this.senderBytesSent + "\n");
        stringBuffer.append("Bytes received by MQLinkSender   = " + this.senderBytesReceived + "\n");
        stringBuffer.append("Byte sent by MQLinkReceiver      = " + this.receiverBytesSent + "\n");
        stringBuffer.append("Bytes received by MQLinkReceiver = " + this.receiverBytesReceived + "\n");
        stringBuffer.append("Short retries attempted          = " + this.shortRetries + "\n");
        stringBuffer.append("Long retries attempted           = " + this.longRetries + "\n");
        stringBuffer.append("Sender busy indicator            = " + this.senderBusyIndicator + "%\n");
        return new String(stringBuffer);
    }
}

