/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.admin.SIBMQLinkReceiverCurrentStatus;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.SIBMQConstants;
import com.ibm.ws.sib.admin.SIBMQLinkNPMSpeed;
import com.ibm.ws.sib.admin.SIBMQLinkState;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQLink;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.link.MQLinkStats;
import com.ibm.ws.sib.comms.mq.link.MQSync;
import com.ibm.ws.sib.comms.mq.link.MQSyncItem;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.mqinterop.fap.InitData;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mfp.mqinterop.fap.MSH;
import com.ibm.ws.sib.mfp.mqinterop.fap.Reset;
import com.ibm.ws.sib.mfp.mqinterop.fap.Resync;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.security.auth.Subject;

public class MQLinkReceiver
implements LinkConstants,
MQConstants,
SIBMQConstants,
ReceiveListener,
MQFAP {
    private JsMessagingEngine engine;
    private SICoreConnection jsConnection;
    private Connection mqConnection;
    private MQLink mqlink;
    private JsBus bus;
    private ReceiverStateMachine stateMachine;
    private MQSync mqSync;
    private MQLinkReceiver linkReceiver;
    private MQLinkManagerImpl linkManagerImpl;
    private boolean stopRequested;
    private Exception batchException;
    private Connection thisConnection;
    private int batchError;
    private int batchData;
    private ProducerSessionCache sessionCache;
    private SIUncoordinatedTransaction transaction;
    private MQLinkStats stats = null;
    private long startTime;
    private long lastMessageTime;
    private String remoteQmgrName;
    private MessageStore messageStore;
    private long handle;
    private SIBMQLinkReceiverCurrentStatus currentStatus;
    private int expectedSequenceNum = 1;
    private int maxSequenceNum;
    private int expectedSegmentNum;
    private int lastSequenceNumReceived;
    private long lastLuwidReceived;
    private boolean recoverableBatch;
    private long numberBatches;
    private long numberMessages;
    private int msgsInBatch;
    private MQSyncItem syncItem = null;
    private int heartbeatInterval;
    private int maxMessageSize;
    private int maxTransmissionSize;
    private int batchSize;
    private long buffersSent;
    private long buffersReceived;
    private int receiverStatus = 2;
    private boolean npmSpeedFast;
    private String partnerAddress;
    private SIDestinationAddressFactory destFactory;
    private String localBusName;
    private String foreignBusName;
    private String inboundUserId;
    private boolean localBusSecurity;
    private Reliability NPReliability;
    private Reliability PersReliability;
    private byte wireEnc;
    private short wireCCSID;
    private static final TraceComponent tc = SibTr.register((Class)MQLinkReceiver.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public MQLinkReceiver(MQLinkManagerImpl mQLinkManagerImpl, MQLink mQLink) throws RuntimeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MQLinkReceiver");
        }
        this.linkManagerImpl = mQLinkManagerImpl;
        this.mqlink = mQLink;
        this.linkReceiver = this;
        this.stateMachine = new ReceiverStateMachine();
        this.engine = mQLink.getEngine();
        this.messageStore = (MessageStore)this.engine.getMessageStore();
        try {
            this.destFactory = SIDestinationAddressFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"MQLinkReceiver.MQLinkReceiver", (String)"1", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw new RuntimeException(exception);
        }
        this.bus = (JsBus)this.engine.getBus();
        this.localBusName = this.bus.getName();
        String string = mQLink.getMQLinkTargetUuid();
        ForeignBusDefinition foreignBusDefinition = this.bus.getForeignBusForLink(string);
        if (foreignBusDefinition != null) {
            this.foreignBusName = foreignBusDefinition.getName();
        }
        try {
            this.inboundUserId = foreignBusDefinition.getLink().getInboundUserid();
        }
        catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
            FFDCFilter.processException((Throwable)sIBExceptionNoLinkExists, (String)"MQLinkReceiver.MQLinkReceiver", (String)"2", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIBExceptionNoLinkExists));
            }
            throw new RuntimeException(sIBExceptionNoLinkExists);
        }
        this.localBusSecurity = mQLink.isBusSecure(this.bus.getName());
        this.PersReliability = mQLink.getInboundPersReliability();
        this.NPReliability = mQLink.getInboundNPReliability();
        this.start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MQLinkReceiver");
        }
    }

    public SIBMQLinkReceiverCurrentStatus getReceiverCurrentStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReceiverCurrentStatus");
        }
        this.currentStatus.setStatus(new SIBMQLinkState(this.receiverStatus));
        this.currentStatus.setBatchSize(new Integer(this.batchSize));
        if (this.mqConnection != null) {
            this.currentStatus.setBuffersReceived(new Long(this.mqConnection.getBuffersReceived()));
            this.currentStatus.setBuffersSent(new Long(this.mqConnection.getBuffersSent()));
            this.currentStatus.setBytesReceived(new Long(this.mqConnection.getBytesReceived()));
            this.currentStatus.setBytesSent(new Long(this.mqConnection.getBytesSent()));
            this.currentStatus.setIpAddress(this.partnerAddress);
        }
        if (this.syncItem != null) {
            this.currentStatus.setCurrentLUWID("LUWID");
            this.currentStatus.setCurrentSequenceNumber(new Long(this.expectedSequenceNum));
            this.currentStatus.setLastLUWID(Long.toHexString(this.syncItem.getCommittedLuwid()));
            this.currentStatus.setLastSequenceNumber(new Long(this.syncItem.getCommittedSequenceNumber()));
        }
        this.currentStatus.setHeartbeatInterval(new Integer(this.heartbeatInterval));
        this.currentStatus.setLastMessageReceiveTimeMillis(new Long(this.lastMessageTime));
        this.currentStatus.setChannelStartTimeMillis(new Long(this.startTime));
        this.currentStatus.setMaxMessageLength(new Integer(this.maxMessageSize));
        this.currentStatus.setMessagesInCurrentBatch(new Integer(this.msgsInBatch));
        this.currentStatus.setNpmSpeed(new SIBMQLinkNPMSpeed(this.npmSpeedFast ? 0 : 1));
        this.currentStatus.setNumberOfBatchesReceived(new Long(this.numberBatches));
        this.currentStatus.setNumberOfMessagesReceived(new Long(this.numberMessages));
        this.currentStatus.setQueueManager(this.remoteQmgrName);
        this.currentStatus.setStopRequested(Boolean.valueOf(this.stopRequested));
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReceiverCurrentStatus");
        }
        return this.currentStatus;
    }

    public synchronized void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        if (this.mqlink.isAuditEnabled()) {
            Object[] objectArray = new Object[]{this.mqlink.getMQLinkName()};
            SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKRECV_START_SICO3220", (Object)objectArray);
        }
        this.stats = this.mqlink.getStats();
        this.stateMachine.gotoState(3);
        this.stopRequested = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if (this.mqlink.isAuditEnabled()) {
            Object[] objectArray = new Object[]{this.mqlink.getMQLinkName()};
            SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKRECV_STOP_SICO3221", (Object)objectArray);
        }
        this.stopRequested = true;
        this.receiverStatus = 7;
        if (n == 0) {
            this.stateMachine.gotoState(2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public void adopted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"adopted");
        }
        if (this.mqlink.isAuditEnabled()) {
            Object[] objectArray = new Object[]{this.mqlink.getMQLinkName(), this.partnerAddress};
            SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKRECV_ADOPT_SICO3222", (Object)objectArray);
        }
        this.stateMachine.gotoState(2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"adopted");
        }
    }

    void destroy() {
    }

    public String getRemoteQMName() {
        return this.remoteQmgrName;
    }

    public long getHandle() {
        return this.handle;
    }

    public void setHandle(long l) {
        this.handle = l;
    }

    public Properties display(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"display");
        }
        Properties properties = new Properties();
        properties.setProperty("CHANNEL", this.mqlink.getReceiverChannelName());
        properties.setProperty("CHLTYPE", "RCV");
        properties.setProperty("TRPTYPE", "TCP");
        if (string.equalsIgnoreCase("channel")) {
            properties.setProperty("DESCR", "Receiver channel for MQLink " + this.mqlink.getMQLinkName());
            properties.setProperty("ALTDATE", MQUtil.timeToMQDate(this.mqlink.getAltTime()));
            properties.setProperty("ALTTIME", MQUtil.timeToMQTime(this.mqlink.getAltTime()));
            properties.setProperty("BATCHSZ", new Integer(this.mqlink.getBatchSize()).toString());
            properties.setProperty("SEQWRAP", new Integer(this.mqlink.getMessageSeqWrapValue()).toString());
            properties.setProperty("MAXMSGL", new Integer(this.mqlink.getMaxMessageSize()).toString());
            properties.setProperty("HBINT", new Integer(this.mqlink.getHeartbeatInterval()).toString());
            properties.setProperty("NPMSPEED", this.mqlink.isNpmSpeedFast() ? "FAST" : "NORMAL");
        } else if (string.equalsIgnoreCase("chstatus")) {
            String string2;
            properties.setProperty("CURLUWID", new Long(this.lastLuwidReceived).toString());
            properties.setProperty("CURSEQNO", new Long(this.lastSequenceNumReceived).toString());
            properties.setProperty("LSTLUWID", new Long(this.syncItem != null ? this.syncItem.getCommittedLuwid() : 0L).toString());
            properties.setProperty("LSTSEQNO", new Long(this.syncItem != null ? (long)this.syncItem.getCommittedSequenceNumber() : 0L).toString());
            properties.setProperty("CURMSGS", new Integer(this.msgsInBatch).toString());
            if (this.stopRequested) {
                string2 = "STOPPING";
            } else {
                switch (this.stateMachine.state) {
                    case 0: {
                        string2 = "INACTIVE";
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        string2 = "BINDING";
                        break;
                    }
                    case 8: {
                        string2 = "RUNNING";
                        break;
                    }
                    case 2: {
                        string2 = "STOPPED";
                        break;
                    }
                    default: {
                        string2 = "ERROR";
                    }
                }
            }
            properties.setProperty("STATUS", string2);
            properties.setProperty("BATCHSZ", new Integer(this.batchSize).toString());
            properties.setProperty("BATCHES", new Long(this.stats.getStatValue(2)).toString());
            properties.setProperty("BUFSRCVD", new Long(this.stats.getStatValue(12)).toString());
            properties.setProperty("BUFSSENT", new Long(this.stats.getStatValue(11)).toString());
            properties.setProperty("BYTSRCVD", new Long(this.stats.getStatValue(8)).toString());
            properties.setProperty("BYTSSENT", new Long(this.stats.getStatValue(7)).toString());
            properties.setProperty("CHSTADA", MQUtil.timeToMQDate(this.startTime));
            properties.setProperty("CHSTATI", MQUtil.timeToMQTime(this.startTime));
            properties.setProperty("HBINT", new Integer(this.heartbeatInterval).toString());
            properties.setProperty("LSTMSGDA", MQUtil.timeToMQDate(this.lastMessageTime));
            properties.setProperty("LSTMSGTI", MQUtil.timeToMQTime(this.lastMessageTime));
            properties.setProperty("MAXMSGL", new Long(this.maxMessageSize).toString());
            properties.setProperty("MSGS", new Long(this.stats.getStatValue(4)).toString());
            properties.setProperty("NPMSPEED", this.npmSpeedFast ? "FAST" : "NORMAL");
            properties.setProperty("STOPREQ", this.stopRequested ? "TRUE" : "FALSE");
            properties.setProperty("QMNAME", this.mqlink.getQMName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"display");
        }
        return properties;
    }

    private ProducerSession getDestinationSession(SIDestinationAddress sIDestinationAddress, JsMessage jsMessage) throws SIException {
        ProducerSession producerSession;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationSession");
        }
        if ((producerSession = this.sessionCache.find(sIDestinationAddress.getBusName(), sIDestinationAddress.getDestinationName(), jsMessage.getSecurityUserid())) == null) {
            block18: {
                try {
                    MPCoreConnection mPCoreConnection = (MPCoreConnection)this.jsConnection;
                    try {
                        producerSession = mPCoreConnection.createProducerSession(sIDestinationAddress, DestinationType.QUEUE, null, jsMessage.getSecurityUserid());
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Created a producer session for destination " + sIDestinationAddress.getDestinationName()));
                        }
                    }
                    catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                        if (sIDestinationAddress.getDestinationName().startsWith("_P")) {
                            try {
                                producerSession = mPCoreConnection.createSystemProducerSession(sIDestinationAddress, null, DestinationType.QUEUE, null, jsMessage.getSecurityUserid());
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Created a producer session for system destination " + sIDestinationAddress.getDestinationName()));
                                }
                                break block18;
                            }
                            catch (SIException sIException) {
                                if (tc.isEventEnabled()) {
                                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                                }
                                this.dlqMessage(sIDestinationAddress, jsMessage, sIException.getExceptionReason(), sIException.getExceptionInserts());
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Failed to creat a producer session for destination " + sIDestinationAddress.getDestinationName()));
                                }
                                break block18;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Failed to find destination " + sIDestinationAddress.getDestinationName()));
                        }
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
                        }
                        this.dlqMessage(sIDestinationAddress, jsMessage, sINotPossibleInCurrentConfigurationException.getExceptionReason(), sINotPossibleInCurrentConfigurationException.getExceptionInserts());
                    }
                }
                catch (SIException sIException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    this.dlqMessage(sIDestinationAddress, jsMessage, sIException.getExceptionReason(), sIException.getExceptionInserts());
                }
            }
            if (producerSession != null) {
                this.sessionCache.add(producerSession, sIDestinationAddress.getBusName(), sIDestinationAddress.getDestinationName(), jsMessage.getSecurityUserid());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationSession");
        }
        return producerSession;
    }

    private void dlqMessage(SIDestinationAddress sIDestinationAddress, JsMessage jsMessage, int n, String[] stringArray) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Reason = " + n));
        }
        String string = sIDestinationAddress.getDestinationName();
        Object[] objectArray = null;
        objectArray = new Object[]{this.mqlink.getReceiverChannelName(), string, this.mqlink.getEngine().getName()};
        SibTr.info((TraceComponent)tc, (String)"INFO_RCV_FAILED_TO_PUT_TO_TARGET_SICO3312", (Object)objectArray);
        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.remoteQmgrName};
        SibTr.info((TraceComponent)tc, (String)"INFO_RCV_PUT_TO_DLQ_SICO3098", (Object)objectArray);
        SIMPFactory sIMPFactory = (SIMPFactory)this.mqlink.getEngine().getMessageProcessor();
        ExceptionDestinationHandler exceptionDestinationHandler = null;
        exceptionDestinationHandler = sIMPFactory.createExceptionDestinationHandler(string);
        UndeliverableReturnCode undeliverableReturnCode = exceptionDestinationHandler.handleUndeliverableMessage((SIBusMessage)jsMessage, jsMessage.getSecurityUserid(), (Transaction)this.transaction, n, stringArray);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Undeliverable rc =" + undeliverableReturnCode));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
        if (undeliverableReturnCode != UndeliverableReturnCode.OK) {
            throw new SIErrorException(nls.getFormattedMessage("ERR_MQLINKRCV_MSGERR_SICO3231", null, null));
        }
    }

    private void forwardMessage(JsMessage jsMessage, SITransaction sITransaction) throws SIException {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"forwardMessage");
            }
            JsDestinationAddress jsDestinationAddress = jsMessage.getRoutingDestination();
            try {
                ProducerSession producerSession = this.getDestinationSession((SIDestinationAddress)jsDestinationAddress, jsMessage);
                if (producerSession != null) {
                    producerSession.send((SIBusMessage)jsMessage, sITransaction);
                }
            }
            catch (SIException sIException) {
                this.dlqMessage((SIDestinationAddress)jsDestinationAddress, jsMessage, sIException.getExceptionReason(), sIException.getExceptionInserts());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"MQLinkReceiver.forwardMessage", (String)"3", (Object)this);
                if (!tc.isEventEnabled()) break block6;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forwardMessage");
        }
    }

    public synchronized ReceiveListener dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])wsByteBuffer.array(), (int)wsByteBuffer.arrayOffset(), (int)wsByteBuffer.remaining(), (String)"Data received by MQLinkReceiver");
        }
        if (this.mqConnection == null) {
            this.mqConnection = connection;
            this.partnerAddress = this.mqConnection.getRemoteNetworkAddress();
        }
        this.stateMachine.dataReceived(connection, wsByteBuffer);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
        return null;
    }

    public void errorOccurred(Connection connection, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred");
        }
        if (tc.isEventEnabled()) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
        }
        MQUtil.reportError(connection, null, throwable);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
        }
    }

    public WsByteBuffer buildErrorCloseFapFlow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
        }
        try {
            MQFap mQFap = new MQFap();
            mQFap.createStatus((byte)8, 0, null, this.wireEnc, this.wireCCSID);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
            }
            return mQFap.getData();
        }
        catch (IOException iOException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
            }
            return null;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQLinkReceiver.java, SIB.comms, WAS60.SIB, o0444.07 1.56");
        }
    }

    private class ReceiverStateMachine
    implements MQFAP {
        private int state = 0;
        private MQFap jsmFap;
        private List currentMessageFaps = new ArrayList();
        private int stopReason = 1;

        private ReceiverStateMachine() {
        }

        private void gotoState(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)("gotoState " + MQUtil.getState(n)));
            }
            this.state = n;
            switch (this.state) {
                case 3: {
                    MQLinkReceiver.this.receiverStatus = 2;
                    break;
                }
                case 2: {
                    MQLinkReceiver.this.receiverStatus = 7;
                    this.doStopped(MQLinkReceiver.this.mqConnection);
                    break;
                }
                case 4: {
                    MQLinkReceiver.this.receiverStatus = 6;
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"gotoState");
            }
        }

        private void dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
            if (MQLinkReceiver.this.stats != null) {
                MQLinkReceiver.this.stats.receiverReceived(wsByteBuffer.remaining());
            }
            MQFap mQFap = null;
            boolean bl = true;
            try {
                long l;
                mQFap = new MQFap(wsByteBuffer);
                TSH tSH = mQFap.getTsh();
                boolean bl2 = true;
                if (tSH.getSegmentType() == 5 && (tSH.getControlFlags1() & 8) != 0) {
                    this.stopReason = 3;
                    this.gotoState(2);
                }
                block2 : switch (this.state) {
                    case 3: {
                        switch (tSH.getSegmentType()) {
                            case 1: {
                                break block2;
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    case 4: {
                        switch (tSH.getSegmentType()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 9: {
                                break block2;
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    case 6: {
                        switch (tSH.getSegmentType()) {
                            case 3: 
                            case 4: 
                            case 7: 
                            case 9: {
                                break block2;
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    case 8: {
                        switch (tSH.getSegmentType()) {
                            case 3: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 9: {
                                break block2;
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        MQUtil.reportError(connection, wsByteBuffer, null);
                        mQFap.createStatus((byte)8, 16, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                        l = mQFap.send(connection);
                        if (MQLinkReceiver.this.stats != null) {
                            MQLinkReceiver.this.stats.receiverSent(l);
                        }
                        this.gotoState(2);
                    }
                }
                if (!bl2) {
                    MQUtil.reportError(connection, wsByteBuffer, null);
                    mQFap.createStatus((byte)8, 10, new Integer(tSH.getSegmentType()), MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                    this.gotoState(2);
                }
                if (this.state == 2) {
                    return;
                }
                switch (tSH.getSegmentType()) {
                    case 1: {
                        this.doAccept(connection, mQFap);
                        break;
                    }
                    case 6: {
                        mQFap.getSecurityData().setUserData(null);
                        l = mQFap.send(connection);
                        if (MQLinkReceiver.this.stats == null) break;
                        MQLinkReceiver.this.stats.receiverSent(l);
                        break;
                    }
                    case 2: {
                        this.doResync(connection, mQFap);
                        break;
                    }
                    case 3: {
                        this.doReset(connection, mQFap);
                        break;
                    }
                    case 4: {
                        try {
                            this.doMessage(connection, mQFap);
                            bl = false;
                        }
                        catch (Exception exception) {
                            MQLinkReceiver.this.batchException = exception;
                            MQLinkReceiver.this.batchError = 6;
                        }
                        break;
                    }
                    case 9: {
                        this.gotoState(8);
                        if (MQLinkReceiver.this.sessionCache != null) {
                            MQLinkReceiver.this.sessionCache.flush(false);
                        }
                        if (MQLinkReceiver.this.stopRequested) {
                            mQFap.getTsh().setControlFlags1((byte)4);
                        } else {
                            mQFap.getTsh().setControlFlags1((byte)0);
                        }
                        l = mQFap.send(connection);
                        if (MQLinkReceiver.this.stats == null) break;
                        MQLinkReceiver.this.stats.receiverSent(l);
                        break;
                    }
                    case 7: {
                        this.doPing(connection, mQFap);
                        break;
                    }
                    case 5: {
                        if ((tSH.getControlFlags1() & 1) == 0) break;
                        this.doBatchConfirm(connection, mQFap);
                        break;
                    }
                    default: {
                        MQUtil.reportError(connection, wsByteBuffer, null);
                        mQFap.createStatus((byte)8, 13, new Integer(tSH.getSegmentType()), MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                        l = mQFap.send(connection);
                        if (MQLinkReceiver.this.stats != null) {
                            MQLinkReceiver.this.stats.receiverSent(l);
                        }
                        this.gotoState(2);
                    }
                }
                if ((tSH.getControlFlags1() & 8) != 0) {
                    this.gotoState(2);
                }
            }
            catch (IOException iOException) {
                MQUtil.reportError(connection, wsByteBuffer, iOException);
                this.gotoState(2);
            }
            catch (SIException sIException) {
                MQUtil.reportError(connection, wsByteBuffer, sIException);
                this.gotoState(2);
            }
            if (bl) {
                if (mQFap != null) {
                    mQFap.release();
                } else {
                    wsByteBuffer.release();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
        }

        private void doPing(Connection connection, MQFap mQFap) throws SIConnectionDroppedException, SIConnectionLostException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doPing");
            }
            long l = mQFap.send(connection);
            if (MQLinkReceiver.this.stats != null) {
                MQLinkReceiver.this.stats.receiverSent(l);
            }
            connection.close();
            this.gotoState(2);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doPing");
            }
        }

        private void doStopped(Connection connection) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doStopped");
            }
            if (connection != null) {
                try {
                    connection.close();
                    MQLinkReceiver.this.mqlink.emitNotification(10, this.stopReason, MQLinkReceiver.this.remoteQmgrName);
                }
                catch (SIException sIException) {
                    // empty catch block
                }
                connection = null;
            }
            if (MQLinkReceiver.this.jsConnection != null) {
                try {
                    MQLinkReceiver.this.jsConnection.close();
                }
                catch (SIException sIException) {
                    // empty catch block
                }
                MQLinkReceiver.this.jsConnection = null;
            }
            MQLinkReceiver.this.mqlink.unsetReceiver(MQLinkReceiver.this.linkReceiver);
            if (MQLinkReceiver.this.sessionCache != null) {
                MQLinkReceiver.this.sessionCache.flush(true);
            }
            if (this.state == 2) {
                if (MQLinkReceiver.this.batchException != null) {
                    MQUtil.reportError(connection, null, MQLinkReceiver.this.batchException);
                } else if (MQLinkReceiver.this.mqlink.isAuditEnabled()) {
                    Object[] objectArray = new Object[]{MQLinkReceiver.this.mqlink.getMQLinkName()};
                    SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKRECV_TERMINATED_SICO3232", (Object)objectArray);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doStopped");
            }
        }

        private void doAccept(Connection connection, MQFap mQFap) throws IOException, SIConnectionDroppedException, SIConnectionLostException {
            byte by;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doAccept");
            }
            TSH tSH = mQFap.getTsh();
            InitData initData = mQFap.getInitData();
            MQLinkReceiver.this.startTime = System.currentTimeMillis();
            MQLinkReceiver.this.remoteQmgrName = initData.getQueueManagerName().trim();
            initData.setQueueManagerName(MQLinkReceiver.this.mqlink.getQMName());
            MQLinkReceiver.this.wireEnc = tSH.getEncoding();
            MQLinkReceiver.this.wireCCSID = tSH.getCCSID();
            if (MQLinkReceiver.this.thisConnection == null) {
                MQLinkReceiver.this.thisConnection = connection;
            }
            if ((by = initData.getFapLevel()) < 4) {
                tSH.setControlFlags1((byte)2);
                initData.setFapLevel((byte)4);
                initData.setErrFlags((byte)8);
                long l = mQFap.send(connection);
                if (MQLinkReceiver.this.stats != null) {
                    MQLinkReceiver.this.stats.receiverSent(l);
                }
            } else if (by > 7) {
                tSH.setControlFlags1((byte)2);
                initData.setFapLevel((byte)7);
                initData.setErrFlags((byte)8);
                long l = mQFap.send(connection);
                if (MQLinkReceiver.this.stats != null) {
                    MQLinkReceiver.this.stats.receiverSent(l);
                }
            } else if (MQLinkReceiver.this.mqlink.setReceiver(MQLinkReceiver.this.linkReceiver)) {
                MQLinkReceiver.this.currentStatus = new SIBMQLinkReceiverCurrentStatus(MQLinkReceiver.this.handle);
                JsMessagingEngine jsMessagingEngine = MQLinkReceiver.this.mqlink.getEngine();
                SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)jsMessagingEngine.getMessageProcessor();
                HashMap hashMap = new HashMap();
                try {
                    AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
                    AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
                    Subject subject = authUtils.getSIBServerSubject();
                    MQLinkReceiver.this.jsConnection = sICoreConnectionFactory.createConnection(subject, hashMap);
                    MQLinkReceiver.this.sessionCache = new ProducerSessionCache();
                    MQLinkReceiver.this.mqSync = MQSync.open(MQLinkReceiver.this.messageStore, MQLinkReceiver.this.jsConnection, MQLinkReceiver.this.mqlink.getMQLinkUuid());
                    MQLinkReceiver.this.syncItem = MQLinkReceiver.this.mqSync.readSync(2, MQLinkReceiver.this.remoteQmgrName, MQLinkReceiver.this.mqlink.getReceiverChannelName(), MQLinkReceiver.this.mqlink.getMQLinkName());
                    if (MQLinkReceiver.this.syncItem != null) {
                        MQLinkReceiver.this.expectedSequenceNum = MQLinkReceiver.this.syncItem.getCommittedSequenceNumber() + 1;
                    } else {
                        MQLinkReceiver.this.expectedSequenceNum = 1;
                    }
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    mQFap.createStatus((byte)8, 3, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                    MQLinkReceiver.this.batchException = (Exception)((Object)sIConnectionLostException);
                    this.gotoState(2);
                }
                catch (SIAuthenticationException sIAuthenticationException) {
                    mQFap.createStatus((byte)8, 20, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                    MQLinkReceiver.this.batchException = (Exception)((Object)sIAuthenticationException);
                    this.gotoState(2);
                }
                catch (SIException sIException) {
                    mQFap.createStatus((byte)8, 3, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                    MQLinkReceiver.this.batchException = (Exception)((Object)sIException);
                    this.gotoState(2);
                }
                catch (MessageStoreException messageStoreException) {
                    mQFap.createStatus((byte)8, 3, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                    MQLinkReceiver.this.batchException = (Exception)((Object)messageStoreException);
                    this.gotoState(2);
                }
                MQLinkReceiver.this.npmSpeedFast = MQLinkReceiver.this.mqlink.isNpmSpeedFast();
                if ((initData.getIDFlags2() & 2) != 0 && !MQLinkReceiver.this.npmSpeedFast) {
                    tSH.setControlFlags1((byte)2);
                    byte by2 = initData.getIDFlags2();
                    by2 = (byte)(by2 ^ 2);
                    initData.setIDFlags2(by2);
                    initData.setIDEFlags2((byte)2);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats != null) {
                        MQLinkReceiver.this.stats.receiverSent(l);
                    }
                } else {
                    if ((initData.getIDFlags2() & 2) == 0) {
                        MQLinkReceiver.this.npmSpeedFast = false;
                    }
                    MQLinkReceiver.this.heartbeatInterval = initData.getHeartbeatInterval();
                    MQLinkReceiver.this.maxMessageSize = initData.getMaxMessageSize();
                    MQLinkReceiver.this.maxTransmissionSize = initData.getMaxTransmissionSize();
                    MQLinkReceiver.this.batchSize = initData.getMaxMessagesPerBatch();
                    if (MQLinkReceiver.this.jsConnection != null) {
                        tSH.setControlFlags1((byte)0);
                        mQFap.getInitData().setCCSID((short)1208);
                        long l = mQFap.send(connection);
                        if (MQLinkReceiver.this.stats != null) {
                            MQLinkReceiver.this.stats.receiverSent(l);
                        }
                        MQLinkReceiver.this.maxSequenceNum = initData.getMessageSequenceWrapValue();
                        if (MQLinkReceiver.this.expectedSequenceNum > MQLinkReceiver.this.maxSequenceNum) {
                            MQLinkReceiver.this.expectedSequenceNum = 1;
                        }
                        MQLinkReceiver.this.mqlink.emitNotification(9, MQLinkReceiver.this.remoteQmgrName);
                        this.gotoState(4);
                    }
                }
            } else {
                mQFap.createStatus((byte)8, 22, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                long l = mQFap.send(connection);
                if (MQLinkReceiver.this.stats != null) {
                    MQLinkReceiver.this.stats.receiverSent(l);
                }
                this.gotoState(2);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doAccept");
            }
        }

        private void doReset(Connection connection, MQFap mQFap) throws IOException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doReset");
            }
            Reset reset = mQFap.getReset();
            MQLinkReceiver.this.expectedSequenceNum = reset.getMessageSequenceNumber();
            this.gotoState(8);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doReset");
            }
        }

        private void doResync(Connection connection, MQFap mQFap) throws IOException {
            int n;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doResync");
            }
            Resync resync = mQFap.getResync();
            TSH tSH = mQFap.getTsh();
            if (tc.isDebugEnabled()) {
                if (MQLinkReceiver.this.syncItem != null) {
                    SibTr.debug((TraceComponent)tc, (String)"Sync LUWID (Hex)  :", (Object)Long.toHexString(MQLinkReceiver.this.syncItem.getCommittedLuwid()));
                    SibTr.debug((TraceComponent)tc, (String)"Sync LUWID        :", (Object)("" + MQLinkReceiver.this.syncItem.getCommittedLuwid()));
                    SibTr.debug((TraceComponent)tc, (String)("Sync Seq Num (Hex):" + Integer.toHexString(MQLinkReceiver.this.syncItem.getCommittedSequenceNumber())));
                    SibTr.debug((TraceComponent)tc, (String)("Sync Seq Num      :" + MQLinkReceiver.this.syncItem.getCommittedSequenceNumber()));
                }
                if (resync != null) {
                    SibTr.debug((TraceComponent)tc, (String)"Mess LUWID   (Hex):", (Object)Long.toHexString(resync.getLUWID()));
                    SibTr.debug((TraceComponent)tc, (String)"Mess LUWID        :", (Object)("" + resync.getLUWID()));
                    SibTr.debug((TraceComponent)tc, (String)("Mess Seq Num (Hex):" + Integer.toHexString(resync.getMessageSequenceNumber())));
                    SibTr.debug((TraceComponent)tc, (String)("Mess Seq Num      :" + resync.getMessageSequenceNumber()));
                }
                if (tSH != null) {
                    SibTr.debug((TraceComponent)tc, (String)"TSH LUWID (Hex) : ", (Object)Long.toHexString(tSH.getLUWID()));
                    SibTr.debug((TraceComponent)tc, (String)"TSH LUWID       : ", (Object)("" + tSH.getLUWID()));
                }
            }
            if (MQLinkReceiver.this.syncItem == null) {
                n = 2;
            } else if (MQLinkReceiver.this.syncItem.getCommittedLuwid() != resync.getLUWID()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The LUWID's do not match!");
                }
                n = 2;
                mQFap.getTsh().setLUWID(MQLinkReceiver.this.syncItem.getCommittedLuwid());
            } else if (MQLinkReceiver.this.syncItem.getCommittedSequenceNumber() != resync.getMessageSequenceNumber()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The Sequence numbers do not match!");
                }
                n = 2;
                mQFap.getTsh().setLUWID(MQLinkReceiver.this.syncItem.getCommittedLuwid());
            } else {
                n = 0;
            }
            try {
                mQFap.createStatus((byte)n, 0, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                long l = mQFap.send(connection);
                if (MQLinkReceiver.this.stats != null) {
                    MQLinkReceiver.this.stats.receiverSent(l);
                }
            }
            catch (SIException sIException) {
                MQUtil.reportError(connection, null, sIException);
            }
            this.gotoState(6);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doResync");
            }
        }

        private void doBatchConfirm(Connection connection, MQFap mQFap) throws IOException, SIConnectionDroppedException, SIConnectionLostException {
            block21: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
                }
                if (MQLinkReceiver.this.batchError != 0) {
                    try {
                        if (MQLinkReceiver.this.transaction != null) {
                            MQLinkReceiver.this.transaction.rollback();
                        }
                        break block21;
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"MQLinkReceiver$ReceiverStateMachine.doBatchConfirm", (String)"6", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                        }
                        break block21;
                    }
                }
                if (MQLinkReceiver.this.recoverableBatch) {
                    if (MQLinkReceiver.this.syncItem == null) {
                        MQLinkReceiver.this.syncItem = new MQSyncItem(2, MQLinkReceiver.this.remoteQmgrName, MQLinkReceiver.this.mqlink.getReceiverChannelName(), MQLinkReceiver.this.mqlink.getMQLinkName());
                    }
                    if (MQLinkReceiver.this.transaction != null) {
                        MQLinkReceiver.this.syncItem.setRecoveryFields();
                    }
                    MQLinkReceiver.this.syncItem.setCommittedLuwid(MQLinkReceiver.this.lastLuwidReceived);
                    MQLinkReceiver.this.syncItem.setCommittedSequenceNumber(MQLinkReceiver.this.lastSequenceNumReceived);
                    try {
                        MQLinkReceiver.this.mqSync.writeSync(MQLinkReceiver.this.syncItem, (Transaction)MQLinkReceiver.this.transaction);
                        if (MQLinkReceiver.this.transaction != null) {
                            MQLinkReceiver.this.transaction.commit();
                        }
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"MQLinkReceiver$ReceiverStateMachine.doBatchConfirm", (String)"7", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                        }
                        MQLinkReceiver.this.batchError = 17;
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkReceiver$ReceiverStateMachine.doBatchConfirm", (String)"8", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)messageStoreException));
                        }
                        MQLinkReceiver.this.batchError = 17;
                    }
                }
            }
            byte by = MQLinkReceiver.this.batchError == 0 ? (byte)0 : 6;
            if (MQLinkReceiver.this.stopRequested) {
                by = (byte)(by | 4);
            }
            switch (MQLinkReceiver.this.batchError) {
                case 4: 
                case 19: 
                case 21: {
                    mQFap.createStatus(by, MQLinkReceiver.this.batchError, new Integer(MQLinkReceiver.this.batchData), MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats == null) break;
                    MQLinkReceiver.this.stats.receiverSent(l);
                    break;
                }
                default: {
                    mQFap.createStatus(by, MQLinkReceiver.this.batchError, null, MQLinkReceiver.this.wireEnc, MQLinkReceiver.this.wireCCSID);
                    long l = mQFap.send(connection);
                    if (MQLinkReceiver.this.stats == null) break;
                    MQLinkReceiver.this.stats.receiverSent(l);
                }
            }
            if (MQLinkReceiver.this.stats != null) {
                MQLinkReceiver.this.stats.onBatchReceive();
            }
            MQLinkReceiver.this.batchError = 0;
            MQLinkReceiver.this.batchData = 0;
            MQLinkReceiver.this.recoverableBatch = false;
            MQLinkReceiver.this.numberBatches++;
            MQLinkReceiver.this.msgsInBatch = 0;
            MQLinkReceiver.this.transaction = null;
            this.gotoState(8);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
            }
        }

        private void doMessage(Connection connection, MQFap mQFap) throws IOException, SIConnectionLostException, SIConnectionDroppedException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doMessage");
            }
            this.gotoState(8);
            JsMessage jsMessage = null;
            TSH tSH = mQFap.getTsh();
            MSH mSH = mQFap.getMsh();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message received by MQ link receiver:" + mQFap));
            }
            boolean bl = (tSH.getControlFlags1() & 0x10) != 0;
            boolean bl2 = (tSH.getControlFlags1() & 0x20) != 0;
            int n = mSH.getMessageSegmentNumber();
            if (n == MQLinkReceiver.this.expectedSegmentNum) {
                if (bl) {
                    this.jsmFap = mQFap;
                }
                this.jsmFap.addSegment(mQFap);
                if (bl2) {
                    try {
                        if (MQLinkReceiver.this.stats != null) {
                            MQLinkReceiver.this.stats.onReceiveMessage();
                        }
                        MQLinkReceiver.this.lastMessageTime = System.currentTimeMillis();
                        jsMessage = this.jsmFap.decodeMessage(MQLinkReceiver.this.PersReliability, MQLinkReceiver.this.NPReliability, MQLinkReceiver.this.mqlink.getQMName(), MQLinkReceiver.this.localBusName, MQLinkReceiver.this.foreignBusName, MQLinkReceiver.this.localBusSecurity, MQLinkReceiver.this.inboundUserId);
                    }
                    catch (Exception exception) {
                        MQLinkReceiver.this.batchException = exception;
                        if (MQLinkReceiver.this.batchError == 0) {
                            MQUtil.reportError(connection, mQFap, exception);
                        }
                        MQLinkReceiver.this.batchError = 6;
                        this.jsmFap.release();
                    }
                    MQLinkReceiver.this.expectedSegmentNum = 0;
                } else {
                    MQLinkReceiver.this.expectedSegmentNum++;
                }
            } else {
                if (MQLinkReceiver.this.batchError == 0) {
                    MQUtil.reportError(connection, mQFap, null);
                    MQLinkReceiver.this.batchError = 19;
                    MQLinkReceiver.this.batchData = MQLinkReceiver.this.expectedSegmentNum;
                    mQFap.release();
                }
                this.jsmFap = null;
                MQLinkReceiver.this.expectedSegmentNum = 0;
            }
            if (jsMessage != null) {
                int n2 = mSH.getMessageSequenceNumber();
                if (MQLinkReceiver.this.expectedSequenceNum != n2) {
                    SibTr.error((TraceComponent)tc, (String)"ERR_RCV_SEQUENCE_ERROR_SICO3015", (Object)new Object[]{MQLinkReceiver.this.mqlink.getMQLinkName(), new Integer(n2), new Integer(MQLinkReceiver.this.expectedSequenceNum)});
                    if (MQLinkReceiver.this.batchError == 0) {
                        MQUtil.reportError(connection, mQFap, null);
                        MQLinkReceiver.this.batchError = 4;
                        MQLinkReceiver.this.batchData = MQLinkReceiver.this.expectedSequenceNum;
                    }
                } else {
                    MQLinkReceiver.this.lastSequenceNumReceived = n2;
                    MQLinkReceiver.this.expectedSequenceNum = n2 + 1;
                    if (MQLinkReceiver.this.expectedSequenceNum > MQLinkReceiver.this.maxSequenceNum) {
                        MQLinkReceiver.this.expectedSequenceNum = 1;
                    }
                    MQLinkReceiver.this.lastLuwidReceived = tSH.getLUWID();
                    if (!MQLinkReceiver.this.recoverableBatch) {
                        Reliability reliability = jsMessage.getReliability();
                        if (reliability == Reliability.EXPRESS_NONPERSISTENT || reliability == Reliability.BEST_EFFORT_NONPERSISTENT || reliability == Reliability.RELIABLE_NONPERSISTENT) {
                            MQLinkReceiver.this.recoverableBatch = !MQLinkReceiver.this.npmSpeedFast;
                        } else {
                            MQLinkReceiver.this.recoverableBatch = true;
                        }
                        if (MQLinkReceiver.this.transaction == null && MQLinkReceiver.this.recoverableBatch) {
                            MQLinkReceiver.this.transaction = MQLinkReceiver.this.messageStore.getTransactionFactory().createLocalTransaction();
                        }
                    }
                    try {
                        MQLinkReceiver.this.msgsInBatch++;
                        MQLinkReceiver.this.numberMessages++;
                        MQLinkReceiver.this.forwardMessage(jsMessage, (SITransaction)MQLinkReceiver.this.transaction);
                    }
                    catch (SIException sIException) {
                        MQLinkReceiver.this.batchException = (Exception)((Object)sIException);
                        if (MQLinkReceiver.this.batchError == 0) {
                            MQUtil.reportError(connection, mQFap, sIException);
                        }
                        MQLinkReceiver.this.batchError = 6;
                    }
                }
                if ((tSH.getControlFlags1() & 1) != 0) {
                    this.doBatchConfirm(connection, mQFap);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doMessage");
            }
        }
    }

    private class ProducerSessionCache {
        private static final int MAX_CACHE_ENTRIES = 50;
        private static final long MAX_CACHE_TIME = 300000L;
        private Hashtable cacheByName = new Hashtable();
        private int numEntries = 0;
        private ProducerCacheEntry[] cache = new ProducerCacheEntry[50];

        private ProducerSessionCache() {
        }

        private String getKey(String string, String string2, String string3) {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            return new String(string2 + '@' + string + '@' + string3);
        }

        public void add(ProducerSession producerSession, String string, String string2, String string3) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"add");
            }
            ProducerCacheEntry producerCacheEntry = new ProducerCacheEntry(producerSession, string, string2, string3);
            int n = 0;
            this.flush(false);
            if (this.numEntries == 50) {
                long l = this.cache[0].lastAccessTime;
                n = 0;
                for (int i = 1; i < 50; ++i) {
                    if (l <= this.cache[i].lastAccessTime) continue;
                    l = this.cache[i].lastAccessTime;
                    n = i;
                }
                String string4 = this.getKey(this.cache[n].busName, this.cache[n].destName, this.cache[n].userid);
                this.cacheByName.remove(string4);
                try {
                    this.cache[n].session.close();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkReceiver$ProducerSessionCache.add", (String)"4", (Object)this);
                }
            } else {
                n = this.numEntries++;
            }
            String string5 = this.getKey(string, string2, string3);
            this.cacheByName.put(string5, producerCacheEntry);
            this.cache[n] = producerCacheEntry;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
            }
        }

        public ProducerSession find(String string, String string2, String string3) {
            String string4;
            ProducerCacheEntry producerCacheEntry;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"find");
            }
            if ((producerCacheEntry = (ProducerCacheEntry)this.cacheByName.get(string4 = this.getKey(string, string2, string3))) != null) {
                producerCacheEntry.lastAccessTime = System.currentTimeMillis();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"find");
                }
                return producerCacheEntry.session;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"find");
            }
            return null;
        }

        void flush(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush");
            }
            int n = 0;
            long l = System.currentTimeMillis();
            while (n < this.numEntries) {
                if (this.cache[n].lastAccessTime - l > 300000L || bl) {
                    String string = this.getKey(this.cache[n].busName, this.cache[n].destName, this.cache[n].userid);
                    this.cacheByName.remove(string);
                    try {
                        this.cache[n].session.close();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"MQLinkReceiver$ProducerSessionCache.flush", (String)"5", (Object)this);
                    }
                    this.cache[n] = this.cache[this.numEntries - 1];
                    --this.numEntries;
                    continue;
                }
                ++n;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
            }
        }

        private class ProducerCacheEntry {
            private ProducerSession session;
            private long lastAccessTime;
            private String busName;
            private String destName;
            private String userid;

            ProducerCacheEntry(ProducerSession producerSession, String string, String string2, String string3) {
                this.session = producerSession;
                this.lastAccessTime = System.currentTimeMillis();
                this.destName = string2;
                this.busName = string;
                this.userid = string3;
            }
        }
    }
}

