/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.mq.MQLinkManager;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.link.MQAcceptListener;
import com.ibm.ws.sib.comms.mq.link.MQClientLink;
import com.ibm.ws.sib.comms.mq.link.MQLink;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class MQLinkManagerImpl
extends MQLinkManager {
    private static final TraceComponent tc = SibTr.register((Class)MQLinkManagerImpl.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private List mqLinkList;
    private List mqClientLinkList;
    MQAcceptListener acceptListener;
    private boolean systemJmsQueuesCreated = false;
    private String systemJmsAdminQueueName = null;
    private String systemJmsReportQueueName = null;
    private String systemJmsPsStatusQueueName = null;
    private String systemJmsNDCCSubscriberQueueName = null;
    private String systemJmsDCCSubscriberQueueName = null;

    public MQLinkManagerImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQLinkManagerImpl");
        }
        this.mqLinkList = new LinkedList();
        this.mqClientLinkList = new LinkedList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQLinkManagerImpl");
        }
    }

    public void addMQLink(MQLink mQLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMQLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: mqLink", (Object)mQLink);
        }
        if (this.mqClientLinkList.isEmpty() && this.mqLinkList.isEmpty()) {
            this.acceptListener = new MQAcceptListener(this);
            try {
                this.acceptListener.start();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"MQLinkManagerImpl.addMQLink", (String)"1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
                this.acceptListener = null;
            }
        }
        this.mqLinkList.add(mQLink);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMQLink");
        }
    }

    public void removeMQLink(MQLink mQLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMQLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: mqLink", (Object)mQLink);
        }
        this.mqLinkList.remove(mQLink);
        if (this.mqClientLinkList.isEmpty() && this.mqLinkList.isEmpty() && this.acceptListener != null) {
            this.acceptListener.stop();
            this.acceptListener = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMQLink");
        }
    }

    public void addMQClientLink(MQClientLink mQClientLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMQClientLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params:", (Object)mQClientLink);
        }
        if (this.mqClientLinkList.isEmpty() && this.mqLinkList.isEmpty()) {
            this.acceptListener = new MQAcceptListener(this);
            try {
                this.acceptListener.start();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"MQLinkManagerImpl.addMQClientLink", (String)"2");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
                this.acceptListener = null;
            }
        }
        this.mqClientLinkList.add(mQClientLink);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMQClientLink");
        }
    }

    public void removeMQClientLink(MQClientLink mQClientLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMQClientLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: mqClientLink", (Object)mQClientLink);
        }
        this.mqClientLinkList.remove(mQClientLink);
        if (this.mqClientLinkList.isEmpty() && this.mqLinkList.isEmpty() && this.acceptListener != null) {
            this.acceptListener.stop();
            this.acceptListener = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMQClientLink");
        }
    }

    public MQLink getMQLink(String string, String string2) {
        int n;
        int n2;
        int n3 = 0;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: receiverChannel, qmName", (Object)new Object[]{string, string2});
        }
        if ((n2 = string.indexOf(32, 0)) == -1) {
            n2 = string.length();
        }
        if ((n = string2.indexOf(32, 0)) == -1) {
            n = string2.length();
        }
        for (n3 = 0; n3 < this.mqLinkList.size(); ++n3) {
            MQLink mQLink = (MQLink)this.mqLinkList.get(n3);
            if (!string.regionMatches(0, mQLink.getReceiverChannelName(), 0, n2)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLink");
            }
            return mQLink;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLink");
        }
        return null;
    }

    public MQLink getMQLink(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Param: MQLink UUID", (Object)string);
        }
        for (int i = 0; i < this.mqLinkList.size(); ++i) {
            MQLink mQLink = (MQLink)this.mqLinkList.get(i);
            if (mQLink.getMQLinkUuid() != string) continue;
            return mQLink;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLink");
        }
        return null;
    }

    public MQClientLink getMQClientLink(String string, String string2, boolean bl) {
        ListIterator listIterator = this.mqClientLinkList.listIterator();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQClientLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: serverChannel, qmName, isDefault", (Object)new Object[]{string, string2, "" + bl});
        }
        while (listIterator.hasNext()) {
            MQClientLink mQClientLink = (MQClientLink)listIterator.next();
            if (!mQClientLink.getMQChannelName().equals(string.trim())) continue;
            if (bl) {
                if (!mQClientLink.getIsDefaultMQClientLink()) continue;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)("getMQClientLink " + mQClientLink));
                }
                return mQClientLink;
            }
            if (string2 != null && !mQClientLink.getVirtualQmgrName().equals(string2)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)("getMQClientLink " + mQClientLink));
            }
            return mQClientLink;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQClientLink");
        }
        return null;
    }

    public MQClientLink getMQClientLink2(String string, String string2, boolean bl) throws MQException {
        ListIterator listIterator = this.mqClientLinkList.listIterator();
        MQClientLink mQClientLink = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQClientLink2");
        }
        if (string != null) {
            string = string.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: serverChannel, qmName, isDefault", (Object)new Object[]{string, string2, "" + bl});
        }
        while (listIterator.hasNext()) {
            mQClientLink = (MQClientLink)listIterator.next();
            if (mQClientLink.getMQChannelName().trim().equals(string)) {
                bl2 = false;
                if (bl) {
                    if (!mQClientLink.getIsDefaultMQClientLink()) continue;
                    break;
                }
                if (string2 == null || mQClientLink.getVirtualQmgrName().trim().equals(string2)) {
                    bl3 = false;
                    break;
                }
                bl3 = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            throw new MQException(2059);
        }
        if (bl3 || mQClientLink == null) {
            throw new MQException(2058);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("getMQClientLink2" + mQClientLink));
        }
        return mQClientLink;
    }

    public boolean isMQLinkDeletable(String string, ItemStream itemStream) {
        boolean bl = true;
        MQLink mQLink = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMQLinkDeletable");
        }
        if ((mQLink = this.getMQLink(string)) != null && (bl = mQLink.isDeletable(itemStream))) {
            this.removeMQLink(mQLink);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMQLinkDeletable");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJMSSystemQueues(MQClientServerStateMachine mQClientServerStateMachine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createJMSSystemQueues", (Object)mQClientServerStateMachine);
        }
        MQLinkManagerImpl mQLinkManagerImpl = this;
        synchronized (mQLinkManagerImpl) {
            block41: {
                if (this.systemJmsQueuesCreated) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"The System JMS queues were already created.");
                    }
                } else {
                    Object object;
                    String string;
                    MPCoreConnection mPCoreConnection;
                    block40: {
                        mPCoreConnection = (MPCoreConnection)mQClientServerStateMachine.getJSConnection();
                        String string2 = mQClientServerStateMachine.getMQClientLink().getBusName();
                        JsMessagingEngine jsMessagingEngine = mQClientServerStateMachine.getEngine();
                        SIMPMessageProcessorControllable sIMPMessageProcessorControllable = ((SIMPAdmin)jsMessagingEngine.getMessageProcessor()).getAdministrator().getMPRuntimeControl();
                        try {
                            string = "_P" + "SYSTEM.JMS.ADMIN.QUEUE".substring(0, "SYSTEM.JMS.ADMIN.QUEUE".length() - 6) + '_' + mPCoreConnection.getMeUuid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking for: " + string));
                            }
                            sIMPMessageProcessorControllable.getQueueControlByName(string, string2);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"The queue was located");
                            }
                            this.systemJmsAdminQueueName = string;
                            object = "_P" + "SYSTEM.JMS.REPORT.QUEUE".substring(0, "SYSTEM.JMS.REPORT.QUEUE".length() - 6) + '_' + mPCoreConnection.getMeUuid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking for: " + (String)object));
                            }
                            sIMPMessageProcessorControllable.getQueueControlByName((String)object, string2);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"The queue was located");
                            }
                            this.systemJmsReportQueueName = object;
                            String string3 = "_P" + "SYSTEM.JMS.PS.STATUS.QUEUE".substring(0, "SYSTEM.JMS.PS.STATUS.QUEUE".length() - 6) + '_' + mPCoreConnection.getMeUuid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking for: " + string3));
                            }
                            sIMPMessageProcessorControllable.getQueueControlByName(string3, string2);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"The queue was located");
                            }
                            this.systemJmsPsStatusQueueName = string3;
                            String string4 = "_P" + "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE".substring(0, "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE".length() - 13) + '_' + mPCoreConnection.getMeUuid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking for: " + string4));
                            }
                            sIMPMessageProcessorControllable.getQueueControlByName(string4, string2);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"The queue was located");
                            }
                            this.systemJmsNDCCSubscriberQueueName = string4;
                            String string5 = "_P" + "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE".substring(0, "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE".length() - 13) + '_' + mPCoreConnection.getMeUuid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Checking for: " + string5));
                            }
                            sIMPMessageProcessorControllable.getQueueControlByName(string5, string2);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"The queue was located");
                            }
                            this.systemJmsDCCSubscriberQueueName = string5;
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"All queues located.");
                            }
                            this.systemJmsQueuesCreated = true;
                        }
                        catch (SIMPException sIMPException) {
                            if (!tc.isDebugEnabled()) break block40;
                            SibTr.debug((TraceComponent)tc, (String)("The queue was not located due to: " + sIMPException));
                        }
                    }
                    if (!this.systemJmsQueuesCreated) {
                        try {
                            string = null;
                            object = null;
                            if (this.systemJmsAdminQueueName == null) {
                                string = "SYSTEM.JMS.ADMIN.QUEUE";
                                string = string.substring(0, string.length() - 6);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Creating the admin queue with prefix: " + string));
                                }
                                object = mPCoreConnection.createSystemDestination(string);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Created queue with name: " + object.getDestinationName()));
                                }
                                this.systemJmsAdminQueueName = object.getDestinationName();
                            }
                            if (this.systemJmsReportQueueName == null) {
                                string = "SYSTEM.JMS.REPORT.QUEUE";
                                string = string.substring(0, string.length() - 6);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Creating the admin queue with prefix: " + string));
                                }
                                object = mPCoreConnection.createSystemDestination(string);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Created queue with name: " + object.getDestinationName()));
                                }
                                this.systemJmsReportQueueName = object.getDestinationName();
                            }
                            if (this.systemJmsPsStatusQueueName == null) {
                                string = "SYSTEM.JMS.PS.STATUS.QUEUE";
                                string = string.substring(0, string.length() - 6);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Creating the admin queue with prefix: " + string));
                                }
                                object = mPCoreConnection.createSystemDestination(string);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Created queue with name: " + object.getDestinationName()));
                                }
                                this.systemJmsPsStatusQueueName = object.getDestinationName();
                            }
                            if (this.systemJmsNDCCSubscriberQueueName == null) {
                                string = "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE";
                                string = string.substring(0, string.length() - 13);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Creating the admin queue with prefix: " + string));
                                }
                                object = mPCoreConnection.createSystemDestination(string);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Created queue with name: " + object.getDestinationName()));
                                }
                                this.systemJmsNDCCSubscriberQueueName = object.getDestinationName();
                            }
                            if (this.systemJmsDCCSubscriberQueueName == null) {
                                string = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
                                string = string.substring(0, string.length() - 13);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Creating the admin queue with prefix: " + string));
                                }
                                object = mPCoreConnection.createSystemDestination(string);
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Created queue with name: " + object.getDestinationName()));
                                }
                                this.systemJmsDCCSubscriberQueueName = object.getDestinationName();
                            }
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"All queues were created successfully");
                            }
                            this.systemJmsQueuesCreated = true;
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.link.MQLinkManager", (String)"3", (Object)((Object)this));
                            if (!tc.isDebugEnabled()) break block41;
                            SibTr.debug((TraceComponent)tc, (String)"The queue failed to be created", (Object)((Object)sIException));
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createJMSSystemQueues");
        }
    }

    public boolean isJmsPubSubSystemQueue(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isJmsPubSubSystemQueue", (Object)string);
        }
        boolean bl = false;
        if (string.equals("SYSTEM.JMS.ADMIN.QUEUE") || string.equals("SYSTEM.JMS.REPORT.QUEUE") || string.equals("SYSTEM.JMS.PS.STATUS.QUEUE") || string.equals("SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE") || string.equals("SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE")) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isJmsPubSubSystemQueue", (Object)("" + bl));
        }
        return bl;
    }

    public String mapSystemObjectName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mapSystemJmsObjectName", (Object)string);
        }
        if (string.equals("SYSTEM.JMS.ADMIN.QUEUE")) {
            string = this.getSystemJmsAdminQueueName();
        } else if (string.equals("SYSTEM.JMS.REPORT.QUEUE")) {
            string = this.getSystemJmsReportQueueName();
        } else if (string.equals("SYSTEM.JMS.PS.STATUS.QUEUE")) {
            string = this.getSystemJmsPsStatusQueueName();
        } else if (string.equals("SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE")) {
            string = this.getSystemJmsNDCCSubscriberQueueName();
        } else if (string.equals("SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE")) {
            string = this.getSystemJmsDCCSubscriberQueueName();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mapSystemJmsObjectName", (Object)string);
        }
        return string;
    }

    public String getSystemJmsAdminQueueName() {
        return this.systemJmsAdminQueueName;
    }

    public String getSystemJmsReportQueueName() {
        return this.systemJmsReportQueueName;
    }

    public String getSystemJmsPsStatusQueueName() {
        return this.systemJmsPsStatusQueueName;
    }

    public String getSystemJmsNDCCSubscriberQueueName() {
        return this.systemJmsNDCCSubscriberQueueName;
    }

    public String getSystemJmsDCCSubscriberQueueName() {
        return this.systemJmsDCCSubscriberQueueName;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQLinkManagerImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.10");
        }
    }
}

