/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.mq.client.MQClientServer;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQClientLink;
import com.ibm.ws.sib.comms.mq.link.MQLink;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.link.MQLinkReceiver;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.fap.InitData;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mqfapchannel.AcceptListener;
import com.ibm.ws.sib.mqfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ConnectionManager;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MQAcceptListener
implements AcceptListener,
ReceiveListener,
MQFAP,
MQConstants,
LinkConstants {
    private static final TraceComponent tc = SibTr.register((Class)MQAcceptListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private MQLinkManagerImpl linkManagerImpl;
    private WsByteBufferPoolManager poolManager = ConnectionManager.getPoolMgr();

    public MQAcceptListener(MQLinkManagerImpl mQLinkManagerImpl) {
        this.linkManagerImpl = mQLinkManagerImpl;
    }

    public void start() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        ConnectionManager.initialise(new MQAcceptListenerFactory(this));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public ReceiveListener acceptConnection(Connection connection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"acceptConnection");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"acceptConnection");
        }
        return this;
    }

    public ReceiveListener dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
        MQFap mQFap;
        LinkConstants linkConstants;
        block45: {
            TSH tSH = null;
            linkConstants = null;
            byte by = 0;
            short s = 0;
            byte by2 = 0;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"dataReceived");
            }
            if (tc.isDebugEnabled()) {
                SibTr.bytes((TraceComponent)tc, (byte[])wsByteBuffer.array());
            }
            mQFap = null;
            try {
                mQFap = new MQFap(wsByteBuffer);
                tSH = mQFap.getTsh();
                by = tSH.getEncoding();
                s = tSH.getCCSID();
                if (mQFap.isUnsupportedCCSID()) {
                    throw new UnsupportedEncodingException();
                }
                if (tSH.getSegmentType() != 1) {
                    if (tSH.getSegmentType() != 5 || tSH.getSegmentType() == 5 & (tSH.getControlFlags1() & 8) == 0) {
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("ERR_MQLINKACCEPT_SEG_SICO321034", new Object[]{new Integer(tSH.getSegmentType())}, null));
                        MQUtil.reportError(connection, wsByteBuffer, sIErrorException);
                    }
                    connection.close();
                    break block45;
                }
                InitData initData = mQFap.getInitData();
                int n = initData.getFapLevel() & 0xFF;
                by2 = initData.getIDFlags();
                MQClientLink mQClientLink = null;
                boolean bl = false;
                CCSID.getCodepage((int)s);
                if ((by2 & 0x20) != 0) {
                    try {
                        mQClientLink = this.linkManagerImpl.getMQClientLink2(initData.getChannelName(), null, false);
                    }
                    catch (MQException mQException) {
                        int n2;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No MQ Link was available");
                        }
                        if ((n2 = mQException.getReason()) == 2059) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("There is no MQClientLink object defined with channel name " + initData.getChannelName().trim()));
                            }
                        } else if (n2 == 2058 && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"There is no MQClientLink object defined for the specified queue manager");
                        }
                        mQFap.createStatus((byte)8, 1, null, by, s);
                        mQFap.send(connection);
                        connection.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    if (n < 4) {
                        tSH.setControlFlags1((byte)2);
                        initData.setFapLevel((byte)4);
                        initData.setErrFlags((byte)8);
                        mQFap.send(connection);
                    } else if (n > 7) {
                        if ((by2 & 0x20) != 0) {
                            linkConstants = new MQClientServer(connection, mQClientLink);
                            connection.setType(Connection.CLIENT);
                        } else {
                            tSH.setControlFlags1((byte)2);
                            initData.setFapLevel((byte)7);
                            initData.setErrFlags((byte)8);
                            mQFap.send(connection);
                        }
                    } else if ((by2 & 0x20) != 0) {
                        linkConstants = new MQClientServer(connection, mQClientLink);
                        connection.setType(Connection.CLIENT);
                    } else {
                        MQLink mQLink = this.linkManagerImpl.getMQLink(initData.getChannelName(), initData.getQueueManagerName());
                        if (mQLink == null) {
                            SibTr.error((TraceComponent)tc, (String)"ERR_MQLINKACCEPT_LINK_SICO3236", (Object)new Object[]{initData.getChannelName().trim()});
                            mQFap.createStatus((byte)8, 1, null, by, s);
                            mQFap.send(connection);
                            connection.close();
                        } else {
                            linkConstants = new MQLinkReceiver(this.linkManagerImpl, mQLink);
                            connection.setType(Connection.QMGR);
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an UnsupportedEncodingException", (Object)unsupportedEncodingException);
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unsupported CCSID : CCSID = " + s + " Encoding = " + Integer.toHexString(by)));
                }
                Object[] objectArray = new Object[]{"CCSID " + s + " is not supported"};
                SibTr.error((TraceComponent)tc, (String)"TEMPORARY_CWSIC9999", (Object)objectArray);
                if (tSH.getSegmentType() == 1) {
                    by2 = mQFap.getIdFlags();
                }
                try {
                    if ((by2 & 0x20) != 0) {
                        mQFap.createErrorStatus((byte)8, by, s);
                        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>(1);
                        arrayList.add(wsByteBuffer);
                        if (tc.isDebugEnabled()) {
                            SibTr.bytes((TraceComponent)tc, (byte[])wsByteBuffer.array());
                        }
                        connection.send(arrayList, null, false);
                        arrayList = null;
                        wsByteBuffer = null;
                        connection.close();
                    } else {
                        MQFap mQFap2 = new MQFap(1, 2, by, 1208);
                        mQFap2.getTsh().setMQEncoding(273);
                        mQFap2.getInitData().setCCSID((short)1208);
                        mQFap2.getInitData().setErrFlags((byte)1);
                        if (mQFap != null && mQFap.getInitData() != null) {
                            if ((mQFap.getInitData().getIDFlags() & 2) != 0) {
                                mQFap2.getInitData().setIDEFlags2((byte)4);
                            }
                        } else {
                            mQFap2.getInitData().setIDEFlags2((byte)4);
                        }
                        mQFap2.send(connection);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Data Sent" + mQFap2.toString()));
                        }
                    }
                }
                catch (SIException sIException) {
                    MQUtil.reportError(connection, null, sIException);
                }
            }
            catch (IOException iOException) {
                MQUtil.reportError(connection, wsByteBuffer, iOException);
                try {
                    connection.close();
                }
                catch (SIException sIException) {}
            }
            catch (SIException sIException) {
                MQUtil.reportError(connection, null, sIException);
            }
        }
        if (linkConstants == null) {
            if (mQFap != null) {
                mQFap.release();
            } else {
                wsByteBuffer.release();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dataReceived");
        }
        return linkConstants;
    }

    public void errorOccurred(Connection connection, Throwable throwable) {
        MQUtil.reportError(connection, null, throwable);
    }

    public WsByteBuffer buildErrorCloseFapFlow() {
        try {
            MQFap mQFap = new MQFap();
            mQFap.createStatus((byte)8, 12, null, (byte)17, (short)1208);
            return mQFap.getData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/mq/link/MQAcceptListener.java, SIB.comms, jstream 1.8");
        }
    }

    private class MQAcceptListenerFactory
    implements AcceptListenerFactory {
        private AcceptListener acceptListener;

        public MQAcceptListenerFactory(AcceptListener acceptListener) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"MQAcceptListenerFactory.<init>", (Object)acceptListener);
            }
            this.acceptListener = acceptListener;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"MQAcceptListenerFactory.<init>");
            }
        }

        public AcceptListener manufactureAcceptListener() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"MQAcceptListenerFactory.manufactureAcceptListener");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"MQAcceptListenerFactory.manufactureAcceptListener", (Object)this.acceptListener);
            }
            return this.acceptListener;
        }
    }
}

