/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.impl.CommsItemStream;
import com.ibm.ws.sib.comms.mq.client.Subscription;
import com.ibm.ws.sib.comms.mq.client.SubscriptionIdentity;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SubscriptionTable
extends ItemStream
implements MQConstants {
    static final TraceComponent tc = SibTr.register((Class)SubscriptionTable.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private Hashtable subscriptionIds = new Hashtable();
    private Hashtable subscriptionsById = new Hashtable();
    private Hashtable subscriptionsByName = new Hashtable();
    private Hashtable subscriptionQueues = new Hashtable();
    private MessageStore messageStore;
    private boolean isReady;

    public SubscriptionTable() throws MessageStoreException {
    }

    private SubscriptionTable(MessageStore messageStore) throws MessageStoreException {
        this.messageStore = messageStore;
    }

    protected boolean isSubscriptionQueue(String string) {
        return this.subscriptionQueues.get(string) != null;
    }

    Subscription getById(SubscriptionIdentity subscriptionIdentity) {
        return (Subscription)this.subscriptionsById.get(subscriptionIdentity);
    }

    Subscription getByName(String string) {
        return (Subscription)this.subscriptionsByName.get(string);
    }

    public ArrayList getMatching(ArrayList arrayList, String string, String string2, byte[] byArray, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMatching");
        }
        ArrayList<Subscription> arrayList2 = new ArrayList<Subscription>();
        Enumeration enumeration = this.subscriptionsById.elements();
        while (enumeration.hasMoreElements()) {
            Subscription subscription = (Subscription)enumeration.nextElement();
            if (!subscription.getId().matches(byArray, string3, string4) || string != null && !string.equals(subscription.getSubPoint()) || string2 != null && !string2.equals(subscription.getFilter())) continue;
            if (arrayList != null && arrayList.size() > 0) {
                String string5;
                int n;
                for (n = 0; n < arrayList.size() && !(string5 = (String)arrayList.get(n)).equals(subscription.getTopic()); ++n) {
                }
                if (n == arrayList.size()) continue;
            }
            arrayList2.add(subscription);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMatching");
        }
        return arrayList2;
    }

    void add(SubscriptionIdentity subscriptionIdentity, Subscription subscription, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("add " + subscriptionIdentity + "   " + subscription + "   " + transaction));
        }
        SubscriptionIdentity subscriptionIdentity2 = subscription.getId();
        String string = subscription.getSubName();
        String string2 = subscription.getQName();
        if (subscriptionIdentity != null && !this.subscriptionsById.containsKey(subscriptionIdentity)) {
            if (transaction == null) {
                transaction = this.messageStore.getTransactionFactory().createAutoCommitTransaction();
            }
            this.addItem(subscription, transaction);
        } else if (subscriptionIdentity != null) {
            this.subscriptionsById.remove(subscriptionIdentity);
        }
        this.subscriptionsById.put(subscriptionIdentity2, subscription);
        if (string != null) {
            this.subscriptionsByName.put(string, subscription);
        }
        if (this.subscriptionQueues.get(string2) == null) {
            this.subscriptionQueues.put(string2, string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    void remove(Subscription subscription, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        byte[] byArray = subscription.getCorrelId();
        String string = subscription.getSubName();
        SubscriptionIdentity subscriptionIdentity = this.findId(byArray, subscription.getQmgrName(), subscription.getQName());
        if (subscriptionIdentity != null) {
            this.subscriptionsById.remove(subscriptionIdentity);
        }
        if (string != null) {
            this.subscriptionsByName.remove(string);
        }
        SubscriptionFilter subscriptionFilter = new SubscriptionFilter(subscription);
        if (transaction == null) {
            transaction = this.messageStore.getTransactionFactory().createAutoCommitTransaction();
        }
        this.removeFirstMatchingItem(subscriptionFilter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove");
        }
    }

    private SubscriptionIdentity findId(byte[] byArray, String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findId");
        }
        SubscriptionIdentity subscriptionIdentity = new SubscriptionIdentity(byArray, string, string2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("subscriptionId in table = " + (SubscriptionIdentity)this.subscriptionIds.get(subscriptionIdentity)));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findId");
        }
        return (SubscriptionIdentity)this.subscriptionIds.get(subscriptionIdentity);
    }

    SubscriptionIdentity locateUser(byte[] byArray, String string, String string2, String string3, boolean bl, boolean bl2, Transaction transaction) throws MessageStoreException {
        SubscriptionIdentity subscriptionIdentity;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"locateUser");
        }
        if ((subscriptionIdentity = this.findId(byArray, string, string2)) == null) {
            if (bl2) {
                subscriptionIdentity = new SubscriptionIdentity(byArray, string, string2);
                subscriptionIdentity.isFixedUserId = bl;
                if (bl) {
                    subscriptionIdentity.fixedUserId = string3;
                } else {
                    subscriptionIdentity.variableUserIds.add(string3);
                }
                this.subscriptionIds.put(subscriptionIdentity, subscriptionIdentity);
                if (transaction == null) {
                    transaction = this.messageStore.getTransactionFactory().createAutoCommitTransaction();
                }
                this.addItem(subscriptionIdentity, transaction);
                return subscriptionIdentity;
            }
            return null;
        }
        if (this.addUser(subscriptionIdentity, string3, bl, bl2)) {
            return subscriptionIdentity;
        }
        return null;
    }

    boolean addUser(SubscriptionIdentity subscriptionIdentity, String string, boolean bl, boolean bl2) throws MessageStoreException {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"addUser");
        }
        if (!subscriptionIdentity.isFixedUserId) {
            if (!bl) {
                for (int i = 0; i < subscriptionIdentity.variableUserIds.size(); ++i) {
                    String string2 = (String)subscriptionIdentity.variableUserIds.get(i);
                    if (!string2.equals(string)) continue;
                    return true;
                }
                if (bl2) {
                    subscriptionIdentity.variableUserIds.add(string);
                }
                return true;
            }
            if (subscriptionIdentity.variableUserIds.size() > 0 || !((String)subscriptionIdentity.variableUserIds.get(0)).equals(string)) {
                if (this.subscriptionsById.get(subscriptionIdentity) == null) {
                    if (bl2) {
                        subscriptionIdentity.variableUserIds.clear();
                        subscriptionIdentity.fixedUserId = string;
                        subscriptionIdentity.isFixedUserId = true;
                    }
                    return true;
                }
                return false;
            }
            if (bl2) {
                subscriptionIdentity.variableUserIds.clear();
                subscriptionIdentity.fixedUserId = string;
                subscriptionIdentity.isFixedUserId = true;
            }
            return true;
        }
        if (subscriptionIdentity.fixedUserId.equals(string) || this.subscriptionsById.get(subscriptionIdentity) == null) {
            if (!bl && bl2) {
                subscriptionIdentity.fixedUserId = null;
                subscriptionIdentity.variableUserIds.add(string);
                subscriptionIdentity.isFixedUserId = false;
            }
            return true;
        }
        return false;
    }

    public void addSubscriptionQueue(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("addSubscriptionQueue " + string));
        }
        if (this.subscriptionQueues.get(string) == null) {
            this.subscriptionQueues.put(string, string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addSubscriptionQueue");
        }
    }

    public static synchronized SubscriptionTable open(MessageStore messageStore) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"open");
        }
        ExternalAutoCommitTransaction externalAutoCommitTransaction = messageStore.getTransactionFactory().createAutoCommitTransaction();
        Filter filter = new Filter(){

            public boolean filterMatches(AbstractItem abstractItem) {
                return abstractItem instanceof CommsItemStream;
            }
        };
        Filter filter2 = new Filter(){

            public boolean filterMatches(AbstractItem abstractItem) {
                return abstractItem instanceof SubscriptionTable;
            }
        };
        ItemStream itemStream = messageStore.findFirstMatching(filter);
        SubscriptionTable subscriptionTable = null;
        if (itemStream == null) {
            itemStream = new CommsItemStream();
            messageStore.add(itemStream, externalAutoCommitTransaction);
        }
        if (itemStream != null && (subscriptionTable = (SubscriptionTable)itemStream.findFirstMatchingItemStream(filter2)) == null) {
            subscriptionTable = new SubscriptionTable(messageStore);
            subscriptionTable.isReady = true;
            itemStream.addItemStream(subscriptionTable, externalAutoCommitTransaction);
        }
        if (subscriptionTable != null) {
            subscriptionTable.messageStore = messageStore;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"open");
        }
        return subscriptionTable;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/SubscriptionTable.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }

    private class SubscriptionFilter
    implements Filter {
        Subscription subscription;

        SubscriptionFilter(Subscription subscription) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"SubscriptionFilter");
            }
            this.subscription = subscription;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"SubscriptionFilter");
            }
        }

        public boolean filterMatches(AbstractItem abstractItem) throws MessageStoreException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"filterMatches");
            }
            boolean bl = false;
            if (abstractItem == this.subscription) {
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)("filterMatches " + bl));
            }
            return bl;
        }
    }
}

