/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.mq.client.MQAPICallStatus;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public abstract class MQVerb
implements MQConstants,
LinkConstants,
MQFAP {
    Connection connection;
    MQFap mqClientFap;
    MQClientServerStateMachine mqClientServerStateMachine;
    byte segType;
    byte replySegType;
    static final TraceComponent tc = SibTr.register((Class)MQVerb.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    MQVerb(Connection connection, MQFap mQFap, MQClientServerStateMachine mQClientServerStateMachine) {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Connection = " + connection));
        }
        this.connection = connection;
        this.mqClientFap = mQFap;
        this.mqClientServerStateMachine = mQClientServerStateMachine;
        MQAPICallStatus[] mQAPICallStatusArray = mQClientServerStateMachine.getMQAPICallStatus();
        if (mQAPICallStatusArray[n = (mQFap.getSegmentType() & 0xF) - 1] == null) {
            mQAPICallStatusArray[n] = new MQAPICallStatus();
        }
        long l = mQAPICallStatusArray[n].getAPICallCount();
        mQAPICallStatusArray[n].setAPICallCount(++l);
        mQAPICallStatusArray[n].setAPICallDateAndTime(System.currentTimeMillis());
        mQClientServerStateMachine.setMQAPICallStatus(mQAPICallStatusArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    abstract void action();

    void reply(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reply");
        }
        this.mqClientFap.getTsh().setSegmentType(this.replySegType);
        this.mqClientFap.getMQAPI().setReturnCode(n);
        this.mqClientFap.getMQAPI().setReason(n2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<==== Reply ==== ", (Object)this.mqClientFap);
        }
        try {
            this.mqClientFap.send(this.connection);
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.comms.mq.client.MQVerb", (String)"1", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2005", (Object)((Object)sIConnectionLostException));
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"com.ibm.ws.sib.comms.mq.client.MQVerb", (String)"2", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2005", (Object)((Object)sIConnectionDroppedException));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("<================ Reply for " + MQUtil.getSegmentTypeConstant(this.mqClientFap.getSegmentType()) + ": Return = " + n + " Reason = " + n2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reply");
        }
    }

    void xaReply(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"xaReply");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reason Code", (Object)("" + n));
        }
        this.mqClientFap.getTsh().setSegmentType(this.replySegType);
        this.mqClientFap.getMQAPI().setReturnCode(n);
        try {
            this.mqClientFap.send(this.connection);
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.comms.mq.client.MQVerb", (String)"2", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2005", (Object)((Object)sIConnectionLostException));
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"com.ibm.ws.sib.comms.mq.client.MQVerb", (String)"3", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2005", (Object)((Object)sIConnectionDroppedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"xaReply");
        }
    }

    public static void validateName1(String string, int n) throws MQException {
        if (n == 0) {
            throw new MQException(2);
        }
        if (string == null || string.equals("") || string.trim().length() == 0) {
            throw new MQException(1);
        }
        if (string.indexOf(" ") != -1 & string.indexOf(" ") < string.trim().length()) {
            throw new MQException(2);
        }
    }

    public static void validateName2(String string, int n) throws MQException {
        MQVerb.validateName1(string, n);
        if (!string.trim().matches("[A-Za-z0-9./_%]+")) {
            throw new MQException(2);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQVerb.java, SIB.comms, WAS602.SIB, o0610.11 1.20");
        }
    }
}

