/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.impl.ObjectStoreFullException;
import com.ibm.ws.sib.comms.mq.MQLinkManager;
import com.ibm.ws.sib.comms.mq.client.DestinationDefinitionWrapper;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.client.MQVerb;
import com.ibm.ws.sib.comms.mq.client.PubSub;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.mqinterop.api.MQOD;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQOpen;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;

public class MQOPEN
extends MQVerb {
    int objectHandle;
    String GMOResolvedQName;
    String PMOResolvedQName;
    String PMOResolvedQMName;
    static final TraceComponent tc = SibTr.register((Class)MQOPEN.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    boolean tracedata = true;
    boolean allocatedHandleStore = false;
    MQHandleStore mqHandleStore;
    protected static SIDestinationAddressFactory destAddressFactory = null;

    MQOPEN(Connection connection, MQFap mQFap, MQClientServerStateMachine mQClientServerStateMachine) {
        super(connection, mQFap, mQClientServerStateMachine);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Connection = " + connection));
        }
        this.segType = (byte)-125;
        this.replySegType = (byte)-109;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    void action() {
        this.objectHandle = 0;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"action");
        }
        MQHObject mQHObject = new MQHObject();
        MQOpen mQOpen = this.mqClientFap.getMQOpen();
        MQOD mQOD = mQOpen.getObjDesc();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("MQOPEN For [" + mQOD.getObjectName().trim() + "]"));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("MQOPEN call " + mQOpen));
        }
        int n = mQOpen.getOptions();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Open options:", (Object)MQUtil.getOptions(n, "MQOO_"));
        }
        mQHObject.setOpenOptions(n);
        int n2 = 0;
        int n3 = 0;
        try {
            this.mqOpen(mQHObject, mQOD);
            if (mQHObject.isTemporaryDestination()) {
                mQOD.setObjectName(mQHObject.getSessDestName());
                mQOD.setObjectQMgrName(this.mqClientServerStateMachine.getMQClientLink().getVirtualQmgrName().trim());
            }
            this.mqClientServerStateMachine.getMQClientLink().openNotification(mQHObject);
        }
        catch (MQException mQException) {
            n2 = 2;
            n3 = mQException.getReason();
        }
        this.reply(n2, n3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"action MQOPEN");
        }
    }

    void mqOpen(MQHObject mQHObject, MQOD mQOD) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"mqOpen");
        }
        int n = 0;
        this.validateOpenParms(mQHObject, mQOD);
        if (!PubSub.open(mQHObject, mQOD, this.mqClientServerStateMachine)) {
            this.locateDestinations(mQHObject, mQOD);
            int n2 = mQHObject.getOpenOptions();
            if (mQOD.getObjectType() != 5 && mQOD.getObjectType() != 6 && (n2 & 0x1F) != 0) {
                mQHObject.createSessions(this.connection);
            }
        } else {
            int n3 = mQHObject.getOpenOptions();
            if ((n3 & 1) != 0) {
                n3 |= 2;
                mQHObject.setOpenOptions(n3 ^= 1);
            }
        }
        try {
            if (this.mqClientServerStateMachine.getMQHandleStore() == null) {
                this.mqHandleStore = new MQHandleStore();
                this.mqClientServerStateMachine.setMQHandleStore(this.mqHandleStore);
                this.allocatedHandleStore = true;
            } else {
                this.mqHandleStore = this.mqClientServerStateMachine.getMQHandleStore();
            }
            this.objectHandle = this.mqHandleStore.addObject(mQHObject);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            n = 2017;
        }
        if (n != 0) {
            this.cleanUp(mQHObject);
            throw new MQException(n);
        }
        this.mqClientFap.getMQAPI().setHandle(this.objectHandle);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"mqOpen");
        }
    }

    /*
     * Unable to fully structure code
     */
    void validateOpenParms(MQHObject var1_1, MQOD var2_2) throws MQException {
        block53: {
            block52: {
                if (MQOPEN.tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)MQOPEN.tc, (String)"validateOpenParms");
                }
                var3_3 = 2046;
                var4_4 = var1_1.getOpenOptions();
                if ((var4_4 & -11968) != 0 || (var4_4 & 63) == 0) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid options were specified");
                    }
                    throw new MQException(var3_3);
                }
                if ((var4_4 & 1) != 0 && (var4_4 & 2) != 0 || (var4_4 & 1) != 0 && (var4_4 & 4) != 0 || (var4_4 & 2) != 0 && (var4_4 & 4) != 0) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"More than one input option was specified");
                    }
                    throw new MQException(var3_3);
                }
                if ((var4_4 & 128) != 0 && (var4_4 & 7) == 0) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Save all without input options");
                    }
                    throw new MQException(var3_3);
                }
                if ((var4_4 & 16) == 0 && (var4_4 & 1792) != 0) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Output without context options");
                    }
                    throw new MQException(var3_3);
                }
                if (this.mqClientServerStateMachine.isMeQuiescing()) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"ME is quiescing");
                    }
                    if ((var4_4 & 8192) != 0) {
                        throw new MQException(2161);
                    }
                    throw new MQException(2162);
                }
                var3_3 = 2044;
                if (!var2_2.getStrucId().equals("OD  ")) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid structure id");
                    }
                    throw new MQException(var3_3);
                }
                if (var2_2.getVersion() != 1 && var2_2.getVersion() != 2 && var2_2.getVersion() != 3) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid open options structure version");
                    }
                    throw new MQException(var3_3);
                }
                var3_3 = 2154;
                if (var2_2.getVersion() > 1 && var2_2.getRecsPresent() != 0) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Recs present on version 1 options");
                    }
                    throw new MQException(var3_3);
                }
                var3_3 = 2043;
                if (var2_2.getObjectType() != 5 && var2_2.getObjectType() != 1 && var2_2.getObjectType() != 6) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid object type");
                    }
                    throw new MQException(var3_3);
                }
                var1_1.setObjectType(var2_2.getObjectType());
                var3_3 = 2045;
                if ((var2_2.getObjectType() == 5 || var2_2.getObjectType() == 6) && (var4_4 & 31) != 0) {
                    if (this.mqClientFap.getTsh().getSegmentType() == -121) {
                        var3_3 = 2043;
                    }
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Attempting to open queue manager or channel in invalid mode");
                    }
                    throw new MQException(var3_3);
                }
                var3_3 = 2086;
                try {
                    MQOPEN.validateName2(var2_2.getObjectQMgrName(), 48);
                    var1_1.setQMgrName(var2_2.getObjectQMgrName().trim());
                }
                catch (MQException var6_5) {
                    var5_7 = var6_5.getReason();
                    if (var5_7 == 2) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid queue manager name");
                        }
                        throw new MQException(var3_3);
                    }
                    if (var5_7 != 1) break block52;
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Queue manager name was blank - using default");
                    }
                    var1_1.setQMgrName(this.mqClientServerStateMachine.getMQClientLink().getVirtualQmgrName());
                }
            }
            var6_6 = (MQLinkManagerImpl)MQLinkManager.getInstance();
            if (!var1_1.getQMgrName().equals(this.mqClientServerStateMachine.getMQClientLink().getVirtualQmgrName())) {
                if (var2_2.getObjectType() == 5 || var2_2.getObjectType() == 6) {
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Unable to open remote qmgr / channel");
                    }
                    throw new MQException(var3_3);
                }
                if (MQOPEN.tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Fully qualified remote destination was specified");
                }
                var1_1.setOpenForFullyQualifiedRemoteDest(true);
                try {
                    MQOPEN.validateName1(var2_2.getObjectName(), 48);
                    var7_8 = var2_2.getObjectName().trim();
                    var8_12 = var6_6.isJmsPubSubSystemQueue(var7_8);
                    var1_1.setSystemObject(var8_12);
                    if (var8_12) {
                        var7_8 = var6_6.mapSystemObjectName(var7_8);
                    }
                    var1_1.setApiRequestedDestName(var7_8);
                    var1_1.setSessDestName(var2_2.getObjectQMgrName().trim());
                }
                catch (MQException var7_9) {
                    var5_7 = var7_9.getReason();
                    if (var5_7 != 2 && var5_7 != 1) ** GOTO lbl134
                    if (MQOPEN.tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Object name is bad", (Object)var7_9);
                    }
                    throw new MQException(2152);
                }
            } else {
                var3_3 = 2085;
                try {
                    MQOPEN.validateName2(var2_2.getObjectName(), 48);
                    if (var2_2.getObjectType() == 5) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Object is a queue manager");
                        }
                        throw new MQException(2194);
                    }
                    if (var2_2.getObjectType() == 6 && var2_2.getObjectName().trim().length() > 20) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Invalid name for a channel");
                        }
                        throw new MQException(2194);
                    }
                    var7_10 = var2_2.getObjectName().trim();
                    var8_13 = var6_6.isJmsPubSubSystemQueue(var7_10);
                    var1_1.setSystemObject(var8_13);
                    if (var8_13) {
                        var7_10 = var6_6.mapSystemObjectName(var7_10);
                    }
                    var1_1.setApiRequestedDestName(var7_10);
                    if (var1_1.getApiRequestedDestName().equals("SYSTEM.DEFAULT.MODEL.QUEUE")) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Default model queue was specified");
                        }
                        var1_1.setSessDestName(null);
                        var1_1.setOpenForDefaultModelQueue(true);
                    } else {
                        var1_1.setSessDestName(var1_1.getApiRequestedDestName());
                    }
                }
                catch (MQException var7_11) {
                    var5_7 = var7_11.getReason();
                    if (var5_7 == 2) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Object name is bad");
                        }
                        throw new MQException(var3_3);
                    }
                    if (var5_7 != 1) break block53;
                    if (var2_2.getObjectType() != 5) {
                        if (MQOPEN.tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)MQOPEN.tc, (String)"Object name is blank - and they are not opening the qm");
                        }
                        throw new MQException(var3_3);
                    }
                    var1_1.setOpenForQueueManagerAttrs(true);
                    var1_1.setApiRequestedDestName(var2_2.getObjectName().trim());
                    var1_1.setSessDestName(null);
                }
            }
        }
        if (MQOPEN.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)MQOPEN.tc, (String)"validateOpenParms");
        }
    }

    void locateDestinations(MQHObject mQHObject, MQOD mQOD) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"locateDestinations");
        }
        switch (mQOD.getObjectType()) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opening a queue object");
                }
                if (mQHObject.isOpenForDefaultModelQueue()) {
                    this.createTempDest(mQHObject, mQOD);
                }
                try {
                    destAddressFactory = SIDestinationAddressFactory.getInstance();
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception when getting an instance of the SIDestinationAddressFactory", (Object)exception);
                    }
                    throw new MQException(2195);
                }
                if (mQHObject.isOpenForFullyQualifiedRemoteDest()) {
                    mQHObject.setSessDestAddr(destAddressFactory.createSIDestinationAddress(mQHObject.getApiRequestedDestName(), mQHObject.getSessDestName()));
                } else {
                    DestinationDefinitionWrapper destinationDefinitionWrapper = new DestinationDefinitionWrapper(this.mqClientServerStateMachine, mQHObject.getSessDestName());
                    mQHObject.setDestinationDefinition(destinationDefinitionWrapper);
                    mQHObject.setSessDestAddr(destAddressFactory.createSIDestinationAddress(mQHObject.getSessDestName(), false));
                }
                this.resolveOpenForInputAsQDefOption(mQHObject);
                break;
            }
            case 5: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opening a queue manager");
                break;
            }
            case 6: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opening a channel");
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opening an unsupported type of object");
                }
                throw new MQException(2043);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"locateDestinations");
        }
    }

    void createTempDest(MQHObject mQHObject, MQOD mQOD) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTempDest");
        }
        try {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opening default model queue");
            }
            SICoreConnection sICoreConnection = this.mqClientServerStateMachine.getJSConnection();
            String string = mQOD.getDynamicQName().trim();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Dynamic queue name supplied in Object Descriptor = " + string));
            }
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() > 12) {
                string = string.substring(0, 12);
            }
            String string2 = sICoreConnection.createTemporaryDestination(Distribution.ONE, string).getDestinationName();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Dynamic queue created = " + string2));
            }
            mQHObject.setSessDestName(string2);
            mQOD.setObjectName(string2);
            mQHObject.setTemporaryDestination(true);
        }
        catch (SIInvalidDestinationPrefixException sIInvalidDestinationPrefixException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dynamic queue name prefix not valid", (Object)((Object)sIInvalidDestinationPrefixException));
            }
            throw new MQException(2011);
        }
        catch (SINotAuthorizedException sINotAuthorizedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not authorized", (Object)((Object)sINotAuthorizedException));
            }
            throw new MQException(2035);
        }
        catch (SIException sIException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"SIException", (Object)((Object)sIException));
            }
            int n = MQUtil.mapSIRCtoMQRC(sIException);
            throw new MQException(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTempDest");
        }
    }

    void resolveOpenForInputAsQDefOption(MQHObject mQHObject) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resolveOpenForInputAsQDefOption");
        }
        int n = mQHObject.getOpenOptions();
        if (mQHObject.isOpenForFullyQualifiedRemoteDest()) {
            SIMPForeignBusControllable sIMPForeignBusControllable = null;
            sIMPForeignBusControllable = mQHObject.getForeignBusControllable(this.mqClientServerStateMachine, mQHObject.getQMgrName());
            if (sIMPForeignBusControllable == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Foreign Bus " + mQHObject.getQMgrName() + " not found"));
                }
                throw new MQException(2087);
            }
            if ((n & 1) != 0 || (n & 4) != 0 || (n & 2) != 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Fully qualified remote destination cannot be opened for input");
                }
                throw new MQException(2045);
            }
        } else {
            DestinationDefinitionWrapper destinationDefinitionWrapper = mQHObject.getDestinationDefinition();
            if (destinationDefinitionWrapper.isForeign() && ((n & 1) != 0 || (n & 4) != 0 || (n & 2) != 0)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Foreign destination " + mQHObject.getSessDestName() + " cannot be opened for input"));
                }
                throw new MQException(2045);
            }
            if (destinationDefinitionWrapper.isAlias()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Opened an Alias destination");
                }
                if (destinationDefinitionWrapper.isTargetForeign() && ((n & 1) != 0 || (n & 4) != 0 || (n & 2) != 0)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Foreign destination " + mQHObject.getSessDestName() + " cannot be opened for input"));
                    }
                    throw new MQException(2045);
                }
            }
            if ((n & 1) != 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resolving open for input as queue def option");
                }
                n = destinationDefinitionWrapper.isReceiveExclusive() ? (n |= 4) : (n |= 2);
                mQHObject.setOpenOptions(n ^= 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resolveOpenForInputAsQDefOption");
        }
    }

    void cleanUp(MQHObject mQHObject) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanUp");
        }
        if (mQHObject.isTemporaryDestination()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Deleting temporary destination");
            }
            try {
                this.mqClientServerStateMachine.getJSConnection().deleteTemporaryDestination(mQHObject.getSessDestAddr());
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not authorized", (Object)((Object)sINotAuthorizedException));
                }
                throw new MQException(2035);
            }
            catch (SIDestinationLockedException sIDestinationLockedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination locked", (Object)((Object)sIDestinationLockedException));
                }
                throw new MQException(2042);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Object closed", (Object)((Object)sIConnectionUnavailableException));
                }
                int n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIConnectionUnavailableException));
                throw new MQException(n);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Comms Exception?", (Object)((Object)sIConnectionLostException));
                }
                int n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIConnectionLostException));
                throw new MQException(n);
            }
            catch (SIResourceException sIResourceException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource error", (Object)((Object)sIResourceException));
                }
                throw new MQException(2102);
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Core exception", (Object)((Object)sIException));
                }
                int n = MQUtil.mapSIRCtoMQRC(sIException);
                throw new MQException(n);
            }
        }
        mQHObject.closeSessions();
        mQHObject = null;
        if (this.allocatedHandleStore) {
            this.mqHandleStore = null;
            this.mqClientServerStateMachine.setMQHandleStore(null);
            this.allocatedHandleStore = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanUp");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQOPEN.java, SIB.comms, WAS602.SIB, o0610.11 1.44");
        }
    }
}

