/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.comms.mq.client.DestinationDefinitionWrapper;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.client.MQVerb;
import com.ibm.ws.sib.comms.mq.client.PubSub;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQInq;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class MQINQ
extends MQVerb {
    static final TraceComponent tc = SibTr.register((Class)MQINQ.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final int MAX_SELECTOR = 256;
    int retCode;
    int reason;
    int selectorCount;
    DestinationDefinitionWrapper wrapper;
    String destName;

    MQINQ(Connection connection, MQFap mQFap, MQClientServerStateMachine mQClientServerStateMachine) {
        super(connection, mQFap, mQClientServerStateMachine);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Connection = " + connection));
        }
        this.segType = (byte)-119;
        this.replySegType = (byte)-103;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    void action() {
        block19: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"action");
            }
            this.retCode = 0;
            this.reason = 0;
            MQInq mQInq = this.mqClientFap.getMQInq();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("MQINQ call:" + mQInq));
            }
            this.selectorCount = mQInq.getIntValue("SelectorCount");
            int n = mQInq.getIntValue("IntAttrCount");
            int n2 = mQInq.getIntValue("CharAttrLength");
            this.reason = this.validate(mQInq);
            MQHandleStore mQHandleStore = this.mqClientServerStateMachine.getMQHandleStore();
            try {
                if (this.reason != 0) break block19;
                MQHObject mQHObject = mQHandleStore.getHandle(this.connection, this.mqClientFap);
                this.destName = mQHObject.getName();
                int[] nArray = null;
                byte[] byArray = null;
                if (n > 0) {
                    nArray = new int[n];
                }
                if (n2 > 0) {
                    byArray = new byte[n2];
                }
                List list = (List)mQInq.getValue("Selectors");
                if (mQHObject.getObjectType() == 1) {
                    boolean bl = false;
                    try {
                        this.wrapper = new DestinationDefinitionWrapper(this.mqClientServerStateMachine, this.destName);
                    }
                    catch (MQException mQException) {
                        if (mQException.getReason() == 2085) {
                            bl = this.isUndefinedPubSubQueue(mQHObject);
                            if (!bl) {
                                throw new MQException(2085);
                            }
                        }
                        throw new MQException(mQException.getReason());
                    }
                    if (!bl) {
                        this.inqQueue(mQHObject, list, nArray, byArray);
                    } else {
                        this.inqUndefinedPubSubQueue(mQHObject, list, nArray, byArray);
                    }
                } else if (mQHObject.getObjectType() == 5) {
                    this.inqQmgr(list, nArray, byArray);
                }
                if (n > 0) {
                    mQInq.setIntAttrs(nArray);
                }
                if (n2 > 0) {
                    mQInq.setCharAttrs(new String(byArray));
                }
            }
            catch (MQException mQException) {
                this.reason = mQException.getReason();
            }
        }
        if (this.reason != 0) {
            this.retCode = 2;
        }
        this.reply(this.retCode, this.reason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"action");
        }
    }

    int validate(MQInq mQInq) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validate");
        }
        int n = 0;
        if (this.mqClientServerStateMachine.isMeQuiescing()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MQ is quiescing");
            }
            n = 2162;
        } else {
            int n2 = mQInq.getIntValue("SelectorCount");
            int n3 = mQInq.getIntValue("IntAttrCount");
            int n4 = mQInq.getIntValue("CharAttrLength");
            if (n2 < 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Selector count is < 0");
                }
                n = 2065;
            }
            if (n2 > 256) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Selector limit exceeded");
                }
                n = 2066;
            }
            if (n3 < 0 || n3 > 0x1FFFFFFF) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Count error");
                }
                n = 2021;
            }
            if (n4 < 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Char count is < 0");
                }
                n = 2006;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validate");
        }
        return n;
    }

    private int setInt(int[] nArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInt");
        }
        if (n >= nArray.length) {
            if (this.reason == 0) {
                this.reason = 2023;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInt");
            }
            return n;
        }
        nArray[n] = n2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInt");
        }
        return n + 1;
    }

    private int setBytes(byte[] byArray, int n, String string, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
        if (n + n2 > byArray.length) {
            if (this.reason == 0) {
                this.reason = 2008;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
            }
            return n;
        }
        int n3 = 0;
        if (string != null) {
            n3 = string.length();
            if (n3 > n2) {
                n3 = n2;
            }
            System.arraycopy(string.getBytes(), 0, byArray, n, n3);
        }
        for (int i = n3; i < n2; ++i) {
            byArray[n + i] = 32;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
        return n + n2;
    }

    void inqQueue(MQHObject mQHObject, List list, int[] nArray, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inqQueue");
        }
        int n = 0;
        int n2 = 0;
        block68: for (int i = 0; i < this.selectorCount; ++i) {
            switch ((Integer)list.get(i)) {
                case 2027: {
                    long l = this.wrapper.getAlterationTime();
                    n2 = this.setBytes(byArray, n2, MQUtil.timeToMQDate(l), 12);
                    continue block68;
                }
                case 2028: {
                    long l = this.wrapper.getAlterationTime();
                    n2 = this.setBytes(byArray, n2, MQUtil.timeToMQTime(l), 8);
                    continue block68;
                }
                case 2002: {
                    String string;
                    try {
                        String string2 = this.wrapper.getBaseQName();
                        n2 = this.setBytes(byArray, n2, string2, 48);
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        this.retCode = 1;
                        string = "";
                        MQUtil.padString(string, 48, '*', false);
                        n2 = this.setBytes(byArray, n2, string, 48);
                    }
                    continue block68;
                }
                case 2039: {
                    n2 += this.setBytes(byArray, n2, "", 12);
                    continue block68;
                }
                case 2029: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block68;
                }
                case 2030: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block68;
                }
                case 2004: {
                    long l = this.wrapper.getAlterationTime();
                    n2 = this.setBytes(byArray, n2, MQUtil.timeToMQDate(l), 12);
                    continue block68;
                }
                case 2005: {
                    long l = this.wrapper.getAlterationTime();
                    n2 = this.setBytes(byArray, n2, MQUtil.timeToMQTime(l), 8);
                    continue block68;
                }
                case 2008: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block68;
                }
                case 2012: {
                    n2 = this.setBytes(byArray, n2, "", 48);
                    continue block68;
                }
                case 2013: {
                    n2 = this.setBytes(byArray, n2, this.wrapper.getDescription(), 64);
                    continue block68;
                }
                case 2016: {
                    n2 = this.setBytes(byArray, n2, this.destName, 48);
                    continue block68;
                }
                case 2017: {
                    this.retCode = 1;
                    this.reason = 2068;
                    String string = "";
                    MQUtil.padString(string, 48, '*', false);
                    n2 = this.setBytes(byArray, n2, string, 48);
                    continue block68;
                }
                case 2018: {
                    this.retCode = 1;
                    this.reason = 2068;
                    String string = "";
                    MQUtil.padString(string, 48, '*', false);
                    n2 = this.setBytes(byArray, n2, string, 48);
                    continue block68;
                }
                case 2019: {
                    String string;
                    try {
                        n2 = this.setBytes(byArray, n2, this.wrapper.getExceptionDestination(), 48);
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        this.retCode = 1;
                        string = "";
                        MQUtil.padString(string, 48, '*', false);
                        n2 = this.setBytes(byArray, n2, string, 48);
                    }
                    continue block68;
                }
                case 2022: {
                    n2 += this.setBytes(byArray, n2, "", 8);
                    continue block68;
                }
                case 2023: {
                    n2 = this.setBytes(byArray, n2, "", 64);
                    continue block68;
                }
                case 2024: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block68;
                }
                case 22: {
                    try {
                        n = this.setInt(nArray, n, this.wrapper.getMaxFailedDeliveries());
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        this.retCode = 1;
                        n = this.setInt(nArray, n, -1);
                    }
                    continue block68;
                }
                case 3: {
                    try {
                        n = this.setInt(nArray, n, (int)this.wrapper.getNumberOfQueuedMessages());
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        if (this.reason == 2068) {
                            this.retCode = 1;
                            n = this.setInt(nArray, n, -1);
                            continue block68;
                        }
                        this.retCode = 2;
                        n = this.setInt(nArray, n, 0);
                    }
                    continue block68;
                }
                case 61: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 4: {
                    if (this.wrapper.isReceiveExclusive()) {
                        n = this.setInt(nArray, n, 4);
                        continue block68;
                    }
                    n = this.setInt(nArray, n, 2);
                    continue block68;
                }
                case 5: {
                    int n3 = this.wrapper.getDefaultReliability() == Reliability.ASSURED_PERSISTENT || this.wrapper.getDefaultReliability() == Reliability.RELIABLE_PERSISTENT ? 1 : 0;
                    n = this.setInt(nArray, n, n3);
                    continue block68;
                }
                case 6: {
                    n = this.setInt(nArray, n, this.wrapper.getDefaultPriority());
                    continue block68;
                }
                case 7: {
                    try {
                        if (this.wrapper.isTemporary()) {
                            n = this.setInt(nArray, n, 3);
                            continue block68;
                        }
                        n = this.setInt(nArray, n, 1);
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        this.retCode = 1;
                        n = this.setInt(nArray, n, -1);
                    }
                    continue block68;
                }
                case 34: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 8: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 57: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 9: {
                    if (this.wrapper.isReceiveAllowed()) {
                        n = this.setInt(nArray, n, 0);
                        continue block68;
                    }
                    n = this.setInt(nArray, n, 1);
                    continue block68;
                }
                case 10: {
                    if (this.wrapper.isSendAllowed()) {
                        n = this.setInt(nArray, n, 0);
                        continue block68;
                    }
                    n = this.setInt(nArray, n, 1);
                    continue block68;
                }
                case 13: {
                    n = this.setInt(nArray, n, this.mqClientServerStateMachine.getMaxMessageSize());
                    continue block68;
                }
                case 14: {
                    n = this.setInt(nArray, n, 9);
                    continue block68;
                }
                case 15: {
                    try {
                        n = this.setInt(nArray, n, (int)this.wrapper.getDestinationHighMsgs());
                    }
                    catch (MQException mQException) {
                        this.reason = mQException.getReason();
                        if (this.reason == 2068) {
                            this.retCode = 1;
                            n = this.setInt(nArray, n, -1);
                            continue block68;
                        }
                        this.retCode = 2;
                        n = this.setInt(nArray, n, 0);
                    }
                    continue block68;
                }
                case 16: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 17: {
                    int n4 = this.mqClientServerStateMachine.getMQClientLink().getOpenForInputCount(mQHObject);
                    if (n4 >= 0) {
                        n = this.setInt(nArray, n, n4);
                        continue block68;
                    }
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 18: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 43: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 40: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 44: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 41: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 42: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 54: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 46: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 20: {
                    if (this.wrapper.isLocal()) {
                        n = this.setInt(nArray, n, 1);
                        continue block68;
                    }
                    if (this.wrapper.isAlias()) {
                        n = this.setInt(nArray, n, 3);
                        continue block68;
                    }
                    if (!this.wrapper.isForeign()) continue block68;
                    n = this.setInt(nArray, n, 6);
                    continue block68;
                }
                case 63: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 21: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 45: {
                    n = this.setInt(nArray, n, 1);
                    continue block68;
                }
                case 23: {
                    if (this.wrapper.isReceiveExclusive()) {
                        n = this.setInt(nArray, n, 0);
                        continue block68;
                    }
                    n = this.setInt(nArray, n, 1);
                    continue block68;
                }
                case 24: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 29: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 26: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                case 28: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 12: {
                    n = this.setInt(nArray, n, 0);
                    continue block68;
                }
                case 2000: {
                    n = this.setInt(nArray, n, -2);
                    continue block68;
                }
                default: {
                    this.retCode = 2;
                    this.reason = 2067;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inqQueue");
        }
    }

    void inqQmgr(List list, int[] nArray, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inqQmgr");
        }
        int n = 0;
        int n2 = 0;
        block39: for (int i = 0; i < this.selectorCount; ++i) {
            switch ((Integer)list.get(i)) {
                case 2027: {
                    n = this.setBytes(byArray, n, MQUtil.timeToMQDate(-1L), 12);
                    continue block39;
                }
                case 2028: {
                    n = this.setBytes(byArray, n, MQUtil.timeToMQTime(-1L), 8);
                    continue block39;
                }
                case 2026: {
                    n = this.setBytes(byArray, n, "", 128);
                    continue block39;
                }
                case 2034: {
                    n = this.setBytes(byArray, n, "", 32);
                    continue block39;
                }
                case 2033: {
                    n = this.setBytes(byArray, n, "", 128);
                    continue block39;
                }
                case 2003: {
                    n = this.setBytes(byArray, n, "", 48);
                    continue block39;
                }
                case 2006: {
                    String string = "_SYSTEM.Exception.Destination." + this.mqClientServerStateMachine.getMQClientLink().getMeName();
                    n = this.setBytes(byArray, n, string, 48);
                    continue block39;
                }
                case 2025: {
                    n = this.setBytes(byArray, n, "", 48);
                    continue block39;
                }
                case 2041: {
                    n = this.setBytes(byArray, n, "", 12);
                    continue block39;
                }
                case 2014: {
                    n = this.setBytes(byArray, n, "", 64);
                    continue block39;
                }
                case 2032: {
                    n = this.setBytes(byArray, n, "", 48);
                    continue block39;
                }
                case 2015: {
                    n = this.setBytes(byArray, n, this.mqClientServerStateMachine.getMQClientLink().getVirtualQmgrName(), 48);
                    continue block39;
                }
                case 2040: {
                    n = this.setBytes(byArray, n, "", 4);
                    continue block39;
                }
                case 2035: {
                    n = this.setBytes(byArray, n, "", 48);
                    continue block39;
                }
                case 2036: {
                    n = this.setBytes(byArray, n, "", 48);
                    continue block39;
                }
                case 47: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 55: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 56: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 58: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 2: {
                    n2 = this.setInt(nArray, n2, 1208);
                    continue block39;
                }
                case 31: {
                    n2 = this.setInt(nArray, n2, 530);
                    continue block39;
                }
                case 34: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 39: {
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 65: {
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 48: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 64: {
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 49: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 11: {
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 13: {
                    n2 = this.setInt(nArray, n2, this.mqClientServerStateMachine.getMQClientLink().getMaxMessageSize());
                    continue block39;
                }
                case 14: {
                    n2 = this.setInt(nArray, n2, 9);
                    continue block39;
                }
                case 33: {
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 53: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 32: {
                    String string = System.getProperty("os.name");
                    if (string.equals("Windows NT")) {
                        n2 = this.setInt(nArray, n2, 11);
                        continue block39;
                    }
                    if (string.startsWith("Windows")) {
                        n2 = this.setInt(nArray, n2, 5);
                        continue block39;
                    }
                    if (string.startsWith("AIX")) {
                        n2 = this.setInt(nArray, n2, 3);
                        continue block39;
                    }
                    if (string.startsWith("Linux")) {
                        n2 = this.setInt(nArray, n2, 3);
                        continue block39;
                    }
                    if (string.startsWith("Z/OS")) {
                        n2 = this.setInt(nArray, n2, 1);
                        continue block39;
                    }
                    if (string.equals("OS/2")) {
                        n2 = this.setInt(nArray, n2, 2);
                        continue block39;
                    }
                    n2 = this.setInt(nArray, n2, -2);
                    continue block39;
                }
                case 50: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 52: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                case 30: {
                    n2 = this.setInt(nArray, n2, 1);
                    continue block39;
                }
                case 25: {
                    n2 = this.setInt(nArray, n2, 0);
                    continue block39;
                }
                default: {
                    this.retCode = 2;
                    this.reason = 2067;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inqQmgr");
        }
    }

    boolean isUndefinedPubSubQueue(MQHObject mQHObject) {
        PubSub pubSub;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isUndefinedPubSubQueue");
        }
        if ((pubSub = mQHObject.getPubSub()) != null && (this.destName.equals("SYSTEM.JMS.ND.SUBSCRIBER.QUEUE") || this.destName.equals("SYSTEM.JMS.D.SUBSCRIBER.QUEUE") || this.destName.equals("SYSTEM.BROKER.CONTROL.QUEUE") || this.destName.equals("SYSTEM.BROKER.DEFAULT.STREAM"))) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("We are dealing with an undefined PubSub queue " + this.destName));
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("isUnDefinedPubSubQueue : Returned boolean value = " + bl));
        }
        return bl;
    }

    void inqUndefinedPubSubQueue(MQHObject mQHObject, List list, int[] nArray, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inqUndefinedPubSubQueue");
        }
        int n = 0;
        int n2 = 0;
        block56: for (int i = 0; i < this.selectorCount; ++i) {
            switch ((Integer)list.get(i)) {
                case 2027: {
                    n2 = this.setBytes(byArray, n2, "", 12);
                    continue block56;
                }
                case 2028: {
                    n2 = this.setBytes(byArray, n2, "", 8);
                    continue block56;
                }
                case 2002: {
                    this.retCode = 1;
                    this.reason = 2068;
                    n2 = this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2039: {
                    n2 += this.setBytes(byArray, n2, "", 12);
                    continue block56;
                }
                case 2029: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2030: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2004: {
                    n2 = this.setBytes(byArray, n2, "", 12);
                    continue block56;
                }
                case 2005: {
                    n2 = this.setBytes(byArray, n2, "", 8);
                    continue block56;
                }
                case 2008: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2012: {
                    n2 = this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2013: {
                    n2 = this.setBytes(byArray, n2, "", 64);
                    continue block56;
                }
                case 2016: {
                    n2 = this.setBytes(byArray, n2, this.destName, 48);
                    continue block56;
                }
                case 2017: {
                    this.retCode = 1;
                    this.reason = 2068;
                    n2 = this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2018: {
                    this.retCode = 1;
                    this.reason = 2068;
                    n2 = this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 2019: {
                    String string = "_SYSTEM.Exception.Destination." + this.mqClientServerStateMachine.getMQClientLink().getMeName();
                    n2 = this.setBytes(byArray, n2, string, 48);
                    continue block56;
                }
                case 2022: {
                    n2 += this.setBytes(byArray, n2, "", 8);
                    continue block56;
                }
                case 2023: {
                    n2 = this.setBytes(byArray, n2, "", 64);
                    continue block56;
                }
                case 2024: {
                    n2 += this.setBytes(byArray, n2, "", 48);
                    continue block56;
                }
                case 22: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 3: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 61: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 4: {
                    n = this.setInt(nArray, n, 2);
                    continue block56;
                }
                case 5: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 6: {
                    n = this.setInt(nArray, n, 9);
                    continue block56;
                }
                case 7: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 34: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 8: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 57: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 9: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 10: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 13: {
                    n = this.setInt(nArray, n, this.mqClientServerStateMachine.getMaxMessageSize());
                    continue block56;
                }
                case 14: {
                    n = this.setInt(nArray, n, 9);
                    continue block56;
                }
                case 15: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 16: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 17: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 18: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 43: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 40: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 44: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 41: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 42: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 54: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 46: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 20: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 63: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 21: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 45: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 23: {
                    n = this.setInt(nArray, n, 1);
                    continue block56;
                }
                case 24: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 29: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 26: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                case 28: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 12: {
                    n = this.setInt(nArray, n, 0);
                    continue block56;
                }
                case 2000: {
                    n = this.setInt(nArray, n, -2);
                    continue block56;
                }
                default: {
                    this.retCode = 2;
                    this.reason = 2067;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inqUndefinedPubSubQueue");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQINQ.java, SIB.comms, WAS602.SIB, o0610.11 1.34");
        }
    }
}

