/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.mq.client.DestinationDefinitionWrapper;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.PubSub;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQTimer;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;

public class MQHObject
implements MQConstants {
    static final TraceComponent tc = SibTr.register((Class)MQHObject.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private int objectType;
    private String apiRequestedDestName;
    private String sessDestName;
    private SIDestinationAddress sessDestAddr = null;
    private String baseDestName = "";
    private SIDestinationAddress baseDestAddr = null;
    private String qmgrName;
    private ProducerSession producerSession;
    private ConsumerSession consumerSession;
    private BifurcatedConsumerSession bifConsumerSession = null;
    private AsynchConsumerCallback asynchGetCallback;
    private ConsumerSession frwdScanConSession;
    private AsynchConsumerCallback frwdScanAsynchGetCallback;
    private ConsumerSession currentConsumerSession;
    private BrowserSession browserSession;
    private MQTimer timer = null;
    private int openOptions;
    private boolean isTemporaryDestination = false;
    private boolean isOpenForQueueManagerAttrs = false;
    private boolean isOpenForDefaultModelQueue = false;
    private boolean isOpenForFullyQualifiedRemoteDest = false;
    private int getOptions;
    private String getSelector = null;
    private String frwdScanConSelector = null;
    private PubSub pubSub;
    private SIMessageHandle savedMessageHandle;
    private boolean savedMessageLocked = false;
    private byte[] acctToken = new byte[32];
    private String applIdentityData;
    private String userIdentifier;
    private String applOriginData;
    private String putApplName;
    private int putApplType;
    private String putDate;
    private String putTime;
    private boolean savedContext = false;
    private boolean isSystemObject = false;
    private DestinationDefinitionWrapper destDef = null;

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int n) {
        this.objectType = n;
    }

    public int getGetOptions() {
        return this.getOptions;
    }

    public void setGetOptions(int n) {
        this.getOptions = n;
    }

    public boolean isTemporaryDestination() {
        return this.isTemporaryDestination;
    }

    public void setTemporaryDestination(boolean bl) {
        this.isTemporaryDestination = bl;
    }

    public boolean isOpenForQueueManagerAttrs() {
        return this.isOpenForQueueManagerAttrs;
    }

    public void setOpenForQueueManagerAttrs(boolean bl) {
        this.isOpenForQueueManagerAttrs = bl;
    }

    public boolean isOpenForDefaultModelQueue() {
        return this.isOpenForDefaultModelQueue;
    }

    public void setOpenForDefaultModelQueue(boolean bl) {
        this.isOpenForDefaultModelQueue = bl;
    }

    public boolean isOpenForFullyQualifiedRemoteDest() {
        return this.isOpenForFullyQualifiedRemoteDest;
    }

    public void setOpenForFullyQualifiedRemoteDest(boolean bl) {
        this.isOpenForFullyQualifiedRemoteDest = bl;
    }

    public String getName() {
        if (this.getSessDestName() != null) {
            return this.getSessDestName();
        }
        return this.getApiRequestedDestName();
    }

    public void setApiRequestedDestName(String string) {
        this.apiRequestedDestName = string;
    }

    public String getApiRequestedDestName() {
        return this.apiRequestedDestName;
    }

    public void setSessDestName(String string) {
        this.sessDestName = string;
    }

    public String getSessDestName() {
        return this.sessDestName;
    }

    public void setSessDestAddr(SIDestinationAddress sIDestinationAddress) {
        this.sessDestAddr = sIDestinationAddress;
    }

    public String getBaseDestName() {
        return this.baseDestName;
    }

    public void setBaseDestName(String string) {
        this.baseDestName = string;
    }

    public SIDestinationAddress getSessDestAddr() {
        return this.sessDestAddr;
    }

    public void setDestinationDefinition(DestinationDefinitionWrapper destinationDefinitionWrapper) {
        this.destDef = destinationDefinitionWrapper;
    }

    public DestinationDefinitionWrapper getDestinationDefinition() {
        return this.destDef;
    }

    public void setQMgrName(String string) {
        this.qmgrName = string;
    }

    public String getQMgrName() {
        return this.qmgrName;
    }

    public void setProducerSession(ProducerSession producerSession) {
        this.producerSession = producerSession;
    }

    public ProducerSession getProducerSession() {
        return this.producerSession;
    }

    public void setConsumerSession(ConsumerSession consumerSession) {
        this.consumerSession = consumerSession;
    }

    public ConsumerSession getConsumerSession(String string) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current selector", (Object)this.getSelector);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requested selector", (Object)string);
        }
        if (!this.isEqual(this.getSelector, string)) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Need to recreate consumer session");
                }
                SICoreConnection sICoreConnection = this.consumerSession.getConnection();
                this.consumerSession.close();
                SelectionCriteria selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(null, string, SelectorDomain.JMS);
                this.consumerSession = ((MPCoreConnection)sICoreConnection).createMQInterOpConsumerSession(this.getSessDestAddr(), DestinationType.QUEUE, selectionCriteria, Reliability.NONE, false, false, Reliability.NONE, true, null, false, this.isSystemObject());
                this.setAsynchGetCallback(null);
                this.getSelector = string;
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to recreate consumer", (Object)((Object)sIException));
                }
                throw sIException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        return this.consumerSession;
    }

    private boolean isEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public ConsumerSession getConsumerSession() {
        return this.consumerSession;
    }

    public void setAsynchGetCallback(AsynchConsumerCallback asynchConsumerCallback) {
        this.asynchGetCallback = asynchConsumerCallback;
    }

    public AsynchConsumerCallback getAsynchGetCallback() {
        return this.asynchGetCallback;
    }

    public void setFrwdScanConSession(ConsumerSession consumerSession) {
        this.frwdScanConSession = consumerSession;
    }

    public ConsumerSession getFrwdScanConSession(String string, boolean bl) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFrwdScanConSession");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current forward scan consumer selector", (Object)this.frwdScanConSelector);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requested selector", (Object)string);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Recreate override flag", (Object)new Boolean(bl));
        }
        if (!this.isEqual(this.frwdScanConSelector, string) || bl) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Need to recreate forward scanning consumer session");
                }
                SICoreConnection sICoreConnection = this.frwdScanConSession.getConnection();
                if (this.bifConsumerSession != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing bifurcated consumer session");
                    }
                    this.bifConsumerSession.close();
                    this.bifConsumerSession = null;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing forward scanning consumer session");
                }
                this.frwdScanConSession.close();
                this.frwdScanConSession = null;
                SelectionCriteria selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(null, string, SelectorDomain.JMS);
                this.frwdScanConSession = ((MPCoreConnection)sICoreConnection).createMQInterOpConsumerSession(this.getSessDestAddr(), DestinationType.QUEUE, selectionCriteria, Reliability.RELIABLE_NONPERSISTENT, false, false, null, true, null, true, this.isSystemObject());
                this.setFrwdScanAsynchGetCallback(null);
                this.frwdScanConSelector = string;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a bifurcated consumer session");
                }
                try {
                    this.bifConsumerSession = sICoreConnection.createBifurcatedConsumerSession(this.frwdScanConSession.getId());
                }
                catch (SIException sIException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to recreate bifurcated consumer session", (Object)((Object)sIException));
                    }
                    throw sIException;
                }
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to recreate forward scanning consumer", (Object)((Object)sIException));
                }
                throw sIException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFrwdScanConSession");
        }
        return this.frwdScanConSession;
    }

    public ConsumerSession getFrwdScanConSession() {
        return this.frwdScanConSession;
    }

    public void setFrwdScanAsynchGetCallback(AsynchConsumerCallback asynchConsumerCallback) {
        this.frwdScanAsynchGetCallback = asynchConsumerCallback;
    }

    public AsynchConsumerCallback getFrwdScanAsynchGetCallback() {
        return this.frwdScanAsynchGetCallback;
    }

    public ConsumerSession getCurrentConsumerSession() {
        return this.currentConsumerSession;
    }

    public void setCurrentConsumerSession(ConsumerSession consumerSession) {
        this.currentConsumerSession = consumerSession;
    }

    public void setBrowserSession(BrowserSession browserSession) {
        this.browserSession = browserSession;
    }

    public BrowserSession getBrowserSession() {
        return this.browserSession;
    }

    public void setOpenOptions(int n) {
        this.openOptions = n;
    }

    public int getOpenOptions() {
        return this.openOptions;
    }

    MQTimer getTimer() {
        return this.timer;
    }

    void setTimer(MQTimer mQTimer) {
        this.timer = mQTimer;
    }

    public boolean isConsumerInhibited(MQClientServerStateMachine mQClientServerStateMachine) throws MQException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isConsumerInhibited");
        }
        if (this.pubSub == null) {
            if (this.isReceiveAllowed(mQClientServerStateMachine, this.getSessDestName())) {
                if (this.getBaseDestName() != "" && !this.isReceiveAllowed(mQClientServerStateMachine, this.getBaseDestName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isConsumerInhibited");
        }
        return bl;
    }

    public boolean isProducerInhibited(MQClientServerStateMachine mQClientServerStateMachine) throws MQException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isProducerInhibited");
        }
        if (this.pubSub == null) {
            if (this.isSendAllowed(mQClientServerStateMachine, this.getSessDestName())) {
                if (this.getBaseDestName() != "" && !this.isSendAllowed(mQClientServerStateMachine, this.getBaseDestName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isProducerInhibited");
        }
        return bl;
    }

    public SIMPMessageProcessorControllable getMPCon(MQClientServerStateMachine mQClientServerStateMachine) throws MQException {
        JsMessagingEngine jsMessagingEngine;
        SIMPMessageProcessorControllable sIMPMessageProcessorControllable;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMPCon");
        }
        if ((sIMPMessageProcessorControllable = ((SIMPAdmin)(jsMessagingEngine = mQClientServerStateMachine.getEngine()).getMessageProcessor()).getAdministrator().getMPRuntimeControl()) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The Message Processor runtime control object is null");
            }
            throw new MQException(2195);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMPCon");
        }
        return sIMPMessageProcessorControllable;
    }

    public SIMPQueueControllable getQueueControllable(MQClientServerStateMachine mQClientServerStateMachine, String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQueueControllable");
        }
        String string2 = mQClientServerStateMachine.getMQClientLink().getBusName();
        SIMPQueueControllable sIMPQueueControllable = null;
        SIMPMessageProcessorControllable sIMPMessageProcessorControllable = this.getMPCon(mQClientServerStateMachine);
        try {
            sIMPQueueControllable = sIMPMessageProcessorControllable.getQueueControlByName(string, string2);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"QueueControllable object not found for given destination", (Object)sIMPControllableNotFoundException);
            }
        }
        catch (SIMPException sIMPException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource exception", (Object)sIMPException);
            }
            throw new MQException(2195);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQueueControllable");
        }
        return sIMPQueueControllable;
    }

    public SIMPForeignBusControllable getForeignBusControllable(MQClientServerStateMachine mQClientServerStateMachine, String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getForeignBusControllable");
        }
        SIMPForeignBusControllable sIMPForeignBusControllable = null;
        SIMPMessageProcessorControllable sIMPMessageProcessorControllable = this.getMPCon(mQClientServerStateMachine);
        SIMPIterator sIMPIterator = sIMPMessageProcessorControllable.getForeignBusIterator();
        boolean bl = false;
        while (!bl & sIMPIterator.hasNext()) {
            SIMPForeignBusControllable sIMPForeignBusControllable2 = (SIMPForeignBusControllable)sIMPIterator.next();
            if (sIMPForeignBusControllable2.getName() != string) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getForeignBusControllable");
        }
        return sIMPForeignBusControllable;
    }

    public boolean isReceiveAllowed(MQClientServerStateMachine mQClientServerStateMachine, String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isReceiveAllowed");
        }
        boolean bl = this.getDestinationDefinition().isReceiveAllowed();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isReceiveAllowed", (Object)("" + bl));
        }
        return bl;
    }

    public boolean isSendAllowed(MQClientServerStateMachine mQClientServerStateMachine, String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean bl = false;
        if (!this.isOpenForFullyQualifiedRemoteDest) {
            bl = this.getDestinationDefinition().isSendAllowed();
        } else {
            SIMPForeignBusControllable sIMPForeignBusControllable = null;
            sIMPForeignBusControllable = this.getForeignBusControllable(mQClientServerStateMachine, this.qmgrName);
            if (sIMPForeignBusControllable != null && sIMPForeignBusControllable.isSendAllowed()) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSendAllowed", (Object)("" + bl));
        }
        return bl;
    }

    public void createSessions(Connection connection) throws MQException {
        int n = 0;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSessions");
        }
        MQClientServerStateMachine mQClientServerStateMachine = (MQClientServerStateMachine)connection.getAttachment();
        SICoreConnection sICoreConnection = mQClientServerStateMachine.getJSConnection();
        try {
            if (!this.isConsumerInhibited(mQClientServerStateMachine)) {
                SelectionCriteria selectionCriteria;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating the consumer");
                }
                if (((this.openOptions & 2) != 0 || (this.openOptions & 4) != 0) && this.consumerSession == null) {
                    selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(null, null, SelectorDomain.JMS);
                    this.consumerSession = ((MPCoreConnection)sICoreConnection).createMQInterOpConsumerSession(this.getSessDestAddr(), DestinationType.QUEUE, selectionCriteria, Reliability.NONE, false, false, null, true, null, false, this.isSystemObject());
                }
                if ((this.openOptions & 8) != 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a forward scanning consumer session for browse");
                    }
                    if (this.frwdScanConSession == null) {
                        selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(null, null, SelectorDomain.JMS);
                        this.frwdScanConSession = ((MPCoreConnection)sICoreConnection).createMQInterOpConsumerSession(this.getSessDestAddr(), DestinationType.QUEUE, selectionCriteria, Reliability.RELIABLE_NONPERSISTENT, false, false, Reliability.RELIABLE_NONPERSISTENT, true, null, true, this.isSystemObject());
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a bifurcated consumer session");
                        }
                        this.bifConsumerSession = sICoreConnection.createBifurcatedConsumerSession(this.frwdScanConSession.getId());
                    }
                }
            }
            if (!this.isProducerInhibited(mQClientServerStateMachine) && (this.openOptions & 0x10) != 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Creating producer session to " + this.getSessDestAddr()));
                }
                if (this.producerSession == null) {
                    this.producerSession = this.isSystemObject() ? ((MPCoreConnection)sICoreConnection).createSystemProducerSession(this.getSessDestAddr(), null, DestinationType.QUEUE, null, null) : sICoreConnection.createProducerSession(this.getSessDestAddr(), DestinationType.QUEUE, null, null);
                }
            }
        }
        catch (SINotAuthorizedException sINotAuthorizedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not authorized", (Object)((Object)sINotAuthorizedException));
            }
            throw new MQException(2035);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination possibly has wrong type", (Object)((Object)sINotPossibleInCurrentConfigurationException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sINotPossibleInCurrentConfigurationException));
            throw new MQException(n);
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No connection", (Object)((Object)sIConnectionDroppedException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIConnectionDroppedException));
            throw new MQException(n);
        }
        catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Object closed", (Object)((Object)sIConnectionUnavailableException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIConnectionUnavailableException));
            throw new MQException(n);
        }
        catch (SIDestinationLockedException sIDestinationLockedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination locked", (Object)((Object)sIDestinationLockedException));
            }
            throw new MQException(2042);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Temporary destination not found", (Object)((Object)sITemporaryDestinationNotFoundException));
            }
            throw new MQException(2052);
        }
        catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Discriminator syntax exception", (Object)((Object)sIDiscriminatorSyntaxException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIDiscriminatorSyntaxException));
            throw new MQException(n);
        }
        catch (SISelectorSyntaxException sISelectorSyntaxException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Selector syntax exception", (Object)((Object)sISelectorSyntaxException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sISelectorSyntaxException));
            throw new MQException(n);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Incorrect call", (Object)((Object)sIIncorrectCallException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIIncorrectCallException));
            throw new MQException(n);
        }
        catch (SILimitExceededException sILimitExceededException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Some limit has been exceeded", (Object)((Object)sILimitExceededException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sILimitExceededException));
            throw new MQException(n);
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection Lost", (Object)((Object)sIConnectionLostException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIConnectionLostException));
            throw new MQException(n);
        }
        catch (SIResourceException sIResourceException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource error", (Object)((Object)sIResourceException));
            }
            n = MQUtil.mapSIRCtoMQRC((SIException)((Object)sIResourceException));
            throw new MQException(n);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to get selection criteria factory", (Object)exception);
            }
            throw new MQException(2195);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSessions");
        }
    }

    public void closeSessions() throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeSessions");
        }
        int n = 0;
        if (this.producerSession != null) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing producer session");
                }
                this.producerSession.close();
                this.producerSession = null;
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close producer", (Object)((Object)sIException));
                }
                n = MQUtil.mapSIRCtoMQRC(sIException);
            }
        }
        if (this.consumerSession != null) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing consumer session");
                }
                this.consumerSession.close();
                this.consumerSession = null;
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close consumer", (Object)((Object)sIException));
                }
                n = MQUtil.mapSIRCtoMQRC(sIException);
            }
        }
        if (this.frwdScanConSession != null) {
            try {
                if (this.bifConsumerSession != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing bifurcated consumer session");
                        }
                        this.bifConsumerSession.close();
                        this.bifConsumerSession = null;
                    }
                    catch (SIException sIException) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unabled to close bifurcated consumer session", (Object)((Object)sIException));
                        }
                        n = MQUtil.mapSIRCtoMQRC(sIException);
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing forward scanning consumer session");
                }
                this.frwdScanConSession.close();
                this.frwdScanConSession = null;
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close forward scanning consumer", (Object)((Object)sIException));
                }
                n = MQUtil.mapSIRCtoMQRC(sIException);
            }
        }
        if (this.browserSession != null) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Closing browser session");
                }
                this.browserSession.close();
                this.browserSession = null;
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close browser", (Object)((Object)sIException));
                }
                n = MQUtil.mapSIRCtoMQRC(sIException);
            }
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (n != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Failed to close sessions, reason = " + n));
            }
            throw new MQException(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeSessions");
        }
    }

    PubSub getPubSub() {
        return this.pubSub;
    }

    void setPubSub(PubSub pubSub) {
        this.pubSub = pubSub;
    }

    public SIBusMessage getSavedMessage() throws MQException {
        SIBusMessage sIBusMessage;
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getSavedMessage");
            }
            sIBusMessage = null;
            try {
                if (this.savedMessageHandle == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"No saved message");
                    }
                    if (this.savedMessageLocked) {
                        this.savedMessageLocked = false;
                        throw new MQException(2209);
                    }
                    this.savedMessageLocked = false;
                    throw new MQException(2033);
                }
                if (this.bifConsumerSession != null) {
                    SIBusMessage[] sIBusMessageArray = this.bifConsumerSession.readSet(new SIMessageHandle[]{this.savedMessageHandle});
                    if (sIBusMessageArray.length != 1) {
                        MQException mQException = new MQException(2195);
                        FFDCFilter.processException((Throwable)mQException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"1", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Unexpected number of items returned from readSet():", (Object)("" + sIBusMessageArray.length));
                        }
                        throw mQException;
                    }
                    sIBusMessage = sIBusMessageArray[0];
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Message was retrieved successfully");
                    }
                    break block15;
                }
                MQException mQException = new MQException(2195);
                FFDCFilter.processException((Throwable)mQException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"2", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Bifurcated consumer session is null");
                }
                throw mQException;
            }
            catch (SIMessageNotLockedException sIMessageNotLockedException) {
                FFDCFilter.processException((Throwable)sIMessageNotLockedException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"3", (Object)this);
                MQException mQException = new MQException(2209);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Caught a message not locked exception", (Object)((Object)sIMessageNotLockedException));
                }
                throw mQException;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"4", (Object)this);
                MQException mQException = new MQException(2195);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Caught an unexpected exception", (Object)((Object)sIException));
                }
                throw mQException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSavedMessage", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    public void setSavedMessage(SIBusMessage sIBusMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSavedMessage", (Object)sIBusMessage);
        }
        this.savedMessageHandle = sIBusMessage == null ? null : sIBusMessage.getMessageHandle();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSavedMessage");
        }
    }

    public boolean isMessageSaved() {
        return this.savedMessageHandle != null;
    }

    public void unlockSavedMessage() throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockSavedMessage");
        }
        try {
            if (this.savedMessageHandle == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No saved message");
                }
                if (this.savedMessageLocked) {
                    this.savedMessageLocked = false;
                    throw new MQException(2209);
                }
                this.savedMessageLocked = false;
                throw new MQException(2033);
            }
            if (this.bifConsumerSession == null) {
                MQException mQException = new MQException(2195);
                FFDCFilter.processException((Throwable)mQException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"5", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Bifurcated consumer session is null");
                }
                throw mQException;
            }
            this.bifConsumerSession.unlockSet(new SIMessageHandle[]{this.savedMessageHandle});
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"6", (Object)this);
            MQException mQException = new MQException(2195);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught an unexpected exception", (Object)((Object)sIException));
            }
            throw mQException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockSavedMessage");
        }
    }

    public void deleteSavedMessage(SITransaction sITransaction) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSavedMessage", (Object)sITransaction);
        }
        try {
            if (this.savedMessageHandle == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No saved message");
                }
                if (this.savedMessageLocked) {
                    this.savedMessageLocked = false;
                    throw new MQException(2209);
                }
                this.savedMessageLocked = false;
                throw new MQException(2033);
            }
            if (this.bifConsumerSession == null) {
                MQException mQException = new MQException(2195);
                FFDCFilter.processException((Throwable)mQException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"7", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Bifurcated consumer session is null");
                }
                throw mQException;
            }
            this.bifConsumerSession.deleteSet(new SIMessageHandle[]{this.savedMessageHandle}, sITransaction);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQHObject", (String)"8", (Object)this);
            MQException mQException = new MQException(2195);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught an unexpected exception", (Object)((Object)sIException));
            }
            throw mQException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSavedMessage");
        }
    }

    public boolean isSavedMessageLocked() {
        return this.savedMessageLocked;
    }

    public void setSavedMessageLocked(boolean bl) {
        this.savedMessageLocked = bl;
    }

    public byte[] getAccountingToken() {
        return this.acctToken;
    }

    public void setAccountingToken(byte[] byArray) {
        this.acctToken = byArray;
    }

    public String getApplIdentityData() {
        return this.applIdentityData;
    }

    public void setApplIdentityData(String string) {
        this.applIdentityData = string;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public void setUserIdentifier(String string) {
        this.userIdentifier = string;
    }

    public String getApplOriginData() {
        return this.applOriginData;
    }

    public void setApplOriginData(String string) {
        this.applOriginData = string;
    }

    public String getPutApplName() {
        return this.putApplName;
    }

    public void setPutApplName(String string) {
        this.putApplName = string;
    }

    public int getPutApplType() {
        return this.putApplType;
    }

    public void setPutApplType(int n) {
        this.putApplType = n;
    }

    public String getPutDate() {
        return this.putDate;
    }

    public void setPutDate(String string) {
        this.putDate = string;
    }

    public String getPutTime() {
        return this.putTime;
    }

    public void setPutTime(String string) {
        this.putTime = string;
    }

    public boolean getSavedContext() {
        return this.savedContext;
    }

    public void setSavedContext(boolean bl) {
        this.savedContext = bl;
    }

    public boolean isSystemObject() {
        return this.isSystemObject;
    }

    public void setSystemObject(boolean bl) {
        this.isSystemObject = bl;
    }

    public String getFrwdScanConSelector() {
        return this.frwdScanConSelector;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQHObject.java, SIB.comms, WASX.SIB, o0436.08 1.40");
        }
    }
}

