/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.client.MQVerb;
import com.ibm.ws.sib.comms.mq.client.PubSub;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQClose;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;

public class MQCLOSE
extends MQVerb {
    static final TraceComponent tc = SibTr.register((Class)MQCLOSE.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    MQCLOSE(Connection connection, MQFap mQFap, MQClientServerStateMachine mQClientServerStateMachine) {
        super(connection, mQFap, mQClientServerStateMachine);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.segType = (byte)-124;
        this.replySegType = (byte)-108;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    void action() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"action");
        }
        MQClose mQClose = this.mqClientFap.getMQClose();
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("MQCLOSE call" + mQClose));
        }
        int n = 0;
        int n2 = 0;
        try {
            this.mqClose(mQClose.getOptions());
        }
        catch (MQException mQException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close", (Object)mQException);
            }
            n2 = mQException.getReason();
        }
        this.mqClientFap.getMQAPI().setHandle(-1);
        if (n2 != 0) {
            n = 2;
        }
        this.reply(n, n2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"action");
        }
    }

    void mqClose(int n) throws MQException {
        int n2;
        MQHObject mQHObject = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"mqClose");
        }
        this.validateCloseParms(n);
        MQHandleStore mQHandleStore = this.mqClientServerStateMachine.getMQHandleStore();
        if (mQHandleStore != null) {
            SIDestinationAddress sIDestinationAddress;
            PubSub pubSub;
            n2 = this.mqClientFap.getMQAPI().getHandle();
            mQHObject = mQHandleStore.getMQHObject(this.connection, n2);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MQCLOSE For [" + mQHObject.getName() + "]"));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Close options:", (Object)MQUtil.getOptions(n, "MQCO_"));
            }
            if ((pubSub = mQHObject.getPubSub()) == null || !pubSub.isSubscriptionQ()) {
                mQHObject.closeSessions();
            }
            if ((sIDestinationAddress = this.mqClientServerStateMachine.getMQClientLink().closeNotification(mQHObject)) != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Removing temporary destination");
                    }
                    this.mqClientServerStateMachine.getJSConnection().deleteTemporaryDestination(sIDestinationAddress);
                }
                catch (SIResourceException sIResourceException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"delete failed", (Object)((Object)sIResourceException));
                    }
                    throw new MQException(2102);
                }
                catch (SIDestinationLockedException sIDestinationLockedException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"delete failed", (Object)((Object)sIDestinationLockedException));
                    }
                    throw new MQException(2046);
                }
                catch (SINotAuthorizedException sINotAuthorizedException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"delete failed", (Object)((Object)sINotAuthorizedException));
                    }
                    throw new MQException(2035);
                }
                catch (SIException sIException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"delete failed", (Object)((Object)sIException));
                    }
                    throw new MQException(2195);
                }
            }
        } else {
            throw new MQException(2019);
        }
        mQHandleStore.removeHandle(this.connection, n2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"mqClose");
        }
    }

    private void validateCloseParms(int n) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateCloseParms");
        }
        if ((n | 3) != 3) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid options specified");
            }
            throw new MQException(2046);
        }
        int n2 = 0;
        if ((n & 0) != 0) {
            ++n2;
        }
        if ((n & 1) != 0) {
            ++n2;
        }
        if ((n & 2) != 0) {
            ++n2;
        }
        if (n2 > 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Too many close options specified");
            }
            throw new MQException(2046);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateCloseParms");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQCLOSE.java, SIB.comms, WAS602.SIB, o0610.11 1.21");
        }
    }
}

