/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.websphere.sib.admin.SIBQueuePoint;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import java.io.Serializable;

public class SIBQueuePointImpl
implements SIBQueuePoint,
Serializable {
    private static final long serialVersionUID = 2911459032498475359L;
    private boolean fullyValid = true;
    private long _depth = 0L;
    private long _destinationHighMsgs = Long.MAX_VALUE;
    private String _id = null;
    private boolean _isLocal;
    private boolean _isSystem;
    private boolean _isTemporary;
    private String _name = null;
    private boolean _sendAllowed = true;
    private String _state = null;
    private String _type = null;

    public SIBQueuePointImpl(SIMPQueueControllable sIMPQueueControllable) {
        this.copyQueueMembers(sIMPQueueControllable);
        try {
            this.copyQueuePointMembers(sIMPQueueControllable.getLocalQueuePointControl());
        }
        catch (SIMPException sIMPException) {
            this.fullyValid = false;
        }
    }

    public SIBQueuePointImpl(SIMPLocalQueuePointControllable sIMPLocalQueuePointControllable) {
        this.copyQueueMembers((SIMPQueueControllable)sIMPLocalQueuePointControllable.getMessageHandler());
        this.copyQueuePointMembers(sIMPLocalQueuePointControllable);
    }

    private void copyQueueMembers(SIMPQueueControllable sIMPQueueControllable) {
        this._isLocal = sIMPQueueControllable.isLocal();
        this._isSystem = sIMPQueueControllable.isSystem();
        this._isTemporary = sIMPQueueControllable.isTemporary();
        this._state = sIMPQueueControllable.getState();
        this._type = sIMPQueueControllable.getDestinationType().toString();
    }

    private void copyQueuePointMembers(SIMPLocalQueuePointControllable sIMPLocalQueuePointControllable) {
        this._depth = sIMPLocalQueuePointControllable.getNumberOfQueuedMessages();
        this._id = sIMPLocalQueuePointControllable.getId();
        this._destinationHighMsgs = sIMPLocalQueuePointControllable.getDestinationHighMsgs();
        this._name = sIMPLocalQueuePointControllable.getName();
        this._sendAllowed = sIMPLocalQueuePointControllable.isSendAllowed();
    }

    public boolean isFullyValid() {
        return this.fullyValid;
    }

    public long getDepth() {
        return this._depth;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getIdentifier() {
        return this._name;
    }

    public boolean isSystem() {
        return this._isSystem;
    }

    public boolean isTemporary() {
        return this._isTemporary;
    }

    public long getDestinationHighMsgs() {
        return this._destinationHighMsgs;
    }

    public int getMaxMsgs() {
        return (int)this._destinationHighMsgs;
    }

    public boolean isSendAllowed() {
        return this._sendAllowed;
    }

    public String getState() {
        return this._state;
    }

    public String getType() {
        return this._type;
    }
}

